/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.config.JSImportResolveContext;
import com.intellij.lang.javascript.frameworks.modules.JSPathResolution;
import com.intellij.lang.javascript.frameworks.modules.JSResolvableModuleReferenceContributor;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSDefaultFileReferenceContext;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSFileImportsResolverImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.util.CssFileTypeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\nH\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/CssModuleReferenceContributor;", "Lcom/intellij/lang/javascript/frameworks/modules/JSResolvableModuleReferenceContributor;", "<init>", "()V", "resolveElement", "", "Lcom/intellij/psi/ResolveResult;", "element", "Lcom/intellij/psi/PsiElement;", "text", "", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)[Lcom/intellij/psi/ResolveResult;", "getDefaultWeight", "", "isApplicable", "", "host", "isAcceptableText", "unquotedRefText", "CssFileImportsResolver", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nCssModuleReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CssModuleReferenceContributor.kt\ncom/intellij/lang/javascript/frameworks/modules/CssModuleReferenceContributor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,50:1\n12574#2,2:51\n*S KotlinDebug\n*F\n+ 1 CssModuleReferenceContributor.kt\ncom/intellij/lang/javascript/frameworks/modules/CssModuleReferenceContributor\n*L\n33#1:51,2\n*E\n"})
public final class CssModuleReferenceContributor
extends JSResolvableModuleReferenceContributor {
    @Override
    @NotNull
    protected ResolveResult[] resolveElement(@NotNull PsiElement element, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiFile psiFile = JSResolveUtil.getOriginalFile(element);
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiFile virtualFile = psiFile;
        JSDefaultFileReferenceContext referenceContext = new JSDefaultFileReferenceContext(text, element, null, CssFileTypeUtil.CSS_EXTENSIONS_WITH_DOT);
        JSPathResolution pathResolution = new CssFileImportsResolver(project2, referenceContext).resolveDirectFile(text, (VirtualFile)virtualFile);
        PsiFileSystemItem psiFileSystemItem = PsiUtilCore.findFileSystemItem((Project)project2, (VirtualFile)pathResolution.resolvedTarget());
        if (psiFileSystemItem == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiFileSystemItem result2 = psiFileSystemItem;
        ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(CollectionsKt.listOf((Object)result2));
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"toResolveResults(...)");
        return resolveResultArray;
    }

    @Override
    public int getDefaultWeight() {
        return JSModuleBaseReference.ModuleTypes.TS_MODULE.weight();
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return DialectDetector.isTypeScript(host);
    }

    @Override
    protected boolean isAcceptableText(@NotNull String unquotedRefText) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)unquotedRefText, (String)"unquotedRefText");
            Intrinsics.checkNotNullExpressionValue((Object)CssFileTypeUtil.CSS_EXTENSIONS_WITH_DOT, (String)"CSS_EXTENSIONS_WITH_DOT");
            Object[] $this$any$iv = CssFileTypeUtil.CSS_EXTENSIONS_WITH_DOT;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String ext = (String)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)ext);
                if (!StringsKt.endsWith$default((String)unquotedRefText, (String)ext, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J0\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/CssModuleReferenceContributor$CssFileImportsResolver;", "Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSFileImportsResolverImpl;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSDefaultFileReferenceContext;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSDefaultFileReferenceContext;)V", "loadModuleForLastPart", "Lcom/intellij/lang/javascript/frameworks/modules/JSPathResolution;", "name", "", "parent", "Lcom/intellij/openapi/vfs/VirtualFile;", "result", "", "resolveDirectory", "", "intellij.javascript.impl"})
    public static final class CssFileImportsResolver
    extends JSFileImportsResolverImpl {
        public CssFileImportsResolver(@NotNull Project project, @NotNull JSDefaultFileReferenceContext context2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            JSImportResolveContext jSImportResolveContext = context2;
            Intrinsics.checkNotNullExpressionValue((Object)CssFileTypeUtil.CSS_EXTENSIONS_WITH_DOT, (String)"CSS_EXTENSIONS_WITH_DOT");
            super(project, jSImportResolveContext, CssFileTypeUtil.CSS_EXTENSIONS_WITH_DOT);
        }

        @Override
        @Nullable
        protected JSPathResolution loadModuleForLastPart(@NotNull String name, @NotNull VirtualFile parent, @NotNull List<VirtualFile> result2, boolean resolveDirectory) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            return this.loadModuleForLastPartDirectly(name, parent, resolveDirectory, result2);
        }
    }
}

