/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSLocalTypeEvaluatorBase;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.ES6ImportCallType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyIndexedAccessType;
import com.intellij.lang.javascript.psi.types.evaluable.JSBestChoiceTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSThisType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLocalTypeEvaluator
extends JSLocalTypeEvaluatorBase {
    @Contract(value="null -> !null")
    @Nullable
    public static JSType evaluateTypeLocally(@Nullable JSExpression expression) {
        return new JSLocalTypeEvaluator().evaluate(expression);
    }

    @Override
    @NotNull
    protected JSType getThisExpressionType(@NotNull JSThisExpression expression) {
        JSType typeFromComment;
        if (expression == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(0);
        }
        return (typeFromComment = JSDocumentationUtils.findContextType((PsiElement)expression)) != null ? typeFromComment : new JSThisType(expression);
    }

    @Override
    @Nullable
    protected JSType getNewExpressionType(@NotNull JSNewExpression expression) {
        JSType type;
        if (expression == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(1);
        }
        return (type = this.getNewExpressionType(expression, expression.getMethodExpression())) != null ? type : JSSymbolUtil.evaluateNamespaceLocally(expression);
    }

    @Override
    @Nullable
    protected JSType getReferenceExpressionType(@NotNull JSReferenceExpression expression) {
        String referenceName;
        if (expression == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(2);
        }
        if ((referenceName = expression.getReferenceName()) != null) {
            JSExpression qualifier = expression.getQualifier();
            if (qualifier == null) {
                JSNamespace predefinedType = JSSymbolUtil.getPredefinedNamespace(expression);
                if (predefinedType != null) {
                    return predefinedType;
                }
                return new JSReferenceType(referenceName, expression);
            }
            JSType qualifierType = this.evaluate(qualifier);
            if (qualifierType != null) {
                return new JSQualifiedReferenceType(referenceName, qualifierType, expression);
            }
        }
        return null;
    }

    @Override
    @Nullable
    protected JSType getIndexedPropertyAccessExpressionType(@NotNull JSIndexedPropertyAccessExpression expression) {
        JSExpression qualifier;
        JSType qualifierType;
        if (expression == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(3);
        }
        if ((qualifierType = this.evaluate(qualifier = expression.getQualifier())) != null) {
            JSType argumentType = this.evaluate(expression.getIndexExpression());
            return new JSApplyIndexedAccessType(qualifierType, argumentType, expression);
        }
        return null;
    }

    @Override
    @Nullable
    protected JSType getArrayLiteralExpressionType(@NotNull JSArrayLiteralExpression expression) {
        List<JSType> types;
        if (expression == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(4);
        }
        if ((types = this.getArrayNestedTypes(expression, 5, false)) == null) {
            return null;
        }
        if (types.size() > 1) {
            JSType commonType = JSTypeUtils.widenLiteralTypes(types.get(0));
            ProcessingContext context2 = new ProcessingContext();
            for (int i = 1; i < types.size(); ++i) {
                JSType currentType = JSTypeUtils.widenLiteralTypes(types.get(i));
                if (commonType.isEquivalentTo(currentType, context2, false)) continue;
                commonType = null;
                break;
            }
            if (commonType != null) {
                return new JSArrayTypeImpl(commonType, JSLocalTypeEvaluator.createTypeSource((PsiElement)expression));
            }
        }
        return JSCompositeTypeFactory.createTupleType(JSLocalTypeEvaluator.createTypeSource((PsiElement)expression), types, false, -1, false);
    }

    @Override
    @Nullable
    protected JSType getConditionalExpressionType(@NotNull JSConditionalExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(5);
        }
        JSType thenType = this.evaluate((JSExpression)expression.getThenBranch());
        JSType elseType = this.evaluate((JSExpression)expression.getElseBranch());
        if (thenType == null && elseType == null) {
            return null;
        }
        if (thenType == null || elseType == null) {
            return ((JSType)ObjectUtils.chooseNotNull((Object)thenType, (Object)elseType)).copyWithStrict(false);
        }
        boolean isStrictType = thenType.isSourceStrict() && elseType.isSourceStrict();
        JSTypeSource commonTypeSource = JSTypeSourceFactory.createTypeSource((PsiElement)expression, isStrictType);
        return new JSBestChoiceTypeImpl(thenType, elseType, commonTypeSource);
    }

    @Override
    @NotNull
    protected JSType getImportCallType(@NotNull ES6ImportCall expression) {
        if (expression == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(6);
        }
        ES6ImportCallType type = new ES6ImportCallType(expression);
        JSType jSType = JSTypeUtils.wrapInPromiseType(type, type.getSource());
        if (jSType == null) {
            JSLocalTypeEvaluator.$$$reportNull$$$0(7);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSLocalTypeEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSLocalTypeEvaluator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportCallType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThisExpressionType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNewExpressionType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpressionType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyAccessExpressionType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getArrayLiteralExpressionType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConditionalExpressionType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getImportCallType";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

