/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIndexerToPropertyAccessIntention
extends JavaScriptIntention {
    public JSIndexerToPropertyAccessIntention() {
        this.setText(this.getFamilyName());
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSIndexerToPropertyAccessIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSIndexerToPropertyAccessIntention.$$$reportNull$$$0(1);
        }
        JSIndexedPropertyAccessExpression indexer = JSIndexerToPropertyAccessIntention.findIndexer(element, true);
        assert (indexer != null);
        JSExpression qualifier = indexer.getQualifier();
        assert (qualifier != null);
        String identifier = JSIndexerToPropertyAccessIntention.getValidIdentifier(indexer.getIndexExpression(), project);
        assert (identifier != null);
        JSExpression newExpression = JSPsiElementFactory.createJSExpression(qualifier.getText() + "." + identifier, element);
        indexer.replace((PsiElement)newExpression);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.indexer.to.property.intention", new Object[0]);
        if (string == null) {
            JSIndexerToPropertyAccessIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSIndexerToPropertyAccessIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            JSIndexerToPropertyAccessIntention.$$$reportNull$$$0(4);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSIndexedPropertyAccessExpression indexer = JSIndexerToPropertyAccessIntention.findIndexer(element, true);
        return indexer != null && indexer.getQualifier() != null && JSIndexerToPropertyAccessIntention.getValidIdentifier(indexer.getIndexExpression(), project) != null;
    }

    @Nullable
    private static String getValidIdentifier(JSExpression expression, Project project) {
        JSLiteralExpression literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)expression, JSLiteralExpression.class);
        if (literalExpression == null || !literalExpression.isStringLiteral()) {
            return null;
        }
        String value = literalExpression.getStringValue();
        return JSRefactoringUtil.isValidIdentifier(value, project) ? value : null;
    }

    @Nullable
    private static JSIndexedPropertyAccessExpression findIndexer(@Nullable PsiElement element, boolean checkPrev) {
        if (element == null) {
            return null;
        }
        if (element instanceof JSIndexedPropertyAccessExpression) {
            return (JSIndexedPropertyAccessExpression)element;
        }
        IElementType type = PsiUtilCore.getElementType((PsiElement)element);
        if (type != JSTokenTypes.STRING_LITERAL && type != JSTokenTypes.LBRACKET && type != JSTokenTypes.RBRACKET) {
            return checkPrev ? JSIndexerToPropertyAccessIntention.findIndexer(element.getPrevSibling(), false) : null;
        }
        if (type == JSTokenTypes.STRING_LITERAL) {
            JSLiteralExpression literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)element.getParent(), JSLiteralExpression.class);
            return literalExpression == null ? null : (JSIndexedPropertyAccessExpression)ObjectUtils.tryCast((Object)literalExpression.getParent(), JSIndexedPropertyAccessExpression.class);
        }
        return (JSIndexedPropertyAccessExpression)ObjectUtils.tryCast((Object)element.getParent(), JSIndexedPropertyAccessExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSIndexerToPropertyAccessIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSIndexerToPropertyAccessIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

