/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterEditorNotifications;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.io.URLUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterAnnotationsBuilder {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final JSLinterAnnotationResult myResult;
    @NotNull
    private final AnnotationHolder myHolder;
    @NotNull
    private final HighlightDisplayKey myKey;
    @NotNull
    private final UntypedJSLinterConfigurable myConfigurable;
    @NotNull
    @Nls
    private final String myPrefix;
    private int myTabSize;
    @NotNull
    private JSLinterWithInspectionExternalAnnotator.HighlightingGranularity myHighlightingGranularity;
    @NotNull
    private final Class<? extends JSLinterInspection> myInspectionClass;
    @NotNull
    private final JSLinterStandardFixes myStandardFixes;
    @Nullable
    private Icon myDefaultFileLevelErrorIcon;

    public JSLinterAnnotationsBuilder(@NotNull PsiFile file, @NotNull JSLinterAnnotationResult annotationResult, @NotNull AnnotationHolder holder, @NotNull UntypedJSLinterConfigurable configurable, @NotNull @Nls String errorPrefix, @NotNull Class<? extends JSLinterInspection> inspectionClass, @NotNull JSLinterStandardFixes fixes) {
        if (file == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(0);
        }
        if (annotationResult == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(2);
        }
        if (configurable == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(3);
        }
        if (errorPrefix == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(4);
        }
        if (inspectionClass == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(5);
        }
        if (fixes == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(6);
        }
        this.myTabSize = 1;
        this.myFile = file;
        this.myResult = annotationResult;
        this.myHolder = holder;
        this.myKey = JSLinterInspection.getHighlightDisplayKeyByClass(inspectionClass);
        this.myConfigurable = configurable;
        this.myPrefix = errorPrefix;
        this.myInspectionClass = inspectionClass;
        this.myStandardFixes = fixes;
        this.myHighlightingGranularity = JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.none;
    }

    @NotNull
    public JSLinterAnnotationsBuilder setTabSize(int tabSize) {
        this.myTabSize = tabSize;
        JSLinterAnnotationsBuilder jSLinterAnnotationsBuilder = this;
        if (jSLinterAnnotationsBuilder == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(7);
        }
        return jSLinterAnnotationsBuilder;
    }

    public void apply() {
        Document document = PsiDocumentManager.getInstance((Project)this.myFile.getProject()).getDocument(this.myFile);
        if (document == null) {
            return;
        }
        InspectionProjectProfileManager inspectionProjectProfileManager = InspectionProjectProfileManager.getInstance((Project)this.myFile.getProject());
        SeverityRegistrar severityRegistrar = inspectionProjectProfileManager.getSeverityRegistrar();
        EditorColorsScheme colorsScheme = this.myResult.getColorsScheme();
        Function severityTextAttributesProvider = severity -> JSLinterUtil.getTextAttributes(colorsScheme, severityRegistrar, severity);
        List<JSLinterError> limitedErrors = JSLinterUtil.limitErrorsAtTheSamePosition(this.myResult.getErrors(), 10);
        if (this.myHolder.isBatchMode()) {
            if (this.myResult.hasFileLevelInfo()) {
                JSLinterFileLevelAnnotation fileLevelError = this.myResult.getFileLevelError();
                JSLinterError globalLinterError = new JSLinterError(1, 1, fileLevelError.getMessage(), null, fileLevelError.getSeverity());
                List<IntentionAction> fixes = fileLevelError.getFixes().createListForError(this.myResult.getConfigFile(), this.myConfigurable, globalLinterError);
                this.createAnnotation(document, globalLinterError, (Function<? super HighlightSeverity, ? extends TextAttributes>)severityTextAttributesProvider, fixes, this.myKey, null);
            }
        } else {
            JSLinterFileLevelAnnotation annotation = this.createFileLevelAnnotation();
            this.applyFileLevelAnnotation(annotation);
        }
        for (JSLinterError linterError : limitedErrors) {
            Function<? super JSLinterErrorBase, ? extends ProblemGroup> getProblemGroup = this.myStandardFixes.getProblemGroup();
            ProblemGroup problemGroup = getProblemGroup != null ? (ProblemGroup)getProblemGroup.fun((Object)linterError) : null;
            List<IntentionAction> fixes = this.myStandardFixes.createListForError(this.myResult.getConfigFile(), this.myConfigurable, linterError);
            this.createAnnotation(document, linterError, (Function<? super HighlightSeverity, ? extends TextAttributes>)severityTextAttributesProvider, fixes, this.myKey, problemGroup);
        }
    }

    @Nullable
    private JSLinterFileLevelAnnotation createFileLevelAnnotation() {
        JSLinterFileLevelAnnotation error = this.myResult.getFileLevelError();
        if (error != null) {
            error.prefix(this.myPrefix);
            if (error.getIcon() == null) {
                error.withIcon(this.myDefaultFileLevelErrorIcon);
            }
            JSLinterStandardFixes fixes = new JSLinterStandardFixes().setShowEditSettings(false).setOtherFixes(error.getFixes().createList(this.myResult.getConfigFile(), this.myConfigurable)).setEditConfig(false);
            JSLinterFileLevelAnnotation copy = new JSLinterFileLevelAnnotation(error.getIcon(), error.getMessage(), error.getSeverity(), fixes);
            if (error.getShortMessage() != null) {
                copy.setShortMessage(error.getShortMessage());
            }
            return copy;
        }
        return null;
    }

    protected void applyFileLevelAnnotation(@Nullable JSLinterFileLevelAnnotation annotation) {
        if (annotation != null) {
            JSLinterEditorNotifications.setNotification(this.myFile.getProject(), this.myInspectionClass, this.myFile.getVirtualFile(), annotation);
        } else {
            JSLinterEditorNotifications.clearNotification(this.myFile.getProject(), this.myInspectionClass, this.myFile.getVirtualFile());
        }
    }

    private void createAnnotation(@NotNull Document document, @NotNull JSLinterError linterError, @NotNull Function<? super HighlightSeverity, ? extends TextAttributes> severityTextAttributesProvider, @NotNull List<? extends IntentionAction> fixes, @NotNull HighlightDisplayKey key, @Nullable ProblemGroup problemGroup) {
        if (document == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(8);
        }
        if (linterError == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(9);
        }
        if (severityTextAttributesProvider == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(10);
        }
        if (fixes == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(11);
        }
        if (key == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(12);
        }
        int errorLine = linterError.getLine();
        int errorColumn = linterError.getColumn();
        if (errorLine < 0 || errorLine >= document.getLineCount()) {
            return;
        }
        TextRange range = this.calculateAnnotationRange(document, errorLine, errorColumn);
        if (range == null) {
            return;
        }
        String firstLine = StringUtil.notNullize((String)((String)ArrayUtil.getFirstElement((Object[])StringUtil.splitByLines((String)linterError.getDescription()))));
        String message = this.myPrefix + firstLine;
        String code = linterError.getCode();
        if (code != null) {
            message = message + " (" + code + ")";
        }
        HighlightSeverity severity = JSLinterInspection.getSeverityForError(linterError.getLinterSeverity(), this.myFile, this.myInspectionClass);
        TextAttributes severityTextAttributes = (TextAttributes)severityTextAttributesProvider.fun((Object)severity);
        String escapedDescription = XmlStringUtil.escapeString((String)linterError.getDescription());
        String tooltip = JSLinterAnnotationsBuilder.getTooltip(this.myPrefix, escapedDescription, linterError.getCode());
        boolean afterEndOfLine = range.getStartOffset() == document.getLineEndOffset(errorLine);
        JSLinterUtil.createAnnotation(this.myHolder, severity, severityTextAttributes, range, message, tooltip, afterEndOfLine, fixes, key, problemGroup);
    }

    @NotNull
    @NlsContexts.Tooltip
    private static String getTooltip(@Nls String prefix, @Nls String description, @Nullable String code) {
        @Nls StringBuilder builder2 = new StringBuilder();
        builder2.append("<html>").append(prefix);
        String descriptionWithLinks = JSLinterAnnotationsBuilder.addLinksForUrls(description);
        if (StringUtil.contains((CharSequence)description, (CharSequence)"\n")) {
            builder2.append("<br>").append("<pre>").append(descriptionWithLinks).append("</pre>");
        } else {
            builder2.append(descriptionWithLinks);
        }
        if (code != null) {
            builder2.append(" (").append(code).append(")");
        }
        builder2.append("</html>");
        String string = builder2.toString();
        if (string == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(13);
        }
        return string;
    }

    private TextRange calculateAnnotationRange(@NotNull Document document, int errorLine, int errorColumn) {
        int errorLineStartOffset;
        if (document == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(14);
        }
        int lineEndOffset = document.getLineEndOffset(errorLine);
        int lineStartOffset = document.getLineStartOffset(errorLine);
        if (errorColumn == -1) {
            errorLineStartOffset = JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.line == this.myHighlightingGranularity ? lineStartOffset : lineEndOffset;
        } else {
            errorLineStartOffset = JSLinterAnnotationsBuilder.calcErrorStartOffsetInDocument(document, lineStartOffset, lineEndOffset, errorColumn, this.myTabSize);
            errorLineStartOffset = Math.min(errorLineStartOffset, document.getTextLength() - 1);
        }
        if (errorLineStartOffset == -1) {
            return null;
        }
        PsiElement element = this.myFile.findElementAt(errorLineStartOffset);
        if (element != null && element.isValid()) {
            Collection suppressors = InspectionProfileEntry.getSuppressors((PsiElement)element);
            for (InspectionSuppressor suppressor : suppressors) {
                if (!suppressor.isSuppressedFor(element, this.myKey.getID())) continue;
                return null;
            }
        }
        if (JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.line.equals((Object)this.myHighlightingGranularity)) {
            return new TextRange(lineStartOffset, lineEndOffset);
        }
        if (JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.element.equals((Object)this.myHighlightingGranularity) && element != null && element.isValid()) {
            InjectedLanguageManager injectedLanguageManager;
            PsiElement injected;
            if ((element instanceof PsiLanguageInjectionHost || element.getParent() instanceof PsiLanguageInjectionHost) && errorLineStartOffset > element.getTextRange().getStartOffset() && (injected = (injectedLanguageManager = InjectedLanguageManager.getInstance((Project)element.getProject())).findInjectedElementAt(this.myFile, errorLineStartOffset)) != null) {
                return injectedLanguageManager.injectedToHost(injected, injected.getTextRange());
            }
            if (element instanceof PsiWhiteSpace) {
                TextRange range = element.getTextRange();
                return new TextRange(Math.max(lineStartOffset, range.getStartOffset()), range.getEndOffset());
            }
            return element.getTextRange();
        }
        return new TextRange(errorLineStartOffset, errorLineStartOffset + 1);
    }

    private static int calcErrorStartOffsetInDocument(@NotNull Document document, int lineStartOffset, int lineEndOffset, int errorColumn, int tabSize) {
        if (document == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(15);
        }
        if (tabSize <= 1) {
            if (errorColumn < 0) {
                return lineStartOffset;
            }
            return Math.min(lineStartOffset + errorColumn, lineEndOffset);
        }
        CharSequence docText = document.getCharsSequence();
        int offset = lineStartOffset;
        for (int col = 0; offset < lineEndOffset && col < errorColumn; col += docText.charAt(offset) == '\t' ? tabSize : 1, ++offset) {
        }
        return offset;
    }

    public JSLinterAnnotationsBuilder setDefaultFileLevelErrorIcon(@Nullable Icon icon) {
        this.myDefaultFileLevelErrorIcon = icon;
        return this;
    }

    public JSLinterAnnotationsBuilder setHighlightingGranularity(@NotNull JSLinterWithInspectionExternalAnnotator.HighlightingGranularity highlightingGranularity) {
        if (highlightingGranularity == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(16);
        }
        this.myHighlightingGranularity = highlightingGranularity;
        return this;
    }

    private static String addLinksForUrls(@NotNull String message) {
        if (message == null) {
            JSLinterAnnotationsBuilder.$$$reportNull$$$0(17);
        }
        if (!URLUtil.canContainUrl((String)message)) {
            return message;
        }
        StringBuilder sb = new StringBuilder();
        Matcher matcher = URLUtil.URL_PATTERN.matcher(message);
        int prev = 0;
        while (matcher.find()) {
            String url = MessageFormat.format("<a href=\"{0}\">{0}</a>", matcher.group());
            sb.append(message, prev, matcher.start()).append(url);
            prev = matcher.end();
        }
        if (prev < message.length()) {
            sb.append(message, prev, message.length());
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationResult";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorPrefix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionClass";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder";
                break;
            }
            case 8: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterError";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityTextAttributesProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingGranularity";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setTabSize";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 13: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calculateAnnotationRange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "calcErrorStartOffsetInDocument";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightingGranularity";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addLinksForUrls";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 13 -> new IllegalStateException(string);
        };
    }
}

