/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.importer;

import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.linter.eslint.importer.EslintJsSettingsConverter;
import com.intellij.lang.javascript.linter.eslint.importer.EslintRuleMapper;
import com.intellij.lang.javascript.linter.eslint.importer.EslintRuleMappersFactory;
import com.intellij.lang.javascript.linter.eslint.importer.EslintSettingsConverter;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.BeforeAfter;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintStandardRuleMappersFactory
implements EslintRuleMappersFactory {
    @Override
    public List<EslintRuleMapper> createMappers() {
        return List.of(new ArrayBracketNewLine(), new ArrayBracketSpacing(), new ArrayElementNewLine(), new ArrowSpacing(), new BraceStyle(), new CommaDangle(), new CommaSpacing(), new Curly(), new DotLocation(), new EolLast(), new FuncCallSpacing(), new Indent(), new IndentLegacy(), new KeySpacing(), new KeywordSpacing(), new LinebreakStyle(), new MaxLen(), new MultilineTernary(), new NewlinePerChainedCall(), new NoMultipleEmptyLines(), new NoTabs(), new NoTrailingSpaces(), new ObjectCurlyNewline(), new ObjectCurlySpacing(), new OneVarDeclarationPerLine(), new ObjectPropertyNewLine(), new Quotes(), new RestSpreadSpacing(), new Semi(), new SemiSpacing(), new SortImports(), new SpaceBeforeBlocks(), new SpaceBeforeFunctionParen(), new SpaceInParens(), new SpaceInfixOps(), new SpaceUnaryOps(), new SpacedComment(), new YieldStarSpacing(), new TemplateCurlySpacing());
    }

    private static class ArrayBracketNewLine
    extends EslintRuleMapper {
        protected ArrayBracketNewLine() {
            super("array-bracket-newline");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            Boolean isOn;
            if (eslintConfig == null) {
                ArrayBracketNewLine.$$$reportNull$$$0(0);
            }
            if ((isOn = this.getArrayLineBreakRulesOption(values)) == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    ArrayBracketNewLine.$$$reportNull$$$0(1);
                }
                return eslintSettingsConverter;
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE != isOn || common.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE != isOn), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = isOn;
                common.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = isOn;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$ArrayBracketNewLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$ArrayBracketNewLine";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class ArrayBracketSpacing
    extends EslintRuleMapper {
        protected ArrayBracketSpacing() {
            super("array-bracket-spacing");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            Boolean isOn;
            if (eslintConfig == null) {
                ArrayBracketSpacing.$$$reportNull$$$0(0);
            }
            if ((isOn = this.getAlwaysNeverOption(values, false)) == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    ArrayBracketSpacing.$$$reportNull$$$0(1);
                }
                return eslintSettingsConverter;
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.SPACE_WITHIN_ARRAY_INITIALIZER_BRACKETS != isOn), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.SPACE_WITHIN_ARRAY_INITIALIZER_BRACKETS = isOn;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$ArrayBracketSpacing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$ArrayBracketSpacing";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class ArrayElementNewLine
    extends EslintRuleMapper {
        protected ArrayElementNewLine() {
            super("array-element-newline");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            Boolean isOn;
            if (eslintConfig == null) {
                ArrayElementNewLine.$$$reportNull$$$0(0);
            }
            if ((isOn = this.getArrayLineBreakRulesOption(values)) == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    ArrayElementNewLine.$$$reportNull$$$0(1);
                }
                return eslintSettingsConverter;
            }
            int value = isOn != false ? 2 : 0;
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.ARRAY_INITIALIZER_WRAP != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.ARRAY_INITIALIZER_WRAP = value;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$ArrayElementNewLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$ArrayElementNewLine";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class ArrowSpacing
    extends EslintRuleMapper {
        protected ArrowSpacing() {
            super("arrow-spacing");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            BeforeAfter<Boolean> beforeAfter;
            if (eslintConfig == null) {
                ArrowSpacing.$$$reportNull$$$0(0);
            }
            if ((beforeAfter = ArrowSpacing.getBeforeAfter(values, true, true)) == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    ArrowSpacing.$$$reportNull$$$0(1);
                }
                return eslintSettingsConverter;
            }
            if (beforeAfter.getBefore() != beforeAfter.getAfter()) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.SKIPPED;
                if (eslintSettingsConverter == null) {
                    ArrowSpacing.$$$reportNull$$$0(2);
                }
                return eslintSettingsConverter;
            }
            boolean haveSpaces = Boolean.TRUE.equals(beforeAfter.getBefore());
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> haveSpaces != custom.SPACE_AROUND_ARROW_FUNCTION_OPERATOR), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.SPACE_AROUND_ARROW_FUNCTION_OPERATOR = haveSpaces;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$ArrowSpacing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$ArrowSpacing";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class BraceStyle
    extends EslintRuleMapper {
        protected BraceStyle() {
            super("brace-style");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                BraceStyle.$$$reportNull$$$0(0);
            }
            Style style = Style.oneTrueBraceStyle;
            if (values != null && !values.isEmpty()) {
                JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)values.get(0), JsonStringLiteral.class);
                if (literal != null) {
                    String text = StringUtil.unquoteString((String)literal.getValue());
                    if (Style.allman.getText().equals(text)) {
                        style = Style.allman;
                    } else if (Style.stroustrup.getText().equals(text)) {
                        style = Style.stroustrup;
                    } else if (!Style.oneTrueBraceStyle.getText().equals(text)) {
                        EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                        if (eslintSettingsConverter == null) {
                            BraceStyle.$$$reportNull$$$0(1);
                        }
                        return eslintSettingsConverter;
                    }
                } else {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        BraceStyle.$$$reportNull$$$0(2);
                    }
                    return eslintSettingsConverter;
                }
            }
            Style finalStyle = style;
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> {
                int braceStyle = finalStyle.getBeginBraceStyle();
                return braceStyle != common.BRACE_STYLE || braceStyle != common.METHOD_BRACE_STYLE || braceStyle != custom.FUNCTION_EXPRESSION_BRACE_STYLE || braceStyle != common.CLASS_BRACE_STYLE || common.ELSE_ON_NEW_LINE != finalStyle.isElseOnNewLine();
            }), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                int braceStyle;
                common.BRACE_STYLE = braceStyle = finalStyle.getBeginBraceStyle();
                common.METHOD_BRACE_STYLE = braceStyle;
                custom.FUNCTION_EXPRESSION_BRACE_STYLE = braceStyle;
                common.CLASS_BRACE_STYLE = braceStyle;
                common.ELSE_ON_NEW_LINE = finalStyle.isElseOnNewLine();
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$BraceStyle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$BraceStyle";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }

        private static enum Style {
            oneTrueBraceStyle("1tbs", 1, false),
            stroustrup("stroustrup", 1, true),
            allman("allman", 2, true);

            private final String myText;
            private final int myBeginBraceStyle;
            private final boolean myElseOnNewLine;

            private Style(String text, int style, boolean line) {
                this.myText = text;
                this.myBeginBraceStyle = style;
                this.myElseOnNewLine = line;
            }

            public String getText() {
                return this.myText;
            }

            public int getBeginBraceStyle() {
                return this.myBeginBraceStyle;
            }

            public boolean isElseOnNewLine() {
                return this.myElseOnNewLine;
            }
        }
    }

    private static class CommaDangle
    extends EslintRuleMapper {
        protected CommaDangle() {
            super("comma-dangle");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                CommaDangle.$$$reportNull$$$0(0);
            }
            JSCodeStyleSettings.TrailingCommaOption option = JSCodeStyleSettings.TrailingCommaOption.Remove;
            if (values != null && !values.isEmpty()) {
                JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)values.get(0), JsonStringLiteral.class);
                if (literal != null) {
                    switch (StringUtil.unquoteString((String)literal.getValue())) {
                        case "never": {
                            break;
                        }
                        case "always": 
                        case "ignore": {
                            option = JSCodeStyleSettings.TrailingCommaOption.Keep;
                            break;
                        }
                        case "always-multiline": 
                        case "only-multiline": {
                            option = JSCodeStyleSettings.TrailingCommaOption.WhenMultiline;
                            break;
                        }
                        default: {
                            EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                            if (eslintSettingsConverter == null) {
                                CommaDangle.$$$reportNull$$$0(1);
                            }
                            return eslintSettingsConverter;
                        }
                    }
                } else if (values.get(0) instanceof JsonObject) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.SKIPPED;
                    if (eslintSettingsConverter == null) {
                        CommaDangle.$$$reportNull$$$0(2);
                    }
                    return eslintSettingsConverter;
                }
            }
            JSCodeStyleSettings.TrailingCommaOption finalOption = option;
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.ENFORCE_TRAILING_COMMA != finalOption), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.ENFORCE_TRAILING_COMMA = finalOption;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$CommaDangle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$CommaDangle";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class CommaSpacing
    extends EslintRuleMapper {
        protected CommaSpacing() {
            super("comma-spacing");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            BeforeAfter<Boolean> beforeAfter;
            if (eslintConfig == null) {
                CommaSpacing.$$$reportNull$$$0(0);
            }
            if ((beforeAfter = CommaSpacing.getBeforeAfter(values, false, true)) == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    CommaSpacing.$$$reportNull$$$0(1);
                }
                return eslintSettingsConverter;
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> (Boolean)beforeAfter.getBefore() != common.SPACE_BEFORE_COMMA || (Boolean)beforeAfter.getAfter() != common.SPACE_AFTER_COMMA), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_COMMA = (Boolean)beforeAfter.getBefore();
                common.SPACE_AFTER_COMMA = (Boolean)beforeAfter.getAfter();
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$CommaSpacing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$CommaSpacing";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class Curly
    extends EslintRuleMapper {
        protected Curly() {
            super("curly");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                Curly.$$$reportNull$$$0(0);
            }
            Option option = Option.all;
            if (values != null && !values.isEmpty()) {
                JsonStringLiteral value = (JsonStringLiteral)ObjectUtils.tryCast((Object)values.get(0), JsonStringLiteral.class);
                if (value == null) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        Curly.$$$reportNull$$$0(1);
                    }
                    return eslintSettingsConverter;
                }
                String text = StringUtil.unquoteString((String)value.getValue());
                option = (Option)((Object)ContainerUtil.find((Object[])Option.values(), o -> o.getText().equals(text)));
                if (option == null) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        Curly.$$$reportNull$$$0(2);
                    }
                    return eslintSettingsConverter;
                }
            }
            int selected = option.getValue();
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.IF_BRACE_FORCE != selected || common.FOR_BRACE_FORCE != selected || common.WHILE_BRACE_FORCE != selected || common.DOWHILE_BRACE_FORCE != selected), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.IF_BRACE_FORCE = selected;
                common.FOR_BRACE_FORCE = selected;
                common.WHILE_BRACE_FORCE = selected;
                common.DOWHILE_BRACE_FORCE = selected;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$Curly";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$Curly";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }

        private static enum Option {
            all("all", 3),
            multi("multi", 1),
            multiLine("multi-line", 1),
            multiOrNest("multi-or-nest", 1);

            private final String myText;
            private final int myValue;

            private Option(String text, int value) {
                this.myText = text;
                this.myValue = value;
            }

            public String getText() {
                return this.myText;
            }

            @CommonCodeStyleSettings.ForceBraceConstant
            public int getValue() {
                return this.myValue;
            }
        }
    }

    private static class DotLocation
    extends EslintRuleMapper {
        protected DotLocation() {
            super("dot-location");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                DotLocation.$$$reportNull$$$0(0);
            }
            boolean isOnNewLine = false;
            if (values != null && !values.isEmpty()) {
                JsonStringLiteral value = (JsonStringLiteral)ObjectUtils.tryCast((Object)values.get(0), JsonStringLiteral.class);
                if (value == null) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        DotLocation.$$$reportNull$$$0(1);
                    }
                    return eslintSettingsConverter;
                }
                String text = StringUtil.unquoteString((String)value.getValue());
                if ("property".equals(text)) {
                    isOnNewLine = true;
                } else if (!"object".equals(text)) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        DotLocation.$$$reportNull$$$0(2);
                    }
                    return eslintSettingsConverter;
                }
            }
            boolean finalIsOnNewLine = isOnNewLine;
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.CHAINED_CALL_DOT_ON_NEW_LINE != finalIsOnNewLine), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.CHAINED_CALL_DOT_ON_NEW_LINE = finalIsOnNewLine;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$DotLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$DotLocation";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class EolLast
    extends EslintRuleMapper {
        protected EolLast() {
            super("eol-last");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            Boolean option;
            if (eslintConfig == null) {
                EolLast.$$$reportNull$$$0(0);
            }
            if ((option = this.getAlwaysNeverOption(values, true)) == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    EolLast.$$$reportNull$$$0(1);
                }
                return eslintSettingsConverter;
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> EditorSettingsExternalizable.getInstance().isEnsureNewLineAtEOF() != option.booleanValue()), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> EditorSettingsExternalizable.getInstance().setEnsureNewLineAtEOF(option.booleanValue())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$EolLast";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$EolLast";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class FuncCallSpacing
    extends EslintRuleMapper {
        protected FuncCallSpacing() {
            super("func-call-spacing");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            Boolean isOn;
            if (eslintConfig == null) {
                FuncCallSpacing.$$$reportNull$$$0(0);
            }
            if ((isOn = this.getAlwaysNeverOption(values, false)) == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    FuncCallSpacing.$$$reportNull$$$0(1);
                }
                return eslintSettingsConverter;
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_METHOD_CALL_PARENTHESES != isOn), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_METHOD_CALL_PARENTHESES = isOn;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$FuncCallSpacing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$FuncCallSpacing";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class Indent
    extends EslintRuleMapper {
        Indent() {
            super("indent");
        }

        protected Indent(String name) {
            super(name);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            boolean indentSwitchCases;
            boolean useTab;
            Integer indentSize;
            block11: {
                if (eslintConfig == null) {
                    Indent.$$$reportNull$$$0(0);
                }
                if (values == null || values.size() == 0) {
                    indentSize = 4;
                    useTab = false;
                } else if (values.get(0) instanceof JsonStringLiteral) {
                    useTab = "tab".equals(StringUtil.unquoteString((String)((JsonStringLiteral)values.get(0)).getValue()));
                    indentSize = null;
                } else {
                    indentSize = Indent.getInteger(values.get(0));
                    useTab = false;
                }
                if (values != null && values.size() > 1) {
                    Integer intOptionValue = Indent.getIntOptionValue(values.get(1), "SwitchCase", 0);
                    if (intOptionValue != null) {
                        indentSwitchCases = intOptionValue > 0;
                        break block11;
                    } else {
                        EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                        if (eslintSettingsConverter == null) {
                            Indent.$$$reportNull$$$0(1);
                        }
                        return eslintSettingsConverter;
                    }
                }
                indentSwitchCases = false;
            }
            if (indentSize == null && !useTab) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    Indent.$$$reportNull$$$0(2);
                }
                return eslintSettingsConverter;
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> {
                if (common.ALIGN_MULTILINE_PARAMETERS_IN_CALLS || common.ALIGN_MULTILINE_PARAMETERS || common.ALIGN_MULTILINE_TERNARY_OPERATION || common.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION || common.ALIGN_MULTILINE_CHAINED_METHODS || common.ALIGN_MULTILINE_FOR) {
                    return true;
                }
                if (common.INDENT_CASE_FROM_SWITCH != indentSwitchCases) {
                    return true;
                }
                CommonCodeStyleSettings.IndentOptions indentOptions = common.getIndentOptions();
                assert (indentOptions != null);
                if (indentSize != null) {
                    return indentSize != indentOptions.INDENT_SIZE || indentSize != indentOptions.CONTINUATION_INDENT_SIZE;
                }
                return !indentOptions.USE_TAB_CHARACTER;
            }), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.ALIGN_MULTILINE_PARAMETERS_IN_CALLS = false;
                common.ALIGN_MULTILINE_PARAMETERS = false;
                common.ALIGN_MULTILINE_TERNARY_OPERATION = false;
                common.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = false;
                common.ALIGN_MULTILINE_CHAINED_METHODS = false;
                common.ALIGN_MULTILINE_FOR = false;
                common.INDENT_CASE_FROM_SWITCH = indentSwitchCases;
                CommonCodeStyleSettings.IndentOptions indentOptions = common.getIndentOptions();
                assert (indentOptions != null);
                if (indentSize != null) {
                    indentOptions.INDENT_SIZE = indentSize;
                    indentOptions.CONTINUATION_INDENT_SIZE = indentSize;
                }
                indentOptions.USE_TAB_CHARACTER = useTab;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$Indent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$Indent";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class IndentLegacy
    extends Indent {
        IndentLegacy() {
            super("indent-legacy");
        }
    }

    private static class KeySpacing
    extends EslintRuleMapper {
        private static final String BEFORE_COLON = "beforeColon";
        private static final String AFTER_COLON = "afterColon";

        KeySpacing() {
            super("key-spacing");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                KeySpacing.$$$reportNull$$$0(0);
            }
            Boolean beforeColon = false;
            Boolean afterColon = true;
            Boolean alignIsColon = null;
            if (values != null && values.size() > 0) {
                JsonObject config = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (config == null) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        KeySpacing.$$$reportNull$$$0(1);
                    }
                    return eslintSettingsConverter;
                }
                beforeColon = KeySpacing.getBooleanOptionValue(config, BEFORE_COLON, false);
                afterColon = KeySpacing.getBooleanOptionValue(config, AFTER_COLON, true);
                JsonProperty alignProperty = config.findProperty("align");
                if (alignProperty != null) {
                    JsonObject alignObject = (JsonObject)ObjectUtils.tryCast((Object)alignProperty.getValue(), JsonObject.class);
                    if (alignObject != null) {
                        alignIsColon = true;
                        JsonProperty on = alignObject.findProperty("on");
                        if (on != null && (alignIsColon = this.readValueAsStringWithTwoVariants(on.getValue(), "colon", "value")) == null) {
                            EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                            if (eslintSettingsConverter == null) {
                                KeySpacing.$$$reportNull$$$0(2);
                            }
                            return eslintSettingsConverter;
                        }
                        if (alignObject.findProperty(BEFORE_COLON) != null) {
                            beforeColon = KeySpacing.getBooleanOptionValue(alignObject, BEFORE_COLON, false);
                        }
                        if (alignObject.findProperty(AFTER_COLON) != null) {
                            afterColon = KeySpacing.getBooleanOptionValue(alignObject, AFTER_COLON, true);
                        }
                    } else {
                        alignIsColon = this.readValueAsStringWithTwoVariants(alignProperty.getValue(), "colon", "value");
                        if (alignIsColon == null) {
                            EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                            if (eslintSettingsConverter == null) {
                                KeySpacing.$$$reportNull$$$0(3);
                            }
                            return eslintSettingsConverter;
                        }
                    }
                }
            }
            if (beforeColon == null || afterColon == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    KeySpacing.$$$reportNull$$$0(4);
                }
                return eslintSettingsConverter;
            }
            Boolean finalBeforeColon = beforeColon;
            Boolean finalAfterColon = afterColon;
            Integer finalAlign = alignIsColon == null ? null : Integer.valueOf(alignIsColon != false ? 2 : 1);
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.SPACE_BEFORE_PROPERTY_COLON != finalBeforeColon || custom.SPACE_AFTER_PROPERTY_COLON != finalAfterColon || finalAlign != null && custom.ALIGN_OBJECT_PROPERTIES != finalAlign), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.SPACE_BEFORE_PROPERTY_COLON = finalBeforeColon;
                custom.SPACE_AFTER_PROPERTY_COLON = finalAfterColon;
                if (finalAlign != null) {
                    custom.ALIGN_OBJECT_PROPERTIES = finalAlign;
                }
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$KeySpacing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$KeySpacing";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class KeywordSpacing
    extends EslintRuleMapper {
        private static Map<String, EslintSettingsConverter> beforeMap(boolean value, @NotNull EslintRuleMapper.EslintConfig configWrapper) {
            if (configWrapper == null) {
                KeywordSpacing.$$$reportNull$$$0(0);
            }
            return ContainerUtil.map2Map(Set.of(Pair.create((Object)"else", (Object)new EslintJsSettingsConverter(configWrapper, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_ELSE_KEYWORD != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_ELSE_KEYWORD = value;
            }))), Pair.create((Object)"while", (Object)new EslintJsSettingsConverter(configWrapper, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_WHILE_KEYWORD != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_WHILE_KEYWORD = value;
            }))), Pair.create((Object)"catch", (Object)new EslintJsSettingsConverter(configWrapper, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_CATCH_KEYWORD != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_CATCH_KEYWORD = value;
            }))), Pair.create((Object)"finally", (Object)new EslintJsSettingsConverter(configWrapper, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_FINALLY_KEYWORD != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_FINALLY_KEYWORD = value;
            })))));
        }

        private static Map<String, EslintSettingsConverter> afterMap(boolean value, @NotNull EslintRuleMapper.EslintConfig configWrapper) {
            if (configWrapper == null) {
                KeywordSpacing.$$$reportNull$$$0(1);
            }
            return ContainerUtil.map2Map(Set.of(Pair.create((Object)"if", (Object)new EslintJsSettingsConverter(configWrapper, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_IF_PARENTHESES != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_IF_PARENTHESES = value;
            }))), Pair.create((Object)"for", (Object)new EslintJsSettingsConverter(configWrapper, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_FOR_PARENTHESES != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_FOR_PARENTHESES = value;
            }))), Pair.create((Object)"while", (Object)new EslintJsSettingsConverter(configWrapper, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_WHILE_PARENTHESES != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_WHILE_PARENTHESES = value;
            }))), Pair.create((Object)"switch", (Object)new EslintJsSettingsConverter(configWrapper, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_SWITCH_PARENTHESES != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_SWITCH_PARENTHESES = value;
            }))), Pair.create((Object)"catch", (Object)new EslintJsSettingsConverter(configWrapper, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_CATCH_PARENTHESES != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_CATCH_PARENTHESES = value;
            })))));
        }

        protected KeywordSpacing() {
            super("keyword-spacing");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                KeywordSpacing.$$$reportNull$$$0(2);
            }
            Map<String, EslintSettingsConverter> beforeTrue = KeywordSpacing.beforeMap(true, eslintConfig);
            Map<String, EslintSettingsConverter> afterTrue = KeywordSpacing.afterMap(true, eslintConfig);
            Map<String, EslintSettingsConverter> beforeFalse = KeywordSpacing.beforeMap(false, eslintConfig);
            Map<String, EslintSettingsConverter> afterFalse = KeywordSpacing.afterMap(false, eslintConfig);
            Map<String, EslintSettingsConverter> beforeMap = KeywordSpacing.beforeMap(true, eslintConfig);
            Map<String, EslintSettingsConverter> afterMap = KeywordSpacing.afterMap(true, eslintConfig);
            if (values != null && !values.isEmpty()) {
                JsonProperty overrides;
                JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (object == null) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        KeywordSpacing.$$$reportNull$$$0(3);
                    }
                    return eslintSettingsConverter;
                }
                BeforeAfter<Boolean> beforeAfter = KeywordSpacing.getBeforeAfter(object, true, true);
                if (beforeAfter == null) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        KeywordSpacing.$$$reportNull$$$0(4);
                    }
                    return eslintSettingsConverter;
                }
                if (!Boolean.TRUE.equals(beforeAfter.getBefore())) {
                    beforeMap = beforeFalse;
                }
                if (!Boolean.TRUE.equals(beforeAfter.getAfter())) {
                    afterMap = afterFalse;
                }
                if ((overrides = object.findProperty("overrides")) != null) {
                    JsonObject overridesObj = (JsonObject)ObjectUtils.tryCast((Object)overrides.getValue(), JsonObject.class);
                    if (overridesObj == null) {
                        EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                        if (eslintSettingsConverter == null) {
                            KeywordSpacing.$$$reportNull$$$0(5);
                        }
                        return eslintSettingsConverter;
                    }
                    if (KeywordSpacing.fillMapFromOverrides("before", beforeMap, beforeTrue, beforeFalse, overridesObj)) {
                        EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                        if (eslintSettingsConverter == null) {
                            KeywordSpacing.$$$reportNull$$$0(6);
                        }
                        return eslintSettingsConverter;
                    }
                    if (KeywordSpacing.fillMapFromOverrides("after", afterMap, afterTrue, afterFalse, overridesObj)) {
                        EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                        if (eslintSettingsConverter == null) {
                            KeywordSpacing.$$$reportNull$$$0(7);
                        }
                        return eslintSettingsConverter;
                    }
                }
            }
            final Collection<EslintSettingsConverter> beforeConvertors = beforeMap.values();
            final Collection<EslintSettingsConverter> afterConvertors = afterMap.values();
            return new EslintSettingsConverter(){

                @Override
                public boolean inSync(@NotNull CodeStyleSettings settings) {
                    if (settings == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return beforeConvertors.stream().allMatch(c -> c.inSync(settings)) && afterConvertors.stream().allMatch(c -> c.inSync(settings));
                }

                @Override
                public void apply(@NotNull CodeStyleSettings settings) {
                    if (settings == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    beforeConvertors.forEach(c -> c.apply(settings));
                    afterConvertors.forEach(c -> c.apply(settings));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "settings";
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$KeywordSpacing$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "inSync";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "apply";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        private static boolean fillMapFromOverrides(@NotNull String propName, @NotNull Map<String, EslintSettingsConverter> map2, @NotNull Map<String, EslintSettingsConverter> mapTrue, @NotNull Map<String, EslintSettingsConverter> mapFalse, @NotNull JsonObject overridesObj) {
            if (propName == null) {
                KeywordSpacing.$$$reportNull$$$0(8);
            }
            if (map2 == null) {
                KeywordSpacing.$$$reportNull$$$0(9);
            }
            if (mapTrue == null) {
                KeywordSpacing.$$$reportNull$$$0(10);
            }
            if (mapFalse == null) {
                KeywordSpacing.$$$reportNull$$$0(11);
            }
            if (overridesObj == null) {
                KeywordSpacing.$$$reportNull$$$0(12);
            }
            return overridesObj.getPropertyList().stream().filter(p -> mapTrue.containsKey(StringUtil.unquoteString((String)p.getName()))).map(p -> {
                JsonObject pObj = (JsonObject)ObjectUtils.tryCast((Object)p.getValue(), JsonObject.class);
                if (pObj == null) {
                    return false;
                }
                Boolean option = KeywordSpacing.getBooleanOptionValue(pObj, propName, true);
                if (option == null) {
                    return false;
                }
                String name = StringUtil.unquoteString((String)p.getName());
                map2.put(name, option != false ? (EslintSettingsConverter)mapTrue.get(name) : (EslintSettingsConverter)mapFalse.get(name));
                return true;
            }).anyMatch(value -> value == false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configWrapper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$KeywordSpacing";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propName";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapTrue";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapFalse";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "overridesObj";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$KeywordSpacing";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "beforeMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "afterMap";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "fillMapFromOverrides";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class LinebreakStyle
    extends EslintRuleMapper {
        protected LinebreakStyle() {
            super("linebreak-style");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                LinebreakStyle.$$$reportNull$$$0(0);
            }
            boolean isLf = true;
            if (values != null && !values.isEmpty()) {
                JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)values.get(0), JsonStringLiteral.class);
                if (literal != null) {
                    String text = StringUtil.unquoteString((String)literal.getValue());
                    if ("windows".equals(text)) {
                        isLf = false;
                    } else if (!"unix".equals(text)) {
                        EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                        if (eslintSettingsConverter == null) {
                            LinebreakStyle.$$$reportNull$$$0(1);
                        }
                        return eslintSettingsConverter;
                    }
                } else {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        LinebreakStyle.$$$reportNull$$$0(2);
                    }
                    return eslintSettingsConverter;
                }
            }
            LineSeparator separator = isLf ? LineSeparator.LF : LineSeparator.CRLF;
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> !separator.getSeparatorString().equals(common.getRootSettings().getLineSeparator())), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.getRootSettings().LINE_SEPARATOR = separator.getSeparatorString();
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$LinebreakStyle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$LinebreakStyle";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class MaxLen
    extends EslintRuleMapper {
        protected MaxLen() {
            super("max-len");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                MaxLen.$$$reportNull$$$0(0);
            }
            Integer rightMargin = null;
            Integer tabWidth = null;
            if (values != null && values.size() != 0) {
                rightMargin = MaxLen.getInteger(values.get(0));
                if (rightMargin != null) {
                    if (values.size() > 1 && (tabWidth = MaxLen.getInteger(values.get(1))) == null) {
                        EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                        if (eslintSettingsConverter == null) {
                            MaxLen.$$$reportNull$$$0(1);
                        }
                        return eslintSettingsConverter;
                    }
                } else {
                    JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                    if (object != null) {
                        JsonProperty tabWidthProperty;
                        JsonProperty code = object.findProperty("code");
                        if (code != null && code.getValue() != null) {
                            rightMargin = MaxLen.getInteger(code.getValue());
                        }
                        if ((tabWidthProperty = object.findProperty("tabWidth")) != null && tabWidthProperty.getValue() != null && (tabWidth = MaxLen.getInteger(tabWidthProperty.getValue())) == null) {
                            EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                            if (eslintSettingsConverter == null) {
                                MaxLen.$$$reportNull$$$0(2);
                            }
                            return eslintSettingsConverter;
                        }
                    } else {
                        EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                        if (eslintSettingsConverter == null) {
                            MaxLen.$$$reportNull$$$0(3);
                        }
                        return eslintSettingsConverter;
                    }
                }
            }
            rightMargin = rightMargin == null ? 80 : rightMargin;
            tabWidth = tabWidth == null ? 4 : tabWidth;
            int finalRightMargin = rightMargin;
            Integer finalTabWidth = tabWidth;
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.RIGHT_MARGIN != finalRightMargin || common.getIndentOptions() != null && common.getIndentOptions().TAB_SIZE != finalTabWidth), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.RIGHT_MARGIN = finalRightMargin;
                CommonCodeStyleSettings.IndentOptions indentOptions = common.getIndentOptions();
                if (indentOptions != null) {
                    indentOptions.TAB_SIZE = finalTabWidth;
                }
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$MaxLen";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$MaxLen";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class MultilineTernary
    extends EslintRuleMapper {
        protected MultilineTernary() {
            super("multiline-ternary");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            Boolean isOn;
            if (eslintConfig == null) {
                MultilineTernary.$$$reportNull$$$0(0);
            }
            if ((isOn = this.getAlwaysNeverOption(values, true)) == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    MultilineTernary.$$$reportNull$$$0(1);
                }
                return eslintSettingsConverter;
            }
            int option = isOn != false ? 2 : 0;
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.TERNARY_OPERATION_WRAP != option), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.TERNARY_OPERATION_WRAP = option;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$MultilineTernary";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$MultilineTernary";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class NewlinePerChainedCall
    extends EslintRuleMapper {
        protected NewlinePerChainedCall() {
            super("newline-per-chained-call");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                NewlinePerChainedCall.$$$reportNull$$$0(0);
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.METHOD_CALL_CHAIN_WRAP != 2), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.METHOD_CALL_CHAIN_WRAP = 2;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eslintConfig", "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$NewlinePerChainedCall", "create"));
        }
    }

    private static class NoMultipleEmptyLines
    extends EslintRuleMapper {
        protected NoMultipleEmptyLines() {
            super("no-multiple-empty-lines");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                NoMultipleEmptyLines.$$$reportNull$$$0(0);
            }
            Integer blankLines = null;
            if (values != null && values.size() != 0) {
                JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (object != null) {
                    JsonProperty code = object.findProperty("max");
                    if (code != null && code.getValue() != null) {
                        blankLines = NoMultipleEmptyLines.getInteger(code.getValue());
                    }
                } else {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        NoMultipleEmptyLines.$$$reportNull$$$0(1);
                    }
                    return eslintSettingsConverter;
                }
            }
            blankLines = blankLines == null ? 2 : blankLines;
            int finalBlankLines = blankLines;
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.KEEP_BLANK_LINES_IN_CODE != finalBlankLines), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.KEEP_BLANK_LINES_IN_CODE = finalBlankLines;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$NoMultipleEmptyLines";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$NoMultipleEmptyLines";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class NoTabs
    extends EslintRuleMapper {
        NoTabs() {
            super("no-tabs");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                NoTabs.$$$reportNull$$$0(0);
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> {
                CommonCodeStyleSettings.IndentOptions indentOptions = common.getIndentOptions();
                assert (indentOptions != null);
                return indentOptions.USE_TAB_CHARACTER;
            }), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                CommonCodeStyleSettings.IndentOptions indentOptions = common.getIndentOptions();
                assert (indentOptions != null);
                indentOptions.USE_TAB_CHARACTER = false;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eslintConfig", "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$NoTabs", "create"));
        }
    }

    private static class NoTrailingSpaces
    extends EslintRuleMapper {
        protected NoTrailingSpaces() {
            super("no-trailing-spaces");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                NoTrailingSpaces.$$$reportNull$$$0(0);
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> {
                EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
                return editorSettings != null && !"Whole".equals(editorSettings.getStripTrailingSpaces());
            }), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
                assert (editorSettings != null);
                editorSettings.setStripTrailingSpaces("Whole");
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eslintConfig", "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$NoTrailingSpaces", "create"));
        }
    }

    private static class ObjectCurlyNewline
    extends EslintRuleMapper {
        protected ObjectCurlyNewline() {
            super("object-curly-newline");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                ObjectCurlyNewline.$$$reportNull$$$0(0);
            }
            Boolean option = true;
            if (values != null && !values.isEmpty() && (option = this.readOption(values)) == null) {
                JsonValue objectExpression;
                JsonObject config = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (config == null) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        ObjectCurlyNewline.$$$reportNull$$$0(1);
                    }
                    return eslintSettingsConverter;
                }
                JsonProperty property = config.findProperty("ObjectExpression");
                JsonValue jsonValue = objectExpression = property == null ? null : property.getValue();
                if (objectExpression != null) {
                    option = this.readOption(Collections.singletonList(objectExpression));
                    if (option == null) {
                        EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                        if (eslintSettingsConverter == null) {
                            ObjectCurlyNewline.$$$reportNull$$$0(2);
                        }
                        return eslintSettingsConverter;
                    }
                } else {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.SKIPPED;
                    if (eslintSettingsConverter == null) {
                        ObjectCurlyNewline.$$$reportNull$$$0(3);
                    }
                    return eslintSettingsConverter;
                }
            }
            int optionValue = option != false ? 2 : 0;
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.OBJECT_LITERAL_WRAP != optionValue), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.OBJECT_LITERAL_WRAP = optionValue;
            }));
        }

        @Nullable
        private Boolean readOption(@NotNull List<JsonValue> values) {
            JsonBooleanLiteral multiline;
            Boolean option;
            if (values == null) {
                ObjectCurlyNewline.$$$reportNull$$$0(4);
            }
            if ((option = this.getAlwaysNeverOption(values, true)) != null) {
                return option;
            }
            JsonObject config = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
            if (config == null) {
                return null;
            }
            JsonProperty property = config.findProperty("multiline");
            JsonBooleanLiteral jsonBooleanLiteral = multiline = property == null ? null : (JsonBooleanLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonBooleanLiteral.class);
            if (multiline != null) {
                return multiline.getValue();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$ObjectCurlyNewline";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$ObjectCurlyNewline";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "readOption";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class ObjectCurlySpacing
    extends EslintRuleMapper {
        protected ObjectCurlySpacing() {
            super("object-curly-spacing");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            Boolean option;
            if (eslintConfig == null) {
                ObjectCurlySpacing.$$$reportNull$$$0(0);
            }
            if ((option = this.getAlwaysNeverOption(values, false)) == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    ObjectCurlySpacing.$$$reportNull$$$0(1);
                }
                return eslintSettingsConverter;
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.SPACES_WITHIN_OBJECT_LITERAL_BRACES != option || custom.SPACES_WITHIN_IMPORTS != option), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.SPACES_WITHIN_OBJECT_LITERAL_BRACES = option;
                custom.SPACES_WITHIN_IMPORTS = option;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$ObjectCurlySpacing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$ObjectCurlySpacing";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class OneVarDeclarationPerLine
    extends EslintRuleMapper {
        protected OneVarDeclarationPerLine() {
            super("one-var-declaration-per-line");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                OneVarDeclarationPerLine.$$$reportNull$$$0(0);
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.VAR_DECLARATION_WRAP != 2), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.VAR_DECLARATION_WRAP = 2;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eslintConfig", "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$OneVarDeclarationPerLine", "create"));
        }
    }

    private static class ObjectPropertyNewLine
    extends EslintRuleMapper {
        protected ObjectPropertyNewLine() {
            super("object-property-newline");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                ObjectPropertyNewLine.$$$reportNull$$$0(0);
            }
            if (values != null && !values.isEmpty()) {
                JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (object == null) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        ObjectPropertyNewLine.$$$reportNull$$$0(1);
                    }
                    return eslintSettingsConverter;
                }
                Boolean multiplePropertiesPerLine = ObjectPropertyNewLine.getBooleanOptionValue(object, "allowMultiplePropertiesPerLine", false);
                if (multiplePropertiesPerLine == null) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        ObjectPropertyNewLine.$$$reportNull$$$0(2);
                    }
                    return eslintSettingsConverter;
                }
                if (multiplePropertiesPerLine.booleanValue()) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.SKIPPED;
                    if (eslintSettingsConverter == null) {
                        ObjectPropertyNewLine.$$$reportNull$$$0(3);
                    }
                    return eslintSettingsConverter;
                }
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.OBJECT_LITERAL_WRAP != 2), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.OBJECT_LITERAL_WRAP = 2;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$ObjectPropertyNewLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$ObjectPropertyNewLine";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class Quotes
    extends EslintRuleMapper {
        protected Quotes() {
            super("quotes");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                Quotes.$$$reportNull$$$0(0);
            }
            boolean isDouble = true;
            if (values != null && !values.isEmpty()) {
                JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)values.get(0), JsonStringLiteral.class);
                if (literal != null) {
                    String text = StringUtil.unquoteString((String)literal.getValue());
                    if ("single".equals(text)) {
                        isDouble = false;
                    } else if (!"double".equals(text)) {
                        EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                        if (eslintSettingsConverter == null) {
                            Quotes.$$$reportNull$$$0(1);
                        }
                        return eslintSettingsConverter;
                    }
                } else {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        Quotes.$$$reportNull$$$0(2);
                    }
                    return eslintSettingsConverter;
                }
            }
            boolean finalIsDouble = isDouble;
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> finalIsDouble != custom.USE_DOUBLE_QUOTES || !custom.FORCE_QUOTE_STYlE), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.USE_DOUBLE_QUOTES = finalIsDouble;
                custom.FORCE_QUOTE_STYlE = true;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$Quotes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$Quotes";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class RestSpreadSpacing
    extends EslintRuleMapper {
        protected RestSpreadSpacing() {
            super("rest-spread-spacing");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            Boolean option;
            if (eslintConfig == null) {
                RestSpreadSpacing.$$$reportNull$$$0(0);
            }
            if ((option = this.getAlwaysNeverOption(values, false)) == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    RestSpreadSpacing.$$$reportNull$$$0(1);
                }
                return eslintSettingsConverter;
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.SPACE_AFTER_DOTS_IN_REST_PARAMETER != option), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.SPACE_AFTER_DOTS_IN_REST_PARAMETER = option;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$RestSpreadSpacing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$RestSpreadSpacing";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class Semi
    extends EslintRuleMapper {
        protected Semi() {
            super("semi");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            Boolean isOn;
            if (eslintConfig == null) {
                Semi.$$$reportNull$$$0(0);
            }
            if ((isOn = this.getAlwaysNeverOption(values, true)) == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    Semi.$$$reportNull$$$0(1);
                }
                return eslintSettingsConverter;
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> isOn != custom.USE_SEMICOLON_AFTER_STATEMENT || !custom.FORCE_SEMICOLON_STYLE), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.USE_SEMICOLON_AFTER_STATEMENT = isOn;
                custom.FORCE_SEMICOLON_STYLE = true;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$Semi";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$Semi";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class SemiSpacing
    extends EslintRuleMapper {
        protected SemiSpacing() {
            super("semi-spacing");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            BeforeAfter<Boolean> beforeAfter;
            if (eslintConfig == null) {
                SemiSpacing.$$$reportNull$$$0(0);
            }
            if ((beforeAfter = SemiSpacing.getBeforeAfter(values, false, true)) == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    SemiSpacing.$$$reportNull$$$0(1);
                }
                return eslintSettingsConverter;
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_SEMICOLON != (Boolean)beforeAfter.getBefore()), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_SEMICOLON = (Boolean)beforeAfter.getBefore();
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$SemiSpacing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$SemiSpacing";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class SortImports
    extends EslintRuleMapper {
        protected SortImports() {
            super("sort-imports");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                SortImports.$$$reportNull$$$0(0);
            }
            boolean sortMembers = true;
            if (values != null && !values.isEmpty()) {
                JsonObject config = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (config == null) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        SortImports.$$$reportNull$$$0(1);
                    }
                    return eslintSettingsConverter;
                }
                Boolean option = SortImports.getBooleanOptionValue(config, "ignoreMemberSort", false);
                if (option == null) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        SortImports.$$$reportNull$$$0(2);
                    }
                    return eslintSettingsConverter;
                }
                sortMembers = option == false;
            }
            boolean finalSortMembers = sortMembers;
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> finalSortMembers != custom.IMPORT_SORT_MEMBERS || !custom.IMPORT_SORT_MODULE_NAME), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.IMPORT_SORT_MEMBERS = finalSortMembers;
                custom.IMPORT_SORT_MODULE_NAME = true;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$SortImports";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$SortImports";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class SpaceBeforeBlocks
    extends EslintRuleMapper {
        protected SpaceBeforeBlocks() {
            super("space-before-blocks");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                SpaceBeforeBlocks.$$$reportNull$$$0(0);
            }
            SubGroupOption functions = new SubGroupOption("functions");
            SubGroupOption keywords = new SubGroupOption("keywords");
            SubGroupOption classes = new SubGroupOption("classes");
            if (values != null && !values.isEmpty()) {
                JsonObject config = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (config != null) {
                    boolean hasErrors = Stream.of(functions, keywords, classes).anyMatch(group -> {
                        JsonProperty functionsProperty = config.findProperty(group.myOptionName);
                        if (functionsProperty == null) {
                            return false;
                        }
                        JsonValue value = functionsProperty.getValue();
                        if (value == null) {
                            return true;
                        }
                        Boolean option = this.getAlwaysNeverOption(Collections.singletonList(value), true);
                        if (option == null) {
                            return true;
                        }
                        group.myValue = option;
                        return false;
                    });
                    if (hasErrors) {
                        EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                        if (eslintSettingsConverter == null) {
                            SpaceBeforeBlocks.$$$reportNull$$$0(1);
                        }
                        return eslintSettingsConverter;
                    }
                } else {
                    Boolean option = this.getAlwaysNeverOption(values, true);
                    if (option == null) {
                        EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                        if (eslintSettingsConverter == null) {
                            SpaceBeforeBlocks.$$$reportNull$$$0(2);
                        }
                        return eslintSettingsConverter;
                    }
                    keywords.myValue = classes.myValue = option;
                    functions.myValue = classes.myValue;
                }
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_METHOD_LBRACE != functions.myValue || common.SPACE_BEFORE_IF_LBRACE != keywords.myValue || common.SPACE_BEFORE_ELSE_LBRACE != keywords.myValue || common.SPACE_BEFORE_FOR_LBRACE != keywords.myValue || common.SPACE_BEFORE_WHILE_LBRACE != keywords.myValue || common.SPACE_BEFORE_DO_LBRACE != keywords.myValue || common.SPACE_BEFORE_SWITCH_LBRACE != keywords.myValue || common.SPACE_BEFORE_TRY_LBRACE != keywords.myValue || common.SPACE_BEFORE_CATCH_LBRACE != keywords.myValue || common.SPACE_BEFORE_FINALLY_LBRACE != keywords.myValue || custom.SPACE_BEFORE_CLASS_LBRACE != classes.myValue), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_METHOD_LBRACE = functions.myValue;
                common.SPACE_BEFORE_IF_LBRACE = keywords.myValue;
                common.SPACE_BEFORE_ELSE_LBRACE = keywords.myValue;
                common.SPACE_BEFORE_FOR_LBRACE = keywords.myValue;
                common.SPACE_BEFORE_WHILE_LBRACE = keywords.myValue;
                common.SPACE_BEFORE_DO_LBRACE = keywords.myValue;
                common.SPACE_BEFORE_SWITCH_LBRACE = keywords.myValue;
                common.SPACE_BEFORE_TRY_LBRACE = keywords.myValue;
                common.SPACE_BEFORE_CATCH_LBRACE = keywords.myValue;
                common.SPACE_BEFORE_FINALLY_LBRACE = keywords.myValue;
                custom.SPACE_BEFORE_CLASS_LBRACE = classes.myValue;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$SpaceBeforeBlocks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$SpaceBeforeBlocks";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }

        private static class SubGroupOption {
            private final String myOptionName;
            private Boolean myValue;

            SubGroupOption(String optionName) {
                this.myOptionName = optionName;
                this.myValue = true;
            }
        }
    }

    private static class SpaceBeforeFunctionParen
    extends EslintRuleMapper {
        protected SpaceBeforeFunctionParen() {
            super("space-before-function-paren");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            Boolean forArrow;
            Boolean forAnonymous;
            Boolean forNamed;
            Boolean option;
            if (eslintConfig == null) {
                SpaceBeforeFunctionParen.$$$reportNull$$$0(0);
            }
            if ((option = this.getAlwaysNeverOption(values, true)) == null) {
                JsonObject obj;
                JsonObject jsonObject = obj = values != null && !values.isEmpty() && values.get(0) instanceof JsonObject ? (JsonObject)values.get(0) : null;
                if (obj == null) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        SpaceBeforeFunctionParen.$$$reportNull$$$0(1);
                    }
                    return eslintSettingsConverter;
                }
                forNamed = this.getAlwaysNeverOption(obj.findProperty("named"), true);
                forAnonymous = this.getAlwaysNeverOption(obj.findProperty("anonymous"), true);
                forArrow = this.getAlwaysNeverOption(obj.findProperty("asyncArrow"), true);
            } else {
                forNamed = option;
                forAnonymous = option;
                forArrow = option;
            }
            if (forAnonymous == null || forNamed == null || forArrow == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    SpaceBeforeFunctionParen.$$$reportNull$$$0(2);
                }
                return eslintSettingsConverter;
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_METHOD_PARENTHESES != forNamed || custom.SPACE_BEFORE_FUNCTION_LEFT_PARENTH != forAnonymous || custom.SPACE_BEFORE_ASYNC_ARROW_LPAREN != forArrow), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_METHOD_PARENTHESES = forNamed;
                custom.SPACE_BEFORE_FUNCTION_LEFT_PARENTH = forAnonymous;
                custom.SPACE_BEFORE_ASYNC_ARROW_LPAREN = forArrow;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$SpaceBeforeFunctionParen";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$SpaceBeforeFunctionParen";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class SpaceInParens
    extends EslintRuleMapper {
        protected SpaceInParens() {
            super("space-in-parens");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            Boolean option;
            if (eslintConfig == null) {
                SpaceInParens.$$$reportNull$$$0(0);
            }
            if ((option = this.getAlwaysNeverOption(values, false)) == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    SpaceInParens.$$$reportNull$$$0(1);
                }
                return eslintSettingsConverter;
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_WITHIN_METHOD_CALL_PARENTHESES != option || common.SPACE_WITHIN_PARENTHESES != option || common.SPACE_WITHIN_METHOD_PARENTHESES != option), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_WITHIN_METHOD_CALL_PARENTHESES = option;
                common.SPACE_WITHIN_PARENTHESES = option;
                common.SPACE_WITHIN_METHOD_PARENTHESES = option;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$SpaceInParens";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$SpaceInParens";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class SpaceInfixOps
    extends EslintRuleMapper {
        protected SpaceInfixOps() {
            super("space-infix-ops");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                SpaceInfixOps.$$$reportNull$$$0(0);
            }
            boolean skipBitwise = false;
            if (values != null && !values.isEmpty()) {
                JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (object == null) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        SpaceInfixOps.$$$reportNull$$$0(1);
                    }
                    return eslintSettingsConverter;
                }
                JsonProperty int32Hint = object.findProperty("int32Hint");
                if (int32Hint != null) {
                    JsonBooleanLiteral literal = (JsonBooleanLiteral)ObjectUtils.tryCast((Object)int32Hint.getValue(), JsonBooleanLiteral.class);
                    if (literal == null) {
                        EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                        if (eslintSettingsConverter == null) {
                            SpaceInfixOps.$$$reportNull$$$0(2);
                        }
                        return eslintSettingsConverter;
                    }
                    skipBitwise = literal.getValue();
                }
            }
            boolean finalSkipBitwise = skipBitwise;
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> !common.SPACE_AROUND_ASSIGNMENT_OPERATORS || !common.SPACE_AROUND_LOGICAL_OPERATORS || !common.SPACE_AROUND_EQUALITY_OPERATORS || !common.SPACE_AROUND_RELATIONAL_OPERATORS || finalSkipBitwise == common.SPACE_AROUND_BITWISE_OPERATORS || !common.SPACE_AROUND_ADDITIVE_OPERATORS || !common.SPACE_AROUND_MULTIPLICATIVE_OPERATORS || !common.SPACE_AROUND_SHIFT_OPERATORS), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
                common.SPACE_AROUND_LOGICAL_OPERATORS = true;
                common.SPACE_AROUND_EQUALITY_OPERATORS = true;
                common.SPACE_AROUND_RELATIONAL_OPERATORS = true;
                common.SPACE_AROUND_BITWISE_OPERATORS = !finalSkipBitwise;
                common.SPACE_AROUND_ADDITIVE_OPERATORS = true;
                common.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
                common.SPACE_AROUND_SHIFT_OPERATORS = true;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$SpaceInfixOps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$SpaceInfixOps";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class SpaceUnaryOps
    extends EslintRuleMapper {
        protected SpaceUnaryOps() {
            super("space-unary-ops");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            if (eslintConfig == null) {
                SpaceUnaryOps.$$$reportNull$$$0(0);
            }
            Boolean nonWords = false;
            Boolean notValue = false;
            if (values != null && !values.isEmpty()) {
                JsonObject overridesValue;
                JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (object == null) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        SpaceUnaryOps.$$$reportNull$$$0(1);
                    }
                    return eslintSettingsConverter;
                }
                nonWords = SpaceUnaryOps.getBooleanOptionValue(object, "nonwords", false);
                if (nonWords == null) {
                    EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                    if (eslintSettingsConverter == null) {
                        SpaceUnaryOps.$$$reportNull$$$0(2);
                    }
                    return eslintSettingsConverter;
                }
                JsonProperty overridesProp = object.findProperty("overrides");
                if (overridesProp != null && (overridesValue = (JsonObject)ObjectUtils.tryCast((Object)overridesProp.getValue(), JsonObject.class)) != null) {
                    notValue = SpaceUnaryOps.getBooleanOptionValue(overridesValue, "!", nonWords);
                }
                if (notValue == null) {
                    notValue = nonWords;
                }
            }
            Boolean finalNonWords = nonWords;
            Boolean finalNotValue = notValue;
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_AROUND_UNARY_OPERATOR != finalNonWords || custom.SPACE_AFTER_UNARY_NOT != finalNotValue), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_AROUND_UNARY_OPERATOR = finalNonWords;
                custom.SPACE_AFTER_UNARY_NOT = finalNotValue;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$SpaceUnaryOps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$SpaceUnaryOps";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class SpacedComment
    extends EslintRuleMapper {
        protected SpacedComment() {
            super("spaced-comment");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            Boolean isOn;
            if (eslintConfig == null) {
                SpacedComment.$$$reportNull$$$0(0);
            }
            if ((isOn = this.getAlwaysNeverOption(values, true)) == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    SpacedComment.$$$reportNull$$$0(1);
                }
                return eslintSettingsConverter;
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> isOn != common.LINE_COMMENT_ADD_SPACE || isOn != common.BLOCK_COMMENT_ADD_SPACE), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                if (isOn.booleanValue()) {
                    common.LINE_COMMENT_AT_FIRST_COLUMN = false;
                }
                common.LINE_COMMENT_ADD_SPACE = isOn;
                common.BLOCK_COMMENT_ADD_SPACE = isOn;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$SpacedComment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$SpacedComment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class YieldStarSpacing
    extends EslintRuleMapper {
        protected YieldStarSpacing() {
            super("yield-star-spacing");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            BeforeAfter beforeAfter;
            if (eslintConfig == null) {
                YieldStarSpacing.$$$reportNull$$$0(0);
            }
            if (values != null && !values.isEmpty()) {
                JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)values.get(0), JsonStringLiteral.class);
                if (literal != null) {
                    switch (StringUtil.unquoteString((String)literal.getValue())) {
                        case "after": {
                            beforeAfter = new BeforeAfter((Object)false, (Object)true);
                            break;
                        }
                        case "before": {
                            beforeAfter = new BeforeAfter((Object)true, (Object)false);
                            break;
                        }
                        case "both": {
                            beforeAfter = new BeforeAfter((Object)true, (Object)true);
                            break;
                        }
                        case "neither": {
                            beforeAfter = new BeforeAfter((Object)false, (Object)false);
                            break;
                        }
                        default: {
                            EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                            if (eslintSettingsConverter == null) {
                                YieldStarSpacing.$$$reportNull$$$0(1);
                            }
                            return eslintSettingsConverter;
                        }
                    }
                } else {
                    beforeAfter = YieldStarSpacing.getBeforeAfter(values, false, true);
                    if (beforeAfter == null) {
                        EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                        if (eslintSettingsConverter == null) {
                            YieldStarSpacing.$$$reportNull$$$0(2);
                        }
                        return eslintSettingsConverter;
                    }
                }
            } else {
                beforeAfter = new BeforeAfter((Object)false, (Object)true);
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.SPACE_BEFORE_GENERATOR_MULT != (Boolean)beforeAfter.getBefore() || custom.SPACE_AFTER_GENERATOR_MULT != (Boolean)beforeAfter.getAfter()), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.SPACE_BEFORE_GENERATOR_MULT = (Boolean)beforeAfter.getBefore();
                custom.SPACE_AFTER_GENERATOR_MULT = (Boolean)beforeAfter.getAfter();
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$YieldStarSpacing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$YieldStarSpacing";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class TemplateCurlySpacing
    extends EslintRuleMapper {
        private TemplateCurlySpacing() {
            super("template-curly-spacing");
        }

        @Override
        @NotNull
        protected EslintSettingsConverter create(@Nullable List<JsonValue> values, @NotNull EslintRuleMapper.EslintConfig eslintConfig) {
            Boolean option;
            if (eslintConfig == null) {
                TemplateCurlySpacing.$$$reportNull$$$0(0);
            }
            if ((option = this.getAlwaysNeverOption(values, false)) == null) {
                EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.MISCONFIGURATION;
                if (eslintSettingsConverter == null) {
                    TemplateCurlySpacing.$$$reportNull$$$0(1);
                }
                return eslintSettingsConverter;
            }
            return new EslintJsSettingsConverter(eslintConfig, (PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.SPACES_WITHIN_INTERPOLATION_EXPRESSIONS != option), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.SPACES_WITHIN_INTERPOLATION_EXPRESSIONS = option;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$TemplateCurlySpacing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintStandardRuleMappersFactory$TemplateCurlySpacing";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

