/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConsoleProgress {
    private static final long DELAY_MILLIS = 300L;
    private final ConsoleViewImpl myConsoleView;
    private Alarm myAlarm;
    private int myCounter;
    private Inlay myCurrentInlay;
    private int myCurrentDocumentLength;

    private ConsoleProgress(@NotNull ConsoleViewImpl consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            ConsoleProgress.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            ConsoleProgress.$$$reportNull$$$0(1);
        }
        this.myCounter = 0;
        this.myConsoleView = consoleView;
        if (!processHandler.isProcessTerminated()) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> ConsoleProgress.this.start(), ModalityState.any());
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> ConsoleProgress.this.stop(), ModalityState.any());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/intellij/lang/javascript/modules/ConsoleProgress$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "startNotified";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    @Nullable
    public static ConsoleProgress install(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            ConsoleProgress.$$$reportNull$$$0(2);
        }
        if (processHandler == null) {
            ConsoleProgress.$$$reportNull$$$0(3);
        }
        if (consoleView instanceof ConsoleViewImpl) {
            return new ConsoleProgress((ConsoleViewImpl)consoleView, processHandler);
        }
        return null;
    }

    private char nextProgressChar() {
        return "-\\|/".charAt(this.myCounter++ % 4);
    }

    private void start() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myAlarm != null) {
            return;
        }
        final ProgressRenderer renderer = new ProgressRenderer(this.nextProgressChar());
        this.myAlarm = new Alarm();
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                Editor editor = ConsoleProgress.this.myConsoleView.getEditor();
                if (editor != null && !editor.isDisposed()) {
                    Document document = editor.getDocument();
                    int documentLength = document.getTextLength();
                    if (documentLength > 0 && document.getImmutableCharSequence().charAt(documentLength - 1) == '\n') {
                        if (documentLength == ConsoleProgress.this.myCurrentDocumentLength && ConsoleProgress.this.myCurrentInlay != null) {
                            renderer.setProgressChar(ConsoleProgress.this.nextProgressChar());
                            ConsoleProgress.this.myCurrentInlay.update();
                            ConsoleProgress.this.myCurrentInlay.repaint();
                        } else {
                            ConsoleProgress.this.myCurrentDocumentLength = documentLength;
                            ConsoleProgress.this.hideProgress();
                            InlayModel inlayModel = editor.getInlayModel();
                            renderer.setProgressChar(ConsoleProgress.this.nextProgressChar());
                            ConsoleProgress.this.myCurrentInlay = inlayModel.addInlineElement(documentLength, (EditorCustomElementRenderer)renderer);
                        }
                    } else {
                        ConsoleProgress.this.hideProgress();
                    }
                }
                ConsoleProgress.this.myAlarm.addRequest((Runnable)this, 300L, ModalityState.any());
            }
        }, 300L, ModalityState.any());
    }

    private void hideProgress() {
        if (this.myCurrentInlay != null) {
            Disposer.dispose((Disposable)this.myCurrentInlay);
            this.myCurrentInlay = null;
        }
    }

    private void stop() {
        ThreadingAssertions.assertEventDispatchThread();
        this.hideProgress();
        if (this.myAlarm != null) {
            this.myAlarm.cancelAllRequests();
            Disposer.dispose((Disposable)this.myAlarm);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/modules/ConsoleProgress";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ProgressRenderer
    implements EditorCustomElementRenderer {
        private char myProgressChar;

        private ProgressRenderer(char initialProgressChar) {
            this.myProgressChar = initialProgressChar;
        }

        void setProgressChar(char progressChar) {
            this.myProgressChar = progressChar;
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                ProgressRenderer.$$$reportNull$$$0(0);
            }
            Editor editor = inlay.getEditor();
            Font font = ProgressRenderer.getFont(editor);
            return editor.getContentComponent().getFontMetrics(font).stringWidth(String.valueOf(this.myProgressChar));
        }

        public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            if (inlay == null) {
                ProgressRenderer.$$$reportNull$$$0(1);
            }
            if (g == null) {
                ProgressRenderer.$$$reportNull$$$0(2);
            }
            if (targetRegion == null) {
                ProgressRenderer.$$$reportNull$$$0(3);
            }
            if (textAttributes == null) {
                ProgressRenderer.$$$reportNull$$$0(4);
            }
            Editor editor = inlay.getEditor();
            g.setColor((Color)JBColor.DARK_GRAY);
            g.setFont(ProgressRenderer.getFont(editor));
            g.drawString(String.valueOf(this.myProgressChar), targetRegion.x, targetRegion.y + editor.getAscent());
        }

        private static Font getFont(@NotNull Editor editor) {
            if (editor == null) {
                ProgressRenderer.$$$reportNull$$$0(5);
            }
            return editor.getColorsScheme().getFont(EditorFontType.PLAIN);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRegion";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributes";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/modules/ConsoleProgress$ProgressRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcWidthInPixels";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFont";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

