/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.modules.imports.JSAddImportExecutor;
import com.intellij.lang.javascript.modules.imports.JSImportAction;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExecutorFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSImportCandidateWithExecutor
implements Comparable<JSImportCandidateWithExecutor> {
    @NotNull
    private final JSImportCandidate myCandidate;
    @NotNull
    private final JSAddImportExecutor myExecutor;

    public JSImportCandidateWithExecutor(@NotNull JSImportCandidate candidate, @NotNull JSAddImportExecutor executor) {
        if (candidate == null) {
            JSImportCandidateWithExecutor.$$$reportNull$$$0(0);
        }
        if (executor == null) {
            JSImportCandidateWithExecutor.$$$reportNull$$$0(1);
        }
        this.myCandidate = candidate;
        this.myExecutor = executor;
    }

    @NotNull
    public String getName() {
        String string = this.myCandidate.getName();
        if (string == null) {
            JSImportCandidateWithExecutor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myCandidate.getElement();
    }

    @Nullable
    public JSImportDescriptor getDescriptor() {
        return this.myCandidate.getDescriptor();
    }

    @NotNull
    public JSImportCandidate getCandidate() {
        JSImportCandidate jSImportCandidate = this.myCandidate;
        if (jSImportCandidate == null) {
            JSImportCandidateWithExecutor.$$$reportNull$$$0(3);
        }
        return jSImportCandidate;
    }

    @NotNull
    public JSAddImportExecutor getExecutor() {
        JSAddImportExecutor jSAddImportExecutor = this.myExecutor;
        if (jSAddImportExecutor == null) {
            JSImportCandidateWithExecutor.$$$reportNull$$$0(4);
        }
        return jSAddImportExecutor;
    }

    @NlsSafe
    @NotNull
    public String getImportText() {
        JSImportDescriptor descriptor = this.myCandidate.getDescriptor();
        if (descriptor == null) {
            String string = "import " + this.myCandidate.getName();
            if (string == null) {
                JSImportCandidateWithExecutor.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = this.myExecutor.getImportStatementText(descriptor);
        if (string == null) {
            JSImportCandidateWithExecutor.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void execute() {
        this.myExecutor.createImportOrUpdateExisting(this.myCandidate);
    }

    @Override
    public int compareTo(@NotNull JSImportCandidateWithExecutor o) {
        int otherPriority;
        int priority;
        if (o == null) {
            JSImportCandidateWithExecutor.$$$reportNull$$$0(7);
        }
        if ((priority = o.myExecutor.priority()) == (otherPriority = this.myExecutor.priority())) {
            return JSImportAction.COMPARE_CANDIDATES.compare(this.myCandidate, o.myCandidate);
        }
        return Integer.compare(priority, otherPriority);
    }

    @NotNull
    public static List<JSImportCandidateWithExecutor> sortWithExecutors(@Nullable JSImportCandidate candidate, @NotNull PsiElement place) {
        if (place == null) {
            JSImportCandidateWithExecutor.$$$reportNull$$$0(8);
        }
        if (candidate == null) {
            List<JSImportCandidateWithExecutor> list = Collections.emptyList();
            if (list == null) {
                JSImportCandidateWithExecutor.$$$reportNull$$$0(9);
            }
            return list;
        }
        return JSImportCandidateWithExecutor.sortWithExecutors(ContainerUtil.createMaybeSingletonList((Object)candidate), place);
    }

    @NotNull
    public static List<JSImportCandidateWithExecutor> sortWithExecutors(@NotNull List<? extends JSImportCandidate> candidates, @NotNull PsiElement place) {
        if (candidates == null) {
            JSImportCandidateWithExecutor.$$$reportNull$$$0(10);
        }
        if (place == null) {
            JSImportCandidateWithExecutor.$$$reportNull$$$0(11);
        }
        return JSImportCandidateWithExecutor.sortWithExecutors(candidates, DialectDetector.languageOfElement(place), place);
    }

    @NotNull
    public static List<JSImportCandidateWithExecutor> sortWithExecutors(@NotNull List<? extends JSImportCandidate> candidates, @NotNull Language contextLanguage, @NotNull PsiElement place) {
        if (candidates == null) {
            JSImportCandidateWithExecutor.$$$reportNull$$$0(12);
        }
        if (contextLanguage == null) {
            JSImportCandidateWithExecutor.$$$reportNull$$$0(13);
        }
        if (place == null) {
            JSImportCandidateWithExecutor.$$$reportNull$$$0(14);
        }
        if (candidates.isEmpty()) {
            List<JSImportCandidateWithExecutor> list = Collections.emptyList();
            if (list == null) {
                JSImportCandidateWithExecutor.$$$reportNull$$$0(15);
            }
            return list;
        }
        List<JSImportExecutorFactory> factories = JSHandlersFactory.forLanguage(contextLanguage).createImportFactories(place);
        List<JSImportCandidateWithExecutor> list = candidates.stream().distinct().flatMap(el -> ContainerUtil.mapNotNull((Collection)factories, factory -> factory.isAvailable((JSImportCandidate)el, place) ? new JSImportCandidateWithExecutor((JSImportCandidate)el, factory.createExecutor(place)) : null).stream()).sorted().toList();
        if (list == null) {
            JSImportCandidateWithExecutor.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 9, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/JSImportCandidateWithExecutor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/JSImportCandidateWithExecutor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportText";
                break;
            }
            case 9: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sortWithExecutors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sortWithExecutors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 9, 15, 16 -> new IllegalStateException(string);
        };
    }
}

