/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ThreeState;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class JSArrowFunctionDetector {
    public static final JSArrowFunctionDetector INSTANCE = new JSArrowFunctionDetector();
    private static final Map<IElementType, IElementType> PARENS = new HashMap<IElementType, IElementType>();
    private static final Map<IElementType, IElementType> GENERIC_PARENS;

    private JSArrowFunctionDetector() {
    }

    public boolean isArrowFunctionExpression(@NotNull PsiBuilder builder2, @NotNull FunctionParser<?> parser2) {
        if (builder2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(0);
        }
        if (parser2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(1);
        }
        PsiBuilder.Marker marker = builder2.mark();
        boolean result2 = this.checkArrowFunctionExpression(builder2, parser2);
        marker.rollbackTo();
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkArrowFunctionExpression(@NotNull PsiBuilder builder2, @NotNull FunctionParser<?> parser2) {
        if (builder2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(2);
        }
        if (parser2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(3);
        }
        this.skipAngleBrackets(builder2);
        if (builder2.getTokenType() != JSTokenTypes.LPAR) {
            return false;
        }
        IElementType next = builder2.lookAhead(1);
        if (!parser2.isValidFirstParameterStart(next)) {
            return false;
        }
        builder2.advanceLexer();
        if (next == JSTokenTypes.RPAR) {
            builder2.advanceLexer();
            if (builder2.getTokenType() == JSTokenTypes.COLON) {
                return true;
            }
        } else {
            while (!builder2.eof()) {
                ThreeState subResult;
                IElementType tokenType = builder2.getTokenType();
                if (tokenType == JSTokenTypes.RPAR) {
                    builder2.advanceLexer();
                    break;
                }
                if (tokenType == JSTokenTypes.COMMA) {
                    if (builder2.lookAhead(1) == JSTokenTypes.EQ) {
                        return true;
                    }
                    builder2.advanceLexer();
                }
                if ((subResult = this.checkCommaSeparatedListElement(builder2, parser2)) == ThreeState.UNSURE) continue;
                return subResult.toBoolean();
            }
        }
        Boolean data = (Boolean)builder2.getUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING);
        try {
            builder2.putUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING, (Object)true);
            if (builder2.getTokenType() == JSTokenTypes.COLON && !((JSPsiTypeParser)parser2.myJavaScriptParser.getTypeParser()).tryParseArrowFunctionReturnType()) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            builder2.putUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING, (Object)data);
        }
        return JSTokenTypes.ARROWS.contains(builder2.getTokenType());
    }

    @NotNull
    private ThreeState checkCommaSeparatedListElement(@NotNull PsiBuilder builder2, @NotNull FunctionParser<?> parser2) {
        if (builder2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(4);
        }
        if (parser2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(5);
        }
        boolean seenEquals = false;
        boolean seenTypeColon = false;
        while (!builder2.eof()) {
            IElementType tokenType = builder2.getTokenType();
            if (PARENS.containsKey(tokenType)) {
                if (this.skipParentheses(builder2, PARENS)) continue;
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    JSArrowFunctionDetector.$$$reportNull$$$0(6);
                }
                return threeState;
            }
            if (seenTypeColon && tokenType == JSTokenTypes.LT) {
                if (this.skipParentheses(builder2, GENERIC_PARENS)) continue;
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    JSArrowFunctionDetector.$$$reportNull$$$0(7);
                }
                return threeState;
            }
            if (tokenType == JSTokenTypes.COMMA || tokenType == JSTokenTypes.RPAR) break;
            if (seenEquals) {
                builder2.advanceLexer();
                continue;
            }
            if (tokenType == JSTokenTypes.EQ) {
                seenEquals = true;
            } else if (tokenType == JSTokenTypes.QUEST) {
                IElementType lookahead = builder2.lookAhead(1);
                if (lookahead == JSTokenTypes.COLON || lookahead == JSTokenTypes.EQ || lookahead == JSTokenTypes.COMMA || lookahead == JSTokenTypes.RPAR) {
                    ThreeState threeState = ThreeState.YES;
                    if (threeState == null) {
                        JSArrowFunctionDetector.$$$reportNull$$$0(8);
                    }
                    return threeState;
                }
                if (!seenTypeColon || !parser2.supportsColonTypeCast()) {
                    ThreeState threeState = ThreeState.NO;
                    if (threeState == null) {
                        JSArrowFunctionDetector.$$$reportNull$$$0(9);
                    }
                    return threeState;
                }
            } else if (tokenType == JSTokenTypes.COLON) {
                if (!parser2.supportsColonTypeCast()) {
                    ThreeState threeState = ThreeState.YES;
                    if (threeState == null) {
                        JSArrowFunctionDetector.$$$reportNull$$$0(10);
                    }
                    return threeState;
                }
                seenTypeColon = true;
            } else {
                if (!seenTypeColon && tokenType == JSTokenTypes.AT) {
                    ThreeState threeState = ThreeState.YES;
                    if (threeState == null) {
                        JSArrowFunctionDetector.$$$reportNull$$$0(11);
                    }
                    return threeState;
                }
                if (!seenTypeColon && tokenType != JSTokenTypes.DOT_DOT_DOT && !JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType)) {
                    ThreeState threeState = ThreeState.NO;
                    if (threeState == null) {
                        JSArrowFunctionDetector.$$$reportNull$$$0(12);
                    }
                    return threeState;
                }
            }
            builder2.advanceLexer();
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(13);
        }
        return threeState;
    }

    public boolean isArrowFunctionType(@NotNull PsiBuilder builder2, @NotNull FunctionParser<?> parser2) {
        if (builder2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(14);
        }
        if (parser2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(15);
        }
        PsiBuilder.Marker marker = builder2.mark();
        boolean result2 = this.checkArrowFunctionType(builder2, parser2);
        marker.rollbackTo();
        return result2;
    }

    public boolean checkArrowFunctionType(@NotNull PsiBuilder builder2, @NotNull FunctionParser<?> parser2) {
        ThreeState state;
        if (builder2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(16);
        }
        if (parser2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(17);
        }
        if (builder2.getTokenType() == JSTokenTypes.LT) {
            return true;
        }
        if (builder2.getTokenType() != JSTokenTypes.LPAR) {
            return false;
        }
        IElementType next = builder2.lookAhead(1);
        if (!parser2.isValidFirstParameterStart(next)) {
            return false;
        }
        if (next == JSTokenTypes.RPAR || next == JSTokenTypes.DOT_DOT_DOT) {
            return true;
        }
        builder2.advanceLexer();
        boolean foundParameter = false;
        while (!builder2.eof() && parser2.myJavaScriptParser.isIdentifierName(builder2.getTokenType())) {
            builder2.advanceLexer();
            foundParameter = true;
        }
        if ((builder2.getTokenType() == JSTokenTypes.LBRACE || builder2.getTokenType() == JSTokenTypes.LBRACKET) && (state = this.skipAndCheckUnionOrIntersection(builder2)) == ThreeState.NO) {
            builder2.advanceLexer();
            foundParameter = true;
        }
        if (!foundParameter) {
            return false;
        }
        next = builder2.getTokenType();
        if (next == JSTokenTypes.COLON || next == JSTokenTypes.COMMA || next == JSTokenTypes.QUEST || next == JSTokenTypes.EQ) {
            return true;
        }
        if (next != JSTokenTypes.RPAR) {
            return false;
        }
        builder2.advanceLexer();
        return JSTokenTypes.ARROWS.contains(builder2.getTokenType());
    }

    private void skipAngleBrackets(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(18);
        }
        if (builder2.getTokenType() == JSTokenTypes.LT) {
            builder2.advanceLexer();
            int balance = 1;
            while (!builder2.eof()) {
                IElementType tokenType = builder2.getTokenType();
                if (tokenType == JSTokenTypes.LT) {
                    ++balance;
                } else if (tokenType == JSTokenTypes.GT) {
                    --balance;
                }
                builder2.advanceLexer();
                if (balance != 0) continue;
                break;
            }
        }
    }

    private boolean skipParentheses(@NotNull PsiBuilder builder2, @NotNull Map<IElementType, IElementType> parens) {
        if (builder2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(19);
        }
        if (parens == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(20);
        }
        ArrayDeque<IElementType> leftParens = new ArrayDeque<IElementType>();
        IElementType firstToken = builder2.getTokenType();
        assert (parens.containsKey(firstToken));
        leftParens.push(firstToken);
        builder2.advanceLexer();
        while (!builder2.eof()) {
            IElementType tokenType = builder2.getTokenType();
            if (tokenType == parens.get(leftParens.peek())) {
                leftParens.pop();
            } else {
                if (parens.containsValue(tokenType)) {
                    return false;
                }
                if (parens.containsKey(tokenType)) {
                    leftParens.push(tokenType);
                }
            }
            builder2.advanceLexer();
            if (!leftParens.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private ThreeState skipAndCheckUnionOrIntersection(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(21);
        }
        IElementType lpar = builder2.getTokenType();
        IElementType rpar = PARENS.get(lpar);
        boolean hasUnionOrIntersection = false;
        builder2.advanceLexer();
        while (!builder2.eof()) {
            IElementType tokenType = builder2.getTokenType();
            if (tokenType == rpar) {
                ThreeState threeState = ThreeState.fromBoolean((boolean)hasUnionOrIntersection);
                if (threeState == null) {
                    JSArrowFunctionDetector.$$$reportNull$$$0(22);
                }
                return threeState;
            }
            if (PARENS.containsValue(tokenType)) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    JSArrowFunctionDetector.$$$reportNull$$$0(23);
                }
                return threeState;
            }
            if (tokenType == JSTokenTypes.OR || tokenType == JSTokenTypes.AND) {
                hasUnionOrIntersection = true;
            }
            if (PARENS.containsKey(tokenType)) {
                ThreeState isUnionOrIntersectionInner = this.skipAndCheckUnionOrIntersection(builder2);
                if (isUnionOrIntersectionInner == ThreeState.UNSURE) {
                    ThreeState threeState = ThreeState.UNSURE;
                    if (threeState == null) {
                        JSArrowFunctionDetector.$$$reportNull$$$0(24);
                    }
                    return threeState;
                }
                hasUnionOrIntersection |= isUnionOrIntersectionInner == ThreeState.YES;
            }
            builder2.advanceLexer();
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(25);
        }
        return threeState;
    }

    static {
        PARENS.put(JSTokenTypes.LPAR, JSTokenTypes.RPAR);
        PARENS.put(JSTokenTypes.LBRACE, JSTokenTypes.RBRACE);
        PARENS.put(JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET);
        PARENS.put(JSTokenTypes.LBRACE_OR, JSTokenTypes.OR_RBRACE);
        GENERIC_PARENS = new HashMap<IElementType, IElementType>();
        GENERIC_PARENS.put(JSTokenTypes.LT, JSTokenTypes.GT);
        GENERIC_PARENS.putAll(PARENS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11, 12, 13, 22, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/parsing/JSArrowFunctionDetector";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/parsing/JSArrowFunctionDetector";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "checkCommaSeparatedListElement";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "skipAndCheckUnionOrIntersection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isArrowFunctionExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkArrowFunctionExpression";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkCommaSeparatedListElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isArrowFunctionType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkArrowFunctionType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "skipAngleBrackets";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "skipParentheses";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "skipAndCheckUnionOrIntersection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11, 12, 13, 22, 23, 24, 25 -> new IllegalStateException(string);
        };
    }
}

