/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public final class JSParsingContextUtil {
    public static final Key<Boolean> ASYNC_METHOD_KEY = Key.create((String)"js.asyncMethod");
    private static final Key<Boolean> IS_GENERATOR_FUNCTION_KEY = Key.create((String)"js.generator.Function");
    static final boolean IS_TOP_LEVEL_ASYNC = true;

    static void fillBuilderData(@NotNull PsiElement context2, PsiBuilder builder2, FunctionParser functionParser) {
        JSFunction parent;
        if (context2 == null) {
            JSParsingContextUtil.$$$reportNull$$$0(0);
        }
        builder2.putUserData(ASYNC_METHOD_KEY, (Object)((parent = (JSFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context2, (Class[])new Class[]{JSFunction.class})) != null ? parent.isAsync() : true));
        JSParsingContextUtil.setIsGenerator(parent != null && parent.isGenerator(), builder2);
    }

    public static boolean isAsyncContext(PsiBuilder builder2) {
        Boolean asyncValue = (Boolean)builder2.getUserData(ASYNC_METHOD_KEY);
        if (asyncValue == null) {
            return true;
        }
        return asyncValue;
    }

    public static boolean isGeneratorContext(PsiBuilder builder2) {
        return Boolean.TRUE.equals(builder2.getUserData(IS_GENERATOR_FUNCTION_KEY));
    }

    public static void setIsGenerator(boolean isGenerator, PsiBuilder builder2) {
        builder2.putUserData(IS_GENERATOR_FUNCTION_KEY, (Object)isGenerator);
    }

    @NotNull
    public static EnumSet<JSModifiersStructure.JSModifiersParseResult> saveAndUpdateParsingContext(@NotNull EnumSet<JSModifiersStructure.JSModifiersParseResult> newContext, @NotNull PsiBuilder builder2) {
        if (newContext == null) {
            JSParsingContextUtil.$$$reportNull$$$0(1);
        }
        if (builder2 == null) {
            JSParsingContextUtil.$$$reportNull$$$0(2);
        }
        boolean wasGeneratorContext = JSParsingContextUtil.isGeneratorContext(builder2);
        boolean wasAsyncContext = JSParsingContextUtil.isAsyncContext(builder2);
        JSParsingContextUtil.restoreParsingContext(newContext, builder2);
        EnumSet<JSModifiersStructure.JSModifiersParseResult> enumSet = wasGeneratorContext ? (wasAsyncContext ? EnumSet.of(JSModifiersStructure.JSModifiersParseResult.MULT_FOUND, JSModifiersStructure.JSModifiersParseResult.ASYNC_FOUND) : EnumSet.of(JSModifiersStructure.JSModifiersParseResult.MULT_FOUND)) : (wasAsyncContext ? EnumSet.of(JSModifiersStructure.JSModifiersParseResult.ASYNC_FOUND) : EnumSet.noneOf(JSModifiersStructure.JSModifiersParseResult.class));
        if (enumSet == null) {
            JSParsingContextUtil.$$$reportNull$$$0(3);
        }
        return enumSet;
    }

    public static void restoreParsingContext(@NotNull EnumSet<JSModifiersStructure.JSModifiersParseResult> savedContext, @NotNull PsiBuilder builder2) {
        if (savedContext == null) {
            JSParsingContextUtil.$$$reportNull$$$0(4);
        }
        if (builder2 == null) {
            JSParsingContextUtil.$$$reportNull$$$0(5);
        }
        JSParsingContextUtil.setIsGenerator(savedContext.contains((Object)JSModifiersStructure.JSModifiersParseResult.MULT_FOUND), builder2);
        builder2.putUserData(ASYNC_METHOD_KEY, (Object)savedContext.contains((Object)JSModifiersStructure.JSModifiersParseResult.ASYNC_FOUND));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContext";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/parsing/JSParsingContextUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "savedContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/parsing/JSParsingContextUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "saveAndUpdateParsingContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillBuilderData";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveAndUpdateParsingContext";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "restoreParsingContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

