/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.presentable;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.presentable.Capitalization;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSOverflowTypeTextStringBuilder;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeDeclarationUtilKt;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSFunctionReturnWrapperType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiFormatUtilBase;
import com.intellij.util.BitUtil;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSFormatUtil
extends PsiFormatUtilBase {
    @NotNull
    public static String formatField(@NotNull JSTypeDeclarationOwner field, int options) {
        if (field == null) {
            JSFormatUtil.$$$reportNull$$$0(0);
        }
        return JSFormatUtil.formatField(field, options, null);
    }

    @Nullable
    public static JSType adjustEvaluatedTypeForDocumentation(JSType type) {
        if (type instanceof JSRecordType || type instanceof JSFunctionType || type instanceof JSTupleType || type instanceof JSEvaluableOnlyType) {
            return null;
        }
        return type;
    }

    @NotNull
    private static String formatField(@NotNull JSTypeDeclarationOwner field, int options, @Nullable JSClass parentClassOverride) {
        if (field == null) {
            JSFormatUtil.$$$reportNull$$$0(1);
        }
        StringBuilder text = new StringBuilder();
        if (BitUtil.isSet((int)options, (int)2) && !BitUtil.isSet((int)options, (int)4)) {
            text.append(JSFormatUtil.getType(field, options));
        }
        JSFormatUtil.appendContainingClassIfNeeded(options, parentClassOverride, text, (PsiElement)field);
        if (BitUtil.isSet((int)options, (int)1)) {
            if (!BitUtil.isSet((int)options, (int)4096)) {
                JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            }
            text.append(field.getName());
        }
        if (BitUtil.isSet((int)options, (int)2) && BitUtil.isSet((int)options, (int)4)) {
            JSFormatUtil.appendTypeAfter((PsiElement)field, options, text, field.getJSType());
        }
        String string = text.toString();
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static void appendContainingClassIfNeeded(int options, @Nullable JSClass parentClassOverride, @NotNull StringBuilder text, @Nullable PsiElement context2) {
        if (text == null) {
            JSFormatUtil.$$$reportNull$$$0(3);
        }
        if (BitUtil.isSet((int)options, (int)4096)) {
            JSClass clazz;
            JSClass jSClass = clazz = parentClassOverride != null ? parentClassOverride : JSResolveUtil.getClassOfContext(context2);
            if (clazz != null && (BitUtil.isSet((int)options, (int)1) || BitUtil.isSet((int)options, (int)2048))) {
                String s;
                JSNamedElementPresenter presenter = new JSNamedElementPresenter(clazz);
                String string = s = BitUtil.isSet((int)options, (int)1) ? presenter.getShortName() : presenter.getQualifiedName();
                if (s.length() > 0) {
                    JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
                    text.append(s).append('.');
                }
            }
        }
    }

    @NlsSafe
    @NotNull
    public static String formatMethod(@NotNull JSFunction method, int options, int parametersOptions) {
        if (method == null) {
            JSFormatUtil.$$$reportNull$$$0(4);
        }
        return JSFormatUtil.formatMethod(method, options, parametersOptions, 7, null);
    }

    @NotNull
    public static String formatTypeMember(@NotNull TypeScriptTypeMember member, int options, int parameterOptions) {
        if (member == null) {
            JSFormatUtil.$$$reportNull$$$0(5);
        }
        if (member instanceof TypeScriptCallSignature) {
            return JSFormatUtil.formatMethod((JSFunction)((Object)member), options, parameterOptions, 7, null, "");
        }
        if (member instanceof TypeScriptIndexSignature) {
            return JSFormatUtil.formatIndexSignature((TypeScriptIndexSignature)member, options, parameterOptions);
        }
        if (member instanceof JSFunction) {
            return JSFormatUtil.formatMethod((JSFunction)((Object)member), options, parameterOptions);
        }
        if (member instanceof TypeScriptPropertySignature) {
            return JSFormatUtil.formatField((JSTypeDeclarationOwner)((Object)member), options);
        }
        String string = (String)ObjectUtils.coalesce((Object)member.getName(), (Object)"");
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String formatMethod(@NotNull JSFunctionItem method, int options, int parametersOptions, int maxParameters, @Nullable JSClass parentClassOverride) {
        if (method == null) {
            JSFormatUtil.$$$reportNull$$$0(7);
        }
        return JSFormatUtil.formatMethod(method, options, parametersOptions, maxParameters, parentClassOverride, JSFormatUtil.getAnonymousElementPresentation());
    }

    @NlsSafe
    @NotNull
    private static String formatMethod(@NotNull JSFunctionItem method, int options, int parametersOptions, int maxParameters, @Nullable JSClass parentClassOverride, String namePlaceholder) {
        String returnType;
        if (method == null) {
            JSFormatUtil.$$$reportNull$$$0(8);
        }
        StringBuilder text = new StringBuilder();
        if (BitUtil.isSet((int)options, (int)2) && !BitUtil.isSet((int)options, (int)4) && (returnType = JSFormatUtil.getReturnType(method, options)) != null) {
            JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            text.append(returnType);
        }
        JSFormatUtil.appendContainingClassIfNeeded(options, parentClassOverride, text, (PsiElement)method);
        if (BitUtil.isSet((int)options, (int)1)) {
            if (!BitUtil.isSet((int)options, (int)4096)) {
                JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            }
            text.append((String)ObjectUtils.coalesce((Object)method.getName(), (Object)namePlaceholder));
        }
        if (BitUtil.isSet((int)options, (int)256) && (!(method instanceof JSFunction) || ((JSFunction)method).getKind() != JSFunction.FunctionKind.GETTER && ((JSFunction)method).getKind() != JSFunction.FunctionKind.SETTER)) {
            text.append('(');
            JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)method, () -> {
                JSParameterItem[] params = method.getParameters();
                for (int i = 0; i < Math.min(params.length, maxParameters); ++i) {
                    if (i != 0) {
                        text.append(", ");
                    }
                    text.append(JSFormatUtil.formatParameter(params[i], parametersOptions));
                }
            });
            text.append(')');
        }
        if (BitUtil.isSet((int)options, (int)2) && BitUtil.isSet((int)options, (int)4)) {
            returnType = JSFormatUtil.getReturnType(method, options);
            JSFormatUtil.appendReturnType(text, returnType, DialectDetector.isActionScript((PsiElement)method));
        }
        String string = text.toString();
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static void appendReturnType(StringBuilder text, String returnType, boolean isActionScript) {
        if (!StringUtil.isEmpty((String)returnType)) {
            text.append(':');
            if (!isActionScript) {
                text.append(' ');
            }
            text.append(returnType);
        }
    }

    @NotNull
    private static String formatIndexSignature(@NotNull TypeScriptIndexSignature member, int options, int parameterOptions) {
        if (member == null) {
            JSFormatUtil.$$$reportNull$$$0(10);
        }
        StringBuilder text = new StringBuilder();
        JSFormatUtil.appendContainingClassIfNeeded(options, null, text, member);
        JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
        text.append('[');
        if (BitUtil.isSet((int)parameterOptions, (int)1)) {
            PsiElement parameterName = member.getParameterNameElement();
            if (parameterName != null) {
                text.append(parameterName.getText());
            }
            if (BitUtil.isSet((int)options, (int)2)) {
                JSType type = member.getMemberParameterType();
                JSFormatUtil.appendTypeAfter(member, options, text, type);
            }
        }
        text.append(']');
        if (BitUtil.isSet((int)options, (int)2)) {
            JSType type = member.getMemberType();
            JSFormatUtil.appendTypeAfter(member, options, text, type);
        }
        String string = text.toString();
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static void appendTypeAfter(@NotNull PsiElement member, int options, @NotNull StringBuilder text, @Nullable JSType type) {
        if (member == null) {
            JSFormatUtil.$$$reportNull$$$0(12);
        }
        if (text == null) {
            JSFormatUtil.$$$reportNull$$$0(13);
        }
        String typeString = JSFormatUtil.formatType(type, member, options);
        JSFormatUtil.appendReturnType(text, typeString, DialectDetector.isActionScript(member));
    }

    @NotNull
    private static String formatParameter(@NotNull JSParameterItem parameter, int options) {
        DialectOptionHolder optionHolder;
        if (parameter == null) {
            JSFormatUtil.$$$reportNull$$$0(14);
        }
        DialectOptionHolder dialectOptionHolder = optionHolder = parameter instanceof PsiElement ? DialectDetector.dialectOfElement((PsiElement)parameter) : null;
        if (!(!BitUtil.isSet((int)options, (int)2) || BitUtil.isSet((int)options, (int)65536) || optionHolder != null && optionHolder.hasFeature(JSLanguageFeature.TYPES))) {
            options &= 0xFFFFFFFD;
            options |= 1;
        }
        StringBuilder text = new StringBuilder();
        if (BitUtil.isSet((int)options, (int)2) && !BitUtil.isSet((int)options, (int)4)) {
            if (parameter.isRest() && optionHolder != null && optionHolder.isECMA4) {
                text.append("Array");
            } else {
                text.append(JSFormatUtil.formatType(parameter.getSimpleType(), (PsiElement)ObjectUtils.tryCast((Object)parameter, PsiElement.class), options));
            }
        }
        if (BitUtil.isSet((int)options, (int)1)) {
            JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            text.append(parameter.getName());
            if ((optionHolder == null || !optionHolder.isJavaScript()) && parameter.isOptional()) {
                text.append("?");
            }
        }
        if (BitUtil.isSet((int)options, (int)2) && BitUtil.isSet((int)options, (int)4)) {
            String typeName = parameter.isRest() && optionHolder != null && optionHolder.isECMA4 ? "Array" : JSFormatUtil.formatType(parameter.getSimpleType(), (PsiElement)ObjectUtils.tryCast((Object)parameter, PsiElement.class), options);
            JSFormatUtil.appendReturnType(text, typeName, optionHolder != null && optionHolder.isECMA4);
        }
        String string = text.toString();
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    private static String getReturnType(@NotNull JSFunctionItem method, int options) {
        if (method == null) {
            JSFormatUtil.$$$reportNull$$$0(16);
        }
        options |= 1;
        JSFunction psiFunction = (JSFunction)ObjectUtils.tryCast((Object)method, JSFunction.class);
        if (psiFunction != null && psiFunction.getKind() == JSFunction.FunctionKind.SETTER) {
            if (psiFunction.getParameterList() != null && method.getParameters().length > 0) {
                return JSFormatUtil.formatType(psiFunction.getParameters()[0].getJSType(), (PsiElement)method, options);
            }
            return null;
        }
        if (psiFunction != null && psiFunction.getKind() == JSFunction.FunctionKind.CONSTRUCTOR && !(psiFunction instanceof TypeScriptCallSignature)) {
            return null;
        }
        return JSFormatUtil.formatType(method.getReturnType(), (PsiElement)method, options);
    }

    @NotNull
    private static String getType(@NotNull JSTypeDeclarationOwner field, int options) {
        if (field == null) {
            JSFormatUtil.$$$reportNull$$$0(17);
        }
        return JSFormatUtil.formatType(field.getJSType(), (PsiElement)field, options);
    }

    @NotNull
    public static String formatType(@Nullable JSType type, @Nullable PsiElement context2, int options) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(context2);
        if (BitUtil.isSet((int)options, (int)1) && !JSFormatUtil.isPossiblyPresentableType(type, context2, false) && (type != null || dialect == null || !dialect.isTypeScript && !dialect.isECMA4)) {
            return "";
        }
        if ((dialect == null || !dialect.isTypeScript && !dialect.isECMA4) && type instanceof JSAnyType) {
            if (BitUtil.isSet((int)options, (int)1)) {
                return "";
            }
            type = null;
        }
        if (type != null) {
            NoResolveTypeTextStringBuilder builder2 = new NoResolveTypeTextStringBuilder();
            type.buildTypeText(dialect != null && dialect.isECMA4 ? JSType.TypeTextFormat.SIMPLE : JSType.TypeTextFormat.CODE, builder2);
            String typeName = builder2.getResult();
            String string = BitUtil.isSet((int)options, (int)8192) ? typeName : JSResolveUtil.getShortTypeName(typeName, true);
            if (string == null) {
                JSFormatUtil.$$$reportNull$$$0(18);
            }
            return string;
        }
        return dialect != null && dialect.isTypeScript ? "any" : "*";
    }

    @NotNull
    public static String formatTypeDeclaration(@NotNull JSTypeDeclaration typeDeclaration) {
        if (typeDeclaration == null) {
            JSFormatUtil.$$$reportNull$$$0(19);
        }
        String string = JSTypeDeclarationUtilKt.getPresentableTypeText(typeDeclaration);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nullable
    public static Icon getPropertyIcon(@NotNull JSFunction method) {
        if (method == null) {
            JSFormatUtil.$$$reportNull$$$0(21);
        }
        boolean isStatic = method.getAttributeList() != null && method.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC);
        JSFunction.FunctionKind kind = method.getKind();
        JSClass jsClass = JSUtils.getMemberContainingClass(method);
        if (kind == JSFunction.FunctionKind.GETTER) {
            if (jsClass.findFunctionByNameAndKind(method.getName(), JSFunction.FunctionKind.SETTER) != null) {
                return isStatic ? AllIcons.Nodes.PropertyReadWriteStatic : AllIcons.Nodes.PropertyReadWrite;
            }
            return isStatic ? AllIcons.Nodes.PropertyReadStatic : AllIcons.Nodes.PropertyRead;
        }
        if (kind == JSFunction.FunctionKind.SETTER) {
            if (jsClass.findFunctionByNameAndKind(method.getName(), JSFunction.FunctionKind.GETTER) != null) {
                return isStatic ? AllIcons.Nodes.PropertyReadWriteStatic : AllIcons.Nodes.PropertyReadWrite;
            }
            return isStatic ? AllIcons.Nodes.PropertyWriteStatic : AllIcons.Nodes.PropertyWrite;
        }
        return null;
    }

    @NotNull
    public static String formatVisibility(@NotNull JSAttributeList.AccessType accessType, @Nullable PsiElement context2) {
        if (accessType == null) {
            JSFormatUtil.$$$reportNull$$$0(22);
        }
        String string = switch (accessType) {
            default -> throw new IncompatibleClassChangeError();
            case JSAttributeList.AccessType.PUBLIC -> JavaScriptBundle.message("javascript.visibility.public", new Object[0]);
            case JSAttributeList.AccessType.PACKAGE_LOCAL -> {
                if (context2 != null && DialectDetector.isTypeScript(context2)) {
                    yield "";
                }
                yield JavaScriptBundle.message("javascript.visibility.internal", new Object[0]);
            }
            case JSAttributeList.AccessType.PRIVATE -> JavaScriptBundle.message("javascript.visibility.private", new Object[0]);
            case JSAttributeList.AccessType.PROTECTED -> JavaScriptBundle.message("javascript.visibility.protected", new Object[0]);
        };
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static String formatVisibility(@NotNull JSAttributeList.AccessType accessType) {
        if (accessType == null) {
            JSFormatUtil.$$$reportNull$$$0(24);
        }
        return JSFormatUtil.formatVisibility(accessType, null);
    }

    @NotNull
    public static String formatVisibility(@NotNull PsiElement element) {
        JSAttributeList attributeList;
        if (element == null) {
            JSFormatUtil.$$$reportNull$$$0(25);
        }
        return (attributeList = ((JSAttributeListOwner)element).getAttributeList()) == null ? "" : JSFormatUtil.formatVisibility(attributeList.getAccessType(), element);
    }

    @NotNull
    public static String getFunctionLongDescription(@NotNull JSFunctionItem jsFunction, boolean addElementKind, boolean includeParent, boolean htmlEmphasize, boolean includeParameters, @Nullable JSClass parentClassOverride) {
        boolean isMethod;
        if (jsFunction == null) {
            JSFormatUtil.$$$reportNull$$$0(26);
        }
        int options = 1;
        if (includeParameters) {
            options |= 0x100;
        }
        boolean bl = isMethod = JSUtils.getMemberContainingClass((PsiElement)jsFunction) != null;
        if (includeParent && isMethod) {
            options |= 0x1000;
        }
        String name = JSFormatUtil.formatMethod(jsFunction, options, 2, 7, parentClassOverride);
        return JSFormatUtil.describeWithPresenter(addElementKind, includeParent, htmlEmphasize, parentClassOverride, isMethod, name, (PsiElement)jsFunction);
    }

    @NotNull
    private static String describeWithPresenter(boolean addElementKind, boolean includeParent, boolean htmlEmphasize, @Nullable JSClass parentClassOverride, boolean isClassMember, String name, PsiElement element) {
        JSNamedElementPresenter presenter = new JSNamedElementPresenter(element, Capitalization.LowerCase, addElementKind);
        presenter.overrideShortName(name);
        if (includeParent && !isClassMember) {
            JSClass clazz;
            JSClass jSClass = clazz = parentClassOverride != null ? parentClassOverride : JSResolveUtil.getClassOfContext(element);
            if (clazz != null) {
                return JSFormatUtil.presentInParent(htmlEmphasize, presenter, clazz);
            }
        }
        String string = presenter.describeWithShortName(htmlEmphasize);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    private static String presentInParent(boolean htmlEmphasize, @NotNull JSNamedElementPresenter presenter, @NotNull JSClass clazz) {
        if (presenter == null) {
            JSFormatUtil.$$$reportNull$$$0(28);
        }
        if (clazz == null) {
            JSFormatUtil.$$$reportNull$$$0(29);
        }
        JSNamedElementPresenter parentPresenter = new JSNamedElementPresenter(clazz);
        String string = JavaScriptBundle.message("entity.in.parent.description", presenter.describeWithShortName(htmlEmphasize), parentPresenter.describeWithShortName(htmlEmphasize));
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public static String getVariableLongDescription(@NotNull JSVariable jsVariable, boolean includeParent, boolean htmlEmphasize, @Nullable JSClass parentClassOverride) {
        boolean isField;
        if (jsVariable == null) {
            JSFormatUtil.$$$reportNull$$$0(31);
        }
        int options = 1;
        boolean bl = isField = JSUtils.getMemberContainingClass((PsiElement)jsVariable) != null;
        if (includeParent && isField) {
            options |= 0x1000;
        }
        String name = JSFormatUtil.formatField(jsVariable, options, parentClassOverride);
        return JSFormatUtil.describeWithPresenter(true, includeParent, htmlEmphasize, parentClassOverride, isField, name, (PsiElement)jsVariable);
    }

    @Nls
    @NotNull
    public static String formatPackage(@Nullable String packageName) {
        return !StringUtil.isEmpty((String)packageName) ? JavaScriptBundle.message("package.description", packageName) : JSFormatUtil.getTopLevelPackageName();
    }

    @NotNull
    @Nls
    public static String getAnonymousName(@NotNull PsiElement psiElement) {
        PsiElement parent;
        if (psiElement == null) {
            JSFormatUtil.$$$reportNull$$$0(32);
        }
        if ((parent = psiElement.getParent()) instanceof ES6ExportDefaultAssignment) {
            String string = JSFormatUtil.getDefaultMemberName();
            if (string == null) {
                JSFormatUtil.$$$reportNull$$$0(33);
            }
            return string;
        }
        if (psiElement instanceof JSPackage || psiElement instanceof JSPackageStatement) {
            return JSFormatUtil.getTopLevelPackageName();
        }
        String string = JSFormatUtil.getAnonymousElementPresentation();
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    public static String buildFunctionSignaturePresentation(@NotNull JSFunctionItem psiElement) {
        if (psiElement == null) {
            JSFormatUtil.$$$reportNull$$$0(35);
        }
        int options = 8450;
        int parametersOptions = 73731;
        return JSFormatUtil.formatMethod(psiElement, options |= 4, parametersOptions |= 4, 7, null);
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isPossiblyPresentableType(@Nullable JSType type, @Nullable PsiElement owner, boolean allowTypeEvaluation) {
        if (type == null) {
            return false;
        }
        if (allowTypeEvaluation && type instanceof JSFunctionReturnWrapperType) {
            type = type.substitute();
        }
        if (owner == null) {
            owner = type.getSource().getSourceElement();
        }
        if (type instanceof JSVoidType && owner instanceof JSPsiElementBase && JSSymbolUtil.isConstructorSymbol((JSPsiElementBase)owner)) {
            return false;
        }
        return (allowTypeEvaluation || !JSTypeUtils.hasTypes(type, JSCodeBasedType.class)) && (!allowTypeEvaluation || !type.getSource().isJavaScript() || !(type instanceof JSEvaluableOnlyType) || JSFormatUtil.adjustEvaluatedTypeForDocumentation(type.substitute()) != null);
    }

    @Nls
    public static String getAnonymousElementPresentation() {
        return JavaScriptBundle.message("element.name.anonymous", new Object[0]);
    }

    @Nls
    public static String getDefaultMemberName() {
        return JavaScriptBundle.message("element.name.default", new Object[0]);
    }

    @Nls
    @NotNull
    public static String getTopLevelPackageName() {
        String string = JavaScriptBundle.message("top.level.package", new Object[0]);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 9, 11, 15, 18, 20, 23, 27, 30, 33, 34, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 27: 
            case 30: 
            case 33: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/presentable/JSFormatUtil";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDeclaration";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFunction";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presenter";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsVariable";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/presentable/JSFormatUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "formatField";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTypeMember";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMethod";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "formatIndexSignature";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "formatParameter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "formatType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTypeDeclaration";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "formatVisibility";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "describeWithPresenter";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "presentInParent";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnonymousName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatField";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 27: 
            case 30: 
            case 33: 
            case 34: 
            case 36: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendContainingClassIfNeeded";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "formatMethod";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatTypeMember";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "formatIndexSignature";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendTypeAfter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "formatParameter";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "formatTypeDeclaration";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyIcon";
                break;
            }
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "formatVisibility";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionLongDescription";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "presentInParent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getVariableLongDescription";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAnonymousName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "buildFunctionSignaturePresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 9, 11, 15, 18, 20, 23, 27, 30, 33, 34, 36 -> new IllegalStateException(string);
        };
    }

    private static final class NoResolveTypeTextStringBuilder
    extends JSOverflowTypeTextStringBuilder {
        private NoResolveTypeTextStringBuilder() {
            super(JSType.TypeTextFormat.CODE);
        }

        @Override
        public boolean startProcessType(@NotNull JSType type) {
            if (type == null) {
                NoResolveTypeTextStringBuilder.$$$reportNull$$$0(0);
            }
            if (type instanceof JSTypeImpl) {
                this.append(type.getTypeText());
                return false;
            }
            return super.startProcessType(type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/presentable/JSFormatUtil$NoResolveTypeTextStringBuilder", "startProcessType"));
        }
    }
}

