/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagDefinition;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagPart;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReferenceSet;
import com.intellij.lang.javascript.psi.types.JSImportType;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class JSDocTagReferencesHolderImpl
extends JSElementImpl
implements JSDocTagPart {
    private static final Set<JSDocBlockTags> ourSoftTags = Set.of(JSDocBlockTags.THROWS, JSDocBlockTags.MODULE, JSDocBlockTags.EVENT, JSDocBlockTags.SEE, JSDocBlockTags.RETURNS);
    private static final Pattern REPLACE_ASTERISKS_PATTERN = Pattern.compile("\\n\\s*\\*?");
    private static final Key<ParameterizedCachedValue<PsiReference[], JSDocTagReferencesHolderImpl>> REFERENCES_KEY = new Key("js.doc.tag.references");
    private static final ParameterizedCachedValueProvider<PsiReference[], JSDocTagReferencesHolderImpl> REFERENCES_PROVIDER = param -> CachedValueProvider.Result.create((Object)param.createRefs(), (Object[])new Object[]{param});

    JSDocTagReferencesHolderImpl(IElementType elementType) {
        super(elementType);
    }

    @Override
    public String getTextWithoutLeadingAsterisks() {
        StringBuilder result2 = new StringBuilder();
        for (TreeElement cur = this.getFirstChildNode(); cur != null; cur = cur.getTreeNext()) {
            IElementType elementType = cur.getElementType();
            if (elementType == JSDocTokenTypes.DOC_WHITESPACE) {
                result2.append(JSDocumentationUtils.getWhitespaceTextAsterisksAware((ASTNode)cur));
                continue;
            }
            if (elementType == JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK) continue;
            result2.append(cur.getText());
        }
        return result2.toString().trim();
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, REFERENCES_KEY, REFERENCES_PROVIDER, false, (Object)this);
        if (psiReferenceArray == null) {
            JSDocTagReferencesHolderImpl.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getLastElement((Object[])this.getReferences());
    }

    protected abstract PsiReference[] createRefs();

    protected PsiReference @NotNull [] createReferencesFromText(@NotNull String text, final int offset, @NotNull JSDocTagDefinition definition, boolean isNamepath, boolean forceHard) {
        boolean parsedSuccessfully;
        if (text == null) {
            JSDocTagReferencesHolderImpl.$$$reportNull$$$0(1);
        }
        if (definition == null) {
            JSDocTagReferencesHolderImpl.$$$reportNull$$$0(2);
        }
        boolean soft = !forceHard && (ourSoftTags.contains(definition) || JSDocBlockTags.CLASS.equals(definition) && !text.contains("."));
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
        Matcher matcher = REPLACE_ASTERISKS_PATTERN.matcher(text);
        StringBuilder builder2 = new StringBuilder(text);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            builder2.replace(start, end, StringUtil.repeatSymbol((char)' ', (int)(end - start)));
        }
        text = builder2.toString();
        text = StringUtil.trimEnd((String)text, (String)"()");
        if (isNamepath && JSDocBlockTags.PARAM.equals(definition) && !StringUtil.equalsIgnoreCase((CharSequence)((JSDocTag)this.getParent()).getName(), (CharSequence)"config")) {
            PsiReference[] psiReferenceArray = JSDocParamReference.createReferences((JSDocTagNamepath)((Object)this), List.of(Pair.create((Object)offset, (Object)text)));
            if (psiReferenceArray == null) {
                JSDocTagReferencesHolderImpl.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        SmartList myReferences = new SmartList();
        SmartList myImportTypes = new SmartList();
        JSTypeParser typeParser = new JSTypeParser(this.getProject(), text, new JSTypeVisitor(){
            final /* synthetic */ List val$myImportTypes;
            final /* synthetic */ List val$myReferences;
            {
                this.val$myImportTypes = list;
                this.val$myReferences = list2;
            }

            @Override
            public void visitSingleType(int startOffset, @Nullable JSType type, @NotNull String name) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!JSCommonTypeNames.NON_REFERENCE_TYPES.contains(name)) {
                    Pair pair = Pair.create((Object)(offset + startOffset), (Object)name);
                    if (type instanceof JSImportType) {
                        this.val$myImportTypes.add(pair);
                    } else {
                        this.val$myReferences.add(pair);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagReferencesHolderImpl$1", "visitSingleType"));
            }
        });
        boolean bl = parsedSuccessfully = (isNamepath ? typeParser.parseNamepath() : typeParser.parseParameterType()) != null;
        if (parsedSuccessfully) {
            this.fillNamepathReferences(soft, JSDocBlockTags.EVENT.equals(definition) || JSDocBlockTags.FIRES.equals(definition), JSDocBlockTags.MODULE.equals(definition) || JSDocBlockTags.EXPORTS.equals(definition), result2, (List<Pair<Integer, String>>)myReferences);
            this.fillImportTypeReferences(soft, result2, (List<Pair<Integer, String>>)myImportTypes);
        } else if (JSDocumentationUtils.isExtendedTypeName(text) || DialectDetector.isActionScript((PsiElement)this)) {
            JSDocReferenceSet set = new JSDocReferenceSet((PsiElement)this, text, offset, soft);
            Collections.addAll(result2, set.getReferences());
        }
        PsiReference[] psiReferenceArray = result2.isEmpty() ? PsiReference.EMPTY_ARRAY : result2.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            JSDocTagReferencesHolderImpl.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    private void fillNamepathReferences(boolean soft, boolean event, boolean module, @NotNull List<PsiReference> result2, @NotNull List<Pair<Integer, String>> myReferences) {
        if (result2 == null) {
            JSDocTagReferencesHolderImpl.$$$reportNull$$$0(5);
        }
        if (myReferences == null) {
            JSDocTagReferencesHolderImpl.$$$reportNull$$$0(6);
        }
        for (Pair<Integer, String> reference : myReferences) {
            String qName = (String)reference.second;
            JSDocReferenceSet set = new JSDocReferenceSet((PsiElement)this, qName, (Integer)reference.first, soft, event, module);
            Collections.addAll(result2, set.getReferences());
        }
    }

    private void fillImportTypeReferences(boolean soft, List<PsiReference> result2, List<Pair<Integer, String>> myImportTypes) {
        for (Pair<Integer, String> reference : myImportTypes) {
            int separator;
            int last;
            int first;
            String importStart = (String)reference.second;
            int start = importStart.indexOf("import");
            if (start < 0 || (first = StringUtil.findFirst((CharSequence)importStart, ch -> ch == '\'' || ch == '\"')) <= 0 || (last = importStart.lastIndexOf(separator = importStart.charAt(first) == '\'' ? 39 : 34)) <= 0 || last <= first || last + 1 >= importStart.length()) continue;
            int fileReferenceOffset = (Integer)reference.first + first + 1;
            String fileReferenceText = importStart.substring(first, last + 1);
            PsiReference[] references = JSFileReferencesUtil.createImportExportFromClauseReferences((PsiElement)this, fileReferenceOffset, fileReferenceText, null);
            Collections.addAll(result2, references);
            int docOffset = start + (Integer)reference.first;
            JSDocReferenceSet docSet = new JSDocReferenceSet((PsiElement)this, importStart.substring(start), docOffset, soft, false, false);
            Collections.addAll(result2, docSet.getReferences());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagReferencesHolderImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagReferencesHolderImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferencesFromText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createReferencesFromText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillNamepathReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

