/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.FlowJSFileType;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSXFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.IndexedFileTypeProvider;
import com.intellij.lang.javascript.library.JSPredefinedLibraryManager;
import com.intellij.lang.javascript.psi.resolve.JSElementResolveScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveScopeProvider;
import com.intellij.lang.typescript.library.TypeScriptLibraries;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveScopeEnlarger;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptResolveScopeProvider
extends JSResolveScopeProvider
implements JSElementResolveScopeProvider {
    private static final Supplier<Set<FileType>> myExpandedScopeFileTypes = ExtensionPointUtil.dropLazyValueOnChange((SynchronizedClearableLazy)new SynchronizedClearableLazy(() -> {
        HashSet<Object> expandedScopeFileTypes = new HashSet<Object>(4);
        expandedScopeFileTypes.add(JavaScriptSupportLoader.JAVASCRIPT);
        expandedScopeFileTypes.add(FlowJSFileType.INSTANCE);
        expandedScopeFileTypes.add(HtmlFileType.INSTANCE);
        expandedScopeFileTypes.add(JSXFileType.INSTANCE);
        for (IndexedFileTypeProvider indexedFileTypeProvider : IndexedFileTypeProvider.EP_NAME.getExtensionList()) {
            Collections.addAll(expandedScopeFileTypes, indexedFileTypeProvider.getFileTypesToIndex());
        }
        return expandedScopeFileTypes;
    }), IndexedFileTypeProvider.EP_NAME, null);

    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(1);
        }
        if (!JavaScriptResolveScopeProvider.isApplicable(file)) {
            return null;
        }
        return this.getProjectAndLibrariesScope(file, project);
    }

    @NotNull
    public GlobalSearchScope getProjectAndLibrariesScope(@NotNull VirtualFile file, @NotNull Project project) {
        Set<Object> excludedFiles;
        Set<VirtualFile> includedFiles;
        TypeScriptLibraryProvider service;
        TypeScriptLibraries library;
        if (file == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(3);
        }
        if ((library = (service = TypeScriptLibraryProvider.getService(project)).getEffectiveLibrary()).isBundled()) {
            JSLanguageLevel level = DialectDetector.getConfiguredJSLevel(file, project);
            includedFiles = JSPredefinedLibraryManager.getPredefinedLibraryManager(project).getRequiredLibraryFilesForResolve(level);
            excludedFiles = Collections.emptySet();
        } else {
            includedFiles = service.getPredefinedLibraries(file);
            excludedFiles = service.getAllBundledLibraries();
        }
        GlobalSearchScope globalSearchScope = this.getProjectAndLibrariesScope(file, project, includedFiles, excludedFiles);
        if (globalSearchScope == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @Override
    @Nullable
    public GlobalSearchScope getElementResolveScope(@NotNull PsiElement element) {
        Language language;
        if (element == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(5);
        }
        if (!((language = DialectDetector.languageOfElement(element)) == JavascriptLanguage.INSTANCE || language instanceof JSLanguageDialect && ((JSLanguageDialect)language).getOptionHolder().isJavaScript())) {
            return null;
        }
        VirtualFile file = JavaScriptResolveScopeProvider.getFileForScopeEvaluation(element);
        if (file != null && JavaScriptResolveScopeProvider.isApplicable(file)) {
            return null;
        }
        Project project = element.getProject();
        GlobalSearchScope result2 = this.getProjectScopeIncludingPredefines(project);
        if (file != null) {
            for (ResolveScopeEnlarger enlarger : ResolveScopeEnlarger.EP_NAME.getExtensionList()) {
                SearchScope extra = enlarger.getAdditionalResolveScope(file, project);
                if (extra == null) continue;
                result2 = result2.union(extra);
            }
        }
        return result2;
    }

    protected static boolean isApplicable(@NotNull VirtualFile file) {
        if (file == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(6);
        }
        return myExpandedScopeFileTypes.get().contains(file.getFileType());
    }

    @Override
    protected boolean isApplicablePredefinedLibraryFile(@NotNull VirtualFile predefinedLibraryFile) {
        if (predefinedLibraryFile == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(7);
        }
        return JavaScriptResolveScopeProvider.isApplicable(predefinedLibraryFile) || TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(predefinedLibraryFile.getFileType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JavaScriptResolveScopeProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedLibraryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JavaScriptResolveScopeProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectAndLibrariesScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProjectAndLibrariesScope";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementResolveScope";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isApplicablePredefinedLibraryFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

