/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSConstStatusOwner;
import com.intellij.lang.javascript.psi.JSControlFlowScope;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSCallInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSCaseBlockInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSConditionInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSEntryPointInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSInstructionWithReachability;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSLoopJunctionInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSModificationInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSReadWriteInstruction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNotNullExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.guard.JSInjectionControlFlowUtil;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.operations.JSCompositeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSDeclaredTypeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSDecoratorsOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSEmptyOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSMergeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByArrayMutationOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByEqualityOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByInstanceOfOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByNeverReturnOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByPrivateBrandCheckOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeBySwitchDiscriminantOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeBySwitchOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByTruthinessOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByTypePredicateOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByTypeofOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByTypeofSwitchOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSUnionOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JavaScriptNarrowTypeByInKeywordOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.TypeScriptNarrowTypeByAssignmentOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.TypeScriptNarrowTypeByConstructorOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.TypeScriptNarrowTypeByDiscriminantEqualityOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.TypeScriptNarrowTypeByDiscriminantTruthinessOperation;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeGuard {
    private static final Logger LOGGER = Logger.getInstance(TypeScriptTypeGuard.class);
    private static final int CF_DEPTH_LIMIT = 100;
    private final boolean myResetDecoratorsOnAnyCall;
    private final AtomicInteger myDepth;
    private final ArrayDeque<Instruction> myLoopStack;
    @Nullable
    private final JSControlFlowScope myStartControlFlowScope;
    @Nullable
    private final PsiElement myResolvedElement;
    @NotNull
    private final List<PsiElement> myAllResolvedElements;
    @NotNull
    protected final PsiElement myElement;
    @NotNull
    private final PsiElement myReferencingElement;
    private final boolean myIsTypeScript;
    private final boolean myPossibleAutoType;
    private final Map<Instruction, JSTypeOperation> myCalculatedTypes;

    public TypeScriptTypeGuard(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(0);
        }
        this.myDepth = new AtomicInteger();
        this.myLoopStack = new ArrayDeque();
        this.myCalculatedTypes = new HashMap<Instruction, JSTypeOperation>();
        if (!JSTypeGuardUtil.isAcceptableForTypeGuard(element)) {
            throw new IllegalArgumentException("Element is not acceptable for CFG type guard");
        }
        this.myElement = element;
        this.myIsTypeScript = DialectDetector.isTypeScript(element);
        this.myStartControlFlowScope = TypeScriptTypeGuard.findControlFlowScope(element);
        this.myReferencingElement = element instanceof JSReferenceExpression ? TypeScriptTypeGuard.getTopLeftExpression((JSReferenceExpression)element) : element;
        this.myAllResolvedElements = element instanceof JSReferenceExpression ? TypeScriptTypeGuard.resolveReferenceExpressionLocallyMerged(this.myReferencingElement) : List.of(element);
        this.myResolvedElement = (PsiElement)ContainerUtil.getLastItem(this.myAllResolvedElements);
        this.myResetDecoratorsOnAnyCall = element instanceof JSReferenceExpression && TypeScriptTypeGuard.shouldResetDecoratorsOnAssignments(this.myResolvedElement, this.myStartControlFlowScope, (JSReferenceExpression)element, TypeScriptTypeGuard.getFirstQualifierName((JSReferenceExpression)element));
        this.myPossibleAutoType = this.myReferencingElement == this.myElement && this.myIsTypeScript && TypeScriptTypeGuard.possibleAutoType(this.myResolvedElement);
    }

    private static boolean possibleAutoType(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        Pair<Boolean, Boolean> states = JSTypeGuardUtil.getAutoTypeStates(element);
        return states != null && ((Boolean)states.first != false || (Boolean)states.second != false);
    }

    private static List<PsiElement> resolveReferenceExpressionLocallyMerged(@Nullable PsiElement expression) {
        if (!(expression instanceof JSReferenceExpression)) {
            return Collections.emptyList();
        }
        String name = ((JSReferenceExpression)expression).getReferenceName();
        if (StringUtil.isEmpty((String)name)) {
            return Collections.emptyList();
        }
        JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
        if (qualifier instanceof JSThisExpression) {
            expression = JSContextResolver.resolveThisReference((PsiElement)qualifier);
        }
        if (expression == null) {
            return Collections.emptyList();
        }
        return JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(name, expression, false);
    }

    @Nullable
    private static PsiElement resolveReferenceExpressionLocally(@Nullable PsiElement expression) {
        return (PsiElement)ContainerUtil.getLastItem(TypeScriptTypeGuard.resolveReferenceExpressionLocallyMerged(expression));
    }

    @NotNull
    private static JSExpression getTopLeftExpression(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(1);
        }
        JSExpression qualifier = expression.getQualifier();
        JSQualifiedExpression result2 = expression;
        while (qualifier instanceof JSQualifiedExpression) {
            result2 = (JSQualifiedExpression)qualifier;
            qualifier = result2.getQualifier();
        }
        JSReferenceExpression jSReferenceExpression = result2;
        if (jSReferenceExpression == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(2);
        }
        return jSReferenceExpression;
    }

    private static boolean shouldResetDecoratorsOnAssignments(@Nullable PsiElement resolveResult, @Nullable PsiElement startControlFlowScope, @NotNull JSReferenceExpression reference, @NotNull String topName) {
        ASTNode node;
        if (reference == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(3);
        }
        if (topName == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(4);
        }
        if (!(resolveResult instanceof JSVariable)) {
            return true;
        }
        if (((JSVariable)resolveResult).isConst() && !(resolveResult instanceof JSField)) {
            return false;
        }
        if (reference.getQualifier() != null || !TypeScriptTypeGuard.isLocalSymbol((JSVariable)resolveResult)) {
            return true;
        }
        ASTNode aSTNode = node = startControlFlowScope == null ? null : startControlFlowScope.getNode();
        if (!(node instanceof CompositeElement)) {
            return true;
        }
        return JSTreeUtil.hasDeclarationOrAssignmentInNestedScopes((CompositeElement)node, topName);
    }

    private static boolean isLocalSymbol(@NotNull JSVariable resolveResult) {
        JSFile file;
        JSModuleStatusOwner.ModuleStatus status;
        PsiElement declarationScope;
        if (resolveResult == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(5);
        }
        if (!((declarationScope = resolveResult.getDeclarationScope()) instanceof PsiFile)) {
            return true;
        }
        PsiFile containingFile = (PsiFile)declarationScope;
        return containingFile instanceof JSFile && ((status = (file = (JSFile)containingFile).getModuleStatus()) == JSModuleStatusOwner.ModuleStatus.ES6 || status == JSModuleStatusOwner.ModuleStatus.COMMONJS);
    }

    public static boolean isEvolvingArrayOperationTarget(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(6);
        }
        if ((parent = element.getParent()) instanceof JSIndexedPropertyAccessExpression && parent instanceof JSDefinitionExpression) {
            return true;
        }
        if (element instanceof JSReferenceExpression && parent instanceof JSReferenceExpression) {
            JSReferenceExpression parentExpression = (JSReferenceExpression)parent;
            if (parentExpression.getParent() instanceof JSReferenceExpression) {
                return false;
            }
            String name = parentExpression.getName();
            return TypeScriptTypeGuard.isPushOrUnshiftName(name) || "length".equals(name);
        }
        return false;
    }

    public static boolean isPushOrUnshiftName(@Nullable String name) {
        return "push".equals(name) || "unshift".equals(name);
    }

    public static boolean checkUseAutoTypeFromConfig(@NotNull PsiElement element, @NotNull PsiElement resolveResult, @Nullable TypeScriptConfig config) {
        if (element == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(7);
        }
        if (resolveResult == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(8);
        }
        return config != null && config.noImplicitAny() && element.getContainingFile().equals(resolveResult.getContainingFile());
    }

    @NotNull
    public final JSTypeOperation getNarrowedTypeOperations() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSControlFlowService.JSControlFlow flow = this.getStartControlFlow();
        if (flow == null) {
            JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
            if (jSDeclaredTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(9);
            }
            return jSDeclaredTypeOperation;
        }
        Instruction instruction = this.getControlFlowInstruction(flow, this.myElement);
        if (instruction == null) {
            JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
            if (jSDeclaredTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(10);
            }
            return jSDeclaredTypeOperation;
        }
        return this.getTypeAtFlowNode(flow, instruction);
    }

    @Nullable
    public Instruction getControlFlowInstruction(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull PsiElement context2) {
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(11);
        }
        if (context2 == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(12);
        }
        Instruction[] instructions = flow.getInstructions();
        int indexOfElement = context2 instanceof JSField ? instructions.length - 1 : ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)context2);
        if (indexOfElement == -1) {
            Document document = PsiDocumentManager.getInstance((Project)context2.getProject()).getDocument(context2.getContainingFile());
            int number = document == null ? -1 : document.getLineNumber(context2.getNode().getStartOffset());
            LOGGER.debug("Control flow must contain all semantic elements for correct type inference, line " + number + ", class " + context2.getClass());
            return null;
        }
        return instructions[indexOfElement];
    }

    @Nullable
    private JSControlFlowService.JSControlFlow getStartControlFlow() {
        return this.getControlFlow(this.myStartControlFlowScope);
    }

    @Nullable
    private JSControlFlowService.JSControlFlow getControlFlow(@Nullable JSControlFlowScope executionScope) {
        if (executionScope == null || executionScope instanceof JSClass) {
            return null;
        }
        return JSControlFlowService.getService(this.myElement.getProject()).getControlFlow(executionScope);
    }

    @Nullable
    public static JSControlFlowScope findControlFlowScope(@NotNull PsiElement context2) {
        if (context2 == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(13);
        }
        PsiElement result2 = PsiTreeUtil.findFirstContext((PsiElement)context2, (boolean)true, element -> {
            if (element instanceof JSClass) {
                return true;
            }
            if (element instanceof JSEmbeddedContent) {
                return ES6PsiUtil.isEmbeddedBlock(element);
            }
            return element instanceof JSControlFlowScope;
        });
        if (context2 instanceof JSField && result2 instanceof JSClass) {
            return ((JSClass)result2).getConstructor();
        }
        return result2 instanceof JSClass || !(result2 instanceof JSControlFlowScope) ? null : (JSControlFlowScope)result2;
    }

    @NotNull
    private JSTypeOperation getTypeAtFlowNode(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Instruction currentInstruction) {
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(14);
        }
        if (currentInstruction == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(15);
        }
        ProgressManager.checkCanceled();
        if (currentInstruction instanceof JSLoopJunctionInstruction) {
            return this.getTypeAtLoop(flow, (JSLoopJunctionInstruction)currentInstruction);
        }
        JSTypeOperation type = this.myCalculatedTypes.get(currentInstruction);
        if (type != null) {
            JSTypeOperation jSTypeOperation = type;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(16);
            }
            return jSTypeOperation;
        }
        type = this.getTypeAtFlowNodeImpl(flow, currentInstruction);
        this.myCalculatedTypes.put(currentInstruction, type);
        JSTypeOperation jSTypeOperation = type;
        if (jSTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(17);
        }
        return jSTypeOperation;
    }

    @NotNull
    private JSTypeOperation getTypeAtFlowNodeImpl(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Instruction currentInstruction) {
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(18);
        }
        if (currentInstruction == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(19);
        }
        HashSet<Instruction> visitedInstructions = new HashSet<Instruction>();
        while (currentInstruction != null) {
            Collection prevInstructions;
            int size;
            JSTypeOperation result2;
            JSTypeOperation assignmentType;
            if (!visitedInstructions.add(currentInstruction)) {
                JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
                if (jSDeclaredTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(20);
                }
                return jSDeclaredTypeOperation;
            }
            if (currentInstruction instanceof JSEntryPointInstruction) {
                boolean isReferenceExpression;
                JSControlFlowScope scope2 = ((JSEntryPointInstruction)currentInstruction).getScope();
                if (this.isFinalScope(scope2) || (!(isReferenceExpression = this.myElement instanceof JSReferenceExpression) || ((JSReferenceExpression)this.myElement).getQualifier() != null) && (isReferenceExpression || this.myElement instanceof JSThisExpression)) break;
                JSTypeOperation operation = this.getTypeAtParentScope(scope2);
                JSTypeOperation jSTypeOperation = JSPsiImplUtils.isIIFE(scope2) ? operation : JSDecoratorsOperation.create(operation, Collections.emptySet());
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(21);
                }
                return jSTypeOperation;
            }
            JSTypeOperation dialectResult = this.getDialectSpecificTypeOperation(flow, currentInstruction);
            if (dialectResult != null) {
                JSTypeOperation jSTypeOperation = dialectResult;
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(22);
                }
                return jSTypeOperation;
            }
            if (currentInstruction instanceof JSReadWriteInstruction && (assignmentType = this.getTypeAtFlowReadWrite(flow, (JSReadWriteInstruction)currentInstruction)) != null) {
                JSTypeOperation jSTypeOperation = assignmentType;
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(23);
                }
                return jSTypeOperation;
            }
            if (currentInstruction instanceof JSModificationInstruction && (result2 = this.getTypeAtFlowArrayMutation(flow, (JSModificationInstruction)currentInstruction)) != null) {
                JSTypeOperation jSTypeOperation = result2;
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(24);
                }
                return jSTypeOperation;
            }
            if (currentInstruction instanceof JSCaseBlockInstruction) {
                return this.getTypeAtCaseBlock(flow, (JSCaseBlockInstruction)currentInstruction);
            }
            if (currentInstruction instanceof JSConditionInstruction) {
                return this.getTypeAtFlowCondition(flow, (JSConditionInstruction)currentInstruction);
            }
            if (currentInstruction instanceof JSLoopJunctionInstruction) {
                return this.getTypeAtLoop(flow, (JSLoopJunctionInstruction)currentInstruction);
            }
            if (currentInstruction instanceof JSCallInstruction) {
                PsiElement element = currentInstruction.getElement();
                if (element instanceof JSCallExpression && TypeScriptTypeGuard.isSuitableCallForAssertion((JSCallExpression)element)) {
                    JSTypeOperation assertion = this.getTypeAtCallAssertion(flow, (JSCallInstruction)currentInstruction, (JSCallExpression)element);
                    JSTypeOperation jSTypeOperation = this.myResetDecoratorsOnAnyCall ? JSDecoratorsOperation.create(assertion, Collections.emptySet()) : assertion;
                    if (jSTypeOperation == null) {
                        TypeScriptTypeGuard.$$$reportNull$$$0(25);
                    }
                    return jSTypeOperation;
                }
                if (this.myResetDecoratorsOnAnyCall) {
                    JSTypeOperation jSTypeOperation = JSDecoratorsOperation.create(this.getPrevFlowType(flow, currentInstruction), Collections.emptySet());
                    if (jSTypeOperation == null) {
                        TypeScriptTypeGuard.$$$reportNull$$$0(26);
                    }
                    return jSTypeOperation;
                }
            }
            if ((size = (prevInstructions = currentInstruction.allPred()).size()) == 0) break;
            if (size > 1) {
                JSTypeOperation jSTypeOperation = this.getPrevFlowType(flow, currentInstruction);
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(27);
                }
                return jSTypeOperation;
            }
            currentInstruction = (Instruction)ContainerUtil.getFirstItem((Collection)prevInstructions);
        }
        JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
        if (jSDeclaredTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(28);
        }
        return jSDeclaredTypeOperation;
    }

    private boolean isFinalScope(@NotNull PsiElement scope2) {
        if (scope2 == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(29);
        }
        return TypeScriptTypeGuard.isFinalFileScope(scope2) || scope2 instanceof JSExecutionScope && ((JSExecutionScope)scope2).isTopmostControlFlowScope() || ES6PsiUtil.isEmbeddedModule(scope2) || scope2 instanceof JSFunction && this.isFinalFunctionScope((JSFunction)scope2);
    }

    private static boolean isFinalFileScope(@NotNull PsiElement scope2) {
        if (scope2 == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(30);
        }
        return scope2 instanceof JSFile && !JSInjectionControlFlowUtil.isCfgAwareInjectedFile(scope2);
    }

    private boolean isFinalFunctionScope(@NotNull JSFunction scope2) {
        if (scope2 == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(31);
        }
        if (!(scope2 instanceof JSFunctionExpression) && !TypeScriptTypeGuard.isObjectLiteralOrClassExpressionMethod(scope2)) {
            return true;
        }
        if (JSPsiImplUtils.isIIFE(scope2)) {
            return false;
        }
        if (this.myResolvedElement instanceof JSConstStatusOwner && ((JSConstStatusOwner)this.myResolvedElement).isConst()) {
            return false;
        }
        if (this.myResolvedElement instanceof JSParameter) {
            JSTreeUtil.JSScopeDeclarationsAndAssignments assignmentsInScope;
            ASTNode node;
            String name = ((JSParameter)this.myResolvedElement).getName();
            JSFunction function = ((JSParameter)this.myResolvedElement).getDeclaringFunction();
            ASTNode aSTNode = node = function != null ? function.getNode() : null;
            if (node instanceof CompositeElement && name != null && !(assignmentsInScope = JSTreeUtil.getDeclarationsAndAssignmentsInScope(name, (CompositeElement)node)).hasAssignments()) {
                return false;
            }
        }
        return true;
    }

    @Contract(pure=true)
    private static boolean isObjectLiteralOrClassExpressionMethod(@NotNull JSFunction scope2) {
        if (scope2 == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(32);
        }
        return scope2 instanceof JSFunctionProperty;
    }

    @Nullable
    protected JSTypeOperation getDialectSpecificTypeOperation(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Instruction instruction) {
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(33);
        }
        if (instruction == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(34);
        }
        return null;
    }

    @NotNull
    private JSTypeOperation getTypeAtLoop(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSLoopJunctionInstruction instruction) {
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(35);
        }
        if (instruction == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(36);
        }
        JSTypeOperation currentValue = this.myCalculatedTypes.get((Object)instruction);
        if (this.myLoopStack.contains((Object)instruction) || currentValue != null) {
            JSTypeOperation jSTypeOperation = currentValue == null ? JSEmptyOperation.NO_OPERATION : currentValue;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(37);
            }
            return jSTypeOperation;
        }
        this.myLoopStack.push((Instruction)instruction);
        JSTypeOperation resultType = this.getRegularPredTypes(flow, instruction.getRegularPred());
        if (!this.isDeclareOperationNoAutoType(resultType)) {
            this.myCalculatedTypes.put((Instruction)instruction, resultType);
            Collection<Instruction> jumps = instruction.getJumpPred();
            if (!jumps.isEmpty()) {
                resultType = JSUnionOperation.create(resultType, this.getPrevFlowTypeForInstructions(flow, jumps), true);
            }
        }
        this.myLoopStack.pop();
        this.myCalculatedTypes.put((Instruction)instruction, resultType);
        JSTypeOperation jSTypeOperation = resultType;
        if (jSTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(38);
        }
        return jSTypeOperation;
    }

    @NotNull
    private JSTypeOperation getRegularPredTypes(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Collection<Instruction> regularPreds) {
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(39);
        }
        if (regularPreds == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(40);
        }
        if (regularPreds.size() > 0) {
            return this.getPrevFlowTypeForInstructions(flow, regularPreds);
        }
        JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
        if (jSDeclaredTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(41);
        }
        return jSDeclaredTypeOperation;
    }

    @Nullable
    private JSTypeOperation getTypeAtFlowReadWrite(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSReadWriteInstruction currentInstruction) {
        ReadWriteAccessDetector.Access access;
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(42);
        }
        if (currentInstruction == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(43);
        }
        if ((access = currentInstruction.getAccess()) == ReadWriteAccessDetector.Access.Read) {
            return this.getTypeAtFlowRead(flow, currentInstruction);
        }
        return this.getTypeAtFlowAssignment(flow, currentInstruction, access);
    }

    @Nullable
    private JSTypeOperation getTypeAtFlowRead(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSReadWriteInstruction currentInstruction) {
        PsiElement element;
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(44);
        }
        if (currentInstruction == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(45);
        }
        if ((element = currentInstruction.getElement()) != this.myElement && element instanceof JSReferenceExpression) {
            Object parent = element.getParent();
            if (parent instanceof TypeScriptNotNullExpression) {
                parent = ((TypeScriptNotNullExpression)parent).getExpression();
            }
            if (!(parent instanceof JSReferenceExpression) || ((JSReferenceExpression)parent).getQualifier() != element) {
                return null;
            }
            if (this.isMatchingReference(this.myElement, element) && !((JSReferenceExpression)parent).isElvis()) {
                JSTypeOperation prev = this.getPrevFlowType(flow, (Instruction)currentInstruction);
                return JSDecoratorsOperation.create(prev, JSTypeGuardChecker.NOTNULL_NOTUNDEFINED);
            }
        }
        return null;
    }

    @NotNull
    protected JSTypeOperation narrowTypeByEquality(@NotNull JSTypeOperation prev, @NotNull IElementType sign, @NotNull JSExpression expression, boolean assumeTrue) {
        if (prev == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(46);
        }
        if (sign == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(47);
        }
        if (expression == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(48);
        }
        return PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)this.myElement, (boolean)false) ? prev : new JSNarrowTypeByEqualityOperation(prev, sign, expression, JSTypeGuardChecker.isNegativeSign(sign) != assumeTrue);
    }

    @NotNull
    private JSTypeOperation narrowTypeByAnd(@NotNull JSTypeOperation prevOperation, @NotNull JSBinaryExpression expr, boolean assumeTrue) {
        if (prevOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(49);
        }
        if (expr == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(50);
        }
        if (assumeTrue) {
            return this.narrowTypeOperation(this.narrowTypeOperation(prevOperation, expr.getLOperand(), true), expr.getROperand(), true);
        }
        JSTypeOperation type1 = this.narrowTypeOperation(prevOperation, expr.getLOperand(), false);
        if (this.isDeclareOperationNoAutoType(type1)) {
            JSTypeOperation jSTypeOperation = type1;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(51);
            }
            return jSTypeOperation;
        }
        JSTypeOperation type2 = this.narrowTypeOperation(this.narrowTypeOperation(prevOperation, expr.getLOperand(), true), expr.getROperand(), false);
        JSTypeOperation jSTypeOperation = JSUnionOperation.create(type1, type2, false);
        if (jSTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(52);
        }
        return jSTypeOperation;
    }

    @NotNull
    private JSTypeOperation narrowTypeByOr(@NotNull JSTypeOperation prevOperation, @NotNull JSBinaryExpression expr, boolean assumeTrue) {
        if (prevOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(53);
        }
        if (expr == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(54);
        }
        if (assumeTrue) {
            JSTypeOperation left = this.narrowTypeOperation(prevOperation, expr.getLOperand(), true);
            if (this.isDeclareOperationNoAutoType(left)) {
                JSTypeOperation jSTypeOperation = left;
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(55);
                }
                return jSTypeOperation;
            }
            JSTypeOperation right = this.narrowTypeOperation(this.narrowTypeOperation(prevOperation, expr.getLOperand(), false), expr.getROperand(), true);
            JSTypeOperation jSTypeOperation = JSUnionOperation.create(left, right, false);
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(56);
            }
            return jSTypeOperation;
        }
        return this.narrowTypeOperation(this.narrowTypeOperation(prevOperation, expr.getLOperand(), false), expr.getROperand(), false);
    }

    private boolean isDeclareOperationNoAutoType(JSTypeOperation left) {
        return left == JSDeclaredTypeOperation.DECLARED_TYPE && !this.myPossibleAutoType;
    }

    @NotNull
    private JSTypeOperation narrowTypeByInstanceof(@NotNull JSTypeOperation prevOperation, @NotNull JSBinaryExpression expr, boolean assumeTrue) {
        JSExpression left;
        if (prevOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(57);
        }
        if (expr == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(58);
        }
        if ((left = JSTypeGuardUtil.getReferenceCandidate(expr.getLOperand())) == null) {
            JSTypeOperation jSTypeOperation = prevOperation;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(59);
            }
            return jSTypeOperation;
        }
        JSExpression rOperand = expr.getROperand();
        if (rOperand == null) {
            JSTypeOperation jSTypeOperation = prevOperation;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(60);
            }
            return jSTypeOperation;
        }
        if (!this.isMatchingReference(this.myElement, (PsiElement)left)) {
            return this.createElvisNarrowingIfNeeded(this.containsMatchingReference(this.myElement, (PsiElement)left) ? JSDeclaredTypeOperation.DECLARED_TYPE : prevOperation, JSTokenTypes.INSTANCEOF_KEYWORD, rOperand, assumeTrue, left);
        }
        return new JSNarrowTypeByInstanceOfOperation(prevOperation, rOperand, assumeTrue);
    }

    @NotNull
    protected final JSTypeOperation getTypeAtSwitchClause(@NotNull JSTypeOperation prevOperation, @NotNull JSSwitchStatement statement, int start, int end) {
        JSCaseClause[] clauses;
        if (prevOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(61);
        }
        if (statement == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(62);
        }
        if ((clauses = statement.getCaseClauses()).length == 0 || clauses.length < end) {
            JSTypeOperation jSTypeOperation = prevOperation;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(63);
            }
            return jSTypeOperation;
        }
        JSExpression expression = statement.getSwitchExpression();
        if (this.isMatchingReference(this.myElement, (PsiElement)expression)) {
            return new JSNarrowTypeBySwitchDiscriminantOperation(prevOperation, statement, start, end);
        }
        if (expression instanceof JSReferenceExpression && this.isMatchingReferenceDiscriminantCandidate((PsiElement)expression)) {
            return new JSNarrowTypeBySwitchOperation(prevOperation, statement, (JSReferenceExpression)expression, start, end);
        }
        if (expression instanceof JSPrefixExpression) {
            JSPrefixExpression prefix = (JSPrefixExpression)expression;
            JSExpression prefixExpression = prefix.getExpression();
            if (prefix.getOperationSign() == JSTokenTypes.TYPEOF_KEYWORD && this.isMatchingReference(this.myElement, (PsiElement)prefixExpression)) {
                JSTypeOperation jSTypeOperation = JSNarrowTypeByTypeofSwitchOperation.create(prevOperation, statement, start, end);
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(64);
                }
                return jSTypeOperation;
            }
        }
        JSTypeOperation jSTypeOperation = prevOperation;
        if (jSTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(65);
        }
        return jSTypeOperation;
    }

    @NotNull
    protected JSTypeOperation narrowByCallExpression(@NotNull JSTypeOperation prev, @NotNull JSCallExpression expr, boolean assumeTrue, boolean isAssertion) {
        if (prev == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(66);
        }
        if (expr == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(67);
        }
        JSTypeOperation jSTypeOperation = this.createNarrowByCallExpressionOperation(prev, expr, assumeTrue, isAssertion);
        if (jSTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(68);
        }
        return jSTypeOperation;
    }

    @NotNull
    protected final JSTypeOperation narrowTypeOperation(@NotNull JSTypeOperation prevOperation, @Nullable JSExpression expression, boolean assumeTrue) {
        if (prevOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(69);
        }
        ProgressManager.checkCanceled();
        if (prevOperation == JSEmptyOperation.NO_OPERATION) {
            JSTypeOperation jSTypeOperation = prevOperation;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(70);
            }
            return jSTypeOperation;
        }
        if (expression instanceof JSSuperExpression || expression instanceof JSThisExpression || expression instanceof JSReferenceExpression) {
            return this.narrowTypeByTruthiness(prevOperation, expression, assumeTrue);
        }
        if (expression instanceof JSCallExpression) {
            JSTypeOperation jSTypeOperation = this.narrowByCallExpression(prevOperation, (JSCallExpression)expression, assumeTrue, false);
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(71);
            }
            return jSTypeOperation;
        }
        if (expression instanceof JSParenthesizedExpression) {
            return this.narrowTypeOperation(prevOperation, ((JSParenthesizedExpression)expression).getInnerExpression(), assumeTrue);
        }
        if (expression instanceof JSBinaryExpression) {
            return this.narrowTypeByBinaryExpression(prevOperation, (JSBinaryExpression)expression, assumeTrue);
        }
        if (expression instanceof JSPrefixExpression && ((JSPrefixExpression)expression).getOperationSign() == JSTokenTypes.EXCL) {
            return this.narrowTypeOperation(prevOperation, ((JSPrefixExpression)expression).getExpression(), !assumeTrue);
        }
        JSTypeOperation jSTypeOperation = prevOperation;
        if (jSTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(72);
        }
        return jSTypeOperation;
    }

    protected JSTypeOperation createNarrowTypeByTruthinessOperation(@NotNull JSTypeOperation prev, boolean assumeTrue) {
        if (prev == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(73);
        }
        return new JSNarrowTypeByTruthinessOperation(prev, assumeTrue);
    }

    @NotNull
    protected JSTypeOperation createNarrowTypeByDiscriminantTruthinessOperation(@NotNull JSTypeOperation prev, @NotNull JSReferenceExpression expression, boolean assumeTrue) {
        String name;
        if (prev == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(74);
        }
        if (expression == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(75);
        }
        if ((name = expression.getReferenceName()) == null) {
            JSTypeOperation jSTypeOperation = prev;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(76);
            }
            return jSTypeOperation;
        }
        return new TypeScriptNarrowTypeByDiscriminantTruthinessOperation(prev, name, assumeTrue, JSPsiImplUtils.isElvisOrInOptChain(expression));
    }

    @NotNull
    protected JSTypeOperation createNarrowByCallExpressionOperation(@NotNull JSTypeOperation prevOp, @NotNull JSCallExpression expr, boolean assumeTrue, boolean isAssertion) {
        if (prevOp == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(77);
        }
        if (expr == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(78);
        }
        return this.createNarrowForPredicate(prevOp, expr, assumeTrue, isAssertion);
    }

    @NotNull
    private JSTypeOperation createNarrowForPredicate(@NotNull JSTypeOperation prev, @NotNull JSCallExpression expr, boolean assumeTrue, boolean isAssertion) {
        if (prev == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(79);
        }
        if (expr == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(80);
        }
        IntOpenHashSet matched = new IntOpenHashSet();
        IntOpenHashSet matchedNonRefs = new IntOpenHashSet();
        if (this.checkMethodCallPredicateCandidate(expr)) {
            matched.add(-1);
        }
        JSExpression[] arguments = expr.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            JSExpression argument = arguments[i];
            if (argument instanceof JSReferenceExpression && this.isMatchingReference(this.myElement, (PsiElement)argument)) {
                matched.add(i);
                continue;
            }
            if (!isAssertion || !((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)argument).expand(TypeScriptTypeGuard::canContainNarrowingOperation)).filter(JSReferenceExpression.class).filter(r -> this.isMatchingReference(this.myElement, (PsiElement)r)).isNotEmpty()) continue;
            matchedNonRefs.add(i);
        }
        if (matched.isEmpty() && matchedNonRefs.isEmpty()) {
            if (!isAssertion || !assumeTrue) {
                JSTypeOperation jSTypeOperation = prev;
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(81);
                }
                return jSTypeOperation;
            }
            JSTypeOperation jSTypeOperation = this.createReturnOperation(prev, expr);
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(82);
            }
            return jSTypeOperation;
        }
        HashMap<Integer, JSTypeOperation> operations = new HashMap<Integer, JSTypeOperation>();
        for (Integer ref2 : matchedNonRefs) {
            JSTypeOperation rel = this.narrowTypeOperation(prev, expr.getArguments()[ref2], assumeTrue);
            if (rel == prev) continue;
            operations.put(ref2, rel);
        }
        if (isAssertion && operations.isEmpty() && matched.isEmpty()) {
            if (!assumeTrue) {
                JSTypeOperation jSTypeOperation = prev;
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(83);
                }
                return jSTypeOperation;
            }
            JSTypeOperation jSTypeOperation = this.createReturnOperation(prev, expr);
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(84);
            }
            return jSTypeOperation;
        }
        JSType expressionType = JSTypeGuardUtil.getOperationType(expr);
        return new JSNarrowTypeByTypePredicateOperation(prev, expressionType, (IntSet)matched, (IntSet)matchedNonRefs, assumeTrue, operations, isAssertion);
    }

    private static boolean canContainNarrowingOperation(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(85);
        }
        return !(element instanceof JSObjectLiteralExpression) && !(element instanceof JSArrayLiteralExpression) && !(element instanceof JSControlFlowScope);
    }

    @NotNull
    protected JSTypeOperation createReturnOperation(@NotNull JSTypeOperation prev, @NotNull JSCallExpression expr) {
        if (prev == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(86);
        }
        if (expr == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(87);
        }
        return new JSNarrowTypeByNeverReturnOperation(prev, expr);
    }

    private boolean checkMethodCallPredicateCandidate(@NotNull JSCallExpression expr) {
        JSExpression method;
        if (expr == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(88);
        }
        if ((method = expr.getMethodExpression()) instanceof JSReferenceExpression) {
            JSExpression qualifier = ((JSReferenceExpression)method).getQualifier();
            return this.isMatchingReference(this.myElement, (PsiElement)qualifier);
        }
        return false;
    }

    @NotNull
    private JSTypeOperation narrowTypeByTruthiness(@NotNull JSTypeOperation prevOp, @Nullable JSExpression expression, boolean assumeTrue) {
        if (prevOp == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(89);
        }
        if (expression == null) {
            JSTypeOperation jSTypeOperation = prevOp;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(90);
            }
            return jSTypeOperation;
        }
        if (this.isMatchingReference(this.myElement, (PsiElement)expression)) {
            JSTypeOperation jSTypeOperation = this.createNarrowTypeByTruthinessOperation(prevOp, assumeTrue);
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(91);
            }
            return jSTypeOperation;
        }
        if (expression instanceof JSReferenceExpression && this.isMatchingReferenceDiscriminantByTruthinessCandidate((PsiElement)expression)) {
            JSTypeOperation jSTypeOperation = this.createNarrowTypeByDiscriminantTruthinessOperation(prevOp, (JSReferenceExpression)expression, assumeTrue);
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(92);
            }
            return jSTypeOperation;
        }
        JSTypeOperation jSTypeOperation = prevOp;
        if (jSTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(93);
        }
        return jSTypeOperation;
    }

    protected boolean isMatchingReferenceDiscriminantByTruthinessCandidate(@Nullable PsiElement expression) {
        return this.isMatchingReferenceDiscriminantCandidate(expression);
    }

    protected boolean isMatchingReferenceDiscriminantCandidate(@Nullable PsiElement expression) {
        if (!(expression instanceof JSElvisOwner)) {
            return false;
        }
        if (expression instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getReferenceName() == null) {
            return false;
        }
        JSExpression qualifier = TypeScriptTypeGuard.getElvisQualifierForNarrowing(expression);
        if (qualifier == null) {
            return false;
        }
        if (this.isMatchingReference(this.myElement, (PsiElement)qualifier)) {
            return true;
        }
        boolean hasMatching = false;
        boolean hasElvis = false;
        while (qualifier != null) {
            if (this.isMatchingReference(this.myElement, (PsiElement)qualifier)) {
                hasMatching = true;
            }
            if (hasElvis) break;
            if (qualifier instanceof JSElvisOwner && ((JSElvisOwner)qualifier).isElvis()) {
                hasElvis = true;
            }
            qualifier = TypeScriptTypeGuard.getElvisQualifierForNarrowing((PsiElement)qualifier);
        }
        return hasMatching && hasElvis;
    }

    @Nullable
    private static JSExpression getElvisQualifierForNarrowing(@NotNull PsiElement expression) {
        if (expression == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(94);
        }
        JSExpression qualifier = null;
        if (expression instanceof JSQualifiedExpression) {
            qualifier = ((JSQualifiedExpression)expression).getQualifier();
        } else if (expression instanceof JSCallExpression && (qualifier = ((JSCallExpression)expression).getMethodExpression()) instanceof JSQualifiedExpression) {
            qualifier = ((JSQualifiedExpression)qualifier).getQualifier();
        }
        return qualifier;
    }

    @Contract(value="_,null -> false")
    protected final boolean containsMatchingReference(@Nullable PsiElement source, @Nullable PsiElement target) {
        while (TypeScriptTypeGuard.isPropertyAccessExpression(source)) {
            if (!this.isMatchingReference((PsiElement)(source = ((JSReferenceExpression)source).getQualifier()), target)) continue;
            return true;
        }
        return false;
    }

    protected final boolean isMatchingReference(@Nullable PsiElement source, @Nullable PsiElement target) {
        if (target == null || source == null) {
            return false;
        }
        if (target == source) {
            return true;
        }
        if (target instanceof JSAssignmentExpression) {
            target = ((JSAssignmentExpression)target).getDefinitionExpression();
        }
        if (target instanceof JSDefinitionExpression) {
            target = ((JSDefinitionExpression)target).getExpression();
        }
        if (source instanceof JSReferenceExpression && target instanceof JSReferenceExpression) {
            String sourceName;
            String targetName = ((JSReferenceExpression)target).getReferenceName();
            if (!StringUtil.equals((CharSequence)targetName, (CharSequence)(sourceName = ((JSReferenceExpression)source).getReferenceName())) || targetName == null || sourceName == null) {
                return false;
            }
            JSExpression targetQualifier = ((JSReferenceExpression)target).getQualifier();
            JSExpression sourceQualifier = ((JSReferenceExpression)source).getQualifier();
            if (targetQualifier == null) {
                PsiElement targetElement;
                if (sourceQualifier != null) {
                    return false;
                }
                PsiElement sourceElement = this.myReferencingElement == source ? this.myResolvedElement : TypeScriptTypeGuard.resolveReferenceExpressionLocally(source);
                PsiElement psiElement = targetElement = this.myReferencingElement == target ? this.myResolvedElement : TypeScriptTypeGuard.resolveReferenceExpressionLocally(target);
                if (sourceElement != targetElement) {
                    return false;
                }
                if (sourceElement == null) {
                    PsiFile sourceFile = source.getContainingFile();
                    sourceFile = JSInjectionControlFlowUtil.isCfgAwareInjectedFile((PsiElement)sourceFile) ? InjectedLanguageManager.getInstance((Project)sourceFile.getProject()).getTopLevelFile((PsiElement)sourceFile) : sourceFile;
                    return Objects.equals(sourceFile, target.getContainingFile());
                }
                return true;
            }
            return this.isMatchingReference((PsiElement)targetQualifier, (PsiElement)sourceQualifier);
        }
        if (source instanceof JSVariable && target instanceof JSReferenceExpression) {
            return this.isMatchingReferenceForVariable((JSFieldVariable)source, (JSReferenceExpression)target);
        }
        if (source instanceof JSReferenceExpression && target instanceof JSVariable) {
            return this.isMatchingReferenceForVariable((JSFieldVariable)target, (JSReferenceExpression)source);
        }
        if (source instanceof JSThisExpression && target instanceof JSThisExpression) {
            return true;
        }
        if (source instanceof JSSuperExpression && target instanceof JSSuperExpression) {
            return true;
        }
        if (source instanceof TypeScriptNotNullExpression && target instanceof TypeScriptNotNullExpression) {
            return this.isMatchingReference((PsiElement)((TypeScriptNotNullExpression)source).getExpression(), (PsiElement)((TypeScriptNotNullExpression)target).getExpression());
        }
        return false;
    }

    private boolean isMatchingReferenceForVariable(@NotNull JSFieldVariable variable, @NotNull JSReferenceExpression expression) {
        String varName;
        JSExpression qualifier;
        if (variable == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(95);
        }
        if (expression == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(96);
        }
        if ((qualifier = expression.getQualifier()) != null && !(qualifier instanceof JSThisExpression)) {
            return false;
        }
        String name = expression.getReferenceName();
        if (!StringUtil.equals((CharSequence)name, (CharSequence)(varName = variable.getName()))) {
            return false;
        }
        if (expression == this.myReferencingElement) {
            return this.myAllResolvedElements.contains(variable);
        }
        return variable.equals(TypeScriptTypeGuard.resolveReferenceExpressionLocally((PsiElement)expression));
    }

    private static boolean isPropertyAccessExpression(@Nullable PsiElement element) {
        return element instanceof JSReferenceExpression && ((JSReferenceExpression)element).getQualifier() != null;
    }

    @NotNull
    protected final JSTypeOperation narrowTypeByBinaryExpression(@NotNull JSTypeOperation prevOperation, @NotNull JSBinaryExpression expression, boolean assumeTrue) {
        IElementType sign;
        if (prevOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(97);
        }
        if (expression == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(98);
        }
        if ((sign = expression.getOperationSign()) == null) {
            JSTypeOperation jSTypeOperation = prevOperation;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(99);
            }
            return jSTypeOperation;
        }
        if (sign == JSTokenTypes.ANDAND) {
            return this.narrowTypeByAnd(prevOperation, expression, assumeTrue);
        }
        if (sign == JSTokenTypes.OROR) {
            return this.narrowTypeByOr(prevOperation, expression, assumeTrue);
        }
        if (sign == JSTokenTypes.EQ) {
            return this.narrowTypeByTruthiness(prevOperation, expression.getLOperand(), assumeTrue);
        }
        if (sign == JSTokenTypes.INSTANCEOF_KEYWORD) {
            return this.narrowTypeByInstanceof(prevOperation, expression, assumeTrue);
        }
        if (sign == JSTokenTypes.COMMA) {
            return this.narrowTypeOperation(prevOperation, expression.getROperand(), assumeTrue);
        }
        if (sign == JSTokenTypes.IN_KEYWORD) {
            JSExpression lOperand = expression.getLOperand();
            JSExpression candidate = JSTypeGuardUtil.getReferenceCandidate(expression.getROperand());
            if (lOperand instanceof JSLiteralExpression && ((JSLiteralExpression)lOperand).isStringLiteral() && this.isMatchingReference(this.myElement, (PsiElement)candidate)) {
                String value = ((JSLiteralExpression)lOperand).getStringValue();
                if (!StringUtil.isEmptyOrSpaces((String)value)) {
                    JSTypeOperation jSTypeOperation = this.createNarrowTypeByInKeywordOperation(prevOperation, (PsiElement)lOperand, value, assumeTrue);
                    if (jSTypeOperation == null) {
                        TypeScriptTypeGuard.$$$reportNull$$$0(100);
                    }
                    return jSTypeOperation;
                }
                JSTypeOperation jSTypeOperation = prevOperation;
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(101);
                }
                return jSTypeOperation;
            }
            if (lOperand instanceof JSReferenceExpression && JSUtils.isPrivateBrandCheckReference((JSReferenceExpression)lOperand) && this.isMatchingReference(this.myElement, (PsiElement)candidate)) {
                return new JSNarrowTypeByPrivateBrandCheckOperation(prevOperation, (JSReferenceExpression)lOperand, assumeTrue);
            }
            JSTypeOperation jSTypeOperation = prevOperation;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(102);
            }
            return jSTypeOperation;
        }
        if (sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.NE || sign == JSTokenTypes.NEQEQ || sign == JSTokenTypes.EQEQEQ) {
            JSExpression left = JSTypeGuardUtil.getReferenceCandidate(expression.getLOperand());
            JSExpression right = JSTypeGuardUtil.getReferenceCandidate(expression.getROperand());
            if (left == null || right == null) {
                JSTypeOperation jSTypeOperation = prevOperation;
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(103);
                }
                return jSTypeOperation;
            }
            JSPrefixExpression leftTypeOf = JSTypeGuardChecker.getTypeOfPrefixExpression(left);
            if (leftTypeOf != null && JSTypeGuardChecker.isStringLiteralExpression(right)) {
                JSTypeOperation jSTypeOperation = this.narrowTypeByTypeof(prevOperation, leftTypeOf, sign, (JSLiteralExpression)right, assumeTrue);
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(104);
                }
                return jSTypeOperation;
            }
            JSPrefixExpression rightTypeOf = JSTypeGuardChecker.getTypeOfPrefixExpression(right);
            if (rightTypeOf != null && JSTypeGuardChecker.isStringLiteralExpression(left)) {
                JSTypeOperation jSTypeOperation = this.narrowTypeByTypeof(prevOperation, rightTypeOf, sign, (JSLiteralExpression)left, assumeTrue);
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(105);
                }
                return jSTypeOperation;
            }
            if (this.isMatchingReference(this.myElement, (PsiElement)left)) {
                JSTypeOperation jSTypeOperation = this.narrowTypeByEquality(prevOperation, sign, right, assumeTrue);
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(106);
                }
                return jSTypeOperation;
            }
            if (this.isMatchingReference(this.myElement, (PsiElement)right)) {
                JSTypeOperation jSTypeOperation = this.narrowTypeByEquality(prevOperation, sign, left, assumeTrue);
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(107);
                }
                return jSTypeOperation;
            }
            if (this.isMatchingReferenceDiscriminantCandidate((PsiElement)left)) {
                JSTypeOperation jSTypeOperation = this.narrowTypeByDiscriminantEquality(prevOperation, assumeTrue, sign, right, left);
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(108);
                }
                return jSTypeOperation;
            }
            if (this.isMatchingReferenceDiscriminantCandidate((PsiElement)right)) {
                JSTypeOperation jSTypeOperation = this.narrowTypeByDiscriminantEquality(prevOperation, assumeTrue, sign, left, right);
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(109);
                }
                return jSTypeOperation;
            }
            if (TypeScriptTypeGuard.shouldNarrowIndexerByConstructor(left)) {
                JSTypeOperation jSTypeOperation = this.narrowTypeByConstructor(prevOperation, assumeTrue, sign, right, left);
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(110);
                }
                return jSTypeOperation;
            }
            if (TypeScriptTypeGuard.shouldNarrowIndexerByConstructor(right)) {
                JSTypeOperation jSTypeOperation = this.narrowTypeByConstructor(prevOperation, assumeTrue, sign, left, right);
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(111);
                }
                return jSTypeOperation;
            }
        }
        JSTypeOperation jSTypeOperation = prevOperation;
        if (jSTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(112);
        }
        return jSTypeOperation;
    }

    @NotNull
    protected JSTypeOperation createNarrowTypeByInKeywordOperation(@NotNull JSTypeOperation prev, @NotNull PsiElement propertySource, @NotNull String property, boolean assumeTrue) {
        if (prev == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(113);
        }
        if (propertySource == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(114);
        }
        if (property == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(115);
        }
        return new JavaScriptNarrowTypeByInKeywordOperation(prev, propertySource, property, assumeTrue);
    }

    @NotNull
    protected JSTypeOperation narrowTypeByDiscriminantEquality(@NotNull JSTypeOperation prev, boolean assumeTrue, IElementType sign, JSExpression toCheck, JSExpression expression) {
        String propertyName;
        JSTypeOperation byConstructor;
        if (prev == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(116);
        }
        if ((byConstructor = this.narrowTypeByConstructor(prev, assumeTrue, sign, toCheck, expression)) != prev) {
            JSTypeOperation jSTypeOperation = byConstructor;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(117);
            }
            return jSTypeOperation;
        }
        if (toCheck == null) {
            JSTypeOperation jSTypeOperation = prev;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(118);
            }
            return jSTypeOperation;
        }
        String string = expression instanceof JSReferenceExpression ? ((JSReferenceExpression)expression).getReferenceName() : (propertyName = expression instanceof JSElvisOwner ? "_$_$ELVIS$_$_" : null);
        if (StringUtil.isEmpty((String)propertyName)) {
            JSTypeOperation jSTypeOperation = prev;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(119);
            }
            return jSTypeOperation;
        }
        TypeScriptNarrowTypeByDiscriminantEqualityOperation typeScriptNarrowTypeByDiscriminantEqualityOperation = this.createNarrowTypeByDiscriminatorEqualityOperation(prev, sign, toCheck, propertyName, JSTypeGuardChecker.isNegativeSign(sign) != assumeTrue, JSPsiImplUtils.isElvisOrInOptChain((JSElvisOwner)expression));
        if (typeScriptNarrowTypeByDiscriminantEqualityOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(120);
        }
        return typeScriptNarrowTypeByDiscriminantEqualityOperation;
    }

    @NotNull
    protected TypeScriptNarrowTypeByDiscriminantEqualityOperation createNarrowTypeByDiscriminatorEqualityOperation(@NotNull JSTypeOperation prev, IElementType sign, JSExpression toCheck, String propertyName, boolean assumeTrue, boolean expression) {
        if (prev == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(121);
        }
        return new TypeScriptNarrowTypeByDiscriminantEqualityOperation(prev, sign, toCheck, propertyName, assumeTrue, expression);
    }

    @NotNull
    protected JSTypeOperation narrowTypeByConstructor(@NotNull JSTypeOperation prev, boolean assumeTrue, IElementType sign, JSExpression toCheck, JSExpression expression) {
        if (prev == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(122);
        }
        if (toCheck == null) {
            JSTypeOperation jSTypeOperation = prev;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(123);
            }
            return jSTypeOperation;
        }
        boolean isNegativeSign = JSTypeGuardChecker.isNegativeSign(sign);
        if (!isNegativeSign && assumeTrue && TypeScriptTypeGuard.shouldNarrowIndexerByConstructor(expression)) {
            return new TypeScriptNarrowTypeByConstructorOperation(prev, toCheck, true);
        }
        if (!(expression instanceof JSReferenceExpression)) {
            JSTypeOperation jSTypeOperation = prev;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(124);
            }
            return jSTypeOperation;
        }
        String propertyName = ((JSReferenceExpression)expression).getReferenceName();
        if (StringUtil.isEmpty((String)propertyName)) {
            JSTypeOperation jSTypeOperation = prev;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(125);
            }
            return jSTypeOperation;
        }
        if ("constructor".equals(propertyName) && !isNegativeSign && assumeTrue) {
            return new TypeScriptNarrowTypeByConstructorOperation(prev, toCheck, true);
        }
        JSTypeOperation jSTypeOperation = prev;
        if (jSTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(126);
        }
        return jSTypeOperation;
    }

    private static boolean shouldNarrowIndexerByConstructor(JSExpression expression) {
        JSExpression indexExpression;
        return expression instanceof JSIndexedPropertyAccessExpression && (indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression()) instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isQuotedLiteral() && "constructor".equals(((JSLiteralExpression)indexExpression).getStringValue());
    }

    @NotNull
    protected JSTypeOperation narrowTypeByTypeof(@NotNull JSTypeOperation prevOperation, @NotNull JSPrefixExpression typeOfExpr, @NotNull IElementType sign, @NotNull JSLiteralExpression literal, boolean assumeTrue) {
        JSExpression target;
        if (prevOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(127);
        }
        if (typeOfExpr == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(128);
        }
        if (sign == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(129);
        }
        if (literal == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(130);
        }
        if (!this.isMatchingReference(this.myElement, (PsiElement)(target = JSTypeGuardUtil.getReferenceCandidate(typeOfExpr.getExpression())))) {
            return this.createElvisNarrowingIfNeeded(prevOperation, sign, literal, assumeTrue, target);
        }
        String value = literal.getStringValue();
        if (StringUtil.isEmpty((String)value)) {
            JSTypeOperation jSTypeOperation = prevOperation;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(131);
            }
            return jSTypeOperation;
        }
        return new JSNarrowTypeByTypeofOperation(prevOperation, value, JSTypeGuardChecker.isNegativeSign(sign) != assumeTrue);
    }

    @NotNull
    private JSTypeOperation createElvisNarrowingIfNeeded(@NotNull JSTypeOperation prevOperation, @NotNull IElementType sign, @NotNull JSExpression source, boolean assumeTrue, @Nullable JSExpression target) {
        JSExpression qualifier;
        if (prevOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(132);
        }
        if (sign == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(133);
        }
        if (source == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(134);
        }
        JSTypeOperation result2 = prevOperation;
        if (assumeTrue && target instanceof JSElvisOwner && JSPsiImplUtils.isElvisOrInOptChain((JSElvisOwner)target) && (qualifier = TypeScriptTypeGuard.getElvisQualifierForNarrowing((PsiElement)target)) != null && this.isMatchingReference(this.myElement, (PsiElement)qualifier)) {
            result2 = this.createNarrowTypeByDiscriminatorEqualityOperation(prevOperation, sign, source, "_$_$ELVIS$_$_", true, true);
        }
        JSTypeOperation jSTypeOperation = result2;
        if (jSTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(135);
        }
        return jSTypeOperation;
    }

    @Nullable
    private JSTypeOperation getTypeAtFlowAssignment(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSReadWriteInstruction currentInstruction, @NotNull ReadWriteAccessDetector.Access access) {
        PsiElement element;
        JSElement referenceExpressionCandidate;
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(136);
        }
        if (currentInstruction == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(137);
        }
        if (access == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(138);
        }
        if ((referenceExpressionCandidate = TypeScriptTypeGuard.getAssignTarget(element = currentInstruction.getElement())) == null) {
            return null;
        }
        if (this.isMatchingReference(this.myElement, (PsiElement)referenceExpressionCandidate)) {
            JSVarStatement statement;
            PsiElement parent;
            boolean isDeclarationPlace = element instanceof JSFieldVariable;
            JSExpression initializer = JSTypeGuardUtil.getInitializerExpression(element);
            if (initializer == null && isDeclarationPlace && (parent = JSResolveUtil.findParent(element)) instanceof JSForInStatement && (statement = ((JSForInStatement)parent).getVarDeclaration()) == element.getParent()) {
                return JSDeclaredTypeOperation.DECLARED_TYPE;
            }
            boolean allowsReDeclaration = !(element instanceof JSField) && element instanceof JSVariable && !((JSVariable)element).hasBlockScope();
            JSTypeOperation prevOp = this.getPrevInAssignment(flow, currentInstruction, (PsiElement)initializer, isDeclarationPlace, allowsReDeclaration);
            if (prevOp == JSEmptyOperation.NO_OPERATION || element instanceof JSVariable && JSDestructuringUtil.isDestructuring(element.getParent()) && ((JSVariable)element).getInitializer() == initializer) {
                return prevOp;
            }
            return this.createNarrowTypeByAssigmentOperation(prevOp, element, access, isDeclarationPlace, this.expressionHasCircularThisPropertyReferences(initializer, (PsiElement)referenceExpressionCandidate), TypeScriptTypeGuard.isInConstructor(element));
        }
        if (this.containsMatchingReference(this.myElement, element)) {
            return JSDeclaredTypeOperation.DECLARED_TYPE;
        }
        return null;
    }

    private boolean expressionHasCircularThisPropertyReferences(@Nullable JSExpression expression, @NotNull PsiElement target) {
        if (target == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(139);
        }
        if (expression == null || !(target instanceof JSQualifiedExpression) || !(((JSQualifiedExpression)target).getQualifier() instanceof JSThisExpression)) {
            return false;
        }
        return ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)expression).filter(el -> this.isMatchingReference((PsiElement)el, target))).traverse().isNotEmpty();
    }

    private static boolean isInConstructor(@NotNull PsiElement element) {
        JSExecutionScope scope2;
        if (element == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(140);
        }
        return (scope2 = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)element, JSExecutionScope.class)) instanceof JSFunction && ((JSFunction)scope2).isConstructor();
    }

    @NotNull
    private JSTypeOperation getPrevInAssignment(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSReadWriteInstruction currentInstruction, @Nullable PsiElement initializer, boolean isDeclarationPlace, boolean allowsReDeclaration) {
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(141);
        }
        if (currentInstruction == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(142);
        }
        if (currentInstruction.getAccess() == ReadWriteAccessDetector.Access.ReadWrite) {
            JSTypeOperation jSTypeOperation = this.getPrevFlowType(flow, (Instruction)currentInstruction);
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(143);
            }
            return jSTypeOperation;
        }
        if (isDeclarationPlace && !allowsReDeclaration || initializer != null) {
            JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
            if (jSDeclaredTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(144);
            }
            return jSDeclaredTypeOperation;
        }
        JSTypeOperation jSTypeOperation = this.getPrevFlowType(flow, (Instruction)currentInstruction);
        if (jSTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(145);
        }
        return jSTypeOperation;
    }

    @NotNull
    protected JSTypeOperation createNarrowTypeByAssigmentOperation(@NotNull JSTypeOperation prev, @NotNull PsiElement element, @NotNull ReadWriteAccessDetector.Access access, boolean isDeclarationPlace, boolean hasCircularThisPropertyAssignments, boolean isInConstructor) {
        if (prev == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(146);
        }
        if (element == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(147);
        }
        if (access == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(148);
        }
        return new TypeScriptNarrowTypeByAssignmentOperation(prev, element, access, isDeclarationPlace, hasCircularThisPropertyAssignments, isInConstructor);
    }

    @NotNull
    protected JSTypeOperation getTypeAtParentScope(@NotNull PsiElement scope2) {
        if (scope2 == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(149);
        }
        ArrayList<PsiElement> candidateParents = new ArrayList<PsiElement>();
        JSExecutionScope cfScope = null;
        for (Object parent = scope2 instanceof JSFile && JSInjectionControlFlowUtil.isCfgAwareInjectedFile(scope2) ? InjectedLanguageManager.getInstance((Project)scope2.getProject()).getInjectionHost(scope2) : scope2.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof JSClass) {
                JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
                if (jSDeclaredTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(150);
                }
                return jSDeclaredTypeOperation;
            }
            if (parent instanceof JSExecutionScope) {
                JSExecutionScope parentScope;
                cfScope = parentScope = (JSExecutionScope)parent;
                break;
            }
            candidateParents.add((PsiElement)parent);
        }
        if (cfScope == null) {
            JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
            if (jSDeclaredTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(151);
            }
            return jSDeclaredTypeOperation;
        }
        JSControlFlowService.JSControlFlow flowScope = this.getControlFlow(cfScope);
        if (flowScope == null) {
            JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
            if (jSDeclaredTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(152);
            }
            return jSDeclaredTypeOperation;
        }
        Instruction[] instructions = flowScope.getInstructions();
        for (PsiElement candidateScope : candidateParents) {
            int numberByElement = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)candidateScope);
            if (numberByElement == -1) continue;
            return this.getTypeAtFlowNode(flowScope, instructions[numberByElement]);
        }
        JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
        if (jSDeclaredTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(153);
        }
        return jSDeclaredTypeOperation;
    }

    @Nullable
    private JSTypeOperation getTypeAtFlowArrayMutation(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSModificationInstruction instruction) {
        JSDefinitionExpression definitionExpression;
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(154);
        }
        if (instruction == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(155);
        }
        if (!this.myIsTypeScript || !this.myPossibleAutoType) {
            return null;
        }
        JSExpression expression = instruction.getExpression();
        JSExpression toProcess = TypeScriptTypeGuard.getExpressionForArrayMutation(expression);
        if (!this.isMatchingReference(this.myElement, (PsiElement)JSTypeGuardUtil.getReferenceCandidate(toProcess))) {
            return null;
        }
        JSTypeOperation prevOp = this.getPrevFlowType(flow, instruction);
        PsiElement element = instruction.getElement();
        if (element == null) {
            return prevOp;
        }
        if (element instanceof JSCallExpression) {
            return new JSNarrowTypeByArrayMutationOperation(prevOp, (JSCallExpression)element, null, null);
        }
        if (element instanceof JSAssignmentExpression && (definitionExpression = ((JSAssignmentExpression)element).getDefinitionExpression()) != null) {
            JSExpression indexExpression;
            JSExpression elExpression = definitionExpression.getExpression();
            JSExpression initializer = definitionExpression.getInitializer();
            if (elExpression instanceof JSIndexedPropertyAccessExpression && initializer != null && (indexExpression = ((JSIndexedPropertyAccessExpression)elExpression).getIndexExpression()) != null) {
                return new JSNarrowTypeByArrayMutationOperation(prevOp, null, indexExpression, initializer);
            }
        }
        return prevOp;
    }

    @Nullable
    private static JSExpression getExpressionForArrayMutation(@NotNull JSExpression expression) {
        if (expression == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(156);
        }
        if (expression instanceof JSReferenceExpression) {
            PsiElement parent = expression.getParent();
            if (parent instanceof JSIndexedPropertyAccessExpression) {
                return expression;
            }
            return ((JSReferenceExpression)expression).getQualifier();
        }
        return null;
    }

    @NotNull
    private JSTypeOperation getTypeAtCaseBlock(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSCaseBlockInstruction instruction) {
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(157);
        }
        if (instruction == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(158);
        }
        JSTypeOperation prevOp = this.getPrevFlowType(flow, (Instruction)instruction);
        JSCaseBlockInstruction startBlock = instruction.getStartBlock();
        JSSwitchStatement statement = instruction.getSwitchStatement();
        if (statement == null) {
            JSTypeOperation jSTypeOperation = prevOp;
            if (jSTypeOperation == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(159);
            }
            return jSTypeOperation;
        }
        return this.getTypeAtSwitchClause(prevOp, statement, startBlock.getIndex(), instruction.getIndex());
    }

    @NotNull
    private JSTypeOperation getTypeAtFlowCondition(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSConditionInstruction instruction) {
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(160);
        }
        if (instruction == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(161);
        }
        JSTypeOperation prevOp = this.getPrevFlowType(flow, (Instruction)instruction);
        boolean assumeTrue = instruction.getValue();
        PsiElement element = instruction.getElement();
        if (element instanceof JSExpression) {
            return this.narrowTypeOperation(prevOp, (JSExpression)element, assumeTrue);
        }
        JSTypeOperation jSTypeOperation = prevOp;
        if (jSTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(162);
        }
        return jSTypeOperation;
    }

    @NotNull
    private JSTypeOperation getTypeAtCallAssertion(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull JSCallInstruction instruction, @NotNull JSCallExpression expression) {
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(163);
        }
        if (instruction == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(164);
        }
        if (expression == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(165);
        }
        JSTypeOperation jSTypeOperation = this.narrowByCallExpression(this.getPrevFlowType(flow, (Instruction)instruction), expression, true, true);
        if (jSTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(166);
        }
        return jSTypeOperation;
    }

    private static boolean isSuitableCallForAssertion(@NotNull JSCallExpression element) {
        PsiElement parent;
        if (element == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(167);
        }
        if (!((parent = element.getParent()) instanceof JSExpressionStatement) || ((JSExpressionStatement)parent).getExpression() != element) {
            return false;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)element.getMethodExpression(), JSReferenceExpression.class);
        return referenceExpression != null && JSSymbolUtil.isAccurateReferenceExpression(referenceExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected JSTypeOperation getPrevFlowType(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Instruction instruction) {
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(168);
        }
        if (instruction == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(169);
        }
        int depth = this.myDepth.incrementAndGet();
        if (depth > 100) {
            JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
            JSDeclaredTypeOperation jSDeclaredTypeOperation2 = jSDeclaredTypeOperation;
            if (jSDeclaredTypeOperation2 == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(170);
            }
            return jSDeclaredTypeOperation2;
        }
        Collection prevInstructions = instruction.allPred();
        int size = prevInstructions.size();
        if (size == 1) {
            JSTypeOperation jSTypeOperation = this.getTypeAtFlowNode(flow, (Instruction)ContainerUtil.getFirstItem((Collection)prevInstructions));
            JSTypeOperation jSTypeOperation2 = jSTypeOperation;
            if (jSTypeOperation2 == null) {
                TypeScriptTypeGuard.$$$reportNull$$$0(171);
            }
            return jSTypeOperation2;
        }
        JSTypeOperation jSTypeOperation = this.getPrevFlowTypeForInstructions(flow, prevInstructions);
        JSTypeOperation jSTypeOperation3 = jSTypeOperation;
        if (jSTypeOperation3 == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(172);
        }
        return jSTypeOperation3;
        finally {
            this.myDepth.decrementAndGet();
        }
    }

    @NotNull
    private JSTypeOperation getPrevFlowTypeForInstructions(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Collection<Instruction> instructions) {
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(173);
        }
        if (instructions == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(174);
        }
        LinkedHashSet<JSTypeOperation> result2 = new LinkedHashSet<JSTypeOperation>();
        boolean hasNoOperation = false;
        for (Instruction prevInstructions : instructions) {
            boolean isUnreachable = TypeScriptTypeGuard.isUnreachableInstruction(flow, prevInstructions);
            if (isUnreachable) continue;
            JSTypeOperation currentOperation = this.getTypeAtFlowNode(flow, prevInstructions);
            JSCompositeOperation.addFlat(result2, currentOperation, JSMergeOperation.class);
            hasNoOperation |= currentOperation == JSEmptyOperation.NO_OPERATION;
        }
        JSTypeOperation defaultOp = hasNoOperation ? JSEmptyOperation.NO_OPERATION : JSDeclaredTypeOperation.DECLARED_TYPE;
        JSTypeOperation jSTypeOperation = JSMergeOperation.create(result2, defaultOp);
        if (jSTypeOperation == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(175);
        }
        return jSTypeOperation;
    }

    private static boolean isUnreachableInstruction(@NotNull JSControlFlowService.JSControlFlow flow, @NotNull Instruction prevInstructions) {
        if (flow == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(176);
        }
        if (prevInstructions == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(177);
        }
        return flow.isCFUnreachable(prevInstructions) || prevInstructions instanceof JSInstructionWithReachability && !((JSInstructionWithReachability)prevInstructions).isReachable();
    }

    @Contract(value="null -> null")
    private static JSElement getAssignTarget(@Nullable PsiElement element) {
        if (element instanceof JSAssignmentExpression) {
            element = ((JSAssignmentExpression)element).getDefinitionExpression();
        }
        if (element instanceof JSDefinitionExpression) {
            return ((JSDefinitionExpression)element).getExpression();
        }
        if (element instanceof JSParameter) {
            return null;
        }
        if (element instanceof JSVariable) {
            return (JSVariable)element;
        }
        if (element instanceof JSForInStatement) {
            return JSUtils.unparenthesize(((JSForInStatement)element).getVariableExpression());
        }
        if (element instanceof JSReferenceExpression && JSDestructuringUtil.parentIsDestructuringAssignmentLHS((JSReferenceExpression)element)) {
            return (JSElement)element;
        }
        return null;
    }

    @NotNull
    static String getFirstQualifierName(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(178);
        }
        JSExpression qualifier = expression.getQualifier();
        while (qualifier instanceof JSReferenceExpression) {
            expression = (JSReferenceExpression)qualifier;
            qualifier = expression.getQualifier();
        }
        return qualifier == null ? StringUtil.notNullize((String)expression.getReferenceName()) : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 9, 10, 16, 17, 20, 21, 22, 23, 24, 25, 26, 27, 28, 37, 38, 41, 51, 52, 55, 56, 59, 60, 63, 64, 65, 68, 70, 71, 72, 76, 81, 82, 83, 84, 90, 91, 92, 93, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 117, 118, 119, 120, 123, 124, 125, 126, 131, 135, 143, 144, 145, 150, 151, 152, 153, 159, 162, 166, 170, 171, 172, 175 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 48: 
            case 75: 
            case 94: 
            case 96: 
            case 98: 
            case 156: 
            case 165: 
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 37: 
            case 38: 
            case 41: 
            case 51: 
            case 52: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 131: 
            case 135: 
            case 143: 
            case 144: 
            case 145: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 159: 
            case 162: 
            case 166: 
            case 170: 
            case 171: 
            case 172: 
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeGuard";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topName";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 11: 
            case 14: 
            case 18: 
            case 33: 
            case 35: 
            case 39: 
            case 42: 
            case 44: 
            case 136: 
            case 141: 
            case 154: 
            case 157: 
            case 160: 
            case 163: 
            case 168: 
            case 173: 
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: 
            case 19: 
            case 43: 
            case 45: 
            case 137: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentInstruction";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 34: 
            case 36: 
            case 155: 
            case 158: 
            case 161: 
            case 164: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regularPreds";
                break;
            }
            case 46: 
            case 66: 
            case 73: 
            case 74: 
            case 79: 
            case 86: 
            case 113: 
            case 116: 
            case 121: 
            case 122: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 47: 
            case 129: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 49: 
            case 53: 
            case 57: 
            case 61: 
            case 69: 
            case 97: 
            case 127: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevOperation";
                break;
            }
            case 50: 
            case 54: 
            case 58: 
            case 67: 
            case 78: 
            case 80: 
            case 87: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 77: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevOp";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySource";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOfExpr";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 138: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeGuard";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLeftExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNarrowedTypeOperations";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtFlowNode";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtFlowNodeImpl";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtLoop";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegularPredTypes";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByAnd";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByOr";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByInstanceof";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtSwitchClause";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowByCallExpression";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeOperation";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "createNarrowTypeByDiscriminantTruthinessOperation";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "createNarrowForPredicate";
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByTruthiness";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByBinaryExpression";
                break;
            }
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByDiscriminantEquality";
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByConstructor";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByTypeof";
                break;
            }
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "createElvisNarrowingIfNeeded";
                break;
            }
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevInAssignment";
                break;
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtParentScope";
                break;
            }
            case 159: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtCaseBlock";
                break;
            }
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtFlowCondition";
                break;
            }
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtCallAssertion";
                break;
            }
            case 170: 
            case 171: 
            case 172: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevFlowType";
                break;
            }
            case 175: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevFlowTypeForInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTopLeftExpression";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 37: 
            case 38: 
            case 41: 
            case 51: 
            case 52: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 131: 
            case 135: 
            case 143: 
            case 144: 
            case 145: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 159: 
            case 162: 
            case 166: 
            case 170: 
            case 171: 
            case 172: 
            case 175: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldResetDecoratorsOnAssignments";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isLocalSymbol";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEvolvingArrayOperationTarget";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkUseAutoTypeFromConfig";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowInstruction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findControlFlowScope";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowNode";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowNodeImpl";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isFinalScope";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isFinalFileScope";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isFinalFunctionScope";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isObjectLiteralOrClassExpressionMethod";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDialectSpecificTypeOperation";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtLoop";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getRegularPredTypes";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowReadWrite";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowRead";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByEquality";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByAnd";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByOr";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByInstanceof";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtSwitchClause";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "narrowByCallExpression";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeOperation";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "createNarrowTypeByTruthinessOperation";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "createNarrowTypeByDiscriminantTruthinessOperation";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "createNarrowByCallExpressionOperation";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createNarrowForPredicate";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "canContainNarrowingOperation";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "createReturnOperation";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodCallPredicateCandidate";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByTruthiness";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getElvisQualifierForNarrowing";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingReferenceForVariable";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByBinaryExpression";
                break;
            }
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "createNarrowTypeByInKeywordOperation";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByDiscriminantEquality";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "createNarrowTypeByDiscriminatorEqualityOperation";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByConstructor";
                break;
            }
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByTypeof";
                break;
            }
            case 132: 
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "createElvisNarrowingIfNeeded";
                break;
            }
            case 136: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowAssignment";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "expressionHasCircularThisPropertyReferences";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "isInConstructor";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "getPrevInAssignment";
                break;
            }
            case 146: 
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "createNarrowTypeByAssigmentOperation";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtParentScope";
                break;
            }
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowArrayMutation";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionForArrayMutation";
                break;
            }
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtCaseBlock";
                break;
            }
            case 160: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowCondition";
                break;
            }
            case 163: 
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtCallAssertion";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableCallForAssertion";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "getPrevFlowType";
                break;
            }
            case 173: 
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "getPrevFlowTypeForInstructions";
                break;
            }
            case 176: 
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "isUnreachableInstruction";
                break;
            }
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "getFirstQualifierName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 9, 10, 16, 17, 20, 21, 22, 23, 24, 25, 26, 27, 28, 37, 38, 41, 51, 52, 55, 56, 59, 60, 63, 64, 65, 68, 70, 71, 72, 76, 81, 82, 83, 84, 90, 91, 92, 93, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 117, 118, 119, 120, 123, 124, 125, 126, 131, 135, 143, 144, 145, 150, 151, 152, 153, 159, 162, 166, 170, 171, 172, 175 -> new IllegalStateException(string);
        };
    }
}

