/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.recordImpl;

import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeHashCodeUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.recordImpl.FunctionSignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.JSDelegatePropertySignature;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PropertySignatureCommonImpl
extends JSRecordType.PropertySignature {
    @Override
    @NotNull
    default public JSRecordType.PropertySignature copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform) {
        boolean sourcesAreSame;
        if (childTransform == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(0);
        }
        JSType oldType = this.getJSType();
        JSType type = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform);
        JSRecordType.MemberSource oldMemberSource = this.getMemberSource();
        JSRecordType.MemberSource memberSource = JSRecordTypeImpl.getUpdatedTypeMemberSource(oldMemberSource, childTransform);
        boolean bl = sourcesAreSame = memberSource == oldMemberSource;
        if (oldType == type && sourcesAreSame) {
            PropertySignatureCommonImpl propertySignatureCommonImpl = this;
            if (propertySignatureCommonImpl == null) {
                PropertySignatureCommonImpl.$$$reportNull$$$0(1);
            }
            return propertySignatureCommonImpl;
        }
        if (this instanceof JSRecordType.FunctionMember && type instanceof JSFunctionType) {
            return new FunctionSignatureImpl(this.getMemberName(), this.isPrivateName(), this.getPrivateNameDepth(), this.isConst(), type, this.isOptional(), memberSource);
        }
        JSRecordType.PropertySignature propertySignature = this.copyPropertySignatureWithTypeAndSource(type, sourcesAreSame, memberSource);
        if (propertySignature == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(2);
        }
        return propertySignature;
    }

    @NotNull
    private JSRecordType.PropertySignature copyPropertySignatureWithTypeAndSource(@Nullable JSType type, boolean sourcesAreSame, @NotNull JSRecordType.MemberSource memberSource) {
        if (memberSource == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(3);
        }
        if (this instanceof PsiElement && sourcesAreSame) {
            return new JSDelegatePropertySignature(this, type);
        }
        if (this instanceof JSDelegatePropertySignature && sourcesAreSame) {
            return new JSDelegatePropertySignature(((JSDelegatePropertySignature)this).getParentSignature(), type);
        }
        JSType keyType = sourcesAreSame ? this.getKeyType() : null;
        return new PropertySignatureImpl(this.getMemberName(), this.isPrivateName(), this.getPrivateNameDepth(), this.isConst(), type, keyType, this.isOptional(), this.isNumericKey(), memberSource);
    }

    @Override
    @Nullable
    default public JSType getKeyType() {
        JSComputedPropertyNameOwner esComputedOwner;
        ES6ComputedName computedPropertyName;
        Double doubleVal;
        JSRecordType.MemberSource memberSource = this.getMemberSource();
        JSTypeSource source = JSTypeSourceFactory.createTypeSource(memberSource.getSingleElement(), true);
        String name = this.getMemberName();
        if (this.isNumericKey() && (doubleVal = JSStringUtil.parseDoubleSafely(name)) != null) {
            return new JSNumberLiteralTypeImpl(doubleVal, false, source, name);
        }
        PropertySignatureCommonImpl propertySignatureCommonImpl = this;
        if (propertySignatureCommonImpl instanceof JSComputedPropertyNameOwner && (computedPropertyName = (esComputedOwner = (JSComputedPropertyNameOwner)((Object)propertySignatureCommonImpl)).getComputedPropertyName()) != null && computedPropertyName.isExpressionNumericLiteral()) {
            JSExpression expr = computedPropertyName.getExpression();
            if (expr instanceof JSLiteralExpression) {
                JSLiteralExpression literalExpression = (JSLiteralExpression)expr;
                Object expValue = literalExpression.getValue();
                if (expValue instanceof Number) {
                    Number number = (Number)expValue;
                    return new JSNumberLiteralTypeImpl(number.doubleValue(), false, source, name);
                }
                if (expValue != null) {
                    Logger.getInstance(PropertySignatureCommonImpl.class).error("Expected: Number, found: " + expValue);
                }
            } else {
                Logger.getInstance(PropertySignatureCommonImpl.class).error("Expected: literal expression, found: " + expr);
            }
        }
        return new JSTypeKeyTypeImpl(name, this, source);
    }

    @Override
    default public void appendMemberPresentation(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2, @NotNull String typeSeparator, char quote) {
        if (format == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(4);
        }
        if (builder2 == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(5);
        }
        if (typeSeparator == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(6);
        }
        PropertySignatureCommonImpl.appendPresentation(this, format, builder2, typeSeparator, quote, this.getMemberName());
    }

    public static void appendPresentation(@NotNull JSRecordType.PropertySignature signature, @NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2, @NotNull String typeSeparator, char quote, @NotNull String name) {
        JSType propertyType;
        if (signature == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(7);
        }
        if (format == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(8);
        }
        if (builder2 == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(9);
        }
        if (typeSeparator == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(10);
        }
        if (name == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(11);
        }
        if (signature.isConst()) {
            builder2.append("readonly ");
        }
        if (signature.isPrivateName()) {
            builder2.append(name);
            builder2.append("~" + signature.getPrivateNameDepth());
        } else if (PropertySignatureCommonImpl.isNumericOrComputed(signature)) {
            builder2.append(name);
        } else {
            builder2.append(JSSymbolUtil.quoteIfSpecialPropertyName(name, false, quote));
        }
        if (signature.isOptional()) {
            builder2.append("?");
        }
        if ((propertyType = signature.getJSType()) != null) {
            if (PropertySignatureCommonImpl.isFunctionMember(signature, propertyType)) {
                ((JSFunctionTypeImpl)propertyType).buildTypeTextImpl(format, builder2, false);
            } else {
                boolean appendBrackets = propertyType.isJavaScript() && JSTypeUtils.isNeedWrapTypeForSerialization(propertyType);
                builder2.append(typeSeparator);
                if (appendBrackets) {
                    builder2.append("(");
                }
                propertyType.buildTypeText(format, builder2);
                if (appendBrackets) {
                    builder2.append(")");
                }
            }
        }
    }

    private static boolean isNumericOrComputed(@NotNull JSRecordType.PropertySignature signature) {
        JSComputedPropertyNameOwner computedPropertyNameOwner;
        if (signature == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(12);
        }
        return signature.isNumericKey() || signature instanceof JSComputedPropertyNameOwner && (computedPropertyNameOwner = (JSComputedPropertyNameOwner)((Object)signature)).getComputedPropertyName() != null && computedPropertyNameOwner.getComputedPropertyName().isExpressionNumericLiteral() || signature instanceof JSRecordType.ComputedMember;
    }

    @Override
    default public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        JSType type;
        if (visitor == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(13);
        }
        if ((type = this.getJSType()) != null) {
            type.accept(visitor);
        }
    }

    public static boolean isFunctionMember(@NotNull JSRecordType.TypeMember typeMember, @Nullable JSType propertyType) {
        if (typeMember == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(14);
        }
        return propertyType instanceof JSFunctionTypeImpl && (typeMember instanceof JSRecordType.FunctionMember || typeMember.getMemberSource().getSingleElement() instanceof JSFunction);
    }

    @Override
    default public boolean isEquivalentTo(@Nullable JSRecordType.TypeMember other, @Nullable ProcessingContext context2, boolean allowResolve) {
        return PropertySignatureCommonImpl.arePropertySignaturesEqual(this, other, context2, allowResolve);
    }

    public static boolean arePropertySignaturesEqual(@NotNull JSRecordType.PropertySignature first, @Nullable JSRecordType.TypeMember otherRaw, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        JSType otherType;
        if (first == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(15);
        }
        if (otherRaw == first) {
            return true;
        }
        if (!(otherRaw instanceof JSRecordType.PropertySignature)) {
            return false;
        }
        JSRecordType.PropertySignature other = (JSRecordType.PropertySignature)otherRaw;
        if (!first.getMemberName().equals(other.getMemberName())) {
            return false;
        }
        JSType type = first.getJSType();
        return JSType.isEquivalentToSafe(type, otherType = other.getJSType(), processingContext, allowResolve) && first.getPrivateNameDepth() == other.getPrivateNameDepth() && first.isOptional() == other.isOptional();
    }

    @Override
    default public int getMemberHashCode() {
        return Objects.hash(this.getClass(), this.getMemberName(), JSTypeHashCodeUtil.getHashCodeSafe(this.getJSType()), this.isOptional(), this.isPrivateName(), this.getPrivateNameDepth());
    }

    @Override
    @Nullable
    default public JSType getJSTypeWithOptionality() {
        JSType type = JSRecordType.PropertySignature.super.getJSTypeWithOptionality();
        if (this.isOptional() && type != null) {
            return JSTypeGuardUtil.wrapWithUndefined(type, type.getSource());
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/recordImpl/PropertySignatureCommonImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberSource";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSeparator";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/recordImpl/PropertySignatureCommonImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyPropertySignatureWithTypeAndSource";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendMemberPresentation";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendPresentation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isNumericOrComputed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionMember";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "arePropertySignaturesEqual";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

