/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSConstStatusOwner;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionWithOperationNode;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static boolean isConstantExpression(JSExpression expression, boolean includeVars) {
        if (expression == null) {
            return false;
        }
        IsConstantExpressionVisitor visitor = new IsConstantExpressionVisitor(includeVars);
        expression.accept(visitor);
        return visitor.isConstant;
    }

    public static boolean isIncrementDecrementExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            ExpressionUtil.$$$reportNull$$$0(0);
        }
        if (expression instanceof JSPostfixExpression) {
            IElementType operator = ((JSPostfixExpression)expression).getOperationSign();
            return JSTokenTypes.PLUSPLUS.equals(operator) || JSTokenTypes.MINUSMINUS.equals(operator);
        }
        if (expression instanceof JSPrefixExpression) {
            IElementType operator = ((JSPrefixExpression)expression).getOperationSign();
            return JSTokenTypes.PLUSPLUS.equals(operator) || JSTokenTypes.MINUSMINUS.equals(operator);
        }
        return false;
    }

    public static int computeIncrementDecrementAmount(@Nullable PsiElement expression) {
        if (expression == null) {
            return 0;
        }
        if (expression instanceof JSPostfixExpression || expression instanceof JSPrefixExpression) {
            return ExpressionUtil.computeIncrementDecrementAmount((JSExpressionWithOperationNode)expression);
        }
        return 0;
    }

    private static int computeIncrementDecrementAmount(@NotNull JSExpressionWithOperationNode expression) {
        IElementType operator;
        if (expression == null) {
            ExpressionUtil.$$$reportNull$$$0(1);
        }
        if (JSTokenTypes.PLUSPLUS == (operator = expression.getOperationSign())) {
            return 1;
        }
        if (JSTokenTypes.MINUSMINUS == operator) {
            return -1;
        }
        return 0;
    }

    @Nullable
    public static Object computeConstantExpression(@Nullable JSExpression expression) {
        if (expression == null) {
            return null;
        }
        return ExpressionUtil.computeConstantExpression(expression, new JSComputeConstantExpressionVisitor(expression.getParent()));
    }

    public static Object computeConstantExpression(@Nullable JSExpression expression, Map<String, Object> computedEnumFields) {
        if (expression == null) {
            return null;
        }
        return ExpressionUtil.computeConstantExpression(expression, new JSComputeConstantExpressionVisitor(expression.getParent(), computedEnumFields));
    }

    private static Object computeConstantExpression(@Nullable JSExpression expression, JSComputeConstantExpressionVisitor visitor) {
        if (expression == null) {
            return null;
        }
        expression.accept(visitor);
        return visitor.getResult();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "expression";
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/ExpressionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isIncrementDecrementExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "computeIncrementDecrementAmount";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class IsConstantExpressionVisitor
    extends JSElementVisitor {
        private final boolean myIncludeVars;
        private boolean isConstant;
        private final Map<JSConstStatusOwner, Boolean> isVariableConstant = new HashMap<JSConstStatusOwner, Boolean>();
        private static final int MAX_WALK_DEPTH = JavaScriptParserBase.MAX_TREE_DEPTH;
        private int myWalkDepth = 0;

        IsConstantExpressionVisitor(boolean includeVars) {
            this.myIncludeVars = includeVars;
        }

        @Override
        public void visitJSExpression(@NotNull JSExpression expression) {
            if (expression == null) {
                IsConstantExpressionVisitor.$$$reportNull$$$0(0);
            }
            this.isConstant = false;
        }

        @Override
        public void visitJSStringTemplateExpression(@NotNull JSStringTemplateExpression stringTemplateExpression) {
            if (stringTemplateExpression == null) {
                IsConstantExpressionVisitor.$$$reportNull$$$0(1);
            }
            this.isConstant = stringTemplateExpression.getArguments().length == 0;
        }

        @Override
        public void visitJSLiteralExpression(@NotNull JSLiteralExpression expression) {
            if (expression == null) {
                IsConstantExpressionVisitor.$$$reportNull$$$0(2);
            }
            this.isConstant = true;
        }

        @Override
        public void visitJSParenthesizedExpression(@NotNull JSParenthesizedExpression expression) {
            JSExpression expr;
            if (expression == null) {
                IsConstantExpressionVisitor.$$$reportNull$$$0(3);
            }
            if ((expr = expression.getInnerExpression()) != null) {
                expr.accept(this);
            }
        }

        @Override
        public void visitJSPrefixExpression(@NotNull JSPrefixExpression expression) {
            if (expression == null) {
                IsConstantExpressionVisitor.$$$reportNull$$$0(4);
            }
            this.visitJSPrefixOrPostfixExpression(expression.getExpression(), expression.getOperationSign());
        }

        @Override
        public void visitJSPostfixExpression(@NotNull JSPostfixExpression expression) {
            if (expression == null) {
                IsConstantExpressionVisitor.$$$reportNull$$$0(5);
            }
            this.visitJSPrefixOrPostfixExpression(expression.getExpression(), expression.getOperationSign());
        }

        public void visitJSPrefixOrPostfixExpression(@Nullable JSExpression operand, IElementType sign) {
            if (operand == null) {
                this.isConstant = false;
                return;
            }
            operand.accept(this);
            if (!this.isConstant) {
                return;
            }
            if (sign == JSTokenTypes.PLUS || sign == JSTokenTypes.MINUS || sign == JSTokenTypes.TILDE || sign == JSTokenTypes.EXCL) {
                return;
            }
            this.isConstant = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                IsConstantExpressionVisitor.$$$reportNull$$$0(6);
            }
            if (this.myWalkDepth > MAX_WALK_DEPTH) {
                this.isConstant = false;
                return;
            }
            try {
                ++this.myWalkDepth;
                JSExpression lOperand = expression.getLOperand();
                if (lOperand == null) {
                    return;
                }
                lOperand.accept(this);
                if (!this.isConstant) {
                    return;
                }
                JSExpression rOperand = expression.getROperand();
                if (rOperand != null) {
                    rOperand.accept(this);
                }
            }
            finally {
                --this.myWalkDepth;
            }
        }

        @Override
        public void visitJSConditionalExpression(@NotNull JSConditionalExpression expression) {
            if (expression == null) {
                IsConstantExpressionVisitor.$$$reportNull$$$0(7);
            }
            JSExpression thenExpr = (JSExpression)expression.getThenBranch();
            JSExpression elseExpr = (JSExpression)expression.getElseBranch();
            if (thenExpr == null || elseExpr == null) {
                this.isConstant = false;
                return;
            }
            JSExpression condition = expression.getCondition();
            if (condition != null) {
                condition.accept(this);
            }
            if (!this.isConstant) {
                return;
            }
            thenExpr.accept(this);
            if (!this.isConstant) {
                return;
            }
            elseExpr.accept(this);
        }

        @Override
        public void visitJSReferenceExpression(@NotNull JSReferenceExpression expression) {
            if (expression == null) {
                IsConstantExpressionVisitor.$$$reportNull$$$0(8);
            }
            if (!this.myIncludeVars) {
                return;
            }
            PsiElement resolve2 = expression.resolve();
            if (!(resolve2 instanceof JSElement)) {
                return;
            }
            JSElement refElement = (JSElement)resolve2;
            if (!(refElement instanceof JSConstStatusOwner)) {
                this.isConstant = false;
                return;
            }
            JSConstStatusOwner variable = (JSConstStatusOwner)((Object)refElement);
            Boolean isConst = this.isVariableConstant.get(variable);
            if (isConst != null) {
                this.isConstant &= isConst.booleanValue();
                return;
            }
            boolean variableIsConst = variable.isConst();
            this.isVariableConstant.put(variable, variableIsConst);
            this.isConstant = variableIsConst;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringTemplateExpression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/util/ExpressionUtil$IsConstantExpressionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSStringTemplateExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSLiteralExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSParenthesizedExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSPrefixExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSPostfixExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSBinaryExpression";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSConditionalExpression";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class JSComputeConstantExpressionVisitor
    extends JSElementVisitor {
        private final Stack<Object> myStack = new Stack();
        private final PsiElement myParent;
        private final Map<String, Object> myComputedEnumFields;

        private JSComputeConstantExpressionVisitor(PsiElement parent) {
            this.myParent = parent;
            this.myComputedEnumFields = new HashMap<String, Object>();
        }

        private JSComputeConstantExpressionVisitor(PsiElement parent, Map<String, Object> computedEnumFields) {
            this.myParent = parent;
            this.myComputedEnumFields = computedEnumFields;
        }

        @Nullable
        private Object getResult() {
            if (this.myStack.isEmpty()) {
                return null;
            }
            Object res2 = this.myStack.pop();
            if (res2 == null) {
                this.myStack.clear();
            }
            return res2;
        }

        @Override
        public void visitJSParenthesizedExpression(@NotNull JSParenthesizedExpression node) {
            JSExpression innerExpression;
            if (node == null) {
                JSComputeConstantExpressionVisitor.$$$reportNull$$$0(0);
            }
            if ((innerExpression = node.getInnerExpression()) != null) {
                innerExpression.accept(this);
            }
        }

        @Override
        public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
            if (node == null) {
                JSComputeConstantExpressionVisitor.$$$reportNull$$$0(1);
            }
            Object value = null;
            String text = node.getText();
            if (node.isNumericLiteral()) {
                value = node.getValue();
            } else if (node.isQuotedLiteral()) {
                value = node instanceof JSStringTemplateExpression ? String.valueOf(node.getStringValue()) : StringUtil.unquoteString((String)text);
            } else {
                boolean equalsWithTrue = "true".equals(text);
                if (equalsWithTrue || "false".equals(text)) {
                    value = equalsWithTrue;
                }
            }
            this.pushValue(value);
        }

        private void pushValue(Object value) {
            int intValue;
            if (value instanceof Double) {
                intValue = (int)((Double)value).doubleValue();
                if (Double.valueOf(intValue).equals(value)) {
                    value = intValue;
                } else {
                    long rounded = (long)((Double)value).doubleValue();
                    if (Double.valueOf(rounded).equals(value)) {
                        value = rounded;
                    }
                }
            }
            if (value instanceof Long && Long.valueOf(intValue = (int)((Long)value).longValue()).equals(value)) {
                value = intValue;
            }
            this.myStack.push(value);
        }

        @Override
        public void visitJSConditionalExpression(@NotNull JSConditionalExpression node) {
            JSExpression expression;
            Object value;
            JSExpression condition;
            if (node == null) {
                JSComputeConstantExpressionVisitor.$$$reportNull$$$0(2);
            }
            if ((condition = node.getCondition()) != null) {
                condition.accept(this);
            }
            if ((value = this.getResult()) == null) {
                return;
            }
            JSExpression jSExpression = expression = JSComputeConstantExpressionVisitor.toBoolean(value) != false ? (JSExpression)node.getThenBranch() : (JSExpression)node.getElseBranch();
            if (expression == null) {
                return;
            }
            expression.accept(this);
        }

        @Override
        public void visitJSPrefixExpression(@NotNull JSPrefixExpression node) {
            JSExpression expression;
            if (node == null) {
                JSComputeConstantExpressionVisitor.$$$reportNull$$$0(3);
            }
            if ((expression = node.getExpression()) == null) {
                return;
            }
            expression.accept(this);
            Object value = this.getResult();
            if (value == null) {
                return;
            }
            IElementType operationSign = node.getOperationSign();
            Number number = JSComputeConstantExpressionVisitor.toNumber(value);
            if (operationSign == JSTokenTypes.MINUS) {
                value = -number.doubleValue();
            } else if (operationSign == JSTokenTypes.TILDE) {
                value = number.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
            } else if (operationSign == JSTokenTypes.EXCL) {
                value = JSComputeConstantExpressionVisitor.toBoolean(value) == false;
            } else if (operationSign == JSTokenTypes.PLUS) {
                value = number;
            }
            this.pushValue(value);
        }

        @Override
        public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
            JSExpression qualifier;
            if (node == null) {
                JSComputeConstantExpressionVisitor.$$$reportNull$$$0(4);
            }
            if ((qualifier = node.getQualifier()) != null && !(qualifier instanceof JSReferenceExpression)) {
                return;
            }
            if (!(this.myParent instanceof TypeScriptEnumField)) {
                return;
            }
            String name = ((TypeScriptEnumField)this.myParent).getName();
            if (this.myComputedEnumFields.containsKey(name)) {
                this.pushValue(this.myComputedEnumFields.get(name));
                return;
            }
            TypeScriptEnum owner = ((TypeScriptEnumField)this.myParent).getOwner();
            if (owner == null) {
                return;
            }
            if (qualifier != null && !Objects.equals(owner.getName(), ((JSReferenceExpression)qualifier).getReferenceName())) {
                return;
            }
            JSField[] fields = owner.getFields();
            int prevIntValue = -1;
            for (JSField field : fields) {
                if (field == this.myParent || field.getTextOffset() >= this.myParent.getTextOffset()) break;
                JSExpression fieldInitializer = field.getInitializer();
                if (fieldInitializer == null) {
                    ++prevIntValue;
                    if (!(field instanceof TypeScriptEnumField) || !Objects.equals(field.getName(), node.getReferenceName())) continue;
                    this.pushValue(prevIntValue);
                    this.myComputedEnumFields.put(field.getName(), prevIntValue);
                    return;
                }
                Object constantValue = ExpressionUtil.computeConstantExpression(fieldInitializer, new JSComputeConstantExpressionVisitor(fieldInitializer.getParent(), this.myComputedEnumFields));
                if (constantValue == null) continue;
                if (field instanceof TypeScriptEnumField && Objects.equals(field.getName(), node.getReferenceName())) {
                    this.pushValue(constantValue);
                    this.myComputedEnumFields.put(field.getName(), constantValue);
                    return;
                }
                if (!(constantValue instanceof Number)) break;
                prevIntValue = ((Number)constantValue).intValue();
            }
        }

        @Override
        public void visitJSPostfixExpression(@NotNull JSPostfixExpression node) {
            JSExpression expression;
            if (node == null) {
                JSComputeConstantExpressionVisitor.$$$reportNull$$$0(5);
            }
            if ((expression = node.getExpression()) == null) {
                return;
            }
            expression.accept(this);
            Object result2 = this.getResult();
            if (result2 == null) {
                return;
            }
            Number number = JSComputeConstantExpressionVisitor.toNumber(result2);
            Number value = JSComputeConstantExpressionVisitor.computeIncrementDecrementExpression(number, node.getOperationSign());
            this.pushValue(value);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void visitJSBinaryExpression(@NotNull JSBinaryExpression node) {
            Object value;
            block41: {
                IElementType operationSign;
                Object rightValue;
                Object leftValue;
                block46: {
                    BigInteger rightNumber;
                    BigInteger leftNumber;
                    block59: {
                        block58: {
                            block57: {
                                block56: {
                                    block55: {
                                        block54: {
                                            block53: {
                                                block52: {
                                                    block51: {
                                                        block50: {
                                                            block49: {
                                                                block48: {
                                                                    block47: {
                                                                        block45: {
                                                                            block44: {
                                                                                block43: {
                                                                                    block42: {
                                                                                        block40: {
                                                                                            JSExpression lOperand;
                                                                                            if (node == null) {
                                                                                                JSComputeConstantExpressionVisitor.$$$reportNull$$$0(6);
                                                                                            }
                                                                                            if ((lOperand = node.getLOperand()) == null) {
                                                                                                return;
                                                                                            }
                                                                                            lOperand.accept(this);
                                                                                            leftValue = this.getResult();
                                                                                            if (leftValue == null) {
                                                                                                return;
                                                                                            }
                                                                                            JSExpression rOperand = node.getROperand();
                                                                                            if (rOperand == null) {
                                                                                                return;
                                                                                            }
                                                                                            rOperand.accept(this);
                                                                                            rightValue = this.getResult();
                                                                                            if (rightValue == null) {
                                                                                                return;
                                                                                            }
                                                                                            value = null;
                                                                                            operationSign = node.getOperationSign();
                                                                                            if (operationSign == JSTokenTypes.EQEQEQ || operationSign == JSTokenTypes.NEQEQ) {
                                                                                                boolean eq = leftValue.equals(rightValue);
                                                                                                value = operationSign == JSTokenTypes.EQEQEQ == eq;
                                                                                            }
                                                                                            if (operationSign != JSTokenTypes.EQEQ) break block40;
                                                                                            value = JSComputeConstantExpressionVisitor.computeEquality(leftValue, rightValue);
                                                                                            break block41;
                                                                                        }
                                                                                        if (operationSign != JSTokenTypes.NE) break block42;
                                                                                        value = !JSComputeConstantExpressionVisitor.computeEquality(leftValue, rightValue);
                                                                                        break block41;
                                                                                    }
                                                                                    if (operationSign != JSTokenTypes.ANDAND) break block43;
                                                                                    Boolean leftBoolean = JSComputeConstantExpressionVisitor.toBoolean(leftValue);
                                                                                    value = leftBoolean == false ? leftValue : rightValue;
                                                                                    break block41;
                                                                                }
                                                                                if (operationSign != JSTokenTypes.OROR) break block44;
                                                                                Boolean leftBoolean = JSComputeConstantExpressionVisitor.toBoolean(leftValue);
                                                                                value = leftBoolean != false ? leftValue : rightValue;
                                                                                break block41;
                                                                            }
                                                                            if (operationSign != JSTokenTypes.PLUS || !(leftValue instanceof String) && !(rightValue instanceof String)) break block45;
                                                                            value = leftValue.toString() + rightValue.toString();
                                                                            break block41;
                                                                        }
                                                                        if (!(leftValue instanceof BigInteger)) break block46;
                                                                        leftNumber = (BigInteger)leftValue;
                                                                        if (!(rightValue instanceof BigInteger)) break block46;
                                                                        rightNumber = (BigInteger)rightValue;
                                                                        if (operationSign != JSTokenTypes.PLUS) break block47;
                                                                        value = leftNumber.add(rightNumber);
                                                                        break block41;
                                                                    }
                                                                    if (operationSign != JSTokenTypes.MINUS) break block48;
                                                                    value = leftNumber.subtract(rightNumber);
                                                                    break block41;
                                                                }
                                                                if (operationSign != JSTokenTypes.MULT) break block49;
                                                                value = leftNumber.multiply(rightNumber);
                                                                break block41;
                                                            }
                                                            if (operationSign != JSTokenTypes.MULTMULT) break block50;
                                                            value = leftNumber.pow(rightNumber.intValue());
                                                            break block41;
                                                        }
                                                        if (operationSign != JSTokenTypes.DIV || BigInteger.ZERO.equals(rightNumber)) break block51;
                                                        value = leftNumber.divide(rightNumber);
                                                        break block41;
                                                    }
                                                    if (operationSign != JSTokenTypes.PERC) break block52;
                                                    value = leftNumber.remainder(rightNumber);
                                                    break block41;
                                                }
                                                if (operationSign != JSTokenTypes.LTLT) break block53;
                                                value = leftNumber.shiftLeft(rightNumber.intValue());
                                                break block41;
                                            }
                                            if (operationSign != JSTokenTypes.GTGT) break block54;
                                            value = leftNumber.shiftRight(rightNumber.intValue());
                                            break block41;
                                        }
                                        if (operationSign != JSTokenTypes.LT) break block55;
                                        value = leftNumber.compareTo(rightNumber) < 0;
                                        break block41;
                                    }
                                    if (operationSign != JSTokenTypes.GT) break block56;
                                    value = leftNumber.compareTo(rightNumber) > 0;
                                    break block41;
                                }
                                if (operationSign != JSTokenTypes.LE) break block57;
                                value = leftNumber.compareTo(rightNumber) <= 0;
                                break block41;
                            }
                            if (operationSign != JSTokenTypes.GE) break block58;
                            value = leftNumber.compareTo(rightNumber) >= 0;
                            break block41;
                        }
                        if (operationSign != JSTokenTypes.AND) break block59;
                        value = leftNumber.and(rightNumber);
                        break block41;
                    }
                    if (operationSign == JSTokenTypes.OR) {
                        value = leftNumber.or(rightNumber);
                        break block41;
                    } else if (operationSign == JSTokenTypes.XOR) {
                        value = leftNumber.xor(rightNumber);
                    }
                    break block41;
                }
                Number leftNumber = JSComputeConstantExpressionVisitor.toNumber(leftValue);
                Number rightNumber = JSComputeConstantExpressionVisitor.toNumber(rightValue);
                if (operationSign == JSTokenTypes.PLUS) {
                    value = leftNumber.doubleValue() + rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.MINUS) {
                    value = leftNumber.doubleValue() - rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.MULT) {
                    value = leftNumber.doubleValue() * rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.MULTMULT) {
                    value = Math.pow(leftNumber.doubleValue(), rightNumber.doubleValue());
                } else if (operationSign == JSTokenTypes.DIV) {
                    value = leftNumber.doubleValue() / rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.PERC) {
                    value = leftNumber.doubleValue() % rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.LTLT) {
                    value = leftNumber.longValue() << (int)rightNumber.longValue();
                } else if (operationSign == JSTokenTypes.GTGT) {
                    value = leftNumber.longValue() >> (int)rightNumber.longValue();
                } else if (operationSign == JSTokenTypes.GTGTGT) {
                    value = leftNumber.longValue() >>> (int)rightNumber.longValue();
                } else if (operationSign == JSTokenTypes.LT) {
                    value = leftNumber.doubleValue() < rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.GT) {
                    value = leftNumber.doubleValue() > rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.LE) {
                    value = leftNumber.doubleValue() <= rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.GE) {
                    value = leftNumber.doubleValue() >= rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.AND) {
                    value = leftNumber.longValue() & rightNumber.longValue();
                } else if (operationSign == JSTokenTypes.OR) {
                    value = leftNumber.longValue() | rightNumber.longValue();
                } else if (operationSign == JSTokenTypes.XOR) {
                    value = leftNumber.longValue() ^ rightNumber.longValue();
                }
            }
            this.pushValue(value);
        }

        @NotNull
        private static Number toNumber(Object value) {
            Number number = value instanceof String ? (Number)JSComputeConstantExpressionVisitor.getNumericValue((String)value) : (Number)(value instanceof Boolean ? (Number)((Boolean)value != false ? 1L : 0L) : (Number)((Number)value));
            Number number2 = number;
            if (number2 == null) {
                JSComputeConstantExpressionVisitor.$$$reportNull$$$0(7);
            }
            return number2;
        }

        @NotNull
        private static Number getNumericValue(String text) {
            Double numeric;
            BigInteger bigInteger = JSNumberParser.tryParseBigInt(text);
            if (bigInteger != null) {
                BigInteger bigInteger2 = bigInteger;
                if (bigInteger2 == null) {
                    JSComputeConstantExpressionVisitor.$$$reportNull$$$0(8);
                }
                return bigInteger2;
            }
            if (StringUtil.startsWithChar((CharSequence)text, (char)'+')) {
                text = text.substring(1);
            }
            Double d = (numeric = JSNumberParser.tryParseNumericValue(text, false)) == null ? Double.valueOf(Double.NaN) : numeric;
            if (d == null) {
                JSComputeConstantExpressionVisitor.$$$reportNull$$$0(9);
            }
            return d;
        }

        @NotNull
        private static Boolean toBoolean(Object value) {
            double doubleValue;
            Boolean v = value instanceof String ? Boolean.valueOf(((String)value).length() > 0) : (value instanceof Number ? Boolean.valueOf((doubleValue = ((Number)value).doubleValue()) != 0.0 && !Double.isNaN(doubleValue)) : (Boolean)value);
            Boolean bl = v;
            if (bl == null) {
                JSComputeConstantExpressionVisitor.$$$reportNull$$$0(10);
            }
            return bl;
        }

        private static boolean computeEquality(Object leftValue, Object rightValue) {
            if (leftValue instanceof BigInteger && rightValue instanceof BigInteger) {
                return leftValue.equals(rightValue);
            }
            if (leftValue instanceof Number && rightValue instanceof Number) {
                return ((Number)leftValue).doubleValue() == ((Number)rightValue).doubleValue();
            }
            if (leftValue.getClass() == rightValue.getClass()) {
                return leftValue.equals(rightValue);
            }
            if (leftValue instanceof Number && rightValue instanceof String) {
                return JSComputeConstantExpressionVisitor.computeEquality(leftValue, JSComputeConstantExpressionVisitor.toNumber(rightValue));
            }
            if (leftValue instanceof String && rightValue instanceof Number) {
                return JSComputeConstantExpressionVisitor.computeEquality(JSComputeConstantExpressionVisitor.toNumber(leftValue), rightValue);
            }
            if (leftValue instanceof Boolean) {
                return JSComputeConstantExpressionVisitor.computeEquality(JSComputeConstantExpressionVisitor.toNumber(leftValue), rightValue);
            }
            if (rightValue instanceof Boolean) {
                return JSComputeConstantExpressionVisitor.computeEquality(leftValue, JSComputeConstantExpressionVisitor.toNumber(rightValue));
            }
            return false;
        }

        @Nullable
        private static Number computeIncrementDecrementExpression(@NotNull Number value, IElementType operationSign) {
            if (value == null) {
                JSComputeConstantExpressionVisitor.$$$reportNull$$$0(11);
            }
            Number v = null;
            if (operationSign == JSTokenTypes.PLUSPLUS) {
                v = value instanceof BigInteger ? ((BigInteger)value).add(BigInteger.ONE) : Long.valueOf(value.longValue() + 1L);
            } else if (operationSign == JSTokenTypes.MINUSMINUS) {
                v = value instanceof BigInteger ? ((BigInteger)value).subtract(BigInteger.ONE) : Long.valueOf(value.longValue() - 1L);
            }
            return v;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/util/ExpressionUtil$JSComputeConstantExpressionVisitor";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/util/ExpressionUtil$JSComputeConstantExpressionVisitor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toNumber";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNumericValue";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toBoolean";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitJSParenthesizedExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitJSLiteralExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitJSConditionalExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitJSPrefixExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitJSReferenceExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitJSPostfixExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitJSBinaryExpression";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "computeIncrementDecrementExpression";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8, 9, 10 -> new IllegalStateException(string);
            };
        }
    }
}

