/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceStatisticsCollector;
import com.intellij.lang.javascript.service.JSLanguageServiceTracerUtilKt;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceConnector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0016\u0018\u0000 ]2\u00020\u0001:\u0002\\]B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u000204H\u0002J\b\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u0002042\u0006\u00109\u001a\u00020.H\u0002J\b\u0010:\u001a\u000204H\u0002J\b\u0010;\u001a\u000204H\u0004J\u0017\u0010<\u001a\u0002042\r\u0010=\u001a\t\u0018\u00010$\u00a2\u0006\u0002\b%H\u0002J\b\u0010>\u001a\u000204H\u0016J\b\u0010?\u001a\u000204H\u0014J\u0010\u0010@\u001a\u0002042\u0006\u0010A\u001a\u00020\u001eH\u0004J\u0010\u0010B\u001a\u0002042\u0006\u0010C\u001a\u00020DH\u0004J\u0017\u0010B\u001a\u0002042\r\u0010E\u001a\t\u0018\u00010$\u00a2\u0006\u0002\bFH\u0004J\b\u0010G\u001a\u000204H\u0004J\u0010\u0010H\u001a\u0002042\u0006\u0010I\u001a\u00020JH\u0002J1\u0010R\u001a\b\u0012\u0004\u0012\u0002HT0S\"\u0004\b\u0000\u0010T2\r\u0010U\u001a\t\u0018\u00010$\u00a2\u0006\u0002\bF2\u000e\u0010V\u001a\n\u0012\u0006\b\u0001\u0012\u0002HT0WJ\u001c\u0010X\u001a\u0002042\u0006\u0010=\u001a\u00020$2\n\b\u0002\u0010Y\u001a\u0004\u0018\u00010ZH\u0004J\u0010\u0010[\u001a\u0002042\u0006\u0010=\u001a\u00020$H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010#\u001a\t\u0018\u00010$\u00a2\u0006\u0002\b%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020'@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010/\u001a\u0004\u0018\u000100X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u0010K\u001a\u00020L8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010MR\u0014\u0010N\u001a\u00020L8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010MR\u0016\u0010O\u001a\u0004\u0018\u00010$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010Q\u00a8\u0006^"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutor;", "myProject", "Lcom/intellij/openapi/project/Project;", "protocol", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceConnector;", "myProcessConnector", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ProcessConnector;", "myReporter", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ServiceInfoReporter;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceConnector;Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ProcessConnector;Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ServiceInfoReporter;)V", "getProtocol", "()Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceConnector;", "getMyReporter", "()Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ServiceInfoReporter;", "myInitialized", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "cacheSyncLock", "Lkotlinx/coroutines/sync/Mutex;", "getCacheSyncLock", "()Lkotlinx/coroutines/sync/Mutex;", "commandCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCommandCoroutineScope$annotations", "()V", "getCommandCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "myExecutorService", "Ljava/util/concurrent/ExecutorService;", "getMyExecutorService", "()Ljava/util/concurrent/ExecutorService;", "myDisposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "myStartErrorMessage", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "value", "Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutor$State;", "state", "getState", "()Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutor$State;", "setState", "(Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutor$State;)V", "myProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "myLifecycleSpan", "Lio/opentelemetry/api/trace/Span;", "getMyLifecycleSpan", "()Lio/opentelemetry/api/trace/Span;", "startServiceWithProgress", "", "startService", "createIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "connectProcessHandler", "processHandler", "createProcessHandler", "processTerminated", "reportUserError", "message", "dispose", "doDispose", "shutdownPool", "pool", "startAction", "command", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceCommand;", "text", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "endAction", "disposeIndicator", "indicator", "Lcom/intellij/openapi/progress/impl/BackgroundableProcessIndicator;", "isStarted", "", "()Z", "isValid", "startErrorMessage", "getStartErrorMessage", "()Ljava/lang/String;", "submit", "Ljava/util/concurrent/Future;", "T", "presentableName", "task", "Ljava/util/concurrent/Callable;", "infoLog", "exception", "", "debugLog", "JSLanguageServiceExecutorCoroutineScope", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSLanguageServiceExecutorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLanguageServiceExecutorImpl.kt\ncom/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,438:1\n31#2,2:439\n19#3:441\n1#4:442\n*S KotlinDebug\n*F\n+ 1 JSLanguageServiceExecutorImpl.kt\ncom/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl\n*L\n57#1:439,2\n340#1:441\n*E\n"})
public class JSLanguageServiceExecutorImpl
implements JSLanguageServiceExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final JSLanguageServiceConnector protocol;
    @Nullable
    private final JSLanguageServiceQueue.ProcessConnector myProcessConnector;
    @NotNull
    private final JSLanguageServiceQueue.ServiceInfoReporter myReporter;
    @NotNull
    private final CompletableFuture<Void> myInitialized;
    @NotNull
    private final Mutex cacheSyncLock;
    @NotNull
    private final CoroutineScope commandCoroutineScope;
    @NotNull
    private final ExecutorService myExecutorService;
    @NotNull
    private final AtomicBoolean myDisposed;
    @Nullable
    private volatile String myStartErrorMessage;
    @NotNull
    private volatile JSLanguageServiceExecutor.State state;
    @Nullable
    private ProcessHandler myProcessHandler;
    @Nullable
    private final Span myLifecycleSpan;

    public JSLanguageServiceExecutorImpl(@NotNull Project myProject, @NotNull JSLanguageServiceConnector protocol, @Nullable JSLanguageServiceQueue.ProcessConnector myProcessConnector, @NotNull JSLanguageServiceQueue.ServiceInfoReporter myReporter) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)myReporter, (String)"myReporter");
        this.myProject = myProject;
        this.protocol = protocol;
        this.myProcessConnector = myProcessConnector;
        this.myReporter = myReporter;
        this.myInitialized = new CompletableFuture();
        this.cacheSyncLock = MutexKt.Mutex((boolean)false);
        ComponentManager $this$service$iv = (ComponentManager)this.myProject;
        boolean $i$f$service = false;
        Class<JSLanguageServiceExecutorCoroutineScope> serviceClass$iv = JSLanguageServiceExecutorCoroutineScope.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.commandCoroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)((JSLanguageServiceExecutorCoroutineScope)object).getCoroutineScope(), (String)("JS external service " + this.myReporter.getPresentableServiceName()), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault().limitedParallelism(2)), (boolean)false, (int)4, null);
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)("JS external service " + this.myReporter.getPresentableServiceName()), (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.myExecutorService = executorService;
        this.myDisposed = new AtomicBoolean(false);
        this.state = JSLanguageServiceExecutor.State.STARTING;
        this.myLifecycleSpan = Span.current();
        this.myExecutorService.execute(() -> JSLanguageServiceExecutorImpl._init_$lambda$0(this));
    }

    @NotNull
    public JSLanguageServiceConnector getProtocol() {
        return this.protocol;
    }

    @NotNull
    protected final JSLanguageServiceQueue.ServiceInfoReporter getMyReporter() {
        return this.myReporter;
    }

    @NotNull
    protected final Mutex getCacheSyncLock() {
        return this.cacheSyncLock;
    }

    @NotNull
    protected final CoroutineScope getCommandCoroutineScope() {
        return this.commandCoroutineScope;
    }

    protected static /* synthetic */ void getCommandCoroutineScope$annotations() {
    }

    @NotNull
    protected final ExecutorService getMyExecutorService() {
        return this.myExecutorService;
    }

    @Override
    @NotNull
    public JSLanguageServiceExecutor.State getState() {
        return this.state;
    }

    protected void setState(@NotNull JSLanguageServiceExecutor.State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    @Nullable
    protected final Span getMyLifecycleSpan() {
        return this.myLifecycleSpan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startServiceWithProgress() {
        ProgressIndicator indicator = this.createIndicator();
        try {
            ProgressManager.getInstance().runProcess(() -> JSLanguageServiceExecutorImpl.startServiceWithProgress$lambda$2(this), indicator);
        }
        catch (ProcessCanceledException e) {
            JSLanguageServiceExecutorImpl.infoLog$default(this, "starting has been cancelled", null, 2, null);
        }
        catch (Throwable e) {
            JSLanguageServiceQueue.Holder.LOGGER.error(e);
            throw e;
        }
        finally {
            if (indicator instanceof BackgroundableProcessIndicator) {
                this.disposeIndicator((BackgroundableProcessIndicator)indicator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startService() {
        try {
            if (this.getState() == JSLanguageServiceExecutor.State.DISPOSED) {
                this.debugLog("StartService: already disposed");
                return;
            }
            this.debugLog("Creating OS Handler");
            JSLanguageServiceTracerUtilKt.withServiceTraceSpan$default(this, "createProcessHandler", null, () -> JSLanguageServiceExecutorImpl.startService$lambda$3(this), 2, null);
            if (this.myProcessHandler == null) {
                return;
            }
            this.debugLog("OS Handler created successfully");
            JSLanguageServiceTracerUtilKt.withServiceTraceSpan$default(this, "connectProcessHandler", null, () -> JSLanguageServiceExecutorImpl.startService$lambda$4(this), 2, null);
        }
        finally {
            this.myInitialized.complete(null);
        }
        Exception exception = null;
        boolean readyNotificationReceived = false;
        try {
            readyNotificationReceived = (Boolean)JSLanguageServiceTracerUtilKt.withServiceTraceSpan$default(this, "awaitReadyNotification", null, () -> JSLanguageServiceExecutorImpl.startService$lambda$5(this), 2, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (Exception e) {
            exception = e;
        }
        if (this.getState() == JSLanguageServiceExecutor.State.DISPOSED) {
            this.debugLog("StartService after awaitReadyNotification. Already disposed.");
            return;
        }
        if (exception != null) {
            this.setState(JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT);
            String string = JSLanguageServiceExecutorImpl.Companion.getPresentableExceptionMessage(exception);
            Intrinsics.checkNotNull((Object)string);
            this.reportUserError(string);
            this.infoLog("Exception while waiting for ready notification", exception);
            return;
        }
        if (readyNotificationReceived) {
            this.setState(JSLanguageServiceExecutor.State.STARTED);
        } else {
            this.setState(JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT);
            this.reportUserError((String)ObjectUtils.coalesce((Object)this.getProtocol().getInitializeError(), (Object)JavaScriptBundle.message("javascript.language.service.start.timeout", new Object[0])));
            JSLanguageServiceExecutorImpl.infoLog$default(this, "Timed out waiting for ready notification", null, 2, null);
        }
    }

    private final ProgressIndicator createIndicator() {
        if (this.myProcessConnector == null) {
            return (ProgressIndicator)new EmptyProgressIndicator();
        }
        Object[] objectArray = new Object[]{this.myReporter.getPresentableServiceName()};
        String string = JavaScriptBundle.message("javascript.starting.service", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        return (ProgressIndicator)new BackgroundableProcessIndicator(this.myProject, title, null, "", false);
    }

    private final void connectProcessHandler(ProcessHandler processHandler) {
        block0: {
            JSLanguageServiceQueue.ProcessConnector processConnector = this.myProcessConnector;
            if (processConnector == null) break block0;
            processConnector.connectToProcessHandler(processHandler);
        }
    }

    private final void createProcessHandler() {
        try {
            this.myProcessHandler = this.getProtocol().connect();
            if (this.myProcessHandler == null) {
                this.setState(JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT);
                this.reportUserError((String)ObjectUtils.coalesce((Object)this.getProtocol().getInitializeError(), (Object)JavaScriptBundle.message("javascript.language.service.start.timeout", new Object[0])));
                JSLanguageServiceExecutorImpl.infoLog$default(this, "Error creating process handler", null, 2, null);
                return;
            }
            ProcessHandler processHandler = this.myProcessHandler;
            Intrinsics.checkNotNull((Object)processHandler);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(this){
                final /* synthetic */ JSLanguageServiceExecutorImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    if (outputType == ProcessOutputTypes.STDERR) {
                        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                            JSLanguageServiceQueue.Holder.LOGGER.debug("Stderr output: " + StringUtil.escapeLineBreak((String)event.getText()));
                        }
                        return;
                    }
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        if (JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
                            JSLanguageServiceQueue.Holder.LOGGER.trace("Stdout output: " + StringUtil.escapeLineBreak((String)event.getText()));
                        }
                        if (ApplicationManager.getApplication().isUnitTestMode()) {
                            ((JSLanguageServiceStatisticsCollector)ApplicationManager.getApplication().getService(JSLanguageServiceStatisticsCollector.class)).responseReceived(event.getText().length());
                        }
                    }
                }

                public void processTerminated(ProcessEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.this$0.processTerminated();
                    if (JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
                        JSLanguageServiceQueue.Holder.LOGGER.trace("Process [" + event.getProcessHandler() + "] was killed " + event.getText());
                    }
                }
            });
        }
        catch (Exception e) {
            this.setState(JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT);
            String string = JSLanguageServiceExecutorImpl.Companion.getPresentableExceptionMessage(e);
            Intrinsics.checkNotNull((Object)string);
            this.reportUserError(string);
            JSLanguageServiceQueue.Holder.LOGGER.info("Error while creating OS Handler: " + e.getMessage(), (Throwable)e);
        }
    }

    protected final void processTerminated() {
        if (this.getState() == JSLanguageServiceExecutor.State.STARTED || this.getState() == JSLanguageServiceExecutor.State.STARTING) {
            this.setState(JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT);
        }
    }

    private final void reportUserError(String message) {
        if (message != null) {
            this.myStartErrorMessage = message;
            this.myReporter.startingError(message);
        }
    }

    public void dispose() {
        if (this.myDisposed.compareAndSet(false, true)) {
            this.doDispose();
        } else {
            this.debugLog("Dispose. already disposed");
        }
    }

    protected void doDispose() {
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            String string = "Disposing service %s with hashCode %s";
            Object[] objectArray = new Object[]{this.myReporter.getPresentableServiceName(), this.hashCode()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            JSLanguageServiceQueue.Holder.LOGGER.debug(string2, new Throwable());
        }
        Span disposeSpan = JSLanguageServiceTracerUtilKt.serviceTraceSpanBuilder(this.getClass(), "dispose", this.myLifecycleSpan).startSpan();
        CompletionStage disposeFuture = ((CompletableFuture)this.myInitialized.thenRunAsync(() -> JSLanguageServiceExecutorImpl.doDispose$lambda$10(disposeSpan, this), PooledThreadExecutor.INSTANCE)).whenComplete((arg_0, arg_1) -> JSLanguageServiceExecutorImpl.doDispose$lambda$12((arg_0, arg_1) -> JSLanguageServiceExecutorImpl.doDispose$lambda$11(disposeSpan, arg_0, arg_1), arg_0, arg_1));
        if (ApplicationManager.getApplication().isUnitTestMode() && this.getState() != JSLanguageServiceExecutor.State.STARTING) {
            try {
                Void cfr_ignored_0 = (Void)((CompletableFuture)disposeFuture).get(11L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed to completely dispose service", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Failed to completely dispose service", e);
            }
            catch (TimeoutException e) {
                throw new RuntimeException("Failed to completely dispose service", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected final void shutdownPool(@NotNull ExecutorService pool) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        timeout = 1000;
        try {
            kotlinx.coroutines.CoroutineScopeKt.cancel((CoroutineScope)this.commandCoroutineScope, (CancellationException)new CancellationException("Service shutdown"));
        }
        catch (IllegalStateException var3_3) {
            // empty catch block
        }
        pool.shutdownNow();
        try {
            if (!pool.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                var4_6 = "%s: Pool did not terminate in %s milliseconds";
                var5_8 = new Object[]{this.myReporter.getPresentableServiceName(), timeout};
                v0 = String.format(var4_6, Arrays.copyOf(var5_8, var5_8.length));
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"format(...)");
                JSLanguageServiceQueue.Holder.LOGGER.warn(v0);
            } else {
                this.debugLog("Pool terminated");
            }
            $this$asSafely$iv = this.getProtocol();
            $i$f$asSafely = false;
            v1 = $this$asSafely$iv;
            ** if (v1 instanceof Disposable) goto lbl27
        }
        catch (InterruptedException ie) {
            try {
                pool.shutdownNow();
                Thread.currentThread().interrupt();
                $this$asSafely$iv = this.getProtocol();
                $i$f$asSafely = false;
                v3 = $this$asSafely$iv;
                ** if (v3 instanceof Disposable) goto lbl67
            }
            catch (Throwable var3_5) {
                $this$asSafely$iv = this.getProtocol();
                $i$f$asSafely = false;
                v4 = $this$asSafely$iv;
                if (!(v4 instanceof Disposable)) {
                    v4 = null;
                }
                v5 = (Disposable)v4;
                if (v5 != null) {
                    it = v5;
                    $i$a$-let-JSLanguageServiceExecutorImpl$shutdownPool$1 = false;
                    try {
                        it.dispose();
                    }
                    catch (Exception e) {
                        JSLanguageServiceQueue.Holder.LOGGER.error("Failed to dispose language service protocol", (Throwable)e);
                    }
                }
                throw var3_5;
            }
lbl-1000:
            // 1 sources

            {
                v3 = null;
            }
lbl67:
            // 2 sources

            v6 = (Disposable)v3;
            if (v6 != null) {
                it = v6;
                $i$a$-let-JSLanguageServiceExecutorImpl$shutdownPool$1 = false;
                try {
                    it.dispose();
                }
                catch (Exception e) {
                    JSLanguageServiceQueue.Holder.LOGGER.error("Failed to dispose language service protocol", (Throwable)e);
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            v1 = null;
        }
lbl27:
        // 2 sources

        v2 = (Disposable)v1;
        if (v2 != null) {
            it = v2;
            $i$a$-let-JSLanguageServiceExecutorImpl$shutdownPool$1 = false;
            try {
                it.dispose();
            }
            catch (Exception e) {
                JSLanguageServiceQueue.Holder.LOGGER.error("Failed to dispose language service protocol", (Throwable)e);
            }
        }
    }

    protected final void startAction(@NotNull JSLanguageServiceCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.startAction(command.getPresentableText(this.myProject));
    }

    protected final void startAction(@Nullable String text) {
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        this.myReporter.setProcess(text);
    }

    protected final void endAction() {
        if (this.getState() == JSLanguageServiceExecutor.State.STARTED) {
            this.myReporter.setProcess(null);
        }
    }

    private final void disposeIndicator(BackgroundableProcessIndicator indicator) {
        try {
            if (!indicator.isCanceled()) {
                indicator.cancel();
            }
            UIUtil.invokeLaterIfNeeded(() -> JSLanguageServiceExecutorImpl.disposeIndicator$lambda$14(this, indicator));
        }
        catch (Exception e) {
            JSLanguageServiceQueue.Holder.LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    protected final boolean isStarted() {
        return this.getState() == JSLanguageServiceExecutor.State.STARTED;
    }

    @Override
    public boolean isValid() {
        JSLanguageServiceExecutor.State state = this.getState();
        return state != JSLanguageServiceExecutor.State.DISPOSED && state != JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
    }

    @Override
    @Nullable
    public String getStartErrorMessage() {
        String string = this.getProtocol().getInitializeError();
        if (string == null) {
            string = this.myStartErrorMessage;
        }
        return string;
    }

    @NotNull
    public final <T> Future<T> submit(@Nullable String presentableName, @NotNull Callable<? extends T> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        try {
            Future<Object> future = this.myExecutorService.submit(() -> JSLanguageServiceExecutorImpl.submit$lambda$16(this, presentableName, task));
            Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
            return future;
        }
        catch (RejectedExecutionException exception) {
            JSLanguageServiceQueue.Holder.LOGGER.debug(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
    }

    protected final void infoLog(@NotNull String message, @Nullable Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        JSLanguageServiceQueue.Holder.LOGGER.info(this.myReporter.getPresentableServiceName() + ": " + message, exception);
    }

    public static /* synthetic */ void infoLog$default(JSLanguageServiceExecutorImpl jSLanguageServiceExecutorImpl, String string, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: infoLog");
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        jSLanguageServiceExecutorImpl.infoLog(string, throwable);
    }

    protected final void debugLog(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        JSLanguageServiceQueue.Holder.LOGGER.debug(this.myReporter.getPresentableServiceName() + ": " + message);
    }

    private static final void _init_$lambda$0(JSLanguageServiceExecutorImpl this$0) {
        this$0.startServiceWithProgress();
    }

    private static final Unit startServiceWithProgress$lambda$2$lambda$1(JSLanguageServiceExecutorImpl this$0) {
        this$0.startService();
        return Unit.INSTANCE;
    }

    private static final Object startServiceWithProgress$lambda$2(JSLanguageServiceExecutorImpl this$0) {
        JSLanguageServiceTracerUtilKt.withServiceTraceSpan(this$0, "startService", this$0.myLifecycleSpan, () -> JSLanguageServiceExecutorImpl.startServiceWithProgress$lambda$2$lambda$1(this$0));
        return null;
    }

    private static final Unit startService$lambda$3(JSLanguageServiceExecutorImpl this$0) {
        this$0.createProcessHandler();
        return Unit.INSTANCE;
    }

    private static final Unit startService$lambda$4(JSLanguageServiceExecutorImpl this$0) {
        ProcessHandler processHandler = this$0.myProcessHandler;
        Intrinsics.checkNotNull((Object)processHandler);
        this$0.connectProcessHandler(processHandler);
        return Unit.INSTANCE;
    }

    private static final boolean startService$lambda$5(JSLanguageServiceExecutorImpl this$0) {
        JSLanguageServiceConnector jSLanguageServiceConnector = this$0.getProtocol();
        ProcessHandler processHandler = this$0.myProcessHandler;
        Intrinsics.checkNotNull((Object)processHandler);
        return jSLanguageServiceConnector.awaitReadyNotification(processHandler);
    }

    private static final Unit doDispose$lambda$10$lambda$9$lambda$6(JSLanguageServiceExecutorImpl this$0) {
        this$0.shutdownPool(this$0.myExecutorService);
        return Unit.INSTANCE;
    }

    private static final Unit doDispose$lambda$10$lambda$9$lambda$7(JSLanguageServiceExecutorImpl this$0) {
        ProcessHandler processHandler = this$0.myProcessHandler;
        Intrinsics.checkNotNull((Object)processHandler);
        ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)processHandler, (long)10000L, null);
        return Unit.INSTANCE;
    }

    private static final Unit doDispose$lambda$10$lambda$9$lambda$8(JSLanguageServiceExecutorImpl this$0) {
        this$0.myProcessConnector.disconnectFromProcessHandler(false);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doDispose$lambda$10(Span $disposeSpan, JSLanguageServiceExecutorImpl this$0) {
        AutoCloseable autoCloseable = (AutoCloseable)$disposeSpan.makeCurrent();
        Throwable throwable = null;
        try {
            Scope it = (Scope)autoCloseable;
            boolean bl = false;
            this$0.setState(JSLanguageServiceExecutor.State.DISPOSED);
            try {
                JSLanguageServiceTracerUtilKt.withServiceTraceSpan$default(this$0, "shutdownPool", null, () -> JSLanguageServiceExecutorImpl.doDispose$lambda$10$lambda$9$lambda$6(this$0), 2, null);
            }
            finally {
                if (this$0.myProcessHandler != null) {
                    ProcessHandler processHandler = this$0.myProcessHandler;
                    Intrinsics.checkNotNull((Object)processHandler);
                    if (!processHandler.isProcessTerminated()) {
                        JSLanguageServiceTracerUtilKt.withServiceTraceSpan$default(this$0, "terminateProcessHandler", null, () -> JSLanguageServiceExecutorImpl.doDispose$lambda$10$lambda$9$lambda$7(this$0), 2, null);
                    }
                    this$0.myProcessHandler = null;
                    if (this$0.myProcessConnector != null) {
                        JSLanguageServiceTracerUtilKt.withServiceTraceSpan$default(this$0, "disconnectFromProcessHandler", null, () -> JSLanguageServiceExecutorImpl.doDispose$lambda$10$lambda$9$lambda$8(this$0), 2, null);
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final Unit doDispose$lambda$11(Span $disposeSpan, Void void_, Throwable throwable) {
        $disposeSpan.end();
        return Unit.INSTANCE;
    }

    private static final void doDispose$lambda$12(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void disposeIndicator$lambda$14(JSLanguageServiceExecutorImpl this$0, BackgroundableProcessIndicator $indicator) {
        if (this$0.myProject.isDisposed()) {
            return;
        }
        Disposer.dispose((Disposable)((Disposable)$indicator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object submit$lambda$16(JSLanguageServiceExecutorImpl this$0, String $presentableName, Callable $task) {
        Object v;
        if (!(this$0.getState() == JSLanguageServiceExecutor.State.STARTED)) {
            boolean $i$a$-check-JSLanguageServiceExecutorImpl$submit$1$22 = false;
            String $i$a$-check-JSLanguageServiceExecutorImpl$submit$1$22 = "Service is not started. State = " + this$0.getState().name();
            throw new IllegalStateException($i$a$-check-JSLanguageServiceExecutorImpl$submit$1$22.toString());
        }
        this$0.startAction($presentableName);
        try {
            v = $task.call();
        }
        catch (IOException e) {
            JSLanguageServiceQueue.Holder.LOGGER.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable throwable) {
            JSLanguageServiceQueue.Holder.LOGGER.error(throwable.getMessage(), throwable);
            throw throwable;
        }
        finally {
            this$0.endAction();
        }
        return v;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl$Companion;", "", "<init>", "()V", "getPresentableExceptionMessage", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "e", "", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final String getPresentableExceptionMessage(Throwable e) {
            return e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getMessage();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl$JSLanguageServiceExecutorCoroutineScope;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "intellij.javascript.impl"})
    private static final class JSLanguageServiceExecutorCoroutineScope {
        @NotNull
        private final CoroutineScope coroutineScope;

        public JSLanguageServiceExecutorCoroutineScope(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.coroutineScope = coroutineScope;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            return this.coroutineScope;
        }
    }
}

