/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.highlighting;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0004()*+B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J*\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0014\u001a\u00020\u0015J8\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\u0006\u0010\u0018\u001a\u00020\u0019JL\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\rH\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020!H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider;", "", "<init>", "()V", "JS_SERVICE_SOURCE", "", "Lorg/jetbrains/annotations/NonNls;", "updateWolfTheProblemSolver", "", "file", "Lcom/intellij/psi/PsiFile;", "name", "holder", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "getServiceName", "runIdeInspections", "Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider$JSProblemDescriptor;", "serviceErrors", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "pass", "Lcom/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass;", "convertToHighlightingInfos", "ideProblems", "languageService", "Lcom/intellij/lang/javascript/service/JSLanguageService;", "registerAnnotation", "result", "element", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "document", "Lcom/intellij/openapi/editor/Document;", "quickFixes", "Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider$JSIdeQuickFix;", "isAnnotationAtEndOfLine", "", "annotation", "Lcom/intellij/openapi/util/Segment;", "JSProblemDescriptor", "JSInspectionToolWrapper", "JSIdeQuickFix", "ClassToObjectsMap", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSLanguageServiceAnnotationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLanguageServiceAnnotationProvider.kt\ncom/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n1755#2,3:312\n1368#2:315\n1454#2,2:316\n1557#2:318\n1628#2,3:319\n1456#2,3:322\n774#2:325\n865#2,2:326\n1863#2,2:328\n1863#2,2:330\n*S KotlinDebug\n*F\n+ 1 JSLanguageServiceAnnotationProvider.kt\ncom/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider\n*L\n53#1:312,3\n121#1:315\n121#1:316,2\n122#1:318\n122#1:319,3\n121#1:322,3\n228#1:325\n228#1:326,2\n229#1:328,2\n232#1:330,2\n*E\n"})
public final class JSLanguageServiceAnnotationProvider {
    @NotNull
    public static final JSLanguageServiceAnnotationProvider INSTANCE = new JSLanguageServiceAnnotationProvider();
    @NotNull
    private static final String JS_SERVICE_SOURCE = "JS Language Service Source";

    private JSLanguageServiceAnnotationProvider() {
    }

    public final void updateWolfTheProblemSolver(@NotNull PsiFile file, @NotNull String name, @NotNull List<? extends HighlightInfo> holder) {
        boolean hasErrorResults;
        VirtualFile virtualFile;
        Project project;
        block6: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(holder, (String)"holder");
            Project project2 = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            project = project2;
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            virtualFile = file.getVirtualFile();
            if (document == null) {
                WolfTheProblemSolver.getInstance((Project)project).clearProblemsFromExternalSource(virtualFile, (Object)this.getServiceName(name));
                return;
            }
            Iterable $this$any$iv = holder;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    HighlightInfo it = (HighlightInfo)element$iv;
                    boolean bl = false;
                    if (!(it.getSeverity() == HighlightSeverity.ERROR)) continue;
                    v1 = true;
                    break block6;
                }
                v1 = hasErrorResults = false;
            }
        }
        if (hasErrorResults) {
            WolfTheProblemSolver.getInstance((Project)project).reportProblemsFromExternalSource(virtualFile, (Object)this.getServiceName(name));
        } else {
            WolfTheProblemSolver.getInstance((Project)project).clearProblemsFromExternalSource(virtualFile, (Object)this.getServiceName(name));
        }
    }

    private final String getServiceName(String name) {
        return "JS Language Service Source " + name;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JSProblemDescriptor> runIdeInspections(@NotNull PsiFile file, @NotNull List<? extends JSAnnotationError> serviceErrors2, @NotNull ProgressableTextEditorHighlightingPass pass) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(serviceErrors2, (String)"serviceErrors");
        Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file);
        if (document == null) {
            return CollectionsKt.emptyList();
        }
        ArrayList optimizedInspections = new ArrayList();
        TypeScriptAnnotatorCheckerProvider typeScriptAnnotatorCheckerProvider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)file);
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptAnnotatorCheckerProvider, (String)"getCheckerProvider(...)");
        TypeScriptAnnotatorCheckerProvider checkerProvider = typeScriptAnnotatorCheckerProvider;
        InspectionEngine.withSession((PsiFile)file, (TextRange)file.getTextRange(), (TextRange)file.getTextRange(), null, (boolean)true, arg_0 -> JSLanguageServiceAnnotationProvider.runIdeInspections$lambda$4(arg_0 -> JSLanguageServiceAnnotationProvider.runIdeInspections$lambda$3(project2, file, optimizedInspections, pass, serviceErrors2, document, checkerProvider, arg_0), arg_0));
        Iterable $this$flatMap$iv = optimizedInspections;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            JSInspectionToolWrapper tool = (JSInspectionToolWrapper)element$iv$iv;
            boolean bl = false;
            List list = tool.getProblemsHolder().getResults();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResults(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProblemDescriptor problemDescriptor = (ProblemDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(new JSProblemDescriptor((ProblemDescriptor)it, tool.getToolShortName()));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<HighlightInfo> convertToHighlightingInfos(@NotNull PsiFile file, @NotNull List<? extends JSAnnotationError> serviceErrors2, @NotNull List<JSProblemDescriptor> ideProblems2, @NotNull JSLanguageService languageService) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(serviceErrors2, (String)"serviceErrors");
        Intrinsics.checkNotNullParameter(ideProblems2, (String)"ideProblems");
        Intrinsics.checkNotNullParameter((Object)languageService, (String)"languageService");
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || !virtualFile.isInLocalFileSystem()) {
            return CollectionsKt.emptyList();
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file);
        if (document == null) {
            return CollectionsKt.emptyList();
        }
        String string = virtualFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String simplePath = string;
        String canonicalPath = virtualFile.getCanonicalPath();
        Path path3 = path2 = virtualFile.getFileSystem().getNioPath(virtualFile);
        String ioFilePath = path3 != null ? LocalFilePath.Companion.asLocalFilePath(path3) : null;
        List quickFixes = new ArrayList();
        for (JSProblemDescriptor jsProblemDescriptor : ideProblems2) {
            QuickFix[] problemFixes;
            ProblemDescriptor problemDescriptor = jsProblemDescriptor.getProblemDescriptor();
            TextRange textRange = problemDescriptor.getTextRangeInElement();
            PsiElement element = problemDescriptor.getPsiElement();
            HighlightDisplayKey highlightDisplayKey = HighlightDisplayKey.find((String)jsProblemDescriptor.getToolShortName());
            if (element == null || highlightDisplayKey == null || (problemFixes = problemDescriptor.getFixes()) == null) continue;
            TextRange textRange2 = textRange;
            if (textRange2 == null || (textRange2 = textRange2.shiftRight(element.getTextRange().getStartOffset())) == null) {
                textRange2 = element.getTextRange();
            }
            TextRange range = textRange2;
            int n = problemFixes.length;
            for (int i = 0; i < n; ++i) {
                IntentionAction intentionAction = QuickFixWrapper.wrap((ProblemDescriptor)problemDescriptor, (int)i);
                Intrinsics.checkNotNullExpressionValue((Object)intentionAction, (String)"wrap(...)");
                String string2 = HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)highlightDisplayKey);
                Intrinsics.checkNotNull((Object)range);
                quickFixes.add(new JSIdeQuickFix(intentionAction, string2, range, highlightDisplayKey));
            }
        }
        Comparator<Object> comparator = Comparator.comparingInt(arg_0 -> JSLanguageServiceAnnotationProvider.convertToHighlightingInfos$lambda$8(JSLanguageServiceAnnotationProvider::convertToHighlightingInfos$lambda$7, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparingInt(...)");
        CollectionsKt.sortWith((List)quickFixes, comparator);
        ArrayList<HighlightInfo> holder = new ArrayList<HighlightInfo>(serviceErrors2.size());
        for (JSAnnotationError jSAnnotationError : serviceErrors2) {
            HighlightInfo annotation;
            JSLanguageServiceUtil.PsiElementInfo info;
            String annotationFilePath = jSAnnotationError.getAbsoluteFilePath();
            if (StringUtil.isEmpty((String)annotationFilePath) || !FileUtil.pathsEqual((String)annotationFilePath, (String)simplePath) && !FileUtil.pathsEqual((String)annotationFilePath, (String)canonicalPath) && !FileUtil.pathsEqual((String)annotationFilePath, (String)ioFilePath) || JSLanguageServiceUtil.getElementInfo(file, document, jSAnnotationError) == null) continue;
            PsiElement element = info.getElement();
            TextRange range = info.getRange();
            if (element == null && range == null || (annotation = this.registerAnnotation(file, jSAnnotationError, element, range, languageService, document, quickFixes)) == null) continue;
            holder.add(annotation);
        }
        return holder;
    }

    /*
     * WARNING - void declaration
     */
    private final HighlightInfo registerAnnotation(PsiFile file, JSAnnotationError result2, PsiElement element, TextRange range, JSLanguageService languageService, Document document, List<JSIdeQuickFix> quickFixes) {
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        ProblemHighlightType problemHighlightType;
        TextRange actualRange;
        boolean bl;
        boolean bl2 = bl = element != null || range != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String string = result2.getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
        String message = string;
        TextRange textRange = range;
        if (textRange == null) {
            PsiElement psiElement = element;
            Intrinsics.checkNotNull((Object)psiElement);
            textRange = actualRange = psiElement.getTextRange();
        }
        if ((problemHighlightType = result2.getHighlightType()) == null) {
            if (result2.getSeverity() == HighlightSeverity.ERROR) {
                problemHighlightType = ProblemHighlightType.GENERIC_ERROR;
            } else {
                ProblemHighlightType problemHighlightType2 = HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)result2.getSeverity());
                problemHighlightType = problemHighlightType2;
                Intrinsics.checkNotNullExpressionValue((Object)problemHighlightType2, (String)"convertSeverityToProblemHighlight(...)");
            }
        }
        ProblemHighlightType type = problemHighlightType;
        HighlightInfoType highlightInfoType = ProblemDescriptorUtil.getHighlightInfoType((ProblemHighlightType)type, (HighlightSeverity)result2.getSeverity(), (SeverityRegistrar)SeverityRegistrar.getSeverityRegistrar((Project)file.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType, (String)"getHighlightInfoType(...)");
        HighlightInfoType highlightInfoType2 = highlightInfoType;
        String string2 = result2.getTooltipText();
        if (string2 == null) {
            string2 = message;
        }
        String tooltip = string2;
        HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType2).range(actualRange).description(message);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"description(...)");
        HighlightInfo.Builder builder3 = builder2;
        builder3.escapedToolTip(tooltip);
        Intrinsics.checkNotNull((Object)actualRange);
        if (this.isAnnotationAtEndOfLine((Segment)actualRange, document)) {
            builder3.endOfLine();
        }
        Iterable $this$filter$iv = quickFixes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            JSIdeQuickFix q = (JSIdeQuickFix)element$iv$iv;
            boolean bl3 = false;
            if (!actualRange.intersects(q.range())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JSIdeQuickFix fix = (JSIdeQuickFix)element$iv;
            boolean bl4 = false;
            builder3.registerFix(fix.quickFix(), null, fix.displayName(), fix.range(), fix.key());
        }
        Collection<IntentionAction> fixes = languageService.getServiceFixes(file, element, result2);
        Iterable $this$forEach$iv2 = fixes;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            IntentionAction it = (IntentionAction)element$iv;
            boolean bl5 = false;
            builder3.registerFix(it, null, null, null, null);
        }
        return builder3.create();
    }

    private final boolean isAnnotationAtEndOfLine(Segment annotation, Document document) {
        int startOffset = annotation.getStartOffset();
        int endOffset = annotation.getEndOffset();
        if (startOffset >= document.getTextLength()) {
            return true;
        }
        return document.getImmutableCharSequence().charAt(startOffset) == '\n' && (startOffset == endOffset || endOffset == startOffset + 1);
    }

    private static final boolean runIdeInspections$lambda$3$lambda$1(HashSet $processedElements, TypeScriptAnnotatorCheckerProvider $checkerProvider, ClassToObjectsMap $optimizedInspectionsElementMap, PsiElement e, PsiElement psiElement) {
        if (!$processedElements.add(e) || !$checkerProvider.skipErrors(e)) {
            return false;
        }
        for (JSInspectionToolWrapper inspection : $optimizedInspectionsElementMap.valuesFor(e.getClass())) {
            Intrinsics.checkNotNull((Object)e);
            inspection.visit(e);
        }
        return !(e instanceof JSExecutionScope);
    }

    private static final boolean runIdeInspections$lambda$3$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    private static final Unit runIdeInspections$lambda$3(Project $project, PsiFile $file, ArrayList $optimizedInspections, ProgressableTextEditorHighlightingPass $pass, List $serviceErrors, Document $document, TypeScriptAnnotatorCheckerProvider $checkerProvider, LocalInspectionToolSession session) {
        ClassToObjectsMap<JSInspectionToolWrapper> optimizedInspectionsElementMap = new ClassToObjectsMap<JSInspectionToolWrapper>();
        InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)$project).getCurrentProfile();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
        InspectionProfileImpl inspectionProfile = inspectionProfileImpl;
        for (ToolsImpl it : InspectionProjectProfileManager.getInstance((Project)$project).getCurrentProfile().getTools()) {
            JSInspection jsInspection;
            Set<Class<? extends PsiElement>> elementsToOptimizeForTSServiceHighlighting;
            HighlightDisplayKey highlightDisplayKey;
            if (HighlightDisplayKey.find((String)it.getTool().getShortName()) == null || !inspectionProfile.isToolEnabled(highlightDisplayKey, (PsiElement)$file)) continue;
            InspectionProfileEntry inspectionProfileEntry = it.getTool().getTool();
            JSInspection jSInspection = inspectionProfileEntry instanceof JSInspection ? (JSInspection)inspectionProfileEntry : null;
            if (jSInspection == null || (elementsToOptimizeForTSServiceHighlighting = (jsInspection = jSInspection).getElementsToOptimizeForTSServiceHighlighting()).isEmpty()) continue;
            Intrinsics.checkNotNull((Object)session);
            InspectionToolWrapper inspectionToolWrapper = it.getTool();
            Intrinsics.checkNotNullExpressionValue((Object)inspectionToolWrapper, (String)"getTool(...)");
            JSInspectionToolWrapper jsInspectionToolWrapper = new JSInspectionToolWrapper(session, inspectionToolWrapper);
            $optimizedInspections.add(jsInspectionToolWrapper);
            for (Class<? extends PsiElement> elementClass : elementsToOptimizeForTSServiceHighlighting) {
                Intrinsics.checkNotNull(elementClass);
                optimizedInspectionsElementMap.putObject(elementClass, jsInspectionToolWrapper);
            }
        }
        $pass.setProgressLimit((long)$serviceErrors.size() * (long)2);
        $pass.advanceProgress((long)$serviceErrors.size());
        HashSet processedElements = new HashSet();
        for (JSAnnotationError error : $serviceErrors) {
            JSLanguageServiceUtil.PsiElementInfo info = JSLanguageServiceUtil.getElementInfo($file, $document, error);
            JSLanguageServiceUtil.PsiElementInfo psiElementInfo = info;
            if (psiElementInfo == null || (psiElementInfo = psiElementInfo.getElement()) == null) continue;
            JSLanguageServiceUtil.PsiElementInfo element = psiElementInfo;
            PsiTreeUtil.treeWalkUp((PsiElement)element, (PsiElement)((PsiElement)$file), (arg_0, arg_1) -> JSLanguageServiceAnnotationProvider.runIdeInspections$lambda$3$lambda$2((arg_0, arg_1) -> JSLanguageServiceAnnotationProvider.runIdeInspections$lambda$3$lambda$1(processedElements, $checkerProvider, optimizedInspectionsElementMap, arg_0, arg_1), arg_0, arg_1));
            $pass.advanceProgress(1L);
        }
        return Unit.INSTANCE;
    }

    private static final void runIdeInspections$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final int convertToHighlightingInfos$lambda$7(JSIdeQuickFix q) {
        return q.range().getStartOffset();
    }

    private static final int convertToHighlightingInfos$lambda$8(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0007J\u001f\u0010\u000e\u001a\u00020\u000f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011R7\u0010\u0005\u001a+\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \b*\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00018\u00008\u00000\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider$ClassToObjectsMap;", "V", "", "<init>", "()V", "sourceMappings", "Lcom/intellij/util/containers/MultiMap;", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "mappings", "valuesFor", "", "klass", "putObject", "", "obj", "(Ljava/lang/Class;Ljava/lang/Object;)V", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nJSLanguageServiceAnnotationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLanguageServiceAnnotationProvider.kt\ncom/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider$ClassToObjectsMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n1863#2,2:312\n*S KotlinDebug\n*F\n+ 1 JSLanguageServiceAnnotationProvider.kt\ncom/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider$ClassToObjectsMap\n*L\n296#1:312,2\n*E\n"})
    private static final class ClassToObjectsMap<V> {
        @NotNull
        private final MultiMap<Class<?>, V> sourceMappings;
        @NotNull
        private final MultiMap<Class<?>, V> mappings;

        public ClassToObjectsMap() {
            MultiMap multiMap = MultiMap.createSet();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createSet(...)");
            this.sourceMappings = multiMap;
            this.mappings = new MultiMap();
        }

        @NotNull
        public final Collection<V> valuesFor(@NotNull Class<?> klass) {
            Intrinsics.checkNotNullParameter(klass, (String)"klass");
            if (!this.mappings.containsKey(klass)) {
                Set set = this.sourceMappings.entrySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)entry);
                    Class cls = (Class)entry.getKey();
                    Collection objs = (Collection)entry.getValue();
                    if (!cls.isAssignableFrom(klass)) continue;
                    this.mappings.putValues(klass, objs);
                }
            }
            Collection collection = this.mappings.get(klass);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            return collection;
        }

        public final void putObject(@NotNull Class<?> klass, V obj) {
            Intrinsics.checkNotNullParameter(klass, (String)"klass");
            this.sourceMappings.putValue(klass, obj);
            this.mappings.clear();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B.\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\r\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0012\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0014\u001a\u00020\nH\u00c6\u0003J8\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000f\b\u0002\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\rR\u0018\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider$JSIdeQuickFix;", "Ljava/lang/Record;", "quickFix", "Lcom/intellij/codeInsight/intention/IntentionAction;", "displayName", "", "Lorg/jetbrains/annotations/Nls;", "range", "Lcom/intellij/openapi/util/TextRange;", "key", "Lcom/intellij/codeInsight/daemon/HighlightDisplayKey;", "<init>", "(Lcom/intellij/codeInsight/intention/IntentionAction;Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/codeInsight/daemon/HighlightDisplayKey;)V", "()Lcom/intellij/codeInsight/intention/IntentionAction;", "()Ljava/lang/String;", "()Lcom/intellij/openapi/util/TextRange;", "()Lcom/intellij/codeInsight/daemon/HighlightDisplayKey;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.javascript.impl"})
    private static final class JSIdeQuickFix
    extends Record {
        @NotNull
        private final IntentionAction quickFix;
        @Nullable
        private final String displayName;
        @NotNull
        private final TextRange range;
        @NotNull
        private final HighlightDisplayKey key;

        public JSIdeQuickFix(@NotNull IntentionAction quickFix, @Nullable String displayName, @NotNull TextRange range, @NotNull HighlightDisplayKey key) {
            Intrinsics.checkNotNullParameter((Object)quickFix, (String)"quickFix");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.quickFix = quickFix;
            this.displayName = displayName;
            this.range = range;
            this.key = key;
        }

        @NotNull
        public final IntentionAction quickFix() {
            return this.quickFix;
        }

        @Nullable
        public final String displayName() {
            return this.displayName;
        }

        @NotNull
        public final TextRange range() {
            return this.range;
        }

        @NotNull
        public final HighlightDisplayKey key() {
            return this.key;
        }

        @NotNull
        public final IntentionAction component1() {
            return this.quickFix;
        }

        @Nullable
        public final String component2() {
            return this.displayName;
        }

        @NotNull
        public final TextRange component3() {
            return this.range;
        }

        @NotNull
        public final HighlightDisplayKey component4() {
            return this.key;
        }

        @NotNull
        public final JSIdeQuickFix copy(@NotNull IntentionAction quickFix, @Nullable String displayName, @NotNull TextRange range, @NotNull HighlightDisplayKey key) {
            Intrinsics.checkNotNullParameter((Object)quickFix, (String)"quickFix");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new JSIdeQuickFix(quickFix, displayName, range, key);
        }

        public static /* synthetic */ JSIdeQuickFix copy$default(JSIdeQuickFix jSIdeQuickFix, IntentionAction intentionAction, String string, TextRange textRange, HighlightDisplayKey highlightDisplayKey, int n, Object object) {
            if ((n & 1) != 0) {
                intentionAction = jSIdeQuickFix.quickFix;
            }
            if ((n & 2) != 0) {
                string = jSIdeQuickFix.displayName;
            }
            if ((n & 4) != 0) {
                textRange = jSIdeQuickFix.range;
            }
            if ((n & 8) != 0) {
                highlightDisplayKey = jSIdeQuickFix.key;
            }
            return jSIdeQuickFix.copy(intentionAction, string, textRange, highlightDisplayKey);
        }

        @Override
        @NotNull
        public String toString() {
            return "JSIdeQuickFix(quickFix=" + this.quickFix + ", displayName=" + this.displayName + ", range=" + this.range + ", key=" + this.key + ")";
        }

        @Override
        public int hashCode() {
            int result2 = this.quickFix.hashCode();
            result2 = result2 * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
            result2 = result2 * 31 + this.range.hashCode();
            result2 = result2 * 31 + this.key.hashCode();
            return result2;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JSIdeQuickFix)) {
                return false;
            }
            JSIdeQuickFix jSIdeQuickFix = (JSIdeQuickFix)other;
            if (!Intrinsics.areEqual((Object)this.quickFix, (Object)jSIdeQuickFix.quickFix)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.displayName, (Object)jSIdeQuickFix.displayName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.range, (Object)jSIdeQuickFix.range)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.key, (Object)jSIdeQuickFix.key);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider$JSInspectionToolWrapper;", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "inspectionToolWrapper", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "<init>", "(Lcom/intellij/codeInspection/LocalInspectionToolSession;Lcom/intellij/codeInspection/ex/InspectionToolWrapper;)V", "toolShortName", "", "getToolShortName", "()Ljava/lang/String;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "getProblemsHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "myVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "visit", "", "e", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.javascript.impl"})
    public static final class JSInspectionToolWrapper {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String toolShortName;
        @NotNull
        private final ProblemsHolder problemsHolder;
        @NotNull
        private final PsiElementVisitor myVisitor;

        public JSInspectionToolWrapper(@NotNull LocalInspectionToolSession session, @NotNull InspectionToolWrapper<?, ?> inspectionToolWrapper) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter(inspectionToolWrapper, (String)"inspectionToolWrapper");
            String string = inspectionToolWrapper.getShortName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortName(...)");
            this.toolShortName = string;
            PsiFile psiFile = session.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
            PsiFile file = psiFile;
            this.problemsHolder = new ProblemsHolder(InspectionManager.getInstance((Project)file.getProject()), file, true);
            InspectionProfileEntry inspectionProfileEntry = inspectionToolWrapper.getTool();
            Intrinsics.checkNotNull((Object)inspectionProfileEntry, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.inspections.JSInspection");
            this.myVisitor = ((JSInspection)inspectionProfileEntry).buildVisitorForTSServiceHighlighting(this.problemsHolder, true, session);
        }

        @NotNull
        public final String getToolShortName() {
            return this.toolShortName;
        }

        @NotNull
        public final ProblemsHolder getProblemsHolder() {
            return this.problemsHolder;
        }

        public final void visit(@NotNull PsiElement e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.accept(this.myVisitor);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider$JSInspectionToolWrapper$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider$JSInspectionToolWrapper;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "inspectionToolWrapper", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "intellij.javascript.impl"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final JSInspectionToolWrapper create(@NotNull LocalInspectionToolSession session, @NotNull InspectionToolWrapper<?, ?> inspectionToolWrapper) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Intrinsics.checkNotNullParameter(inspectionToolWrapper, (String)"inspectionToolWrapper");
                Language language = Language.findLanguageByID((String)inspectionToolWrapper.getLanguage());
                PsiFile psiFile = session.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
                PsiFile file = psiFile;
                if (language == null || !file.getLanguage().isKindOf(language)) {
                    return null;
                }
                return new JSInspectionToolWrapper(session, inspectionToolWrapper);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider$JSProblemDescriptor;", "", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "toolShortName", "", "<init>", "(Lcom/intellij/codeInspection/ProblemDescriptor;Ljava/lang/String;)V", "getProblemDescriptor", "()Lcom/intellij/codeInspection/ProblemDescriptor;", "getToolShortName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.javascript.impl"})
    public static final class JSProblemDescriptor {
        @NotNull
        private final ProblemDescriptor problemDescriptor;
        @NotNull
        private final String toolShortName;

        public JSProblemDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull String toolShortName) {
            Intrinsics.checkNotNullParameter((Object)problemDescriptor, (String)"problemDescriptor");
            Intrinsics.checkNotNullParameter((Object)toolShortName, (String)"toolShortName");
            this.problemDescriptor = problemDescriptor;
            this.toolShortName = toolShortName;
        }

        @NotNull
        public final ProblemDescriptor getProblemDescriptor() {
            return this.problemDescriptor;
        }

        @NotNull
        public final String getToolShortName() {
            return this.toolShortName;
        }

        @NotNull
        public final ProblemDescriptor component1() {
            return this.problemDescriptor;
        }

        @NotNull
        public final String component2() {
            return this.toolShortName;
        }

        @NotNull
        public final JSProblemDescriptor copy(@NotNull ProblemDescriptor problemDescriptor, @NotNull String toolShortName) {
            Intrinsics.checkNotNullParameter((Object)problemDescriptor, (String)"problemDescriptor");
            Intrinsics.checkNotNullParameter((Object)toolShortName, (String)"toolShortName");
            return new JSProblemDescriptor(problemDescriptor, toolShortName);
        }

        public static /* synthetic */ JSProblemDescriptor copy$default(JSProblemDescriptor jSProblemDescriptor, ProblemDescriptor problemDescriptor, String string, int n, Object object) {
            if ((n & 1) != 0) {
                problemDescriptor = jSProblemDescriptor.problemDescriptor;
            }
            if ((n & 2) != 0) {
                string = jSProblemDescriptor.toolShortName;
            }
            return jSProblemDescriptor.copy(problemDescriptor, string);
        }

        @NotNull
        public String toString() {
            return "JSProblemDescriptor(problemDescriptor=" + this.problemDescriptor + ", toolShortName=" + this.toolShortName + ")";
        }

        public int hashCode() {
            int result2 = this.problemDescriptor.hashCode();
            result2 = result2 * 31 + this.toolShortName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JSProblemDescriptor)) {
                return false;
            }
            JSProblemDescriptor jSProblemDescriptor = (JSProblemDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.problemDescriptor, (Object)jSProblemDescriptor.problemDescriptor)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.toolShortName, (Object)jSProblemDescriptor.toolShortName);
        }
    }
}

