/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.surroundWith.JSNotWithParenthesesSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithCastSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithIfElseSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithIfSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithObjectLiteralSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithParenthesesSurrounder;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSExpressionSurroundDescriptor
implements SurroundDescriptor {
    private static final Surrounder[] SURROUNDERS = new Surrounder[]{new JSWithParenthesesSurrounder(), new JSNotWithParenthesesSurrounder(), new JSWithObjectLiteralSurrounder()};
    private List<Surrounder> myAdditionalSurrounders;

    public PsiElement @NotNull [] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        JSExpression expr = JSExpressionSurroundDescriptor.findExpressionInRange(file, startOffset, endOffset);
        if (expr == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                JSExpressionSurroundDescriptor.$$$reportNull$$$0(0);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        this.myAdditionalSurrounders = new ArrayList<Surrounder>();
        if (file.getLanguage().is((Language)FlexSupportLoader.ECMA_SCRIPT_L4)) {
            this.myAdditionalSurrounders.add(new JSWithCastSurrounder());
        }
        if (expr.getParent() instanceof JSExpressionStatement && JSResolveUtil.getExpressionJSType(expr) instanceof JSBooleanType) {
            this.myAdditionalSurrounders.addAll(Arrays.asList(new JSWithIfSurrounder(true), new JSWithIfElseSurrounder(true)));
        }
        PsiElement[] psiElementArray = new PsiElement[]{expr};
        if (psiElementArray == null) {
            JSExpressionSurroundDescriptor.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    public Surrounder @NotNull [] getSurrounders() {
        if (this.myAdditionalSurrounders == null || this.myAdditionalSurrounders.size() == 0) {
            if (SURROUNDERS == null) {
                JSExpressionSurroundDescriptor.$$$reportNull$$$0(2);
            }
            return SURROUNDERS;
        }
        Surrounder[] surrounderArray = (Surrounder[])ArrayUtil.mergeArrayAndCollection((Object[])SURROUNDERS, this.myAdditionalSurrounders, (ArrayFactory)Surrounder.myArrayFactory);
        if (surrounderArray == null) {
            JSExpressionSurroundDescriptor.$$$reportNull$$$0(3);
        }
        return surrounderArray;
    }

    public boolean isExclusive() {
        return false;
    }

    private static JSExpression findExpressionInRange(PsiFile file, int startOffset, int endOffset) {
        JSExpression expression;
        PsiElement element1;
        PsiElement element2 = file.findElementAt(endOffset - 1);
        for (element1 = file.findElementAt(startOffset); element1 != null && (element1 instanceof PsiWhiteSpace || element1.getNode().getElementType() == JSTokenTypes.COMMA); element1 = element1.getNextSibling()) {
        }
        while (element2 != null && (element2 instanceof PsiWhiteSpace || element2.getNode().getElementType() == JSTokenTypes.COMMA)) {
            element2 = element2.getPrevSibling();
        }
        if (element1 != null) {
            startOffset = element1.getTextRange().getStartOffset();
        }
        if (element2 != null) {
            endOffset = element2.getTextRange().getEndOffset();
        }
        if ((expression = (JSExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffset, (int)endOffset, JSExpression.class)) == null || expression.getTextRange().getEndOffset() != endOffset) {
            return null;
        }
        if (expression instanceof JSReferenceExpression && expression.getParent() instanceof JSCallExpression) {
            return null;
        }
        return expression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/surroundWith/JSExpressionSurroundDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToSurround";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurrounders";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

