/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.imports;

import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.imports.FlowImportOptimizer;
import com.intellij.lang.javascript.imports.JSModuleImportOptimizerBase;
import com.intellij.lang.javascript.imports.JSOptimizeImportUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.imports.ES6UnusedImportsHelper;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImportOptimizer
extends JSModuleImportOptimizerBase {
    public static final TokenSet TYPESCRIPT_IMPORT = TokenSet.create((IElementType[])new IElementType[]{TypeScriptElementTypes.IMPORT_STATEMENT});

    public boolean supports(@NotNull PsiFile file) {
        if (file == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(0);
        }
        return file instanceof JSFile && DialectDetector.isTypeScript((PsiElement)file);
    }

    @Override
    @NotNull
    public Collection<JSModuleImportOptimizerBase.UnusedModuleInfo> getModulesInfo(@NotNull PsiElement scope2, @NotNull Set<JSReferenceExpression> ignoredRefs) {
        if (scope2 == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(1);
        }
        if (ignoredRefs == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(2);
        }
        SmartList result2 = new SmartList();
        FlowImportOptimizer es6Optimizer = new FlowImportOptimizer();
        Collection<PsiElement> modules = TypeScriptImportOptimizer.getAllModules(scope2);
        for (PsiElement module : modules) {
            JSModuleImportOptimizerBase.UnusedModuleInfo info;
            if (ES6PsiUtil.isExternalModule(module)) {
                result2.addAll(es6Optimizer.getModulesInfo(module, ignoredRefs));
            }
            if ((info = TypeScriptImportOptimizer.getInfo(scope2, module, ignoredRefs)) == null) continue;
            result2.add(info);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @NotNull
    private static Collection<PsiElement> getAllModules(@NotNull PsiElement scope2) {
        if (scope2 == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(4);
        }
        if (!(scope2 instanceof JSElement)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                TypeScriptImportOptimizer.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        result2.add(scope2);
        ArrayDeque<JSElement> toProcess = new ArrayDeque<JSElement>();
        toProcess.add((JSElement)scope2);
        while (!toProcess.isEmpty()) {
            PsiElement[] modules;
            JSElement current = (JSElement)toProcess.pop();
            for (PsiElement module : modules = TypeScriptImportOptimizer.getDirectChildModules(current)) {
                if (!(module instanceof TypeScriptModule)) continue;
                result2.add(module);
                toProcess.add((JSElement)module);
            }
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static PsiElement[] getDirectChildModules(@NotNull JSElement context2) {
        if (context2 == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(7);
        }
        return JSStubBasedPsiTreeUtil.getChildrenByType((PsiElement)context2, JSExtendedLanguagesTokenSetProvider.MODULES);
    }

    @Nullable
    private static JSModuleImportOptimizerBase.UnusedModuleInfo getInfo(@NotNull PsiElement scope2, @NotNull PsiElement module, @NotNull Set<JSReferenceExpression> ignoredRefs) {
        List<TypeScriptImportStatement> imports;
        if (scope2 == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(8);
        }
        if (module == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(9);
        }
        if (ignoredRefs == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(10);
        }
        if ((imports = TypeScriptImportOptimizer.getImports((JSElement)module)).isEmpty()) {
            return null;
        }
        Set<TypeScriptImportStatement> unusedImports = TypeScriptImportOptimizer.getUnusedImports(imports, ignoredRefs);
        final List<String> texts = TypeScriptImportOptimizer.getNewImportTexts(scope2, imports, unusedImports);
        return new JSModuleImportOptimizerBase.UnusedModuleInfo(){

            @Override
            @NotNull
            public List<String> getImportTexts() {
                List list = texts;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            @Nullable
            public PsiElement getAnchor() {
                return (PsiElement)ContainerUtil.getFirstItem((List)imports);
            }

            @Override
            @NotNull
            public List<PsiElement> getOldImports() {
                return new ArrayList<PsiElement>(imports);
            }

            @Override
            public List<PsiElement> getImportsForScope(@NotNull PsiElement scope2) {
                if (scope2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return scope2 instanceof JSElement ? new ArrayList<TypeScriptImportStatement>(TypeScriptImportOptimizer.getImports((JSElement)scope2)) : Collections.emptyList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/imports/TypeScriptImportOptimizer$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getImportTexts";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/imports/TypeScriptImportOptimizer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getImportsForScope";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    private static List<String> getNewImportTexts(@NotNull PsiElement scope2, @NotNull List<TypeScriptImportStatement> imports, @NotNull Set<TypeScriptImportStatement> unusedImports) {
        if (scope2 == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(11);
        }
        if (imports == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(12);
        }
        if (unusedImports == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(13);
        }
        ArrayList<String> importsResult = new ArrayList<String>();
        ArrayList<TypeScriptImportStatement> importsForProcessing = new ArrayList<TypeScriptImportStatement>(imports);
        TypeScriptImportOptimizer.sortImports(scope2, importsForProcessing);
        String semicolon = JSCodeStyleSettings.getSemicolon(scope2);
        Document document = PsiDocumentManager.getInstance((Project)scope2.getProject()).getDocument(scope2.getContainingFile());
        for (TypeScriptImportStatement statement : importsForProcessing) {
            if (unusedImports.contains(statement) && !ES6UnusedImportsHelper.isTypeScriptSuppressedUnused(statement)) continue;
            List<PsiElement> prevComments = JSOptimizeImportUtil.getPrevComments(document, (PsiElement)statement);
            SmartList current = new SmartList();
            current.addAll(JSOptimizeImportUtil.getPrevCommentsAsStrings(prevComments));
            current.add(TypeScriptImportOptimizer.getImportText(document, statement, semicolon));
            JSOptimizeImportUtil.fillImportsWithNewLines(importsResult, (PsiElement)statement, (List<String>)current);
        }
        return importsResult;
    }

    private static String getImportText(@Nullable Document document, @NotNull TypeScriptImportStatement statement, @NotNull String semicolon) {
        if (statement == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(14);
        }
        if (semicolon == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(15);
        }
        StringBuilder builder2 = new StringBuilder();
        builder2.append(StringUtil.trimEnd((String)StringUtil.trim((String)statement.getText()), (String)";"));
        builder2.append(semicolon);
        JSOptimizeImportUtil.addSameLineComments(document, (PsiElement)statement, builder2);
        return builder2.toString();
    }

    private static void sortImports(@NotNull PsiElement scope2, @NotNull List<TypeScriptImportStatement> imports) {
        if (scope2 == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(16);
        }
        if (imports == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(17);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(scope2);
        Comparator<String> moduleComparator = ES6ImportPsiUtil.getStringImportFromComparator();
        Comparator<String> memberComparator = ES6ImportPsiUtil.getStringImportMemberComparator(scope2);
        ContainerUtil.sort(imports, (o1, o2) -> {
            TypeScriptEntityName internalModuleReference1 = o1.getInternalModuleReference();
            TypeScriptEntityName internalModuleReference2 = o2.getInternalModuleReference();
            TypeScriptExternalModuleReference externalModuleReference1 = o1.getExternalModuleReference();
            TypeScriptExternalModuleReference externalModuleReference2 = o2.getExternalModuleReference();
            if (externalModuleReference1 != null && externalModuleReference2 != null) {
                if (!settings.IMPORT_SORT_MODULE_NAME) {
                    return 0;
                }
                String name1 = TypeScriptImportOptimizer.getExternalModuleReferenceText(externalModuleReference1);
                String name2 = TypeScriptImportOptimizer.getExternalModuleReferenceText(externalModuleReference2);
                return moduleComparator.compare(name1, name2);
            }
            if (internalModuleReference1 != null && internalModuleReference2 != null) {
                String text2;
                String text1 = StringUtil.trim((String)StringUtil.notNullize((String)internalModuleReference1.getText()));
                if (text1.equals(text2 = StringUtil.trim((String)StringUtil.notNullize((String)internalModuleReference2.getText())))) {
                    return memberComparator.compare(o1.getName(), o2.getName());
                }
                if (!settings.IMPORT_SORT_MODULE_NAME) {
                    return 0;
                }
                return moduleComparator.compare(text1, text2);
            }
            return internalModuleReference1 == null ? -1 : 1;
        });
    }

    @NotNull
    private static String getExternalModuleReferenceText(@Nullable TypeScriptExternalModuleReference externalModuleReference1) {
        String string = externalModuleReference1 == null ? "" : StringUtil.unquoteString((String)StringUtil.notNullize((String)externalModuleReference1.getReferenceText()));
        if (string == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static List<TypeScriptImportStatement> getImports(@NotNull JSElement module) {
        if (module == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(19);
        }
        return Arrays.stream(JSStubBasedPsiTreeUtil.getChildrenByType((PsiElement)module, TYPESCRIPT_IMPORT)).filter(el -> el instanceof TypeScriptImportStatement).map(el -> (TypeScriptImportStatement)el).collect(Collectors.toList());
    }

    private static Set<TypeScriptImportStatement> getUnusedImports(@NotNull Collection<TypeScriptImportStatement> imports, @NotNull Set<JSReferenceExpression> ignoredRefs) {
        if (imports == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(20);
        }
        if (ignoredRefs == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(21);
        }
        HashSet<TypeScriptImportStatement> result2 = new HashSet<TypeScriptImportStatement>();
        for (TypeScriptImportStatement currentImport : imports) {
            if (!ES6UnusedImportsHelper.isUnusedTypeScriptImport(currentImport, ignoredRefs)) continue;
            result2.add(currentImport);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredRefs";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/imports/TypeScriptImportOptimizer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unusedImports";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/imports/TypeScriptImportOptimizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModules";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalModuleReferenceText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModulesInfo";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllModules";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDirectChildModules";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNewImportTexts";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getImportText";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sortImports";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getImports";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedImports";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 18 -> new IllegalStateException(string);
        };
    }
}

