/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.lang.ecmascript6.psi.impl.JSimportUtilKt;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.modules.imports.JSImportAction;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.function.BooleanSupplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/typescript/psi/ES6ReferenceImporter;", "Lcom/intellij/codeInsight/daemon/ReferenceImporter;", "<init>", "()V", "computeAutoImportAtOffset", "Ljava/util/function/BooleanSupplier;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "allowCaretNearReference", "", "isAddUnambiguousImportsOnTheFlyEnabled", "isAcceptableContext", "element", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.impl"})
public final class ES6ReferenceImporter
implements ReferenceImporter {
    @Nullable
    public BooleanSupplier computeAutoImportAtOffset(@NotNull Editor editor, @NotNull PsiFile file, int offset, boolean allowCaretNearReference) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement psiElement = JSImportHandlingUtil.findUnresolvedImportableReference(editor, file, offset);
        if (psiElement == null) {
            return null;
        }
        PsiElement expression = psiElement;
        if (Intrinsics.areEqual((Object)true, (Object)expression.getUserData(JSImportAction.NO_HINT_KEY)) || !this.isAcceptableContext(file, expression)) {
            return null;
        }
        return JSimportUtilKt.getSupplier(expression, editor);
    }

    public boolean isAddUnambiguousImportsOnTheFlyEnabled(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        if (file instanceof JSFile) {
            return DialectDetector.isTypeScript((PsiElement)file) ? settings.hasTSUnambiguousImportsOnTheFlyEffective(((JSFile)file).getProject()) : settings.hasJSUnambiguousImportsOnTheFlyEffective(((JSFile)file).getProject()) && ES6PsiUtil.isExternalModule((PsiElement)file);
        }
        if (file instanceof HtmlCompatibleFile) {
            return settings.hasTSUnambiguousImportsOnTheFlyEffective(((HtmlCompatibleFile)file).getProject()) || settings.hasJSUnambiguousImportsOnTheFlyEffective(((HtmlCompatibleFile)file).getProject());
        }
        return false;
    }

    private final boolean isAcceptableContext(PsiFile file, PsiElement element) {
        if (file instanceof JSFile) {
            return true;
        }
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        return DialectDetector.isTypeScript(element) ? settings.hasTSUnambiguousImportsOnTheFlyEffective(file.getProject()) : settings.hasJSUnambiguousImportsOnTheFlyEffective(file.getProject()) && ES6PsiUtil.findExternalModule(element) != null;
    }
}

