/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.python;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.impl.MutableModuleModel;
import com.intellij.packageChecker.model.impl.ProjectDependenciesModelBase;
import com.intellij.packageChecker.python.PythonBuildFileProvider;
import com.intellij.packageChecker.toolwindow.DependencyContext;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.package.PackageType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H&J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\t2\u0006\u0010\u0015\u001a\u00020\u0016H&J\b\u0010\u0019\u001a\u00020\u001aH&J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u001e\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00022\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0014J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fH\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/intellij/packageChecker/python/PyPIProjectDependenciesModel;", "Lcom/intellij/packageChecker/model/impl/ProjectDependenciesModelBase;", "Lcom/intellij/packageChecker/model/impl/MutableModuleModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "importedPackages", "", "Lcom/jetbrains/python/packaging/common/PythonPackage;", "getImportedPackages", "()Ljava/util/List;", "setImportedPackages", "(Ljava/util/List;)V", "buildFileName", "", "getBuildFileName", "()Ljava/lang/String;", "findBuildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "getBuildFileSpecificRequirements", "Lcom/jetbrains/python/packaging/PyRequirement;", "findCorrespondingBuildFileProvider", "Lcom/intellij/packageChecker/api/BuildFileProvider;", "supports", "", "copyModule", "newDependencies", "", "Lcom/intellij/packageChecker/model/Dependency;", "getAllModules", "getAllImported", "intellij.packageChecker.python"})
@SourceDebugExtension(value={"SMAP\nPyPIProjectDependenciesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPIProjectDependenciesModel.kt\ncom/intellij/packageChecker/python/PyPIProjectDependenciesModel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n11483#2,9:117\n13409#2:126\n13410#2:132\n11492#2:133\n11483#2,9:134\n13409#2:143\n13410#2:145\n11492#2:146\n1557#3:127\n1628#3,3:128\n774#3:147\n865#3,2:148\n1368#3:150\n1454#3,5:151\n295#3,2:156\n1#4:131\n1#4:144\n*S KotlinDebug\n*F\n+ 1 PyPIProjectDependenciesModel.kt\ncom/intellij/packageChecker/python/PyPIProjectDependenciesModel\n*L\n58#1:117,9\n58#1:126\n58#1:132\n58#1:133\n98#1:134,9\n98#1:143\n98#1:145\n98#1:146\n69#1:127\n69#1:128,3\n101#1:147\n101#1:148,2\n106#1:150\n106#1:151,5\n78#1:156,2\n58#1:131\n98#1:144\n*E\n"})
public abstract class PyPIProjectDependenciesModel
extends ProjectDependenciesModelBase<MutableModuleModel>
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private List<? extends PythonPackage> importedPackages;

    public PyPIProjectDependenciesModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CompletableJob completableJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        String string = PyPIProjectDependenciesModel.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        super(completableJob.plus((CoroutineContext)new CoroutineName(string)));
        this.project = project;
        this.init();
        this.importedPackages = CollectionsKt.emptyList();
    }

    @NotNull
    public final List<PythonPackage> getImportedPackages() {
        return this.importedPackages;
    }

    public final void setImportedPackages(@NotNull List<? extends PythonPackage> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.importedPackages = list;
    }

    @NotNull
    public abstract String getBuildFileName();

    @Nullable
    public abstract VirtualFile findBuildFile(@NotNull Module var1);

    @NotNull
    public abstract List<PyRequirement> getBuildFileSpecificRequirements(@NotNull Module var1);

    @NotNull
    public abstract BuildFileProvider findCorrespondingBuildFileProvider();

    @Override
    public boolean supports(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ProjectDependenciesModelBase.Companion.isModelSupportedByProject(project, this.getBuildFileName());
    }

    @Override
    @NotNull
    protected MutableModuleModel copyModule(@NotNull MutableModuleModel module, @NotNull Iterable<Dependency> newDependencies) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(newDependencies, (String)"newDependencies");
        return module.withDependencies(newDependencies);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<MutableModuleModel> getAllModules() {
        List list;
        void $this$mapNotNullTo$iv$iv;
        Module[] $this$mapNotNull$iv = ModuleManager.Companion.getInstance(this.project).getModules();
        boolean $i$f$mapNotNull = false;
        Module[] moduleArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            MutableModuleModel mutableModuleModel;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void module = element$iv$iv;
            boolean bl2 = false;
            ProgressManager.checkCanceled();
            if (this.findBuildFile((Module)module) == null) {
                mutableModuleModel = null;
            } else {
                VirtualFile buildFile;
                void $this$mapTo$iv$iv;
                ProgressManager.checkCanceled();
                List<Pair<PyRequirement, PythonPackage>> importedDependencies = ((PythonBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(PythonBuildFileProvider.class, (AreaInstance)this.project)).getMatchingImported(this.getBuildFileSpecificRequirements((Module)module));
                List packageDeclarations = (List)ReadAction.compute(() -> PyPIProjectDependenciesModel.getAllModules$lambda$4$lambda$0(this, (Module)module));
                Iterable $this$map$iv = importedDependencies;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Package package_;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    PyRequirement req = (PyRequirement)pair.component1();
                    PythonPackage importedPackage = (PythonPackage)pair.component2();
                    ProgressManager.checkCanceled();
                    if (importedPackage != null) {
                        package_ = PythonBuildFileProvider.Companion.getPackageFromPyPackage(importedPackage);
                    } else {
                        List list2 = req.getVersionSpecs();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getVersionSpecs(...)");
                        Object object = (PyRequirementVersionSpec)CollectionsKt.firstOrNull((List)list2);
                        if (object == null || (object = object.getVersion()) == null) {
                            object = "0.0.0-ANY";
                        }
                        Object version = object;
                        String string = req.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        package_ = new Package(PackageType.pypi, null, string, (String)version, null, null, null, 112, null);
                    }
                    Package pkg = package_;
                    collection.add(new Dependency(pkg, SetsKt.emptySet(), new DependencyContext(this.project, (Module)module, buildFile, null, (arg_0, arg_1, arg_2) -> PyPIProjectDependenciesModel.getAllModules$lambda$4$lambda$3$lambda$2(packageDeclarations, pkg, arg_0, arg_1, arg_2), 8, null)));
                }
                List dependencies = (List)destination$iv$iv2;
                String string = module.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                mutableModuleModel = new MutableModuleModel(string, (Module)module, buildFile, CollectionsKt.toSet((Iterable)dependencies), this.project);
            }
            if (mutableModuleModel == null) continue;
            MutableModuleModel it$iv$iv = mutableModuleModel;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        this.importedPackages = this.getAllImported();
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PythonPackage> getAllImported() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        if (this.project.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        Module[] $this$mapNotNull$iv = PyStatisticToolsKt.getModules((Project)this.project);
        boolean $i$f$mapNotNull = false;
        Module[] moduleArray = $this$mapNotNull$iv;
        Iterable<Sdk> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Sdk it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void module = element$iv$iv;
            boolean bl2 = false;
            if (PythonSdkUtil.findPythonSdk((Module)module) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List applicableSdk = (List)destination$iv$iv;
        Iterable $this$filter$iv = applicableSdk;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Sdk sdk = (Sdk)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            VirtualFile virtualFile = sdk.getHomeDirectory();
            if (!((virtualFile != null ? virtualFile.exists() : false) && PyPackageUtil.packageManagementEnabled((Sdk)sdk, (boolean)false, (boolean)false))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List filteredSdks = (List)destination$iv$iv2;
        Iterable $this$flatMap$iv = filteredSdks;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            Sdk sdk = (Sdk)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            try {
                list = PythonPackageManager.Companion.forSdk(this.project, sdk).getInstalledPackages();
            }
            catch (ExecutionException e) {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private static final List getAllModules$lambda$4$lambda$0(PyPIProjectDependenciesModel this$0, Module $module) {
        return this$0.declaredDependencies($module);
    }

    private static final PsiElement getAllModules$lambda$4$lambda$3$lambda$2(List $packageDeclarations, Package $pkg, VirtualFile virtualFile, Module module, Package package_) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)module, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)package_, (String)"<unused var>");
            Intrinsics.checkNotNull((Object)$packageDeclarations);
            Iterable $this$firstOrNull$iv = $packageDeclarations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PackageDeclaration it = (PackageDeclaration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPkg(), (Object)$pkg)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        PackageDeclaration packageDeclaration = v0;
        return packageDeclaration != null ? packageDeclaration.getPsiElement() : null;
    }
}

