/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentation;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomStructureTreeElement
implements StructureViewTreeElement,
ItemPresentation {
    private final DomElement myElement;
    private final Function<DomElement, DomService.StructureViewMode> myDescriptor;
    private final DomElementNavigationProvider myNavigationProvider;

    public DomStructureTreeElement(@NotNull DomElement element, @NotNull Function<DomElement, DomService.StructureViewMode> descriptor, @Nullable DomElementNavigationProvider navigationProvider) {
        if (element == null) {
            DomStructureTreeElement.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            DomStructureTreeElement.$$$reportNull$$$0(1);
        }
        this.myElement = element;
        this.myDescriptor = descriptor;
        this.myNavigationProvider = navigationProvider;
    }

    public DomElement getElement() {
        return this.myElement;
    }

    @Nullable
    public Object getValue() {
        return this.myElement.isValid() ? this.myElement.getXmlElement() : null;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        DomStructureTreeElement domStructureTreeElement = this;
        if (domStructureTreeElement == null) {
            DomStructureTreeElement.$$$reportNull$$$0(2);
        }
        return domStructureTreeElement;
    }

    public TreeElement @NotNull [] getChildren() {
        if (!this.myElement.isValid()) {
            if (EMPTY_ARRAY == null) {
                DomStructureTreeElement.$$$reportNull$$$0(3);
            }
            return EMPTY_ARRAY;
        }
        final ArrayList result2 = new ArrayList();
        DomElementVisitor elementVisitor = new DomElementVisitor(){

            public void visitDomElement(DomElement element) {
                if (element instanceof GenericDomValue) {
                    return;
                }
                DomService.StructureViewMode viewMode = (DomService.StructureViewMode)DomStructureTreeElement.this.myDescriptor.fun((Object)element);
                switch (viewMode) {
                    case SHOW: {
                        result2.add(DomStructureTreeElement.this.createChildElement(element));
                        break;
                    }
                    case SHOW_CHILDREN: {
                        DomUtil.acceptAvailableChildren((DomElement)element, (DomElementVisitor)this);
                        break;
                    }
                }
            }
        };
        DomUtil.acceptAvailableChildren((DomElement)this.myElement, (DomElementVisitor)elementVisitor);
        TreeElement[] treeElementArray = result2.toArray(TreeElement.EMPTY_ARRAY);
        if (treeElementArray == null) {
            DomStructureTreeElement.$$$reportNull$$$0(4);
        }
        return treeElementArray;
    }

    protected StructureViewTreeElement createChildElement(DomElement element) {
        return new DomStructureTreeElement(element, this.myDescriptor, this.myNavigationProvider);
    }

    public void navigate(boolean requestFocus) {
        if (this.myNavigationProvider != null) {
            this.myNavigationProvider.navigate(this.myElement, requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.myNavigationProvider != null && this.myNavigationProvider.canNavigate(this.myElement);
    }

    public boolean canNavigateToSource() {
        return this.myNavigationProvider != null && this.myNavigationProvider.canNavigate(this.myElement);
    }

    public String getPresentableText() {
        if (!this.myElement.isValid()) {
            return "<unknown>";
        }
        try {
            ElementPresentation presentation = this.myElement.getPresentation();
            String name = presentation.getElementName();
            return name != null ? name : presentation.getTypeName();
        }
        catch (IndexNotReadyException e) {
            return "Name not available during indexing";
        }
    }

    @Nullable
    public Icon getIcon(boolean open) {
        if (!this.myElement.isValid()) {
            return null;
        }
        return this.myElement.getPresentation().getIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/structure/DomStructureTreeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/structure/DomStructureTreeElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

