/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.CheckValidXmlInScriptBodyInspectionBase;
import org.jetbrains.annotations.NotNull;

public class CheckValidXmlInScriptBodyInspection
extends CheckValidXmlInScriptBodyInspectionBase {
    protected InsertQuotedCharacterQuickFix createFix(PsiElement psiElement, int offsetInElement) {
        return new InsertQuotedCharacterQuickFix(psiElement, offsetInElement);
    }

    private static class InsertQuotedCharacterQuickFix
    extends LocalQuickFixOnPsiElement {
        private final int startInElement;

        InsertQuotedCharacterQuickFix(PsiElement psiElement, int startInElement) {
            super(psiElement);
            this.startInElement = startInElement;
        }

        @NotNull
        public String getText() {
            String string = XmlBundle.message((String)"xml.quickfix.unescaped.xml.character.text", (Object[])new Object[]{this.getXmlCharacter()});
            if (string == null) {
                InsertQuotedCharacterQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = XmlBundle.message((String)"xml.quickfix.unescaped.xml.character.family", (Object[])new Object[0]);
            if (string == null) {
                InsertQuotedCharacterQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project2 == null) {
                InsertQuotedCharacterQuickFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                InsertQuotedCharacterQuickFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                InsertQuotedCharacterQuickFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                InsertQuotedCharacterQuickFix.$$$reportNull$$$0(5);
            }
            PsiFile psiFile = startElement.getContainingFile();
            TextRange range = startElement.getTextRange();
            String xmlCharacter = this.getXmlCharacter();
            String replacement = xmlCharacter.equals("&") ? "&amp;" : "&lt;";
            replacement = startElement.getText().replace(xmlCharacter, replacement);
            psiFile.getViewProvider().getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)replacement);
        }

        private String getXmlCharacter() {
            return this.getStartElement().getText().substring(this.startInElement, this.startInElement + 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xml/util/CheckValidXmlInScriptBodyInspection$InsertQuotedCharacterQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

