/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.server;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.JupyterManagedServerConfiguration;
import com.intellij.jupyter.core.jupyter.connections.JupyterNotebookProcessHandler;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerExecution;
import com.intellij.jupyter.core.jupyter.server.ui.JupyterServerToolWindowKt;
import com.intellij.jupyter.py.server.actions.JupyterStartServerExecutionAction;
import com.intellij.jupyter.py.server.actions.JupyterStopServerExecutionAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u001d\u001a\u00020\tH\u0002J\b\u0010\u001e\u001a\u00020\u0012H\u0002J\b\u0010\u001f\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/jupyter/py/server/JupyterServerToolWindowService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "RUNNER_ID", "", "JUPYTER_SERVER_LOG_HELP_ID", "consoleView", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "content", "Lcom/intellij/ui/content/Content;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "showToolWindow", "", "execution", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerExecution;", "handler", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterNotebookProcessHandler;", "managedServerConfiguration", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterManagedServerConfiguration;", "initializeConsole", "createRunnerLayoutUi", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "console", "logContentTitle", "notifyServerStarting", "dispose", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterServerToolWindowService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterServerToolWindowService.kt\ncom/intellij/jupyter/py/server/JupyterServerToolWindowService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class JupyterServerToolWindowService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final String RUNNER_ID;
    @NotNull
    private final String JUPYTER_SERVER_LOG_HELP_ID;
    @Nullable
    private ConsoleViewImpl consoleView;
    @Nullable
    private Content content;
    @Nullable
    private ToolWindow toolWindow;

    public JupyterServerToolWindowService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.RUNNER_ID = "JupyterServerRunner";
        this.JUPYTER_SERVER_LOG_HELP_ID = "tool_window.jupyter_server_log";
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    public final void showToolWindow(@NotNull JupyterServerExecution execution, @NotNull JupyterNotebookProcessHandler handler, @NotNull JupyterManagedServerConfiguration managedServerConfiguration) {
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)managedServerConfiguration, (String)"managedServerConfiguration");
        Object[] objectArray = new Object[]{managedServerConfiguration.getDisplayName()};
        String serverContentTitle = JupyterBundle.message((String)"Jupyter.toolwindow.server.title", (Object[])objectArray);
        String logContentTitle = JupyterBundle.message((String)"Jupyter.toolwindow.server.log.title", (Object[])new Object[0]);
        this.toolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)this.project);
        ConsoleViewImpl console = this.initializeConsole(handler);
        RunnerLayoutUi ui = this.createRunnerLayoutUi(console, execution, managedServerConfiguration, logContentTitle);
        ToolWindow toolWindow = this.toolWindow;
        if (toolWindow == null || (toolWindow = toolWindow.getContentManager()) == null) {
            return;
        }
        ToolWindow manager = toolWindow;
        if (this.content != null) {
            Content content = this.content;
            if (content != null) {
                content.setComponent(ui.getComponent());
            }
        } else {
            String string;
            void it;
            Content content;
            ContentFactory contentFactory = ContentFactory.getInstance();
            Content content2 = content = contentFactory.createContent(ui.getComponent(), serverContentTitle, true);
            JupyterServerToolWindowService jupyterServerToolWindowService = this;
            boolean bl = false;
            it.setCloseable(false);
            manager.addContent((Content)it, 0);
            if (ModuleManager.Companion.getInstance(this.project).getModules().length > 1) {
                Object[] objectArray2 = new Object[]{managedServerConfiguration.getModule().getName()};
                string = JupyterBundle.message((String)"Jupyter.notebook.server.process.for.module.name", (Object[])objectArray2);
            } else {
                string = JupyterBundle.message((String)"Jupyter.notebook.server.process.name", (Object[])new Object[0]);
            }
            String displayName = string;
            Intrinsics.checkNotNull((Object)it);
            JupyterServerToolWindowKt.attachJupyterServerContentCloseListener((Content)it, (Project)this.project, (String)displayName, (KillableProcessHandler)((KillableProcessHandler)handler));
            jupyterServerToolWindowService.content = content;
        }
        this.notifyServerStarting();
    }

    private final ConsoleViewImpl initializeConsole(JupyterNotebookProcessHandler handler) {
        ConsoleViewImpl console;
        ConsoleViewImpl consoleViewImpl;
        ConsoleViewImpl consoleViewImpl2 = this.consoleView;
        if (consoleViewImpl2 == null) {
            ConsoleViewImpl consoleViewImpl3;
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
            ConsoleViewImpl it = consoleViewImpl3 = new ConsoleViewImpl(this.project, globalSearchScope, true, true);
            boolean bl = false;
            it.setHelpId(this.JUPYTER_SERVER_LOG_HELP_ID);
            this.consoleView = it;
            consoleViewImpl2 = consoleViewImpl3;
        }
        ConsoleViewImpl it = consoleViewImpl = (console = consoleViewImpl2);
        boolean bl = false;
        it.clear();
        it.attachToProcess((ProcessHandler)handler);
        return consoleViewImpl;
    }

    private final RunnerLayoutUi createRunnerLayoutUi(ConsoleViewImpl console, JupyterServerExecution execution, JupyterManagedServerConfiguration managedServerConfiguration, @NlsSafe String logContentTitle) {
        RunnerLayoutUi runnerLayoutUi;
        RunnerLayoutUi runnerLayoutUi2 = RunnerLayoutUi.Factory.getInstance((Project)this.project).create(this.RUNNER_ID, "Jupyter Server", "Jupyter Server", (Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)runnerLayoutUi2, (String)"create(...)");
        RunnerLayoutUi ui = runnerLayoutUi2;
        RunnerLayoutUi $this$createRunnerLayoutUi_u24lambda_u243 = runnerLayoutUi = ui.createContent(this.RUNNER_ID, console.getComponent(), logContentTitle, null, console.getPreferredFocusableComponent());
        boolean bl = false;
        $this$createRunnerLayoutUi_u24lambda_u243.setCloseable(false);
        RunnerLayoutUi runnerLayoutUi3 = runnerLayoutUi;
        Intrinsics.checkNotNullExpressionValue((Object)runnerLayoutUi3, (String)"apply(...)");
        RunnerLayoutUi consoleContent = runnerLayoutUi3;
        runnerLayoutUi = new RunnerLayoutUi[]{new JupyterStartServerExecutionAction(managedServerConfiguration), new JupyterStopServerExecutionAction(execution)};
        DefaultActionGroup group = new DefaultActionGroup((AnAction[])runnerLayoutUi);
        RunnerLayoutUi $this$createRunnerLayoutUi_u24lambda_u244 = runnerLayoutUi = ui;
        boolean bl2 = false;
        $this$createRunnerLayoutUi_u24lambda_u244.addContent((Content)consoleContent);
        $this$createRunnerLayoutUi_u24lambda_u244.getOptions().setLeftToolbar((ActionGroup)group, "toolbar");
        return runnerLayoutUi;
    }

    private final void notifyServerStarting() {
        JupyterServerToolWindowKt.getJUPYTER_NOTIFICATION_GROUP().createNotification(JupyterBundle.message((String)"jupyter.server.starting.notification", (Object[])new Object[0]), NotificationType.INFORMATION).notify(this.project);
    }

    public void dispose() {
        ConsoleViewImpl it;
        ConsoleViewImpl consoleViewImpl = this.consoleView;
        if (consoleViewImpl != null) {
            it = consoleViewImpl;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        this.consoleView = null;
        Content content = this.content;
        if (content != null) {
            it = content;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        this.content = null;
        this.toolWindow = null;
    }
}

