/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ui.remote;

import com.intellij.ide.IdeView;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.IdeViewForProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.jupyter.core.core.api.NotebookDisposable;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParametersSettings;
import com.intellij.jupyter.core.jupyter.connections.JupyterRemoteServersSettingsListener;
import com.intellij.jupyter.core.jupyter.connections.settings.ConfiguredServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.ui.JupyterServersNodeMarker;
import com.intellij.jupyter.core.jupyter.ui.NoJupyterServersNodeMarker;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteAuthorityNodeCache;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteCompositeNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteFileNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteLoadingNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteStructureProvider;
import com.intellij.jupyter.py.ui.remote.providers.JupyterRemoteCopyPasteProvider;
import com.intellij.jupyter.py.ui.remote.providers.JupyterRemoteDeleteProvider;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteFileSystem;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.ui.treeStructure.BgtAwareTreeModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0002\u001a\u001bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J:\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J$\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0002J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0016H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jupyter/py/ui/remote/JupyterRemoteStructureProvider;", "Lcom/intellij/ide/projectView/TreeStructureProvider;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "modify", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "parent", "children", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "filterOutJupyterServerModules", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "selection", "", "getIdeView", "Lcom/intellij/ide/IdeView;", "selected", "MyListener", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterRemoteStructureProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteStructureProvider.kt\ncom/intellij/jupyter/py/ui/remote/JupyterRemoteStructureProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,172:1\n1863#2:173\n1864#2:176\n1611#2,9:177\n1863#2:186\n1864#2:188\n1620#2:189\n1611#2,9:190\n1863#2:199\n1864#2:201\n1620#2:202\n31#3,2:174\n1#4:187\n1#4:200\n37#5,2:203\n14#6:205\n*S KotlinDebug\n*F\n+ 1 JupyterRemoteStructureProvider.kt\ncom/intellij/jupyter/py/ui/remote/JupyterRemoteStructureProvider\n*L\n77#1:173\n77#1:176\n102#1:177,9\n102#1:186\n102#1:188\n102#1:189\n111#1:190,9\n111#1:199\n111#1:201\n111#1:202\n81#1:174,2\n102#1:187\n111#1:200\n111#1:203,2\n169#1:205\n*E\n"})
public final class JupyterRemoteStructureProvider
implements TreeStructureProvider,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public JupyterRemoteStructureProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, @Nullable ViewSettings settings) {
        TreeModel treeModel;
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Object object = ProjectView.getInstance((Project)this.project).getCurrentProjectViewPane();
        TreeModel treeModel2 = object != null && (object = object.getTree()) != null ? ((JTree)object).getModel() : (treeModel = null);
        if (treeModel != null) {
            if (!(treeModel instanceof BgtAwareTreeModel)) {
                LOG.error("The project view does not support asynchronous loading. Remote Jupyter servers won't be shown to avoid UI freezes.");
            } else if (parent instanceof ProjectViewProjectNode && !(parent instanceof NoJupyterServersNodeMarker) || parent instanceof JupyterServersNodeMarker) {
                Iterable $this$forEach$iv = JupyterConnectionParametersSettings.Companion.getInstance(this.project).getConnectionSettingsForRemoteAuthorities().entrySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    String authorityName = (String)entry.getKey();
                    BuildersKt.launch$default((CoroutineScope)((CoroutineScope)NotebookDisposable.Companion.forProject(this.project)), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(authorityName, null){
                        int label;
                        final /* synthetic */ String $authorityName;
                        {
                            this.$authorityName = $authorityName;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = JupyterRemoteFileSystem.Companion.getInstance().getOrCreateAuthorityDirectory(this.$authorityName, (Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    ComponentManager $this$service$iv = (ComponentManager)this.project;
                    boolean $i$f$service = false;
                    Class<JupyterRemoteAuthorityNodeCache> serviceClass$iv = JupyterRemoteAuthorityNodeCache.class;
                    Object object2 = $this$service$iv.getService(serviceClass$iv);
                    if (object2 == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                    }
                    children.add((AbstractTreeNode<?>)((JupyterRemoteAuthorityNodeCache)object2).getOrCreateAuthorityNode(authorityName, settings));
                }
            }
        }
        return this.filterOutJupyterServerModules(children);
    }

    private final Collection<AbstractTreeNode<?>> filterOutJupyterServerModules(Collection<AbstractTreeNode<?>> children) {
        Iterator<AbstractTreeNode<?>> iter = children.iterator();
        while (iter.hasNext()) {
            Object nodeValue = iter.next().getValue();
            if (!(nodeValue instanceof PsiDirectory) || !(((PsiDirectory)nodeValue).getVirtualFile() instanceof JupyterRemoteVirtualFile)) continue;
            iter.remove();
        }
        return children;
    }

    /*
     * WARNING - void declaration
     */
    public void uiDataSnapshot(@NotNull DataSink sink, @NotNull Collection<? extends AbstractTreeNode<?>> selection) {
        void $this$toTypedArray$iv;
        void $this$mapNotNullTo$iv$iv;
        Collection $this$mapNotNull$iv;
        void $this$mapNotNullTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        Iterable $this$mapNotNull$iv2 = selection;
        boolean $i$f$mapNotNull22 = false;
        Iterable iterable = $this$mapNotNull$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            JupyterRemoteNode it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            AbstractTreeNode it = (AbstractTreeNode)element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof JupyterRemoteNode ? (JupyterRemoteNode)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nodes = (List)destination$iv$iv;
        if (nodes.isEmpty()) {
            return;
        }
        DataKey dataKey = PlatformDataKeys.DELETE_ELEMENT_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"DELETE_ELEMENT_PROVIDER");
        sink.set(dataKey, (Object)new JupyterRemoteDeleteProvider(this.project, selection));
        if (nodes.size() != selection.size()) {
            return;
        }
        JupyterRemoteNode single = (JupyterRemoteNode)((Object)CollectionsKt.single((List)nodes));
        DataKey dataKey2 = PlatformDataKeys.VIRTUAL_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"VIRTUAL_FILE");
        sink.set(dataKey2, (Object)single.getVirtualFile());
        DataKey dataKey3 = PlatformDataKeys.VIRTUAL_FILE_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"VIRTUAL_FILE_ARRAY");
        Iterable $i$f$mapNotNull22 = nodes;
        DataKey dataKey4 = dataKey3;
        DataSink dataSink = sink;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            JupyterRemoteNode it = (JupyterRemoteNode)((Object)element$iv$iv);
            boolean bl4 = false;
            if (it.getVirtualFile() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv2;
        $this$mapNotNull$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        dataSink.set(dataKey4, (Object)thisCollection$iv.toArray(new VirtualFile[0]));
        DataKey dataKey5 = LangDataKeys.IDE_VIEW;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey5, (String)"IDE_VIEW");
        sink.set(dataKey5, (Object)this.getIdeView(selection));
        DataKey dataKey6 = CommonDataKeys.NAVIGATABLE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey6, (String)"NAVIGATABLE");
        sink.set(dataKey6, (Object)single);
        JupyterRemoteCopyPasteProvider copyPasteProvider = new JupyterRemoteCopyPasteProvider();
        DataKey dataKey7 = PlatformDataKeys.COPY_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey7, (String)"COPY_PROVIDER");
        sink.set(dataKey7, (Object)copyPasteProvider);
        DataKey dataKey8 = PlatformDataKeys.CUT_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey8, (String)"CUT_PROVIDER");
        sink.set(dataKey8, (Object)copyPasteProvider);
        DataKey dataKey9 = PlatformDataKeys.PASTE_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey9, (String)"PASTE_PROVIDER");
        sink.set(dataKey9, (Object)copyPasteProvider);
    }

    private final IdeView getIdeView(Collection<? extends AbstractTreeNode<?>> selected) {
        ProjectManager projectManager = ProjectManager.getInstance();
        Project[] projectArray = projectManager.getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Project project = (Project)ArraysKt.singleOrNull((Object[])projectArray);
        if (project == null) {
            Project project2 = projectManager.getDefaultProject();
            project = project2;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
        }
        Project currentProject = project;
        AbstractProjectViewPane projectViewPane = ProjectView.getInstance((Project)currentProject).getCurrentProjectViewPane();
        return new IdeView(projectViewPane, selected, currentProject){
            private final IdeViewForProjectViewPane delegate;
            final /* synthetic */ Collection<AbstractTreeNode<?>> $selected;
            final /* synthetic */ Project $currentProject;
            {
                this.$selected = $selected;
                this.$currentProject = $currentProject;
                this.delegate = new IdeViewForProjectViewPane(() -> getIdeView.1.delegate$lambda$0($projectViewPane));
            }

            /*
             * WARNING - void declaration
             */
            public PsiDirectory[] getDirectories() {
                void $this$map2Array$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = this.$selected;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof JupyterRemoteNode)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    VirtualFile virtualFile;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    JupyterRemoteNode jupyterRemoteNode = (JupyterRemoteNode)((Object)element$iv$iv);
                    boolean bl2 = false;
                    JupyterRemoteNode jupyterRemoteNode2 = jupyterRemoteNode;
                    if (jupyterRemoteNode2 instanceof JupyterRemoteCompositeNode) {
                        virtualFile = ((JupyterRemoteCompositeNode)jupyterRemoteNode).getVirtualFile();
                    } else if (jupyterRemoteNode2 instanceof JupyterRemoteFileNode || jupyterRemoteNode2 instanceof JupyterRemoteLoadingNode) {
                        AbstractTreeNode abstractTreeNode = jupyterRemoteNode.getParent();
                        Intrinsics.checkNotNull((Object)abstractTreeNode, (String)"null cannot be cast to non-null type com.intellij.jupyter.py.ui.remote.JupyterRemoteCompositeNode");
                        virtualFile = ((JupyterRemoteCompositeNode)abstractTreeNode).getVirtualFile();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    if (virtualFile == null) continue;
                    VirtualFile it$iv$iv = virtualFile;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                PsiDirectoryFactory psiDirectoryFactory = PsiDirectoryFactory.getInstance((Project)this.$currentProject);
                boolean $i$f$map2Array = false;
                PsiDirectory[] psiDirectoryArray = new PsiDirectory[$this$map2Array$iv.size()];
                Object[] array$iv = psiDirectoryArray;
                boolean bl = false;
                Iterable $this$forEachIndexed$iv$iv = (Iterable)$this$map2Array$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$forEachIndexed$iv$iv) {
                    void p0;
                    void t$iv;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    T bl2 = item$iv$iv;
                    int index$iv = n;
                    boolean bl4 = false;
                    VirtualFile bl3 = (VirtualFile)t$iv;
                    int n2 = index$iv;
                    Object[] objectArray = array$iv;
                    boolean $i$f$getDirectories$stub_for_inlining = false;
                    boolean bl5 = false;
                    PsiDirectory psiDirectory = psiDirectoryFactory.createDirectory((VirtualFile)p0);
                    objectArray[n2] = psiDirectory;
                }
                return (PsiDirectory[])((Object[])psiDirectoryArray);
            }

            public PsiDirectory getOrChooseDirectory() {
                return DirectoryChooserUtil.getOrChooseDirectory((IdeView)this);
            }

            public void selectElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                this.delegate.selectElement(element);
            }

            private static final AbstractProjectViewPane delegate$lambda$0(AbstractProjectViewPane $projectViewPane) {
                return $projectViewPane;
            }
        };
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JupyterRemoteStructureProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/py/ui/remote/JupyterRemoteStructureProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/py/ui/remote/JupyterRemoteStructureProvider$MyListener;", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterRemoteServersSettingsListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "changed", "", "oldSettings", "", "", "Lcom/intellij/jupyter/core/jupyter/connections/settings/ConfiguredServerJupyterModuleConnectionSettings;", "newSettings", "intellij.jupyter.py"})
    @SourceDebugExtension(value={"SMAP\nJupyterRemoteStructureProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteStructureProvider.kt\ncom/intellij/jupyter/py/ui/remote/JupyterRemoteStructureProvider$MyListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,172:1\n1863#2:173\n1864#2:175\n59#3:174\n*S KotlinDebug\n*F\n+ 1 JupyterRemoteStructureProvider.kt\ncom/intellij/jupyter/py/ui/remote/JupyterRemoteStructureProvider$MyListener\n*L\n152#1:173\n152#1:175\n153#1:174\n*E\n"})
    public static final class MyListener
    implements JupyterRemoteServersSettingsListener {
        @NotNull
        private final Project project;

        public MyListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public void changed(@NotNull Map<String, ConfiguredServerJupyterModuleConnectionSettings> oldSettings, @NotNull Map<String, ConfiguredServerJupyterModuleConnectionSettings> newSettings) {
            Intrinsics.checkNotNullParameter(oldSettings, (String)"oldSettings");
            Intrinsics.checkNotNullParameter(newSettings, (String)"newSettings");
            if (!Intrinsics.areEqual(oldSettings, newSettings)) {
                Iterable $this$forEach$iv = SetsKt.minus(oldSettings.keySet(), (Iterable)newSettings.keySet());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String deletedAuthority = (String)element$iv;
                    boolean bl = false;
                    ComponentManager $this$serviceIfCreated$iv = (ComponentManager)this.project;
                    boolean $i$f$serviceIfCreated = false;
                    JupyterRemoteAuthorityNodeCache jupyterRemoteAuthorityNodeCache = (JupyterRemoteAuthorityNodeCache)$this$serviceIfCreated$iv.getServiceIfCreated(JupyterRemoteAuthorityNodeCache.class);
                    if (jupyterRemoteAuthorityNodeCache == null) continue;
                    jupyterRemoteAuthorityNodeCache.forgetAuthorityNode(deletedAuthority);
                }
                if (!ApplicationManager.getApplication().isDispatchThread()) {
                    ApplicationManager.getApplication().invokeLater(() -> MyListener.changed$lambda$1(this));
                } else {
                    ProjectView.getInstance((Project)this.project).refresh();
                }
            }
        }

        private static final void changed$lambda$1(MyListener this$0) {
            ProjectView.getInstance((Project)this$0.project).refresh();
        }
    }
}

