/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ui.remote.providers;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.core.CoreBundle;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.ContentsApiModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.DirectoryModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.NotebookModel;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.jupyter.py.JupyterRemoteBundle;
import com.intellij.jupyter.py.remote.JupyterRemoteUtilKt;
import com.intellij.jupyter.py.remote.SuggestedKind;
import com.intellij.jupyter.py.ui.remote.providers.FileExistsHandler;
import com.intellij.jupyter.py.ui.remote.providers.UtilKt;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0001H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/py/ui/remote/providers/RemoteToLocalCopyStrategy;", "", "fileExistsHandler", "Lcom/intellij/jupyter/py/ui/remote/providers/FileExistsHandler;", "<init>", "(Lcom/intellij/jupyter/py/ui/remote/providers/FileExistsHandler;)V", "copyDirectory", "", "remoteDirPath", "Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "newLocalDirName", "", "localTargetDir", "Ljava/io/File;", "isLocalFileExists", "", "fileName", "copyFile", "remoteFilePath", "newLocalFileName", "writeAsFile", "localFile", "content", "", "writeAsNotebook", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\npasteStrategies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 pasteStrategies.kt\ncom/intellij/jupyter/py/ui/remote/providers/RemoteToLocalCopyStrategy\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n19#2:158\n19#2:162\n19#2:163\n1863#3,2:159\n1#4:161\n*S KotlinDebug\n*F\n+ 1 pasteStrategies.kt\ncom/intellij/jupyter/py/ui/remote/providers/RemoteToLocalCopyStrategy\n*L\n61#1:158\n93#1:162\n97#1:163\n69#1:159,2\n*E\n"})
public final class RemoteToLocalCopyStrategy {
    @NotNull
    private final FileExistsHandler fileExistsHandler;

    public RemoteToLocalCopyStrategy(@NotNull FileExistsHandler fileExistsHandler) {
        Intrinsics.checkNotNullParameter((Object)fileExistsHandler, (String)"fileExistsHandler");
        this.fileExistsHandler = fileExistsHandler;
    }

    public final void copyDirectory(@NotNull JupyterRemotePath remoteDirPath, @NotNull String newLocalDirName, @NotNull File localTargetDir) {
        DirectoryModel directoryModel;
        Collection dirContents;
        Object[] $this$asSafely$iv;
        Intrinsics.checkNotNullParameter((Object)remoteDirPath, (String)"remoteDirPath");
        Intrinsics.checkNotNullParameter((Object)newLocalDirName, (String)"newLocalDirName");
        Intrinsics.checkNotNullParameter((Object)localTargetDir, (String)"localTargetDir");
        ContentsApiModel contentsApiModel = UtilKt.getFileNodeLookingOnExtension(remoteDirPath);
        boolean $i$f$asSafely = false;
        Object[] objectArray = $this$asSafely$iv;
        if (!(objectArray instanceof DirectoryModel)) {
            objectArray = null;
        }
        Collection collection = dirContents = (directoryModel = (DirectoryModel)objectArray) != null ? directoryModel.getContent() : null;
        if (dirContents != null) {
            File localDir = FilesKt.resolve((File)localTargetDir, (String)newLocalDirName);
            if (!FileUtil.createDirectory((File)localDir)) {
                $this$asSafely$iv = new Object[]{localDir.getAbsolutePath()};
                throw new IncorrectOperationException(JupyterRemoteBundle.message("Jupyter.remote.unable.to.create.target.dir", $this$asSafely$iv));
            }
            Iterable $this$forEach$iv = dirContents;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String[] childModel = (String[])element$iv;
                boolean bl = false;
                String[] stringArray = new String[]{childModel.getName()};
                JupyterRemotePath remoteChildPath = remoteDirPath.resolve(stringArray);
                stringArray = childModel;
                if (stringArray instanceof DirectoryModel) {
                    this.copyDirectory(remoteChildPath, ((DirectoryModel)childModel).getName(), localDir);
                    continue;
                }
                if (stringArray instanceof FileModel || stringArray instanceof NotebookModel) {
                    this.copyFile(remoteChildPath, childModel.getName(), localDir);
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final boolean isLocalFileExists(String fileName, File localTargetDir) {
        return FilesKt.resolve((File)localTargetDir, (String)fileName).exists();
    }

    public final void copyFile(@NotNull JupyterRemotePath remoteFilePath, @NotNull String newLocalFileName, @NotNull File localTargetDir) {
        Intrinsics.checkNotNullParameter((Object)remoteFilePath, (String)"remoteFilePath");
        Intrinsics.checkNotNullParameter((Object)newLocalFileName, (String)"newLocalFileName");
        Intrinsics.checkNotNullParameter((Object)localTargetDir, (String)"localTargetDir");
        if (this.isLocalFileExists(newLocalFileName, localTargetDir)) {
            File file;
            File file2;
            File it = file2 = FilesKt.resolve((File)localTargetDir, (String)newLocalFileName);
            boolean bl = false;
            File file3 = file = it.isDirectory() ? file2 : null;
            if (file != null) {
                File $this$copyFile_u24lambda_u242 = file;
                boolean bl2 = false;
                Object[] objectArray = new Object[]{$this$copyFile_u24lambda_u242.getAbsolutePath()};
                throw new IncorrectOperationException(CoreBundle.message((String)"file.already.exists.error", (Object[])objectArray));
            }
            String string = localTargetDir.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!this.fileExistsHandler.shouldOverwriteExistingFile(string, newLocalFileName)) {
                return;
            }
        }
        ContentsApiModel model = UtilKt.getFileNodeLookingOnExtension(remoteFilePath);
        File localFile = FilesKt.resolve((File)localTargetDir, (String)newLocalFileName);
        SuggestedKind suggestedKind = JupyterRemoteUtilKt.suggestedKind(remoteFilePath);
        switch (suggestedKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[suggestedKind.ordinal()]) {
            case 1: {
                NotebookModel notebookModel;
                ObjectNode $this$asSafely$iv;
                ContentsApiModel contentsApiModel = model;
                boolean $i$f$asSafely = false;
                ObjectNode objectNode = $this$asSafely$iv;
                if (!(objectNode instanceof NotebookModel)) {
                    objectNode = null;
                }
                if ((notebookModel = (NotebookModel)objectNode) == null || ($this$asSafely$iv = notebookModel.getContent()) == null) break;
                ObjectNode it = $this$asSafely$iv;
                boolean bl = false;
                this.writeAsNotebook(localFile, it);
                break;
            }
            case 2: {
                byte[] byArray;
                FileModel fileModel;
                ContentsApiModel $this$asSafely$iv = model;
                boolean $i$f$asSafely = false;
                ContentsApiModel contentsApiModel = $this$asSafely$iv;
                if (!(contentsApiModel instanceof FileModel)) {
                    contentsApiModel = null;
                }
                if ((fileModel = (FileModel)contentsApiModel) == null || (byArray = fileModel.getContent()) == null) break;
                byte[] it = byArray;
                boolean bl = false;
                this.writeAsFile(localFile, it);
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void writeAsFile(File localFile, byte[] content) {
        FileUtil.writeToFile((File)localFile, (byte[])content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeAsNotebook(File localFile, Object content) {
        Closeable closeable = new FileOutputStream(localFile);
        Throwable throwable = null;
        try {
            FileOutputStream outputStream = (FileOutputStream)closeable;
            boolean bl = false;
            JupyterJsonKt.getJackson().writer(JupyterNotebookBase.JupyterPrettyPrinter.Companion.getPrettyPrinter$default((JupyterNotebookBase.JupyterPrettyPrinter.Companion)JupyterNotebookBase.JupyterPrettyPrinter.Companion, null, (int)1, null)).writeValue((OutputStream)outputStream, content);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SuggestedKind.values().length];
            try {
                nArray[SuggestedKind.NOTEBOOK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuggestedKind.FILE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

