/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ui.remote.providers;

import com.intellij.jupyter.core.jupyter.JupyterErrorHandlingUtilKt;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameterSettingsUtilsKt;
import com.intellij.jupyter.core.jupyter.connections.settings.ConfiguredServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.py.JupyterRemoteBundle;
import com.intellij.jupyter.py.ui.remote.providers.FileExistsHandler;
import com.intellij.jupyter.py.ui.remote.providers.JupyterRemoteCopyPasteLog;
import com.intellij.jupyter.py.ui.remote.providers.LocalToRemoteCopyStrategy;
import com.intellij.jupyter.py.ui.remote.providers.PasteCommand;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f0\u0005\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/py/ui/remote/providers/SingleLocalFileToRemoteDirCommand;", "Lcom/intellij/jupyter/py/ui/remote/providers/PasteCommand;", "project", "Lcom/intellij/openapi/project/Project;", "newName", "", "sourcePsiItem", "Lcom/intellij/psi/PsiFileSystemItem;", "targetDirectory", "Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/psi/PsiFileSystemItem;Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;)V", "sourcePath", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "targetPath", "taskTitle", "getTaskTitle", "()Ljava/lang/String;", "strategy", "Lcom/intellij/jupyter/py/ui/remote/providers/LocalToRemoteCopyStrategy;", "doExecute", "", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\npasteCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 pasteCommands.kt\ncom/intellij/jupyter/py/ui/remote/providers/SingleLocalFileToRemoteDirCommand\n+ 2 JupyterErrorHandlingUtil.kt\ncom/intellij/jupyter/core/jupyter/JupyterErrorHandlingUtilKt\n*L\n1#1,394:1\n36#2,6:395\n73#2,6:401\n43#2:407\n79#2:408\n77#2,7:409\n47#2:416\n*S KotlinDebug\n*F\n+ 1 pasteCommands.kt\ncom/intellij/jupyter/py/ui/remote/providers/SingleLocalFileToRemoteDirCommand\n*L\n222#1:395,6\n222#1:401,6\n222#1:407\n222#1:408\n222#1:409,7\n222#1:416\n*E\n"})
final class SingleLocalFileToRemoteDirCommand
extends PasteCommand {
    @NotNull
    private final String newName;
    @NotNull
    private final PsiFileSystemItem sourcePsiItem;
    @NotNull
    private final JupyterRemotePath targetDirectory;
    @NotNull
    private final String sourcePath;
    @NotNull
    private final String targetPath;
    @NotNull
    private final String taskTitle;
    @NotNull
    private final LocalToRemoteCopyStrategy strategy;

    public SingleLocalFileToRemoteDirCommand(@NotNull Project project, @NotNull String newName, @NotNull PsiFileSystemItem sourcePsiItem, @NotNull JupyterRemotePath targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)sourcePsiItem, (String)"sourcePsiItem");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        super(project, null);
        this.newName = newName;
        this.sourcePsiItem = sourcePsiItem;
        this.targetDirectory = targetDirectory;
        String string = this.sourcePsiItem.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.sourcePath = string;
        Object[] objectArray = new String[]{this.newName};
        this.targetPath = this.targetDirectory.resolve((String[])objectArray).getFullPath();
        objectArray = new Object[]{this.sourcePath, this.targetPath};
        this.taskTitle = JupyterRemoteBundle.message("Jupyter.remote.copying", objectArray);
        this.strategy = new LocalToRemoteCopyStrategy(this);
    }

    @Override
    @NotNull
    protected String getTaskTitle() {
        return this.taskTitle;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doExecute() {
        try {
            void $this$runHandlingConnectionErrors_u24default$iv;
            Logger logger = JupyterRemoteCopyPasteLog.INSTANCE.getLOG();
            JupyterRemotePath remotePath$iv = this.targetDirectory;
            boolean suggestRemovingConnection$iv = true;
            boolean $i$f$runHandlingConnectionErrors = false;
            void $this$runHandlingConnectionErrors$iv$iv = $this$runHandlingConnectionErrors_u24default$iv;
            boolean $i$f$runHandlingConnectionErrors2 = false;
            try {
                boolean bl = false;
                if (this.sourcePsiItem instanceof PsiDirectory) {
                    Path path = ((PsiDirectory)this.sourcePsiItem).getVirtualFile().toNioPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
                    this.strategy.copyDirectory(path, this.newName, this.targetDirectory);
                } else {
                    Path path = this.sourcePsiItem.getVirtualFile().toNioPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
                    this.strategy.copyFile(path, this.newName, this.targetDirectory);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (IOException e$iv$iv) {
                boolean bl = false;
                ConfiguredServerJupyterModuleConnectionSettings configuredServerJupyterModuleConnectionSettings = JupyterConnectionParameterSettingsUtilsKt.getAnyConnectionSettingsForAuthority((String)remotePath$iv.getAuthority());
                if (configuredServerJupyterModuleConnectionSettings == null) {
                    throw e$iv$iv;
                }
                JupyterErrorHandlingUtilKt.suggestRemovingConnection((ConfiguredServerJupyterModuleConnectionSettings)configuredServerJupyterModuleConnectionSettings, (boolean)suggestRemovingConnection$iv);
                void var11_13 = $this$runHandlingConnectionErrors$iv$iv;
                bl = false;
                var11_13.warn("Unexpected exception for " + JupyterConnectionParameterSettingsUtilsKt.getAnyConnectionSettingsForAuthority((String)remotePath$iv.getAuthority()), (Throwable)e$iv$iv);
                Object var8_10 = null;
            }
        }
        catch (FileExistsHandler.CopyingCancelException copyingCancelException) {
            // empty catch block
        }
    }
}

