/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.media.tags.internal;

import com.vladsch.flexmark.ast.InlineLinkNode;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public abstract class AbstractMediaLink
extends InlineLinkNode {
    private static final String INVALID_SEQUENCE = "%s Link's CharSequence MUST start with an '%s'!";
    private final String PREFIX;
    private final String TYPE;

    public AbstractMediaLink(String prefix, String type2) {
        this.PREFIX = prefix;
        this.TYPE = type2;
    }

    public AbstractMediaLink(String prefix, String type2, Link other) {
        super(other.baseSubSequence(other.getStartOffset() - prefix.length(), other.getEndOffset()), other.baseSubSequence(other.getStartOffset() - prefix.length(), other.getTextOpeningMarker().getEndOffset()), other.getText(), other.getTextClosingMarker(), other.getLinkOpeningMarker(), other.getUrl(), other.getTitleOpeningMarker(), other.getTitle(), other.getTitleClosingMarker(), other.getLinkClosingMarker());
        this.PREFIX = prefix;
        this.TYPE = type2;
        this.verifyBasedSequence(other.getChars(), other.getStartOffset() - prefix.length());
    }

    public final String getPrefix() {
        return this.PREFIX;
    }

    @Override
    public void setTextChars(BasedSequence textChars) {
        this.verifyBasedSequence(textChars, 0);
        int textCharsLength = textChars.length();
        this.textOpeningMarker = textChars.subSequence(0, this.PREFIX.length() + 1);
        this.text = (BasedSequence)textChars.subSequence(this.PREFIX.length() + 2, textCharsLength - 1).trim();
        this.textClosingMarker = textChars.subSequence(textCharsLength - 1, textCharsLength);
    }

    protected final void verifyBasedSequence(BasedSequence chars, int startOffset) {
        if (!chars.baseSubSequence(startOffset, startOffset + this.PREFIX.length()).matches(this.PREFIX)) {
            throw new IllegalArgumentException(String.format(INVALID_SEQUENCE, this.TYPE, this.PREFIX));
        }
    }
}

