/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.rearranger;

import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.LanguageAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.NameAwareArrangementEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CssArrangementEntry
extends DefaultArrangementEntry
implements NameAwareArrangementEntry,
LanguageAwareArrangementEntry {
    @Nullable
    private final String myName;
    @NotNull
    private final Language myLanguage;

    CssArrangementEntry(@Nullable String name, @Nullable ArrangementEntry parent, @NotNull TextRange range, boolean sortByName, @NotNull Language language) {
        if (range == null) {
            CssArrangementEntry.$$$reportNull$$$0(0);
        }
        if (language == null) {
            CssArrangementEntry.$$$reportNull$$$0(1);
        }
        super(parent, range.getStartOffset(), range.getEndOffset(), true);
        this.myLanguage = language;
        if (name == null) {
            if (parent == null) {
                this.myName = null;
            } else {
                String offset = String.valueOf(range.getStartOffset());
                String leadingZeros = StringUtil.repeatSymbol((char)'0', (int)(7 - offset.length()));
                this.myName = "~" + leadingZeros + offset;
            }
        } else {
            this.myName = sortByName ? CssArrangementEntry.adjustName(name) : name;
        }
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            CssArrangementEntry.$$$reportNull$$$0(2);
        }
        return language;
    }

    @NotNull
    private static String adjustName(@NotNull String origName) {
        int index;
        if (origName == null) {
            CssArrangementEntry.$$$reportNull$$$0(3);
        }
        if (origName.startsWith("-") && origName.length() > 3 && (index = origName.indexOf(45, 2)) > 0) {
            String string = origName.substring(index + 1) + "!" + origName.substring(0, index);
            if (string == null) {
                CssArrangementEntry.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = origName + "#";
        if (string == null) {
            CssArrangementEntry.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public String toString() {
        return "CssArrangementEntry: name = " + this.myName + ", children count = " + this.getChildren().size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/rearranger/CssArrangementEntry";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/rearranger/CssArrangementEntry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "adjustName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

