/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.settings;

import com.intellij.lang.PerFileMappingsEx;
import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssDialectsConfigurable
extends PerFileConfigurableBase<String> {
    static final String ID = "settings.css.dialects";

    public CssDialectsConfigurable(@NotNull Project project) {
        if (project == null) {
            CssDialectsConfigurable.$$$reportNull$$$0(0);
        }
        super(project, (PerFileMappingsEx)CssDialectMappings.getInstance(project));
    }

    @Nls
    public String getDisplayName() {
        return CssBundle.message("css.dialects.title", new Object[0]);
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Nullable
    protected <S> Object getParameter(@NotNull Key<S> key) {
        if (key == null) {
            CssDialectsConfigurable.$$$reportNull$$$0(1);
        }
        if (key == DESCRIPTION) {
            return CssBundle.message("css.dialects.caption", ApplicationNamesInfo.getInstance().getProductName());
        }
        if (key == MAPPING_TITLE) {
            return CssBundle.message("css.dialects.column.title", new Object[0]);
        }
        if (key == OVERRIDE_QUESTION) {
            return CssBundle.message("css.dialects.override.warning.text", new Object[0]);
        }
        if (key == OVERRIDE_TITLE) {
            return CssBundle.message("css.dialects.override.warning.title", new Object[0]);
        }
        return null;
    }

    protected void renderValue(@Nullable Object target, @NotNull String dialectName, @NotNull ColoredTextContainer renderer) {
        if (dialectName == null) {
            CssDialectsConfigurable.$$$reportNull$$$0(2);
        }
        if (renderer == null) {
            CssDialectsConfigurable.$$$reportNull$$$0(3);
        }
        renderer.append(CssDialect.getDialectByName(dialectName).getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    protected void renderDefaultValue(Object target, @NotNull ColoredTextContainer renderer) {
        String dialectName;
        if (renderer == null) {
            CssDialectsConfigurable.$$$reportNull$$$0(4);
        }
        if ((dialectName = (String)this.getNewMapping((VirtualFile)target)) == null) {
            return;
        }
        renderer.append(CssDialect.getDialectByName(dialectName).getDisplayName(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/css/settings/CssDialectsConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "renderValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "renderDefaultValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

