/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.actions.ruleset.CssSelectTargetPopupFactory;
import com.intellij.psi.css.actions.ruleset.StyleCreator;
import com.intellij.psi.css.resolve.CssClassOrIdReference;
import com.intellij.psi.css.resolve.HtmlCssClassOrIdReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateSelectorAction
extends BaseRefactoringIntentionAction {
    private static final String CREATE_SELECTOR_ID_STRING = "createCssSelectorIntention";

    @NotNull
    public String getText() {
        String string = CssBundle.message("create.selector.action", new Object[0]);
        if (string == null) {
            CreateSelectorAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message("create.selector.action", new Object[0]);
        if (string == null) {
            CreateSelectorAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiPolyVariantReference reference;
        if (project == null) {
            CreateSelectorAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            CreateSelectorAction.$$$reportNull$$$0(3);
        }
        if ((reference = this.getClassOrIdReference(element, editor)) != null) {
            return reference.multiResolve(false).length == 0;
        }
        return false;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            CreateSelectorAction.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            CreateSelectorAction.$$$reportNull$$$0(5);
        }
        if (element == null) {
            CreateSelectorAction.$$$reportNull$$$0(6);
        }
        PsiFile containingFile = element.getContainingFile();
        PsiPolyVariantReference classOrIdReference = this.getClassOrIdReference(element, editor);
        if (classOrIdReference != null) {
            Consumer<StyleCreator> chooseCreatorCallback = styleCreator -> CommandProcessor.getInstance().executeCommand(project, () -> {
                CssRuleset createdRuleset = styleCreator.createStyleDeclaration(this.getSelectorFromReference(classOrIdReference), new CssDeclaration[0]);
                if (createdRuleset != null) {
                    CssBlock block = createdRuleset.getBlock();
                    if (block != null && block.isValid() && containingFile == block.getContainingFile()) {
                        CreateSelectorAction.navigateInBlock(block, editor);
                    } else if (createdRuleset.canNavigate()) {
                        createdRuleset.navigate(true);
                    }
                }
            }, CssBundle.message("create.selector.dialog.title", new Object[0]), (Object)CREATE_SELECTOR_ID_STRING, editor.getDocument());
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                StyleCreator styleCreator2 = (StyleCreator)project.getUserData(StyleCreator.EXPLICITLY_CHOSEN_STYLE_CREATOR);
                assert (styleCreator2 != null);
                chooseCreatorCallback.accept(styleCreator2);
            } else {
                boolean suggestCurrentFile = CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)containingFile) && containingFile instanceof XmlFile && ((XmlFile)containingFile).getDocument() != null;
                CssSelectTargetPopupFactory.createSelectTargetPopup(CssBundle.message("create.selector.dialog.title", new Object[0]), containingFile, editor, suggestCurrentFile, chooseCreatorCallback).showInBestPositionFor(editor);
            }
        }
    }

    @NotNull
    protected String getSelectorFromReference(@NotNull PsiPolyVariantReference classOrIdReference) {
        if (classOrIdReference == null) {
            CreateSelectorAction.$$$reportNull$$$0(7);
        }
        if (classOrIdReference instanceof CssClassOrIdReference) {
            CssClassOrIdReference cssClassOrIdReference = (CssClassOrIdReference)classOrIdReference;
            String text = cssClassOrIdReference.getCanonicalText();
            if (text.startsWith(".") || text.startsWith("#")) {
                String string = text;
                if (string == null) {
                    CreateSelectorAction.$$$reportNull$$$0(8);
                }
                return string;
            }
            String string = (cssClassOrIdReference.isId() ? "#" : ".") + text;
            if (string == null) {
                CreateSelectorAction.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = StyleCreator.getSelectorForReference((HtmlCssClassOrIdReference)classOrIdReference);
        if (string == null) {
            CreateSelectorAction.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    protected PsiPolyVariantReference getClassOrIdReference(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            CreateSelectorAction.$$$reportNull$$$0(11);
        }
        XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class, (boolean)false);
        return CreateSelectorAction.findReferenceOfType(editor, (PsiElement)xmlAttributeValue, HtmlCssClassOrIdReference.class);
    }

    @Nullable
    protected static <T extends PsiPolyVariantReference> T findReferenceOfType(Editor editor, PsiElement psiElement, Class<T> refClass) {
        PsiReference[] references;
        PsiReference[] psiReferenceArray = references = psiElement != null ? psiElement.getReferences() : PsiReference.EMPTY_ARRAY;
        if (psiElement != null && references.length > 0) {
            int inElementOffset = editor.getCaretModel().getOffset() - psiElement.getTextOffset();
            for (PsiReference each : references) {
                TextRange range;
                UnfairTextRange textRange;
                if (!refClass.isInstance(each) || !(textRange = new UnfairTextRange((range = each.getRangeInElement()).getStartOffset() - 1, range.getEndOffset())).contains(inElementOffset)) continue;
                return (T)((PsiPolyVariantReference)each);
            }
        }
        return null;
    }

    private static void navigateInBlock(CssBlock block, Editor editor) {
        Object[] declarations = block.getDeclarations();
        CssDeclaration firstDeclaration = (CssDeclaration)ArrayUtil.getFirstElement((Object[])declarations);
        if (firstDeclaration != null && firstDeclaration.canNavigate()) {
            firstDeclaration.navigate(true);
        } else {
            PsiElement lBrace = block.getLBrace();
            if (lBrace != null) {
                editor.getCaretModel().moveToOffset(lBrace.getTextRange().getEndOffset());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/CreateSelectorAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOrIdReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/CreateSelectorAction";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectorFromReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSelectorFromReference";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getClassOrIdReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 11 -> new IllegalArgumentException(string);
        };
    }
}

