/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.vcs.log.impl.MergedChange;
import com.intellij.vcs.log.impl.VcsStatusMerger;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b \u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0014J$\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0003H$J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0002H\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/log/impl/VcsChangesMerger;", "Lcom/intellij/vcs/log/impl/VcsStatusMerger;", "Lcom/intellij/openapi/vcs/changes/Change;", "Lcom/intellij/openapi/vcs/FilePath;", "<init>", "()V", "createStatus", "type", "Lcom/intellij/openapi/vcs/changes/Change$Type;", "path", "secondPath", "createChange", "beforePath", "afterPath", "mergedChange", "Lcom/intellij/vcs/log/impl/MergedChange;", "changesToParents", "", "getFirstPath", "info", "getSecondPath", "getType", "intellij.platform.vcs.log.impl"})
public abstract class VcsChangesMerger
extends VcsStatusMerger<Change, FilePath> {
    @Override
    @NotNull
    protected Change createStatus(@NotNull Change.Type type, @NotNull FilePath path, @Nullable FilePath secondPath) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> this.createChange(type, null, path);
            case 2 -> this.createChange(type, path, null);
            case 3 -> this.createChange(type, path, secondPath);
            case 4 -> this.createChange(type, path, path);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    protected abstract Change createChange(@NotNull Change.Type var1, @Nullable FilePath var2, @Nullable FilePath var3);

    @NotNull
    public final MergedChange mergedChange(@NotNull FilePath path, @NotNull List<? extends Change> changesToParents) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(changesToParents, (String)"changesToParents");
        return new MergedChange.SimpleMergedChange(this.merge(path, changesToParents), changesToParents);
    }

    @Override
    @NotNull
    protected FilePath getFirstPath(@NotNull Change info) {
        FilePath filePath;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        switch (WhenMappings.$EnumSwitchMapping$0[info.getType().ordinal()]) {
            case 1: 
            case 4: {
                ContentRevision contentRevision = info.getAfterRevision();
                Intrinsics.checkNotNull((Object)contentRevision);
                FilePath filePath2 = contentRevision.getFile();
                filePath = filePath2;
                Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"getFile(...)");
                break;
            }
            case 2: 
            case 3: {
                ContentRevision contentRevision = info.getBeforeRevision();
                Intrinsics.checkNotNull((Object)contentRevision);
                FilePath filePath3 = contentRevision.getFile();
                filePath = filePath3;
                Intrinsics.checkNotNullExpressionValue((Object)filePath3, (String)"getFile(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return filePath;
    }

    @Override
    @Nullable
    protected FilePath getSecondPath(@NotNull Change info) {
        FilePath filePath;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (WhenMappings.$EnumSwitchMapping$0[info.getType().ordinal()] == 3) {
            ContentRevision contentRevision = info.getAfterRevision();
            Intrinsics.checkNotNull((Object)contentRevision);
            filePath = contentRevision.getFile();
        } else {
            filePath = null;
        }
        return filePath;
    }

    @Override
    @NotNull
    protected Change.Type getType(@NotNull Change info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Change.Type type = info.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
        return type;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Change.Type.values().length];
            try {
                nArray[Change.Type.NEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Change.Type.DELETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Change.Type.MOVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Change.Type.MODIFICATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

