/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn;

import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.javascript.debugger.nashorn.NashornCallFrameEvaluateContext;
import com.intellij.javascript.debugger.nashorn.NashornObject;
import com.intellij.javascript.debugger.nashorn.NashornScope;
import com.intellij.javascript.debugger.nashorn.jdi.AsyncResultCommand;
import com.intellij.javascript.debugger.nashorn.jdi.JdiValueManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.sun.jdi.ObjectReference;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrameBase;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ScopeType;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

final class NashornCallFrame
extends CallFrameBase {
    public static final String THIS_NAME = ":this";
    private final AsyncValueLoader<Variable> receiverVariable;
    private final Object equalityObject;

    NashornCallFrame(final @NotNull JdiValueManager valueManager, final @NotNull StackFrameProxyImpl frame, int line, int column) {
        if (valueManager == null) {
            NashornCallFrame.$$$reportNull$$$0(0);
        }
        if (frame == null) {
            NashornCallFrame.$$$reportNull$$$0(1);
        }
        super(null, line, column, (EvaluateContext)new NashornCallFrameEvaluateContext(frame, valueManager));
        this.equalityObject = frame.hashCode();
        List<NashornScope> scopesValue = Collections.singletonList(new NashornScope(ScopeType.LOCAL, frame, valueManager));
        this.setHasOnlyGlobalScope(false);
        this.setScopes(NotNullLazyValue.createConstantValue(scopesValue));
        this.receiverVariable = new AsyncValueLoader<Variable>(){

            @NotNull
            protected AsyncPromise<Variable> load(@NotNull AsyncPromise<Variable> promise) {
                if (promise == null) {
                    1.$$$reportNull$$$0(0);
                }
                valueManager.getManagerThread().schedule((DebuggerCommandImpl)new AsyncResultCommand<Variable>(promise){

                    @Override
                    protected void doAction() throws Exception {
                        LocalVariableProxyImpl thisVariable = frame.visibleVariableByName(NashornCallFrame.THIS_NAME);
                        if (thisVariable == null) {
                            this.promise.setResult(null);
                            return;
                        }
                        ObjectReference reference = (ObjectReference)frame.getValue(thisVariable);
                        Object value = valueManager.getCachedValue(reference);
                        if (value == null) {
                            value = new NashornObject(ValueType.OBJECT, reference, null, frame.threadProxy().getThreadReference(), valueManager);
                            value = valueManager.getOrCacheValue(reference, (Value)value);
                        }
                        this.promise.setResult((Object)new VariableImpl("this", value, null));
                    }
                });
                AsyncPromise<Variable> asyncPromise = promise;
                if (asyncPromise == null) {
                    1.$$$reportNull$$$0(1);
                }
                return asyncPromise;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "promise";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/debugger/nashorn/NashornCallFrame$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/debugger/nashorn/NashornCallFrame$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "load";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "load";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public Promise<Variable> getReceiverVariable() {
        Promise promise = this.receiverVariable.get();
        if (promise == null) {
            NashornCallFrame.$$$reportNull$$$0(2);
        }
        return promise;
    }

    @NotNull
    public Object getEqualityObject() {
        Object object = this.equalityObject;
        if (object == null) {
            NashornCallFrame.$$$reportNull$$$0(3);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/nashorn/NashornCallFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/nashorn/NashornCallFrame";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceiverVariable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

