/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react.fix;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.javascript.frameworks.jsx.JSXComponent;
import com.intellij.lang.javascript.frameworks.jsx.JSXEmbeddedContentUtil;
import com.intellij.lang.javascript.frameworks.jsx.JSXImplementation;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypedEntity;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.react.ReactBundle;
import com.intellij.react.ReactComponentContentUtil;
import com.intellij.react.fix.ReactPropUpdater;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PsiNavigateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J)\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0096\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J$\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\b\u0001\u0010 \u001a\u00020\u0007H\u0002R\u0018\u0010\u0006\u001a\f0\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/react/fix/ReactUnresolvedPropFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "attribute", "Lcom/intellij/psi/xml/XmlAttribute;", "<init>", "(Lcom/intellij/psi/xml/XmlAttribute;)V", "propName", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/NotNull;", "getFamilyName", "getText", "startInWriteAction", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "createReactPropFromAttribute", "Lcom/intellij/lang/javascript/psi/JSProperty;", "evaluateAttributeValueType", "Lcom/intellij/lang/javascript/psi/JSType;", "attributeValue", "Lcom/intellij/psi/xml/XmlAttributeValue;", "showError", "editor", "Lcom/intellij/openapi/editor/Editor;", "errorText", "intellij.react"})
@SourceDebugExtension(value={"SMAP\nReactUnresolvedPropFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactUnresolvedPropFix.kt\ncom/intellij/react/fix/ReactUnresolvedPropFix\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n19#2:110\n19#2:122\n808#3,11:111\n*S KotlinDebug\n*F\n+ 1 ReactUnresolvedPropFix.kt\ncom/intellij/react/fix/ReactUnresolvedPropFix\n*L\n98#1:110\n103#1:122\n99#1:111,11\n*E\n"})
public final class ReactUnresolvedPropFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final String propName;

    public ReactUnresolvedPropFix(@NotNull XmlAttribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        super((PsiElement)attribute);
        String string = attribute.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.propName = string;
    }

    @NotNull
    public String getFamilyName() {
        return ReactBundle.message("react.inspection.unresolved.prop.quick.fix.family.name", new Object[0]);
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.propName};
        return ReactBundle.message("react.inspection.unresolved.prop.quick.fix.text", objectArray);
    }

    public boolean startInWriteAction() {
        return ApplicationKt.getApplication().isUnitTestMode();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Object v4;
        Editor editor;
        XmlTag tag;
        XmlAttribute attribute;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            if (file.getVirtualFile() == null) {
                return;
            }
            attribute = (XmlAttribute)startElement;
            PsiElement psiElement = attribute.getContext();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
            tag = (XmlTag)psiElement;
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)tag.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
            GlobalSearchScope scope = globalSearchScope;
            editor = PsiEditorUtil.findEditor((PsiElement)startElement);
            PsiFile psiFile = tag.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            JSXComponent component = JSXImplementation.Companion.getImplementation((PsiElement)psiFile).resolveComponent(tag);
            Collection collection = component.getElements();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getElements(...)");
            Collection componentSources = collection;
            if (componentSources.isEmpty()) {
                this.showError(project, editor, ReactBundle.message("react.inspection.unresolved.prop.validation.message.component.source.not.found", new Object[0]));
                return;
            }
            Iterable iterable = componentSources;
            for (Object t : iterable) {
                PsiElement it = (PsiElement)t;
                boolean bl = false;
                VirtualFile virtualFile = it.getContainingFile().getVirtualFile();
                if (!(virtualFile.isWritable() && scope.accept(virtualFile))) continue;
                v4 = t;
                break block5;
            }
            v4 = null;
        }
        PsiElement writableSource = v4;
        if (writableSource == null) {
            this.showError(project, editor, ReactBundle.message("react.inspection.unresolved.prop.validation.message.writable.source.not.found", new Object[0]));
            return;
        }
        String defaultPropsObjectName = tag.getName() + "Props";
        JSTypedEntity propsTypeObject = ReactComponentContentUtil.INSTANCE.findOrCreateWritablePropsTypeObject(writableSource, defaultPropsObjectName);
        if (propsTypeObject == null) {
            this.showError(project, editor, ReactBundle.message("react.inspection.unresolved.prop.validation.message.writable.props.not.found", new Object[0]));
            return;
        }
        ReactPropUpdater.Companion.create(writableSource, propsTypeObject, defaultPropsObjectName, (Function0<? extends JSProperty>)((Function0)() -> ReactUnresolvedPropFix.invoke$lambda$1(this, attribute))).withResultCallback((Function1<? super PsiElement, Unit>)((Function1)ReactUnresolvedPropFix::invoke$lambda$2)).updateProps();
    }

    private final JSProperty createReactPropFromAttribute(XmlAttribute attribute) {
        Object object = this.evaluateAttributeValueType(attribute.getValueElement());
        if (object == null || (object = object.getTypeText(JSType.TypeTextFormat.CODE)) == null) {
            object = "unknown";
        }
        Object valueTypeText = object;
        PsiElement psiElement = JSChangeUtil.createObjectLiteralPropertyFromText((String)(this.propName + "?: " + (String)valueTypeText), (PsiElement)((PsiElement)attribute));
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSProperty");
        return (JSProperty)psiElement;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final JSType evaluateAttributeValueType(XmlAttributeValue attributeValue) {
        if (attributeValue == null) {
            return (JSType)JSNamedTypeFactory.createBooleanPrimitiveType((JSTypeSource)JSTypeSource.EMPTY_TS);
        }
        if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)attributeValue.getFirstChild()), (Object)XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER)) {
            return (JSType)JSNamedTypeFactory.createStringPrimitiveType((JSTypeSource)JSTypeSource.EMPTY_TS);
        }
        v0 = JSXEmbeddedContentUtil.findEmbeddedContent((XmlAttributeValue)attributeValue);
        if (v0 != null) {
            it = v0;
            $i$a$-let-ReactUnresolvedPropFix$evaluateAttributeValueType$strictJSType$1 = false;
            expression /* !! */  = (JSExpression)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)it), JSExpression.class);
            v1 = JSResolveUtil.getExpressionJSType((JSExpression)expression /* !! */ , (boolean)true);
        } else {
            v1 = strictJSType = null;
        }
        if (strictJSType instanceof JSTupleType) {
            v2 = ((JSTupleType)strictJSType).getTypes();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getTypes(...)");
            if (CollectionsKt.distinct((Iterable)v2).size() == 1) {
                return ((JSTupleType)strictJSType).toArrayType(false);
            }
        }
        if ((v3 = strictJSType) == null) ** GOTO lbl-1000
        $this$asSafely$iv = v3;
        $i$f$asSafely = false;
        v4 = $this$asSafely$iv;
        if (!(v4 instanceof JSResolvableType)) {
            v4 = null;
        }
        if ((v3 = (JSResolvableType)v4) != null) {
            v5 = v3.getDeclarations();
        } else lbl-1000:
        // 2 sources

        {
            v5 = null;
        }
        v6 = declarations = v5;
        if (v6 != null) {
            $this$filterIsInstance$iv = v6;
            $i$f$filterIsInstance = false;
            expression /* !! */  = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterIsInstanceTo = false;
            for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof TypeScriptEnumField)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v7 = (List)destination$iv$iv;
        } else {
            v7 = null;
        }
        enumFields = v7;
        var5_2 = enumFields;
        if (!(var5_2 == null || var5_2.isEmpty() != false)) {
            v8 = (TypeScriptEnumField)CollectionsKt.firstOrNull(enumFields);
            return v8 != null && (v8 = v8.getOwner()) != null ? v8.getJSType() : null;
        }
        $this$asSafely$iv = strictJSType;
        $i$f$asSafely = false;
        v9 = $this$asSafely$iv;
        if (!(v9 instanceof JSLiteralType)) {
            v9 = null;
        }
        if ((v10 = (JSLiteralType)v9) == null || (v10 = v10.asPrimitiveType()) == null) {
            v10 = strictJSType;
        }
        return v10;
    }

    private final void showError(Project project, Editor editor, @NlsSafe String errorText) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)errorText, (String)"", null);
    }

    private static final JSProperty invoke$lambda$1(ReactUnresolvedPropFix this$0, XmlAttribute $attribute) {
        return this$0.createReactPropFromAttribute($attribute);
    }

    private static final Unit invoke$lambda$2(PsiElement it) {
        PsiNavigateUtil.navigate((PsiElement)it, (boolean)true);
        return Unit.INSTANCE;
    }
}

