/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import java.util.ArrayList;
import java.util.List;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSReplaceIfWithConditionalIntention
extends JSIntention {
    private static final char TERNARY_QUESTION = '?';
    private static final char TERNARY_SEMICOLON = ':';
    @NonNls
    private static final String RETURN_KEYWORD = "return ";

    @IntentionName
    @NotNull
    public String getText() {
        String string = JSIntentionBundle.message("trivialif.replace-if-with-conditional.display-name", new Object[0]);
        if (string == null) {
            JSReplaceIfWithConditionalIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("trivialif.replace-if-with-conditional.family-name", new Object[0]);
        if (string == null) {
            JSReplaceIfWithConditionalIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new ReplaceIfWithConditionalPredicate();
    }

    @Override
    protected boolean stopTraversingUp(@Nullable PsiElement element) {
        return super.stopTraversingUp(element) || element instanceof JSExpression && !ConditionalUtils.isInIfCondition((JSExpression)element);
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSReplaceIfWithConditionalIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSReplaceIfWithConditionalIntention.$$$reportNull$$$0(3);
        }
        JSIfStatement ifStatement = (JSIfStatement)element;
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)ifStatement);
        if (ReplaceIfWithConditionalPredicate.isReplaceableAssignment(ifStatement)) {
            StringBuilder newStatement = new StringBuilder();
            JSReplaceIfWithConditionalIntention.getAssignmentReplacement(newStatement, ifStatement);
            newStatement.append(semicolon);
            JSRefactoringUtil.replaceStatementAndReformat((JSStatement)ifStatement, (String)newStatement.toString());
        } else if (ReplaceIfWithConditionalPredicate.isReplaceableReturn(ifStatement)) {
            JSReplaceIfWithConditionalIntention.replaceReturn(ifStatement, semicolon);
        }
    }

    private static void getAssignmentReplacement(StringBuilder buffer, JSIfStatement ifStatement) {
        JSExpression condition = ifStatement.getCondition();
        JSStatement thenBranch = ControlFlowUtils.stripBraces((JSStatement)((JSStatement)ifStatement.getThenBranch()));
        JSAssignmentExpression thenAssign = JSReplaceIfWithConditionalIntention.getAssignmentExpression(thenBranch);
        JSExpression thenRhs = thenAssign.getROperand();
        String operator = thenAssign.getOperationNode().getText();
        JSStatement elseBranch = ControlFlowUtils.stripBraces((JSStatement)((JSStatement)ifStatement.getElseBranch()));
        assert (thenRhs != null);
        buffer.append(thenAssign.getLOperand().getText()).append(operator).append(JSParenthesesUtils.getParenthesized((JSExpression)condition, (int)16)).append('?').append(JSParenthesesUtils.getParenthesized((JSExpression)thenRhs, (int)16)).append(':');
        if (elseBranch instanceof JSIfStatement) {
            JSReplaceIfWithConditionalIntention.getAssignmentReplacement(buffer, (JSIfStatement)elseBranch);
            return;
        }
        JSAssignmentExpression elseAssign = JSReplaceIfWithConditionalIntention.getAssignmentExpression(elseBranch);
        JSExpression elseRhs = elseAssign.getROperand();
        assert (elseRhs != null);
        buffer.append(JSParenthesesUtils.getParenthesized((JSExpression)elseRhs, (int)16));
        if (thenBranch instanceof JSVarStatement || elseBranch instanceof JSVarStatement) {
            buffer.insert(0, "var ");
        }
    }

    private static void replaceReturn(JSIfStatement ifStatement, String semicolon) {
        Document document = ifStatement.getContainingFile().getViewProvider().getDocument();
        assert (document != null);
        ArrayList<FormatFixer> formatFixers = new ArrayList<FormatFixer>();
        StringBuilder newStatement = new StringBuilder(RETURN_KEYWORD);
        JSReplaceIfWithConditionalIntention.getReturnReplacement(newStatement, ifStatement, JSReplaceIfWithConditionalIntention.getImplicitReturn(ifStatement), formatFixers);
        newStatement.append(semicolon);
        JSRefactoringUtil.replaceStatementAndReformat((JSStatement)ifStatement, (String)newStatement.toString());
        FormatFixer.fixAll(formatFixers);
    }

    private static void getReturnReplacement(StringBuilder buffer, JSIfStatement ifStatement, @Nullable JSReturnStatement implicitReturn, @NotNull List<FormatFixer> formatFixers) {
        if (formatFixers == null) {
            JSReplaceIfWithConditionalIntention.$$$reportNull$$$0(4);
        }
        JSReturnStatement thenReturn = (JSReturnStatement)ControlFlowUtils.stripBraces((JSStatement)((JSStatement)ifStatement.getThenBranch()));
        JSStatement elseBranch = ControlFlowUtils.stripBraces((JSStatement)((JSStatement)ifStatement.getElseBranch()));
        JSReplaceIfWithConditionalIntention.appendExpression(buffer, ifStatement.getCondition());
        buffer.append('?');
        JSReplaceIfWithConditionalIntention.appendExpression(buffer, thenReturn.getExpression());
        buffer.append(':');
        if (elseBranch instanceof JSIfStatement) {
            JSReplaceIfWithConditionalIntention.getReturnReplacement(buffer, (JSIfStatement)elseBranch, implicitReturn, formatFixers);
            return;
        }
        if (elseBranch instanceof JSReturnStatement) {
            JSReplaceIfWithConditionalIntention.appendExpression(buffer, ((JSReturnStatement)elseBranch).getExpression());
        }
        if (elseBranch == null && implicitReturn != null) {
            JSReplaceIfWithConditionalIntention.appendExpression(buffer, implicitReturn.getExpression());
            formatFixers.add(FormatFixer.create((PsiElement)implicitReturn, (FormatFixer.Mode)FormatFixer.Mode.FirstLinebreak));
            implicitReturn.delete();
        }
    }

    private static void appendExpression(StringBuilder buffer, JSExpression expression) {
        buffer.append(JSParenthesesUtils.getParenthesized((JSExpression)expression, (int)16));
    }

    private static JSAssignmentExpression getAssignmentExpression(JSStatement thenBranch) {
        if (thenBranch instanceof JSExpressionStatement) {
            return (JSAssignmentExpression)((JSExpressionStatement)thenBranch).getExpression();
        }
        JSVariable variable = ((JSVarStatement)thenBranch).getVariables()[0];
        return (JSAssignmentExpression)JSPsiElementFactory.createJSExpression((String)(variable.getName() + " = " + variable.getInitializer().getText()), (PsiElement)variable);
    }

    @Nullable
    private static JSReturnStatement getImplicitReturn(@NotNull JSIfStatement ifStatement) {
        if (ifStatement == null) {
            JSReplaceIfWithConditionalIntention.$$$reportNull$$$0(5);
        }
        return (JSReturnStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)ifStatement), JSReturnStatement.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/trivialif/JSReplaceIfWithConditionalIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatFixers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/trivialif/JSReplaceIfWithConditionalIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReturnReplacement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitReturn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    private static class ReplaceIfWithConditionalPredicate
    implements JSElementPredicate {
        private ReplaceIfWithConditionalPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            JSIfStatement ifStatement;
            block6: {
                block5: {
                    if (element == null) {
                        ReplaceIfWithConditionalPredicate.$$$reportNull$$$0(0);
                    }
                    if (!(element instanceof JSIfStatement)) break block5;
                    ifStatement = (JSIfStatement)element;
                    if (!PsiUtilCore.hasErrorElementChild((PsiElement)element)) break block6;
                }
                return false;
            }
            JSExpression condition = ifStatement.getCondition();
            if (condition == null || !condition.isValid()) {
                return false;
            }
            return ReplaceIfWithConditionalPredicate.isReplaceableAssignment(ifStatement) || ReplaceIfWithConditionalPredicate.isReplaceableReturn(ifStatement);
        }

        private static boolean isReplaceableReturn(@NotNull JSIfStatement ifStatement) {
            if (ifStatement == null) {
                ReplaceIfWithConditionalPredicate.$$$reportNull$$$0(1);
            }
            return ReplaceIfWithConditionalPredicate.isReplaceableReturn(ifStatement, JSReplaceIfWithConditionalIntention.getImplicitReturn(ifStatement) != null);
        }

        private static boolean isReplaceableReturn(@NotNull JSIfStatement ifStatement, boolean emptyReturnAllowed) {
            if (ifStatement == null) {
                ReplaceIfWithConditionalPredicate.$$$reportNull$$$0(2);
            }
            JSStatement thenBranch = ControlFlowUtils.stripBraces((JSStatement)((JSStatement)ifStatement.getThenBranch()));
            JSStatement elseBranch = ControlFlowUtils.stripBraces((JSStatement)((JSStatement)ifStatement.getElseBranch()));
            if (!(thenBranch instanceof JSReturnStatement) || ((JSReturnStatement)thenBranch).getExpression() == null) {
                return false;
            }
            if (elseBranch instanceof JSIfStatement) {
                return ReplaceIfWithConditionalPredicate.isReplaceableReturn((JSIfStatement)elseBranch, emptyReturnAllowed);
            }
            return emptyReturnAllowed && elseBranch == null || elseBranch instanceof JSReturnStatement && ((JSReturnStatement)elseBranch).getExpression() != null;
        }

        private static boolean isReplaceableAssignment(JSIfStatement ifStatement) {
            IElementType elseSign;
            JSStatement thenBranch = ControlFlowUtils.stripBraces((JSStatement)((JSStatement)ifStatement.getThenBranch()));
            if (thenBranch == null) {
                return false;
            }
            if (!ReplaceIfWithConditionalPredicate.isAssignmentOrSingleVarDeclaration(thenBranch)) {
                return false;
            }
            JSStatement elseBranch = ControlFlowUtils.stripBraces((JSStatement)((JSStatement)ifStatement.getElseBranch()));
            if (elseBranch == null) {
                return false;
            }
            if (elseBranch instanceof JSIfStatement) {
                return ReplaceIfWithConditionalPredicate.isReplaceableAssignment((JSIfStatement)elseBranch);
            }
            if (!ReplaceIfWithConditionalPredicate.isAssignmentOrSingleVarDeclaration(elseBranch)) {
                return false;
            }
            JSAssignmentExpression thenExpression = JSReplaceIfWithConditionalIntention.getAssignmentExpression(thenBranch);
            JSAssignmentExpression elseExpression = JSReplaceIfWithConditionalIntention.getAssignmentExpression(elseBranch);
            IElementType thenSign = thenExpression.getOperationSign();
            if (!thenSign.equals(elseSign = elseExpression.getOperationSign())) {
                return false;
            }
            JSExpression thenLhs = thenExpression.getLOperand();
            if (thenExpression.getROperand() == null) {
                return false;
            }
            if (elseExpression.getROperand() == null || elseExpression.getLOperand() == null) {
                return false;
            }
            JSExpression thenRhs = thenExpression.getROperand();
            assert (thenRhs != null);
            JSExpression elseRhs = elseExpression.getROperand();
            if (elseRhs == null) {
                return false;
            }
            JSExpression elseLhs = elseExpression.getLOperand();
            return EquivalenceChecker.expressionsAreEquivalent((JSExpression)thenLhs, (JSExpression)elseLhs);
        }

        private static boolean isAssignmentOrSingleVarDeclaration(@Nullable JSStatement thenBranch) {
            JSInitializerOwner[] declarations;
            if (ConditionalUtils.isAssignment(thenBranch)) {
                return true;
            }
            return thenBranch instanceof JSVarStatement && ((JSVarStatement)thenBranch).getVarKeyword() == JSVarStatement.VarKeyword.VAR && (declarations = ((JSVarStatement)thenBranch).getDeclarations()).length == 1 && declarations[0] instanceof JSVariable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
            }
            objectArray2[1] = "org/intellij/idea/lang/javascript/intention/trivialif/JSReplaceIfWithConditionalIntention$ReplaceIfWithConditionalPredicate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "satisfiedBy";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isReplaceableReturn";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

