/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.skeletons;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.ZipUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.skeletons.PyPregeneratedSkeletons;
import com.jetbrains.python.sdk.skeletons.PyPregeneratedSkeletonsProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultPregeneratedSkeletonsProvider
implements PyPregeneratedSkeletonsProvider {
    private static final Logger LOG = Logger.getInstance(DefaultPregeneratedSkeletonsProvider.class);

    @Nullable
    private static File findPregeneratedSkeletonsRoot() {
        String path2 = PathManager.getHomePath();
        LOG.info("Home path is " + path2);
        File f = new File(path2, "python/skeletons");
        if (f.exists()) {
            return f;
        }
        f = new File(path2, "skeletons");
        if (f.exists()) {
            return f;
        }
        return null;
    }

    @VisibleForTesting
    public static boolean isApplicableZippedSkeletonsFileName(@NotNull String prebuiltSkeletonsName, @NotNull String fileName) {
        if (prebuiltSkeletonsName == null) {
            DefaultPregeneratedSkeletonsProvider.$$$reportNull$$$0(0);
        }
        if (fileName == null) {
            DefaultPregeneratedSkeletonsProvider.$$$reportNull$$$0(1);
        }
        try {
            return fileName.matches(".*" + prebuiltSkeletonsName + "\\.?\\d*\\.zip");
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    @Nullable
    public static String getPregeneratedSkeletonsName(@NotNull Sdk sdk2, int generatorVersion, boolean withMinorVersion, boolean withExtension) {
        if (sdk2 == null) {
            DefaultPregeneratedSkeletonsProvider.$$$reportNull$$$0(2);
        }
        if (PythonSdkUtil.isRemote(sdk2)) {
            return null;
        }
        @NonNls Object versionString = sdk2.getVersionString();
        if (versionString == null) {
            return null;
        }
        if (PythonSdkUtil.isConda(sdk2)) {
            versionString = "Anaconda-" + (String)versionString;
        }
        return DefaultPregeneratedSkeletonsProvider.getPrebuiltSkeletonsName(generatorVersion, (String)versionString, withMinorVersion, withExtension);
    }

    @VisibleForTesting
    @NotNull
    public static String getPrebuiltSkeletonsName(int generatorVersion, @NotNull @NonNls String versionString, boolean withMinorVersion, boolean withExtension) {
        int ind;
        if (versionString == null) {
            DefaultPregeneratedSkeletonsProvider.$$$reportNull$$$0(3);
        }
        String version2 = StringUtil.toLowerCase((String)versionString).replace(" ", "-");
        if (!withMinorVersion && (ind = version2.lastIndexOf(".")) != -1) {
            version2 = version2.substring(0, ind);
        }
        if (SystemInfo.isMac) {
            int secondDot;
            String osVersion = SystemInfo.OS_VERSION;
            int dot = osVersion.indexOf(46);
            if (dot >= 0 && (secondDot = osVersion.indexOf(46, dot + 1)) >= 0) {
                osVersion = osVersion.substring(0, secondDot);
            }
            String string = "skeletons-mac-" + generatorVersion + "-" + osVersion + "-" + version2 + (withExtension ? ".zip" : "");
            if (string == null) {
                DefaultPregeneratedSkeletonsProvider.$$$reportNull$$$0(4);
            }
            return string;
        }
        String os = SystemInfo.isWindows ? "win" : "nix";
        String string = "skeletons-" + os + "-" + generatorVersion + "-" + version2 + (withExtension ? ".zip" : "");
        if (string == null) {
            DefaultPregeneratedSkeletonsProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public PyPregeneratedSkeletons getSkeletonsForSdk(Sdk sdk2, int generatorVersion) {
        File root = DefaultPregeneratedSkeletonsProvider.findPregeneratedSkeletonsRoot();
        if (root == null || !root.exists()) {
            return null;
        }
        LOG.info("Pregenerated skeletons root is " + root);
        String prebuiltSkeletonsName = DefaultPregeneratedSkeletonsProvider.getPregeneratedSkeletonsName(sdk2, generatorVersion, Registry.is((String)"python.prebuilt.skeletons.minor.version.aware"), false);
        if (prebuiltSkeletonsName == null) {
            return null;
        }
        File f = null;
        File[] children2 = root.listFiles();
        if (children2 != null) {
            for (File file : children2) {
                if (!DefaultPregeneratedSkeletonsProvider.isApplicableZippedSkeletonsFileName(prebuiltSkeletonsName, file.getName())) continue;
                f = file;
                break;
            }
        }
        if (f != null) {
            LOG.info("Found pre-generated skeletons at " + f.getPath());
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(f);
            if (virtualFile == null) {
                LOG.info("Could not find pre-generated skeletons in VFS");
                return null;
            }
            return new ArchivedSkeletons(JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile));
        }
        LOG.info("Not found pre-generated skeletons at " + root);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prebuiltSkeletonsName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/skeletons/DefaultPregeneratedSkeletonsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/skeletons/DefaultPregeneratedSkeletonsProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrebuiltSkeletonsName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableZippedSkeletonsFileName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPregeneratedSkeletonsName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPrebuiltSkeletonsName";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    private static class ArchivedSkeletons
    implements PyPregeneratedSkeletons {
        private final VirtualFile myArchiveRoot;

        ArchivedSkeletons(VirtualFile archiveRoot) {
            this.myArchiveRoot = archiveRoot;
        }

        @Override
        public boolean copyPregeneratedSkeleton(String moduleName, String skeletonDir) {
            File targetDir;
            String modulePath2 = moduleName.replace('.', '/');
            File skeletonsDir = new File(skeletonDir);
            VirtualFile pregenerated = this.myArchiveRoot.findFileByRelativePath(modulePath2 + ".py");
            if (pregenerated == null) {
                pregenerated = this.myArchiveRoot.findFileByRelativePath(modulePath2 + "/__init__.py");
                targetDir = new File(skeletonsDir, modulePath2);
            } else {
                int pos = modulePath2.lastIndexOf(47);
                if (pos < 0) {
                    targetDir = skeletonsDir;
                } else {
                    String moduleParentPath = modulePath2.substring(0, pos);
                    targetDir = new File(skeletonsDir, moduleParentPath);
                }
            }
            if (pregenerated != null && (targetDir.exists() || targetDir.mkdirs())) {
                LOG.info("Pre-generated skeleton for " + moduleName);
                File target = new File(targetDir, pregenerated.getName());
                try (FileOutputStream fos = new FileOutputStream(target);){
                    FileUtil.copy((InputStream)pregenerated.getInputStream(), (OutputStream)fos);
                }
                catch (IOException e) {
                    LOG.info("Error copying pre-generated skeleton", (Throwable)e);
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public void unpackPreGeneratedSkeletons(String skeletonDir) {
            ProgressManager.progress((String)PyBundle.message("python.sdk.unpacking.pre.generated.skeletons", new Object[0]));
            try {
                VirtualFile jar = JarFileSystem.getInstance().getVirtualFileForJar(this.myArchiveRoot);
                if (jar != null) {
                    ZipUtil.extract((File)new File(jar.getPath()), (File)new File(skeletonDir), null);
                }
            }
            catch (IOException e) {
                LOG.info("Error unpacking pre-generated skeletons", (Throwable)e);
            }
        }
    }
}

