/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.context;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.vcs.github.ultimate.context.ContextElementReference;
import com.intellij.vcs.github.ultimate.context.ContextElementResolver;
import com.intellij.vcs.github.ultimate.context.handler.GitHubActionContext;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0010\u001a\u00020\u001eJ\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0010\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001c2\u0006\u0010#\u001a\u00020\u0011H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020!H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u001e\u0010\u0012\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0014\u0018\u00010\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lcom/intellij/vcs/github/ultimate/context/ReferenceContext;", "Lcom/intellij/vcs/github/ultimate/context/handler/GitHubActionContext;", "<init>", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "referencePrefixRegex", "Lkotlin/text/Regex;", "getReferencePrefixRegex", "()Lkotlin/text/Regex;", "completePrefixRegex", "getCompletePrefixRegex", "createLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "element", "Lcom/intellij/psi/PsiElement;", "resolver", "Lcom/intellij/vcs/github/ultimate/context/ContextElementResolver;", "Lorg/jetbrains/yaml/psi/YAMLPsiElement;", "getResolver", "()Lcom/intellij/vcs/github/ultimate/context/ContextElementResolver;", "canComplete", "", "s", "", "providePsiReferences", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/PsiReference;", "Lorg/jetbrains/yaml/psi/YAMLValue;", "createPsiReference", "matchResult", "Lkotlin/text/MatchResult;", "provideLookupElements", "yamlElement", "calculateRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.vcs.github.ultimate"})
@SourceDebugExtension(value={"SMAP\nReferenceContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReferenceContext.kt\ncom/intellij/vcs/github/ultimate/context/ReferenceContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public abstract class ReferenceContext
implements GitHubActionContext {
    @NotNull
    private final Icon icon;
    @Nullable
    private final ContextElementResolver<? extends YAMLPsiElement> resolver;

    public ReferenceContext() {
        Icon icon = AllIcons.Vcs.Vendors.Github;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Github");
        this.icon = icon;
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    protected abstract Regex getReferencePrefixRegex();

    @NotNull
    protected abstract Regex getCompletePrefixRegex();

    @NotNull
    protected LookupElement createLookupElement(@NotNull PsiElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PsiNamedElement) {
            string = ((PsiNamedElement)element).getName();
            if (string == null) {
                string = "";
            }
        } else {
            string = element.getText();
        }
        String elementString = string;
        LookupElement lookupElement = LookupElementBuilder.create((String)elementString).withIcon(this.getIcon()).withAutoCompletionPolicy(AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"withAutoCompletionPolicy(...)");
        return lookupElement;
    }

    @Nullable
    public ContextElementResolver<? extends YAMLPsiElement> getResolver() {
        return this.resolver;
    }

    public boolean canComplete(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Regex regex = this.getCompletePrefixRegex();
        CharSequence charSequence = StringUtil.newBombedCharSequence((CharSequence)s, (long)1000L);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
        return regex.matches(charSequence);
    }

    @NotNull
    public final Sequence<PsiReference> providePsiReferences(@NotNull YAMLValue element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        CharSequence charSequence = StringUtil.newBombedCharSequence((CharSequence)element.getText(), (long)1000L);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
        CharSequence expressionString = charSequence;
        Sequence matches = Regex.findAll$default((Regex)this.getReferencePrefixRegex(), (CharSequence)expressionString, (int)0, (int)2, null);
        return SequencesKt.mapNotNull((Sequence)matches, arg_0 -> ReferenceContext.providePsiReferences$lambda$0(this, element, arg_0));
    }

    private final PsiReference createPsiReference(YAMLValue element, MatchResult matchResult) {
        ContextElementReference contextElementReference;
        ContextElementResolver<? extends YAMLPsiElement> contextElementResolver = this.getResolver();
        if (contextElementResolver != null) {
            ContextElementResolver<? extends YAMLPsiElement> it = contextElementResolver;
            boolean bl = false;
            contextElementReference = new ContextElementReference(element, this.calculateRange(matchResult), it);
        } else {
            contextElementReference = null;
        }
        return (PsiReference)contextElementReference;
    }

    @NotNull
    public Sequence<LookupElement> provideLookupElements(@NotNull PsiElement yamlElement) {
        Sequence sequence;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)yamlElement, (String)"yamlElement");
                sequence = this.getResolver();
                if (sequence == null || (sequence = sequence.calculateResolveScope(yamlElement)) == null) break block3;
                Sequence element = sequence;
                boolean bl = false;
                ContextElementResolver<? extends YAMLPsiElement> contextElementResolver = this.getResolver();
                Sequence sequence2 = contextElementResolver != null && (contextElementResolver = contextElementResolver.getReferenceCandidates((PsiElement)element)) != null ? SequencesKt.map(contextElementResolver, arg_0 -> ReferenceContext.provideLookupElements$lambda$3$lambda$2(this, arg_0)) : null;
                sequence = sequence2;
                if (sequence2 != null) break block4;
            }
            sequence = SequencesKt.emptySequence();
        }
        return sequence;
    }

    @NotNull
    protected TextRange calculateRange(@NotNull MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        TextRange textRange = TextRange.EMPTY_RANGE;
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
        return textRange;
    }

    private static final PsiReference providePsiReferences$lambda$0(ReferenceContext this$0, YAMLValue $element, MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        return this$0.createPsiReference($element, matchResult);
    }

    private static final LookupElement provideLookupElements$lambda$3$lambda$2(ReferenceContext this$0, YAMLPsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createLookupElement((PsiElement)it);
    }
}

