/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.tasks;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.GridBag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.tasks.GHRepositoryEditorKt;
import org.jetbrains.plugins.github.tasks.GithubRepository;

final class GithubRepositoryEditor
extends BaseRepositoryEditor<GithubRepository> {
    private MyTextField myRepoAuthor;
    private MyTextField myRepoName;
    private MyTextField myToken;
    private JBCheckBox myShowNotAssignedIssues;
    private JButton myTokenButton;
    private JBLabel myHostLabel;
    private JBLabel myRepositoryLabel;
    private JBLabel myTokenLabel;

    GithubRepositoryEditor(Project project, GithubRepository repository, Consumer<? super GithubRepository> changeListener) {
        super(project, (BaseRepository)repository, changeListener);
        this.myUrlLabel.setVisible(false);
        this.myUsernameLabel.setVisible(false);
        this.myUserNameText.setVisible(false);
        this.myPasswordLabel.setVisible(false);
        this.myPasswordText.setVisible(false);
        this.myUseHttpAuthenticationCheckBox.setVisible(false);
        this.myRepoAuthor.setText(repository.getRepoAuthor());
        this.myRepoName.setText(repository.getRepoName());
        this.myToken.setText(repository.getPassword());
        this.myShowNotAssignedIssues.setSelected(!repository.isAssignedIssuesOnly());
        DocumentAdapter buttonUpdater = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                GithubRepositoryEditor.this.updateTokenButton();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/github/tasks/GithubRepositoryEditor$1", "textChanged"));
            }
        };
        this.myURLText.getDocument().addDocumentListener((DocumentListener)buttonUpdater);
        this.myRepoAuthor.getDocument().addDocumentListener((DocumentListener)buttonUpdater);
        this.myRepoName.getDocument().addDocumentListener((DocumentListener)buttonUpdater);
    }

    @Nullable
    protected JComponent createCustomPanel() {
        this.myHostLabel = new JBLabel(GithubBundle.message("task.repo.host.field", new Object[0]), 4);
        JPanel myHostPanel = new JPanel(new BorderLayout(5, 0));
        myHostPanel.add((Component)this.myURLText, "Center");
        myHostPanel.add((Component)this.myShareUrlCheckBox, "East");
        this.myRepositoryLabel = new JBLabel(GithubBundle.message("task.repo.repository.field", new Object[0]), 4);
        this.myRepoAuthor = new MyTextField(GithubBundle.message("task.repo.owner.field.empty.hint", new Object[0]));
        this.myRepoName = new MyTextField(GithubBundle.message("task.repo.name.field.empty.hint", new Object[0]));
        this.myRepoAuthor.setPreferredSize("SomelongNickname");
        this.myRepoName.setPreferredSize("SomelongReponame-with-suffixes");
        JPanel myRepoPanel = new JPanel(new GridBagLayout());
        GridBag bag = new GridBag().setDefaultWeightX(1.0).setDefaultFill(2);
        myRepoPanel.add((Component)((Object)this.myRepoAuthor), bag.nextLine().next());
        myRepoPanel.add((Component)new JLabel("/"), bag.next().fillCellNone().insets(0, 5, 0, 5).weightx(0.0));
        myRepoPanel.add((Component)((Object)this.myRepoName), bag.next());
        this.myTokenLabel = new JBLabel(GithubBundle.message("task.repo.token.field", new Object[0]), 4);
        this.myToken = new MyTextField(GithubBundle.message("task.repo.token.field.empty.hint", new Object[0]));
        this.myTokenButton = new JButton(GithubBundle.message("task.repo.token.create.button", new Object[0]));
        this.myTokenButton.addActionListener(e -> {
            this.generateToken();
            this.doApply();
        });
        JPanel myTokenPanel = new JPanel();
        myTokenPanel.setLayout(new BorderLayout(5, 5));
        myTokenPanel.add((Component)((Object)this.myToken), "Center");
        myTokenPanel.add((Component)this.myTokenButton, "East");
        this.myShowNotAssignedIssues = new JBCheckBox(VcsBundle.message((String)"checkbox.include.issues.not.assigned.to.me", (Object[])new Object[0]));
        this.installListener((JTextField)((Object)this.myRepoAuthor));
        this.installListener((JTextField)((Object)this.myRepoName));
        this.installListener((JTextField)((Object)this.myToken));
        this.installListener((JCheckBox)this.myShowNotAssignedIssues);
        return FormBuilder.createFormBuilder().setAlignLabelOnRight(true).addLabeledComponent((JComponent)this.myHostLabel, (JComponent)myHostPanel).addLabeledComponent((JComponent)this.myRepositoryLabel, (JComponent)myRepoPanel).addLabeledComponent((JComponent)this.myTokenLabel, (JComponent)myTokenPanel).addComponentToRightColumn((JComponent)this.myShowNotAssignedIssues).getPanel();
    }

    public void apply() {
        super.apply();
        ((GithubRepository)this.myRepository).setRepoName(this.getRepoName());
        ((GithubRepository)this.myRepository).setRepoAuthor(this.getRepoAuthor());
        ((GithubRepository)this.myRepository).setPassword(this.getToken());
        ((GithubRepository)this.myRepository).storeCredentials();
        ((GithubRepository)this.myRepository).setAssignedIssuesOnly(this.isAssignedIssuesOnly());
    }

    private void generateToken() {
        String token2 = GHRepositoryEditorKt.INSTANCE.askToken(this.myProject, this.getHost());
        if (token2 != null) {
            this.myToken.setText(token2);
        }
    }

    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.myHostLabel.setAnchor(anchor);
        this.myRepositoryLabel.setAnchor(anchor);
        this.myTokenLabel.setAnchor(anchor);
    }

    private void updateTokenButton() {
        if (StringUtil.isEmptyOrSpaces((String)this.getHost()) || StringUtil.isEmptyOrSpaces((String)this.getRepoAuthor()) || StringUtil.isEmptyOrSpaces((String)this.getRepoName())) {
            this.myTokenButton.setEnabled(false);
        } else {
            this.myTokenButton.setEnabled(true);
        }
    }

    @NotNull
    private String getHost() {
        String string = this.myURLText.getText().trim();
        if (string == null) {
            GithubRepositoryEditor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private String getRepoAuthor() {
        String string = this.myRepoAuthor.getText().trim();
        if (string == null) {
            GithubRepositoryEditor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private String getRepoName() {
        String string = this.myRepoName.getText().trim();
        if (string == null) {
            GithubRepositoryEditor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private String getToken() {
        String string = this.myToken.getText().trim();
        if (string == null) {
            GithubRepositoryEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    private boolean isAssignedIssuesOnly() {
        return !this.myShowNotAssignedIssues.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/github/tasks/GithubRepositoryEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepoAuthor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepoName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getToken";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class MyTextField
    extends JBTextField {
        private int myWidth;

        public MyTextField(@Nls @NotNull String hintCaption) {
            if (hintCaption == null) {
                MyTextField.$$$reportNull$$$0(0);
            }
            this.myWidth = -1;
            this.getEmptyText().setText(hintCaption);
        }

        public void setPreferredSize(@NotNull String sampleSizeString) {
            if (sampleSizeString == null) {
                MyTextField.$$$reportNull$$$0(1);
            }
            this.myWidth = this.getFontMetrics(this.getFont()).stringWidth(sampleSizeString);
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            if (this.myWidth != -1) {
                size.width = this.myWidth;
            }
            return size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hintCaption";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sampleSizeString";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/github/tasks/GithubRepositoryEditor$MyTextField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setPreferredSize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

