/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierBundle;
import com.intellij.prettierjs.PrettierConfig;
import com.intellij.prettierjs.PrettierImportCodeStyleAction;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PrettierCodeStyleEditorNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    private static final String NOTIFICATION_DISMISSED_PROPERTY = "prettier.import.notification.dismissed";

    private static boolean isNotificationDismissed(@NotNull Project project) {
        if (project == null) {
            PrettierCodeStyleEditorNotificationProvider.$$$reportNull$$$0(0);
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean(NOTIFICATION_DISMISSED_PROPERTY);
    }

    private void dismissNotification(@NotNull Project project) {
        if (project == null) {
            PrettierCodeStyleEditorNotificationProvider.$$$reportNull$$$0(1);
        }
        PropertiesComponent.getInstance((Project)project).setValue(NOTIFICATION_DISMISSED_PROPERTY, true);
        EditorNotifications.getInstance((Project)project).updateNotifications((EditorNotificationProvider)this);
    }

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile contextFile) {
        if (project == null) {
            PrettierCodeStyleEditorNotificationProvider.$$$reportNull$$$0(2);
        }
        if (contextFile == null) {
            PrettierCodeStyleEditorNotificationProvider.$$$reportNull$$$0(3);
        }
        if (PrettierCodeStyleEditorNotificationProvider.isNotificationDismissed(project)) {
            return null;
        }
        VirtualFile file = PrettierImportCodeStyleAction.getFileWithPrettierConfiguration(project, contextFile);
        if (file == null) {
            return null;
        }
        PrettierConfig config = PrettierUtil.parseConfig(project, file);
        if (config == null) {
            return null;
        }
        if (config.isInstalled(project)) {
            return null;
        }
        return fileEditor -> {
            EditorNotificationPanel panel = new EditorNotificationPanel(EditorColors.GUTTER_BACKGROUND, EditorNotificationPanel.Status.Info);
            panel.setText(PrettierBundle.message("editor.notification.title", new Object[0]));
            panel.createActionLabel(PrettierBundle.message("editor.notification.yes.text", new Object[0]), "PrettierImportCodeStyleAction", false);
            panel.createActionLabel(PrettierBundle.message("editor.notification.no.text", new Object[0]), () -> this.dismissNotification(project), false);
            return panel;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/prettierjs/PrettierCodeStyleEditorNotificationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotificationDismissed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "dismissNotification";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNotificationData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

