/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.settingsSync.core.SettingsSyncBridge;
import com.intellij.settingsSync.core.SettingsSyncBundle;
import com.intellij.settingsSync.core.SettingsSyncMain;
import com.intellij.settingsSync.core.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.core.SettingsSyncState;
import com.intellij.settingsSync.core.SyncSettingsEvent;
import com.intellij.settingsSync.core.UpdateResult;
import com.intellij.settingsSync.core.communicator.RemoteCommunicatorHolder;
import com.intellij.settingsSync.core.config.SettingsSyncEnabler;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0006R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/settingsSync/core/config/SettingsSyncEnabler;", "", "<init>", "()V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/settingsSync/core/config/SettingsSyncEnabler$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "checkServerStateAsync", "", "getServerState", "Lcom/intellij/settingsSync/core/UpdateResult;", "getSettingsFromServer", "syncSettings", "Lcom/intellij/settingsSync/core/SettingsSyncState;", "pushSettingsToServer", "addListener", "listener", "Companion", "State", "Listener", "intellij.settingsSync.core"})
@SourceDebugExtension(value={"SMAP\nSettingsSyncEnabler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncEnabler.kt\ncom/intellij/settingsSync/core/config/SettingsSyncEnabler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,112:1\n14#2:113\n*S KotlinDebug\n*F\n+ 1 SettingsSyncEnabler.kt\ncom/intellij/settingsSync/core/config/SettingsSyncEnabler\n*L\n13#1:113\n*E\n"})
public final class SettingsSyncEnabler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventDispatcher<Listener> eventDispatcher;
    @NotNull
    private static final Logger logger;

    public SettingsSyncEnabler() {
        EventDispatcher eventDispatcher = EventDispatcher.create(Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
    }

    public final void checkServerStateAsync() {
        ((Listener)this.eventDispatcher.getMulticaster()).serverStateCheckStarted();
        SettingsSyncRemoteCommunicator settingsSyncRemoteCommunicator = RemoteCommunicatorHolder.INSTANCE.getRemoteCommunicator();
        if (settingsSyncRemoteCommunicator == null) {
            SettingsSyncEnabler $this$checkServerStateAsync_u24lambda_u240 = this;
            boolean bl = false;
            logger.info("communicator doesn't exist, skipping check");
            return;
        }
        SettingsSyncRemoteCommunicator communicator = settingsSyncRemoteCommunicator;
        String string = SettingsSyncBundle.INSTANCE.message("enable.sync.check.server.data.progress", new Object[0]);
        new Task.Modal(communicator, this, string){
            private UpdateResult updateResult;
            final /* synthetic */ SettingsSyncRemoteCommunicator $communicator;
            final /* synthetic */ SettingsSyncEnabler this$0;
            {
                this.$communicator = $communicator;
                this.this$0 = $receiver;
                super(null, $super_call_param$1, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.updateResult = this.$communicator.receiveUpdates();
            }

            public void onCancel() {
                this.updateResult = State.INSTANCE.getCANCELLED();
            }

            public void onFinished() {
                Listener listener = (Listener)SettingsSyncEnabler.access$getEventDispatcher$p(this.this$0).getMulticaster();
                UpdateResult updateResult = this.updateResult;
                if (updateResult == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"updateResult");
                    updateResult = null;
                }
                listener.serverStateCheckFinished(updateResult);
            }
        }.queue();
    }

    @NotNull
    public final UpdateResult getServerState() {
        SettingsSyncRemoteCommunicator settingsSyncRemoteCommunicator = RemoteCommunicatorHolder.INSTANCE.getRemoteCommunicator();
        if (settingsSyncRemoteCommunicator == null) {
            SettingsSyncEnabler $this$getServerState_u24lambda_u241 = this;
            boolean bl = false;
            logger.info("communicator doesn't exist, skipping check");
            return State.INSTANCE.getCANCELLED();
        }
        SettingsSyncRemoteCommunicator communicator = settingsSyncRemoteCommunicator;
        return communicator.receiveUpdates();
    }

    public final void getSettingsFromServer(@Nullable SettingsSyncState syncSettings) {
        ((Listener)this.eventDispatcher.getMulticaster()).updateFromServerStarted();
        SettingsSyncMain.SettingsSyncControls settingsSyncControls = SettingsSyncMain.Companion.getInstance().getControls();
        String string = SettingsSyncBundle.INSTANCE.message("enable.sync.get.from.server.progress", new Object[0]);
        new Task.Modal(syncSettings, settingsSyncControls, this, string){
            private UpdateResult updateResult;
            final /* synthetic */ SettingsSyncState $syncSettings;
            final /* synthetic */ SettingsSyncMain.SettingsSyncControls $settingsSyncControls;
            final /* synthetic */ SettingsSyncEnabler this$0;
            {
                this.$syncSettings = $syncSettings;
                this.$settingsSyncControls = $settingsSyncControls;
                this.this$0 = $receiver;
                super(null, $super_call_param$1, false);
            }

            public void run(ProgressIndicator indicator) {
                UpdateResult result;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                SettingsSyncRemoteCommunicator settingsSyncRemoteCommunicator = RemoteCommunicatorHolder.INSTANCE.getRemoteCommunicator();
                if (settingsSyncRemoteCommunicator == null) {
                    getSettingsFromServer.1 $this$run_u24lambda_u240 = this;
                    boolean bl = false;
                    SettingsSyncEnabler.access$getLogger$cp().info("communicator doesn't exist, cannot get settings from server");
                    $this$run_u24lambda_u240.updateResult = new UpdateResult.Error("No remote communicator");
                    return;
                }
                SettingsSyncRemoteCommunicator remoteCommunicator = settingsSyncRemoteCommunicator;
                this.updateResult = result = remoteCommunicator.receiveUpdates();
                if (result instanceof UpdateResult.Success) {
                    SyncSettingsEvent.CloudChange cloudEvent = new SyncSettingsEvent.CloudChange(((UpdateResult.Success)result).getSettingsSnapshot(), ((UpdateResult.Success)result).getServerVersionId(), this.$syncSettings);
                    this.$settingsSyncControls.getBridge().initialize$intellij_settingsSync_core(new SettingsSyncBridge.InitMode.TakeFromServer(cloudEvent));
                }
            }

            public void onFinished() {
                Listener listener = (Listener)SettingsSyncEnabler.access$getEventDispatcher$p(this.this$0).getMulticaster();
                UpdateResult updateResult = this.updateResult;
                if (updateResult == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"updateResult");
                    updateResult = null;
                }
                listener.updateFromServerFinished(updateResult);
            }
        }.queue();
    }

    public static /* synthetic */ void getSettingsFromServer$default(SettingsSyncEnabler settingsSyncEnabler, SettingsSyncState settingsSyncState, int n, Object object) {
        if ((n & 1) != 0) {
            settingsSyncState = null;
        }
        settingsSyncEnabler.getSettingsFromServer(settingsSyncState);
    }

    public final void pushSettingsToServer() {
        SettingsSyncMain.SettingsSyncControls settingsSyncControls = SettingsSyncMain.Companion.getInstance().getControls();
        settingsSyncControls.getBridge().initialize$intellij_settingsSync_core(SettingsSyncBridge.InitMode.PushToServer.INSTANCE);
    }

    public final void addListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventDispatcher.addListener((EventListener)listener);
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(SettingsSyncEnabler $this) {
        return $this.eventDispatcher;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncEnabler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SettingsSyncEnabler.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/settingsSync/core/config/SettingsSyncEnabler$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/settingsSync/core/config/SettingsSyncEnabler$Listener;", "Ljava/util/EventListener;", "serverStateCheckStarted", "", "serverStateCheckFinished", "state", "Lcom/intellij/settingsSync/core/UpdateResult;", "updateFromServerStarted", "updateFromServerFinished", "result", "serverRequestStarted", "serverRequestFinished", "intellij.settingsSync.core"})
    public static interface Listener
    extends EventListener {
        default public void serverStateCheckStarted() {
            this.serverRequestStarted();
        }

        default public void serverStateCheckFinished(@NotNull UpdateResult state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.serverRequestFinished();
        }

        default public void updateFromServerStarted() {
            this.serverRequestStarted();
        }

        default public void updateFromServerFinished(@NotNull UpdateResult result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            this.serverRequestFinished();
        }

        default public void serverRequestStarted() {
        }

        default public void serverRequestFinished() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/core/config/SettingsSyncEnabler$State;", "", "<init>", "()V", "CANCELLED", "Lcom/intellij/settingsSync/core/UpdateResult$Error;", "getCANCELLED", "()Lcom/intellij/settingsSync/core/UpdateResult$Error;", "intellij.settingsSync.core"})
    public static final class State {
        @NotNull
        public static final State INSTANCE = new State();
        @NotNull
        private static final UpdateResult.Error CANCELLED = new UpdateResult.Error("Cancelled");

        private State() {
        }

        @NotNull
        public final UpdateResult.Error getCANCELLED() {
            return CANCELLED;
        }
    }
}

