/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.jba;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.settingsSync.core.AbstractServerCommunicator;
import com.intellij.settingsSync.core.SettingsSyncEventListener;
import com.intellij.settingsSync.core.SettingsSyncEvents;
import com.intellij.settingsSync.core.SettingsSyncSettings;
import com.intellij.settingsSync.jba.CloudConfigVersionContext;
import com.intellij.settingsSync.jba.auth.JBAAuthService;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.io.HttpRequests;
import com.jetbrains.cloudconfig.CloudConfigFileClientV2;
import com.jetbrains.cloudconfig.Configuration;
import com.jetbrains.cloudconfig.ETagStorage;
import com.jetbrains.cloudconfig.FileVersionInfo;
import com.jetbrains.cloudconfig.auth.JbaJwtTokenAuthProvider;
import com.jetbrains.cloudconfig.exception.UnauthorizedException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 52\u00020\u0001:\u00015B\u001b\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0002J \u0010\u001b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001c2\u0006\u0010\u001e\u001a\u00020\u0003H\u0014J\b\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0019H\u0014J\u0018\u0010#\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%J\u0012\u0010&\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0014J\u0010\u0010'\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0003H\u0014J$\u0010*\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001e\u001a\u00020\u00032\b\u0010+\u001a\u0004\u0018\u00010\u00032\u0006\u0010,\u001a\u00020\u001dH\u0014J\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020%0.2\u0006\u0010\u001e\u001a\u00020\u0003J\u001d\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\tH\u0011\u00a2\u0006\u0002\b2J\b\u00103\u001a\u000204H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u0004\u0018\u00010\u00038\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00138PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000e\u00a8\u00066"}, d2={"Lcom/intellij/settingsSync/jba/CloudConfigServerCommunicator;", "Lcom/intellij/settingsSync/core/AbstractServerCommunicator;", "serverUrl", "", "jbaAuthService", "Lcom/intellij/settingsSync/jba/auth/JBAAuthService;", "<init>", "(Ljava/lang/String;Lcom/intellij/settingsSync/jba/auth/JBAAuthService;)V", "clientVersionContext", "Lcom/intellij/settingsSync/jba/CloudConfigVersionContext;", "getClientVersionContext", "()Lcom/intellij/settingsSync/jba/CloudConfigVersionContext;", "_currentIdTokenVar", "get_currentIdTokenVar$intellij_settingsSync", "()Ljava/lang/String;", "set_currentIdTokenVar$intellij_settingsSync", "(Ljava/lang/String;)V", "_client", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lcom/jetbrains/cloudconfig/CloudConfigFileClientV2;", "client", "getClient$intellij_settingsSync", "()Lcom/jetbrains/cloudconfig/CloudConfigFileClientV2;", "lastRemoteErrorRef", "Ljava/util/concurrent/atomic/AtomicReference;", "", "getCurrentIdToken", "readFileInternal", "Lkotlin/Pair;", "Ljava/io/InputStream;", "filePath", "requestSuccessful", "", "handleRemoteError", "e", "downloadSnapshot", "version", "Lcom/jetbrains/cloudconfig/FileVersionInfo;", "getLatestVersion", "deleteFileInternal", "userId", "getUserId", "writeFileInternal", "versionId", "content", "fetchHistory", "", "createCloudConfigClient", "url", "versionContext", "createCloudConfigClient$intellij_settingsSync", "createConfiguration", "Lcom/jetbrains/cloudconfig/Configuration;", "Companion", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nCloudConfigServerCommunicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudConfigServerCommunicator.kt\ncom/intellij/settingsSync/jba/CloudConfigServerCommunicator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,225:1\n14#2:226\n*S KotlinDebug\n*F\n+ 1 CloudConfigServerCommunicator.kt\ncom/intellij/settingsSync/jba/CloudConfigServerCommunicator\n*L\n204#1:226\n*E\n"})
public class CloudConfigServerCommunicator
extends AbstractServerCommunicator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JBAAuthService jbaAuthService;
    @NotNull
    private final CloudConfigVersionContext clientVersionContext;
    @VisibleForTesting
    @Nullable
    private volatile String _currentIdTokenVar;
    @NotNull
    private SynchronizedClearableLazy<CloudConfigFileClientV2> _client;
    @NotNull
    private final AtomicReference<Throwable> lastRemoteErrorRef;
    @NotNull
    private static final String URL_PROVIDER = "https://www.jetbrains.com/config/IdeaCloudConfig.xml";
    @NotNull
    private static final String DEFAULT_PRODUCTION_URL = "https://cloudconfig.jetbrains.com/cloudconfig";
    @NotNull
    private static final String DEFAULT_DEBUG_URL = "https://stgn.cloudconfig.jetbrains.com/cloudconfig";
    @NotNull
    private static final String URL_PROPERTY = "idea.settings.sync.cloud.url";
    @NotNull
    private static final Lazy<String> _url = LazyKt.lazy(CloudConfigServerCommunicator::_url$lambda$5);
    @NotNull
    private static final Logger LOG;
    @VisibleForTesting
    @NotNull
    private static final ETagStorage DUMMY_ETAG_STORAGE;

    public CloudConfigServerCommunicator(@Nullable String serverUrl, @NotNull JBAAuthService jbaAuthService) {
        Intrinsics.checkNotNullParameter((Object)jbaAuthService, (String)"jbaAuthService");
        this.jbaAuthService = jbaAuthService;
        this.clientVersionContext = new CloudConfigVersionContext();
        this._client = new SynchronizedClearableLazy(() -> CloudConfigServerCommunicator._client$lambda$0(this, serverUrl));
        this.lastRemoteErrorRef = new AtomicReference();
        SettingsSyncEvents.Companion.getInstance().addListener(new SettingsSyncEventListener(){

            @Override
            public void loginStateChanged() {
                _client.drop();
            }
        });
    }

    public /* synthetic */ CloudConfigServerCommunicator(String string, JBAAuthService jBAAuthService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string, jBAAuthService);
    }

    @NotNull
    protected final CloudConfigVersionContext getClientVersionContext() {
        return this.clientVersionContext;
    }

    @Nullable
    public final String get_currentIdTokenVar$intellij_settingsSync() {
        return this._currentIdTokenVar;
    }

    public final void set_currentIdTokenVar$intellij_settingsSync(@Nullable String string) {
        this._currentIdTokenVar = string;
    }

    @NotNull
    public CloudConfigFileClientV2 getClient$intellij_settingsSync() {
        return (CloudConfigFileClientV2)this._client.getValue();
    }

    private final String getCurrentIdToken() {
        this._client.getValue();
        return this._currentIdTokenVar;
    }

    @Override
    @NotNull
    protected Pair<InputStream, String> readFileInternal(@NotNull String filePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return (Pair)this.clientVersionContext.doWithVersion(filePath, null, arg_0 -> CloudConfigServerCommunicator.readFileInternal$lambda$1(this, arg_0));
    }

    @Override
    protected void requestSuccessful() {
        if (this.lastRemoteErrorRef.get() != null) {
            LOG.info("Connection to setting sync server is restored");
        }
        this.lastRemoteErrorRef.set(null);
    }

    @Override
    @NotNull
    protected String handleRemoteError(@NotNull Throwable e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String defaultMessage = "Error during communication with server";
        if (e instanceof IOException) {
            Throwable throwable = this.lastRemoteErrorRef.get();
            if (!Intrinsics.areEqual((Object)(throwable != null ? throwable.getMessage() : null), (Object)e.getMessage())) {
                this.lastRemoteErrorRef.set(e);
                LOG.warn(defaultMessage + ": " + e.getMessage());
            }
        } else if (e instanceof UnauthorizedException) {
            String string2 = this._currentIdTokenVar;
            if (string2 != null) {
                String string3;
                String it = string3 = string2;
                boolean bl = false;
                this.jbaAuthService.invalidateJBA(it);
            }
            SettingsSyncSettings.Companion.getInstance().setSyncEnabled(false);
            LOG.warn("Got \"Unauthorized\" from Settings Sync server. Settings Sync will be disabled. Please login to JBA again");
        } else {
            LOG.error(e);
        }
        if ((string = e.getMessage()) == null) {
            string = defaultMessage;
        }
        return string;
    }

    @Nullable
    public final InputStream downloadSnapshot(@NotNull String filePath, @NotNull FileVersionInfo version) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        InputStream stream = (InputStream)this.clientVersionContext.doWithVersion(filePath, version.getVersionId(), arg_0 -> CloudConfigServerCommunicator.downloadSnapshot$lambda$3(this, arg_0));
        if (stream == null) {
            LOG.info(filePath + " not found on the server");
        }
        return stream;
    }

    @Override
    @Nullable
    protected String getLatestVersion(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        FileVersionInfo fileVersionInfo = this.getClient$intellij_settingsSync().getLatestVersion(filePath);
        return fileVersionInfo != null ? fileVersionInfo.getVersionId() : null;
    }

    @Override
    protected void deleteFileInternal(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.getClient$intellij_settingsSync().delete(filePath);
    }

    @Override
    @NotNull
    public String getUserId() {
        return "jba";
    }

    @Override
    @Nullable
    protected String writeFileInternal(@NotNull String filePath, @Nullable String versionId, @NotNull InputStream content) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return (String)this.clientVersionContext.doWithVersion(filePath, versionId, arg_0 -> CloudConfigServerCommunicator.writeFileInternal$lambda$4(this, content, arg_0));
    }

    @NotNull
    public final List<FileVersionInfo> fetchHistory(@NotNull String filePath) throws Exception {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        List<FileVersionInfo> list = this.getClient$intellij_settingsSync().getVersions(filePath);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getVersions(...)");
        return list;
    }

    @VisibleForTesting
    @NotNull
    public CloudConfigFileClientV2 createCloudConfigClient$intellij_settingsSync(@NotNull String url, @NotNull CloudConfigVersionContext versionContext) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)versionContext, (String)"versionContext");
        Configuration conf = this.createConfiguration();
        return new CloudConfigFileClientV2(url, conf, DUMMY_ETAG_STORAGE, versionContext);
    }

    private final Configuration createConfiguration() {
        String idToken;
        Configuration configuration = new Configuration().connectTimeout(10000).readTimeout(50000);
        this._currentIdTokenVar = idToken = this.jbaAuthService.getIdToken();
        if (idToken == null) {
            LOG.warn("No idToken provided! Setting Sync will be disabled");
        } else {
            configuration.auth(new JbaJwtTokenAuthProvider(idToken));
        }
        Intrinsics.checkNotNull((Object)configuration);
        return configuration;
    }

    private static final CloudConfigFileClientV2 _client$lambda$0(CloudConfigServerCommunicator this$0, String $serverUrl) {
        String string = $serverUrl;
        if (string == null) {
            string = Companion.getDefaultUrl$intellij_settingsSync();
        }
        return this$0.createCloudConfigClient$intellij_settingsSync(string, this$0.clientVersionContext);
    }

    private static final Pair readFileInternal$lambda$1(CloudConfigServerCommunicator this$0, String filePath) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            InputStream stream = this$0.getClient$intellij_settingsSync().read(filePath);
            String actualVersion = this$0.clientVersionContext.get(filePath);
            if (actualVersion == null) {
                LOG.warn("Version not stored in the context for " + filePath);
            }
            pair = new Pair((Object)stream, (Object)actualVersion);
        }
        catch (FileNotFoundException fileNotFoundException) {
            pair = new Pair(null, null);
        }
        return pair;
    }

    private static final InputStream downloadSnapshot$lambda$3(CloudConfigServerCommunicator this$0, String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this$0.getClient$intellij_settingsSync().read(path);
    }

    private static final String writeFileInternal$lambda$4(CloudConfigServerCommunicator this$0, InputStream $content, String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this$0.getClient$intellij_settingsSync().write(filePath, $content);
        String actualVersion = this$0.clientVersionContext.get(filePath);
        if (actualVersion == null) {
            LOG.warn("Version not stored in the context for " + filePath);
        }
        return actualVersion;
    }

    private static final String _url$lambda$5() {
        String string;
        String explicitUrl = System.getProperty(URL_PROPERTY);
        if (explicitUrl != null) {
            LOG.info("Using SettingSync server URL (from properties): " + explicitUrl);
            string = explicitUrl;
        } else if (PluginManagerCore.isRunningFromSources()) {
            LOG.info("Using SettingSync server URL (DEBUG): https://stgn.cloudconfig.jetbrains.com/cloudconfig");
            string = DEFAULT_DEBUG_URL;
        } else {
            string = CloudConfigServerCommunicator.Companion.getProductionUrl();
        }
        return string;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CloudConfigServerCommunicator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        DUMMY_ETAG_STORAGE = new ETagStorage(){

            public String get(String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return null;
            }

            public void store(String path, String value) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            }

            public void remove(String path) {
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u00020\u00128\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/settingsSync/jba/CloudConfigServerCommunicator$Companion;", "", "<init>", "()V", "URL_PROVIDER", "", "DEFAULT_PRODUCTION_URL", "DEFAULT_DEBUG_URL", "URL_PROPERTY", "defaultUrl", "getDefaultUrl$intellij_settingsSync", "()Ljava/lang/String;", "_url", "Lkotlin/Lazy;", "getProductionUrl", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DUMMY_ETAG_STORAGE", "Lcom/jetbrains/cloudconfig/ETagStorage;", "getDUMMY_ETAG_STORAGE$intellij_settingsSync", "()Lcom/jetbrains/cloudconfig/ETagStorage;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDefaultUrl$intellij_settingsSync() {
            return (String)_url.getValue();
        }

        private final String getProductionUrl() {
            String configUrl = (String)HttpRequests.request((String)CloudConfigServerCommunicator.URL_PROVIDER).productNameAsUserAgent().connect(Companion::getProductionUrl$lambda$0, (Object)CloudConfigServerCommunicator.DEFAULT_PRODUCTION_URL, LOG);
            LOG.info("Using SettingSync server URL: " + configUrl);
            Intrinsics.checkNotNull((Object)configUrl);
            return configUrl;
        }

        @NotNull
        public final ETagStorage getDUMMY_ETAG_STORAGE$intellij_settingsSync() {
            return DUMMY_ETAG_STORAGE;
        }

        private static final String getProductionUrl$lambda$0(HttpRequests.Request request) {
            String string;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            try {
                Element documentElement = JDOMUtil.load((InputStream)request.getInputStream());
                string = documentElement.getAttributeValue("baseUrl");
            }
            catch (JDOMException e) {
                throw new IOException(e);
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

