/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.autoupload;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public abstract class MuteFilter {
    private static final Logger LOG_OF_MUTING = Logger.getInstance((String)"#autoupload.mute");

    public abstract boolean isMuted(@NotNull @SystemIndependent String var1);

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    public static @SystemIndependent @NotNull String getUnifiedPath(@NotNull String path) {
        if (path == null) {
            MuteFilter.$$$reportNull$$$0(0);
        }
        if (SystemInfo.isWindows && OSAgnosticPathUtil.startsWithWindowsDrive((String)path)) {
            path = path.substring(2);
        }
        String string = FileUtil.toSystemIndependentName((String)path);
        if (string == null) {
            MuteFilter.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static @SystemIndependent @NotNull String getUnifiedPath(@NotNull VirtualFile file) {
        if (file == null) {
            MuteFilter.$$$reportNull$$$0(2);
        }
        return MuteFilter.getUnifiedPath(file.getPath());
    }

    @NotNull
    public static MuteFilter create(Change @NotNull [] changes) {
        if (changes == null) {
            MuteFilter.$$$reportNull$$$0(3);
        }
        MyChangesMuteFilter filter = new MyChangesMuteFilter(changes);
        if (LOG_OF_MUTING.isDebugEnabled()) {
            @NonNls StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Created new ").append(filter).append(" for changes:\n");
            for (Change change : changes) {
                stringBuilder.append("Change:\n").append(MyChangesMuteFilter.getRevisionPath(change.getBeforeRevision())).append("\n").append(MyChangesMuteFilter.getRevisionPath(change.getAfterRevision())).append("\n");
            }
            LOG_OF_MUTING.debug(stringBuilder.toString());
        }
        MuteFilter muteFilter = MuteFilter.wrap(filter);
        if (muteFilter == null) {
            MuteFilter.$$$reportNull$$$0(4);
        }
        return muteFilter;
    }

    @NotNull
    public static MuteFilter create(@NotNull String path) {
        if (path == null) {
            MuteFilter.$$$reportNull$$$0(5);
        }
        MyPathMuteFilter filter = new MyPathMuteFilter(path);
        if (LOG_OF_MUTING.isDebugEnabled()) {
            LOG_OF_MUTING.debug("Created new " + filter + " for path \"" + path + "\"");
        }
        MuteFilter muteFilter = MuteFilter.wrap(filter);
        if (muteFilter == null) {
            MuteFilter.$$$reportNull$$$0(6);
        }
        return muteFilter;
    }

    public static MuteFilter create(Collection<VirtualFile> roots) {
        MyFilesMuteFilter filter = new MyFilesMuteFilter(roots);
        if (LOG_OF_MUTING.isDebugEnabled()) {
            @NonNls StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Created new ").append(filter).append(" for changes:\n");
            for (VirtualFile root : roots) {
                stringBuilder.append(root.getPath()).append("\n");
            }
            LOG_OF_MUTING.debug(stringBuilder.toString());
        }
        return MuteFilter.wrap(filter);
    }

    private static MuteFilter wrap(MuteFilter filter) {
        return LOG_OF_MUTING.isDebugEnabled() ? new LoggingMuteFilter(filter) : filter;
    }

    private static boolean isAncestor(String ancestorPath, String path) {
        return VfsUtilCore.isEqualOrAncestor((String)ancestorPath, (String)path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnifiedPath";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUnifiedPath";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6 -> new IllegalStateException(string);
        };
    }

    private static final class MyChangesMuteFilter
    extends MuteFilter {
        private final List<String> myUnifiedPaths;

        private MyChangesMuteFilter(Change @NotNull [] changes) {
            if (changes == null) {
                MyChangesMuteFilter.$$$reportNull$$$0(0);
            }
            this.myUnifiedPaths = new ArrayList<String>(2 * changes.length);
            for (Change change : changes) {
                this.addRevision(change.getAfterRevision());
                this.addRevision(change.getBeforeRevision());
            }
        }

        private void addRevision(@Nullable ContentRevision revision) {
            if (revision != null) {
                FilePath filePath = revision.getFile();
                this.myUnifiedPaths.add(MyChangesMuteFilter.getUnifiedPath(filePath.getPath()));
            }
        }

        @Override
        public boolean isMuted(@SystemIndependent @NotNull String unifiedPath) {
            if (unifiedPath == null) {
                MyChangesMuteFilter.$$$reportNull$$$0(1);
            }
            for (String unifiedRootPath : this.myUnifiedPaths) {
                if (!MuteFilter.isAncestor(unifiedRootPath, unifiedPath)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        static String getRevisionPath(@Nullable ContentRevision revision) {
            if (revision == null) {
                return null;
            }
            FilePath filePath = revision.getFile();
            return filePath.getPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unifiedPath";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$MyChangesMuteFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMuted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyPathMuteFilter
    extends MuteFilter {
        private final String myPath;

        private MyPathMuteFilter(String path) {
            this.myPath = MyPathMuteFilter.getUnifiedPath(path);
        }

        @Override
        public boolean isMuted(@SystemIndependent @NotNull String unifiedPath) {
            if (unifiedPath == null) {
                MyPathMuteFilter.$$$reportNull$$$0(0);
            }
            return MuteFilter.isAncestor(this.myPath, unifiedPath);
        }

        @Override
        @NonNls
        public String toString() {
            return "MyPathMuteFilter{myPath='" + this.myPath + "'}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unifiedPath", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$MyPathMuteFilter", "isMuted"));
        }
    }

    private static final class MyFilesMuteFilter
    extends MuteFilter {
        private final List<String> myRootPaths;

        private MyFilesMuteFilter(Collection<VirtualFile> roots) {
            this.myRootPaths = ContainerUtil.map(roots, MuteFilter::getUnifiedPath);
        }

        @Override
        public boolean isMuted(@NotNull @SystemIndependent String path) {
            if (path == null) {
                MyFilesMuteFilter.$$$reportNull$$$0(0);
            }
            for (String rootPath : this.myRootPaths) {
                if (!MuteFilter.isAncestor(rootPath, path)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$MyFilesMuteFilter", "isMuted"));
        }
    }

    private static final class LoggingMuteFilter
    extends MuteFilter {
        private final MuteFilter myFilter;

        private LoggingMuteFilter(MuteFilter filter) {
            this.myFilter = filter;
        }

        @Override
        public boolean isMuted(@NotNull @SystemIndependent String unifiedPath) {
            boolean muted;
            if (unifiedPath == null) {
                LoggingMuteFilter.$$$reportNull$$$0(0);
            }
            LOG_OF_MUTING.debug(this.myFilter + " for \"" + unifiedPath + "\" is " + ((muted = this.myFilter.isMuted(unifiedPath)) ? "" : "not ") + muted);
            return muted;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unifiedPath", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$LoggingMuteFilter", "isMuted"));
        }
    }
}

