/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.javascript.testFramework.JsTestFileByTestNameIndex;
import com.intellij.javascript.testFramework.exports.ExportsTestFileStructure;
import com.intellij.javascript.testFramework.exports.ExportsTestFileStructureBuilder;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaTestLocationProvider
implements SMTestLocator {
    private static final String SUITE_PROTOCOL_ID = "suite";
    private static final String TEST_PROTOCOL_ID = "test";
    private static final char SPLIT_CHAR = '.';
    private final String myUi;

    public MochaTestLocationProvider(@NotNull String ui) {
        if (ui == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(0);
        }
        this.myUi = ui;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @Nullable String metaInfo, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        boolean suite;
        if (protocol == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(1);
        }
        if (path == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(4);
        }
        if ((suite = SUITE_PROTOCOL_ID.equals(protocol)) || TEST_PROTOCOL_ID.equals(protocol)) {
            Location location = this.getTestLocation(project, path, metaInfo, suite);
            List list = ContainerUtil.createMaybeSingletonList((Object)location);
            if (list == null) {
                MochaTestLocationProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(7);
        }
        if (path == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(8);
        }
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(10);
        }
        throw new IllegalStateException("Should not be called");
    }

    @Nullable
    private Location getTestLocation(@NotNull Project project, @NotNull String locationData, @Nullable String testFilePath, boolean isSuite) {
        PsiElement psiElement;
        List path;
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(11);
        }
        if (locationData == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(12);
        }
        if ((path = EscapeUtils.split((String)locationData, (char)'.')).isEmpty()) {
            return null;
        }
        switch (this.myUi) {
            case "bdd": {
                PsiElement psiElement2 = MochaTestLocationProvider.findJasmineElement(project, path, testFilePath, isSuite);
                break;
            }
            case "qunit": {
                PsiElement psiElement2 = MochaTestLocationProvider.findQUnitElement(project, path, testFilePath, isSuite);
                break;
            }
            case "exports": {
                PsiElement psiElement2 = MochaTestLocationProvider.findExportsElement(project, path, testFilePath);
                break;
            }
            case "tdd": 
            case "mocha-typescript": {
                PsiElement psiElement2 = MochaTestLocationProvider.findTddElement(project, path, testFilePath, isSuite);
                break;
            }
            default: {
                PsiElement psiElement2 = psiElement = this.findAppropriateElement(project, path, testFilePath, isSuite);
            }
        }
        if (psiElement != null) {
            return PsiLocation.fromPsiElement((PsiElement)psiElement);
        }
        return null;
    }

    private PsiElement findAppropriateElement(Project project, @NotNull List<String> path, @Nullable String testFilePath, boolean suite) {
        PsiElement element;
        if (path == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(13);
        }
        String lowerCasedUi = StringUtil.toLowerCase((String)this.myUi);
        boolean bdd = false;
        boolean qUnit = false;
        boolean exports = false;
        if (lowerCasedUi.contains("bdd")) {
            bdd = true;
            element = MochaTestLocationProvider.findJasmineElement(project, path, testFilePath, suite);
            if (element != null) {
                return element;
            }
        }
        if (lowerCasedUi.contains("qunit")) {
            qUnit = true;
            element = MochaTestLocationProvider.findQUnitElement(project, path, testFilePath, suite);
            if (element != null) {
                return element;
            }
        }
        if (lowerCasedUi.contains("exports")) {
            exports = true;
            element = MochaTestLocationProvider.findExportsElement(project, path, testFilePath);
            if (element != null) {
                return element;
            }
        }
        if (!bdd && (element = MochaTestLocationProvider.findJasmineElement(project, path, testFilePath, suite)) != null) {
            return element;
        }
        if (!qUnit && (element = MochaTestLocationProvider.findQUnitElement(project, path, testFilePath, suite)) != null) {
            return element;
        }
        if (!exports && (element = MochaTestLocationProvider.findExportsElement(project, path, testFilePath)) != null) {
            return element;
        }
        return null;
    }

    @Nullable
    private static PsiElement findJasmineElement(Project project, @NotNull List<String> location, @Nullable String testFilePath, boolean isSuite) {
        if (location == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(14);
        }
        VirtualFile executedFile = MochaTestLocationProvider.findFile(testFilePath);
        JsTestFqn testFqn = new JsTestFqn(JSTestFileType.JASMINE, location, isSuite);
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List jsTestVirtualFiles = JsTestFileByTestNameIndex.findFiles((JsTestFqn)testFqn, (GlobalSearchScope)scope, (VirtualFile)executedFile);
        for (VirtualFile file : jsTestVirtualFiles) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof JSFile)) continue;
            JSFile jsFile = (JSFile)psiFile;
            JasmineFileStructureBuilder builder = JasmineFileStructureBuilder.getInstance();
            JasmineFileStructure jasmineFileStructure = (JasmineFileStructure)builder.fetchCachedTestFileStructure(jsFile);
            PsiElement element = jasmineFileStructure.findPsiElement(testFqn);
            if (element == null || !element.isValid()) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static VirtualFile findFile(@Nullable String filePath) {
        if (StringUtil.isEmptyOrSpaces((String)filePath)) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)filePath));
    }

    @Nullable
    private static PsiElement findQUnitElement(@NotNull Project project, @NotNull List<String> location, @Nullable String testFilePath, boolean suite) {
        String testName;
        String moduleName;
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(15);
        }
        if (location == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(16);
        }
        VirtualFile executedFile = MochaTestLocationProvider.findFile(testFilePath);
        if (suite) {
            moduleName = location.get(0);
            testName = null;
        } else if (location.size() > 1) {
            moduleName = location.get(0);
            testName = location.get(1);
        } else {
            moduleName = "Default Module";
            testName = location.get(0);
        }
        String key = JsTestFileByTestNameIndex.createQUnitKey((String)moduleName, testName);
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List jsTestVirtualFiles = JsTestFileByTestNameIndex.findFilesByKey((String)key, (GlobalSearchScope)scope, (VirtualFile)executedFile);
        JsTestFqn fqn = new JsTestFqn(JSTestFileType.QUNIT, List.of(moduleName), testName);
        for (VirtualFile file : jsTestVirtualFiles) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof JSFile)) continue;
            JSFile jsFile = (JSFile)psiFile;
            QUnitFileStructureBuilder builder = QUnitFileStructureBuilder.getInstance();
            QUnitFileStructure qunitFileStructure = (QUnitFileStructure)builder.fetchCachedTestFileStructure(jsFile);
            PsiElement element = qunitFileStructure.findPsiElement(fqn);
            if (element == null || !element.isValid()) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static PsiElement findExportsElement(@NotNull Project project, @NotNull List<String> location, @Nullable String testFilePath) {
        JSFile file;
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(17);
        }
        if (location == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(18);
        }
        if ((file = MochaTestLocationProvider.findJSFile(project, testFilePath)) == null) {
            return null;
        }
        ExportsTestFileStructure structure = (ExportsTestFileStructure)ExportsTestFileStructureBuilder.getInstance().fetchCachedTestFileStructure(file);
        return structure.findPsiElement(location);
    }

    @Nullable
    private static PsiElement findTddElement(@NotNull Project project, @NotNull List<String> location, @Nullable String testFilePath, boolean suite) {
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(19);
        }
        if (location == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(20);
        }
        VirtualFile executedFile = MochaTestLocationProvider.findFile(testFilePath);
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        JsTestFqn testFqn = new JsTestFqn(JSTestFileType.TDD, location, suite);
        List jsTestVirtualFiles = JsTestFileByTestNameIndex.findFiles((JsTestFqn)testFqn, (GlobalSearchScope)scope, (VirtualFile)executedFile);
        for (VirtualFile file : jsTestVirtualFiles) {
            String testName;
            List<String> suiteNames;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof JSFile)) continue;
            JSFile jsFile = (JSFile)psiFile;
            MochaTddFileStructure structure = (MochaTddFileStructure)MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
            PsiElement element = structure.findPsiElement(suiteNames = suite ? location : location.subList(0, location.size() - 1), testName = suite ? null : (String)ContainerUtil.getLastItem(location));
            if (element == null || !element.isValid()) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static JSFile findJSFile(@NotNull Project project, @Nullable String testFilePath) {
        VirtualFile file;
        if (project == null) {
            MochaTestLocationProvider.$$$reportNull$$$0(21);
        }
        if ((file = MochaTestLocationProvider.findFile(testFilePath)) == null || !file.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return (JSFile)ObjectUtils.tryCast((Object)psiFile, JSFile.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 2: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationData";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTestLocation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findAppropriateElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findJasmineElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findQUnitElement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findExportsElement";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findTddElement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findJSFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

