/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeLocalFileTransfer;
import com.intellij.javascript.nodejs.debug.NodeDebugCommandLineConfiguratorKt;
import com.intellij.javascript.nodejs.execution.AbstractNodeTargetRunProfile;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.runConfiguration.AbstractNodeRunConfigurationExtension;
import com.intellij.javascript.nodejs.execution.runConfiguration.NodeRunConfigurationLaunchSession;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.net.NetUtils;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.execution.NodeProfilingRuntimeConfigurer;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import com.jetbrains.nodejs.run.profile.NodeProfilingRuntimeSettings;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingPanel;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeJSProfilingRunConfigurationExtension
extends AbstractNodeRunConfigurationExtension {
    @Nullable
    public NodeRunConfigurationLaunchSession createLaunchSession(@NotNull AbstractNodeTargetRunProfile configuration, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        NodeJsRunConfiguration nodeRc;
        NodeProfilingSettings settings;
        if (configuration == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(1);
        }
        if (!(settings = (nodeRc = (NodeJsRunConfiguration)configuration).getNodeProfilingSettings()).isProfile() && !settings.isAllowRuntimeHeapSnapshot()) {
            return null;
        }
        NodeProfilingRuntimeConfigurer configurer = new NodeProfilingRuntimeConfigurer(nodeRc, environment);
        return new ProfilingLaunchSession(settings, nodeRc, configurer, environment);
    }

    protected void writeExternal(@NotNull AbstractNodeTargetRunProfile runConfiguration, @NotNull Element element) {
        if (runConfiguration == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(2);
        }
        if (element == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(3);
        }
        ((NodeJsRunConfiguration)runConfiguration).getNodeProfilingSettings().writeExternal(element);
    }

    protected void readExternal(@NotNull AbstractNodeTargetRunProfile runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(4);
        }
        if (element == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(5);
        }
        NodeProfilingSettings profilingSettings = NodeProfilingSettings.readExternal(element);
        ((NodeJsRunConfiguration)runConfiguration).setNodeProfilingSettings(profilingSettings);
    }

    @Nullable
    @NlsContexts.TabTitle
    public String getEditorTitle() {
        return NodeJSBundle.message("rc.nodejs.profiling.tab.name", new Object[0]);
    }

    public boolean isApplicableFor(@NotNull AbstractNodeTargetRunProfile configuration) {
        if (configuration == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(6);
        }
        return configuration instanceof NodeJsRunConfiguration;
    }

    @NotNull
    public <P extends AbstractNodeTargetRunProfile> SettingsEditor<P> createEditor(@NotNull P configuration) {
        if (configuration == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(7);
        }
        assert (configuration instanceof NodeJsRunConfiguration);
        return new NodeProfilingPanel(configuration.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLaunchSession";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProfilingLaunchSession
    extends NodeRunConfigurationLaunchSession {
        private final NodeProfilingRuntimeConfigurer myConfigurer;
        private final NodeProfilingRuntimeSettings myRuntimeSettings;
        private final boolean myIsDebug;
        private int myInspectorPort;

        private ProfilingLaunchSession(@NotNull NodeProfilingSettings settings, @NotNull NodeJsRunConfiguration configuration, @NotNull NodeProfilingRuntimeConfigurer configurer, @NotNull ExecutionEnvironment environment) throws ExecutionException {
            if (settings == null) {
                ProfilingLaunchSession.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                ProfilingLaunchSession.$$$reportNull$$$0(1);
            }
            if (configurer == null) {
                ProfilingLaunchSession.$$$reportNull$$$0(2);
            }
            if (environment == null) {
                ProfilingLaunchSession.$$$reportNull$$$0(3);
            }
            this.myInspectorPort = -1;
            this.myConfigurer = configurer;
            this.myIsDebug = environment.getExecutor().getId().equals("Debug");
            try {
                String workingDirectory = configuration.getWorkingDirectory();
                assert (workingDirectory != null);
                this.myRuntimeSettings = settings.createRuntimeSettings(configuration.getProject(), workingDirectory, (NodeFileTransfer)NodeLocalFileTransfer.INSTANCE);
                this.myConfigurer.setRuntimeSettings(this.myRuntimeSettings);
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        }

        public void addNodeOptionsTo(@NotNull NodeTargetRun targetRun) throws ExecutionException {
            String runtimeParameters;
            if (targetRun == null) {
                ProfilingLaunchSession.$$$reportNull$$$0(4);
            }
            NodeJsInterpreter interpreter = targetRun.getInterpreter();
            if (!this.myIsDebug) {
                try {
                    this.myInspectorPort = NetUtils.findAvailableSocketPort();
                }
                catch (IOException e) {
                    throw new ExecutionException((Throwable)e);
                }
                String inspectCliOption = "--inspect=" + NodeDebugCommandLineConfiguratorKt.createDebugPortString((int)this.myInspectorPort, (NodeJsInterpreter)interpreter);
                targetRun.addNodeOptions(false, new TargetValue[]{TargetValue.fixed((Object)inspectCliOption)});
            }
            if (this.myRuntimeSettings != null && !StringUtil.isEmptyOrSpaces((String)(runtimeParameters = this.myRuntimeSettings.getNodeParameters()))) {
                List map = ContainerUtil.map((Collection)ParametersListUtil.parse((String)runtimeParameters), TargetValue::fixed);
                targetRun.addNodeOptions(false, map.toArray(new TargetValue[0]));
            }
        }

        @NotNull
        public List<AnAction> getRunDebugActions() {
            this.myConfigurer.onCommandLineCreation();
            List<Object> list = this.myConfigurer.isTakeHeapSnapshots() ? List.of(this.myConfigurer.createSnapshotAction(this.myInspectorPort)) : Collections.emptyList();
            if (list == null) {
                ProfilingLaunchSession.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRun";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension$ProfilingLaunchSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension$ProfilingLaunchSession";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunDebugActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addNodeOptionsTo";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

