/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.build.dependencies;

import java.io.Closeable;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesDownloader;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesExtractOptions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/intellij/build/dependencies/Msys2SshAgentDownloader;", "", "<init>", "()V", "GIT_FOR_WINDOWS_VERSION", "", "GIT_FOR_WINDOWS_URL", "FILE_LIST", "", "getFILE_LIST", "()Ljava/util/Set;", "MSYS_TARGET_DIR_NAME", "downloadAndExtractGitForWindows", "Ljava/nio/file/Path;", "communityRoot", "Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesCommunityRoot;", "resolveSshAgentFilesDir", "gitDir", "getSshAgentFileList", "", "downloadAndUnpackAgentFiles", "", "targetDirectory", "intellij.idea.ultimate.build.dependencies"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMsys2SshAgentDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Msys2SshAgentDownloader.kt\norg/jetbrains/intellij/build/dependencies/Msys2SshAgentDownloader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1#2:59\n774#3:60\n865#3,2:61\n*S KotlinDebug\n*F\n+ 1 Msys2SshAgentDownloader.kt\norg/jetbrains/intellij/build/dependencies/Msys2SshAgentDownloader\n*L\n43#1:60\n43#1:61,2\n*E\n"})
public final class Msys2SshAgentDownloader {
    @NotNull
    public static final Msys2SshAgentDownloader INSTANCE = new Msys2SshAgentDownloader();
    @NotNull
    public static final String GIT_FOR_WINDOWS_VERSION = "2.45.2";
    @NotNull
    private static final String GIT_FOR_WINDOWS_URL = "https://packages.jetbrains.team/files/p/ij/intellij-dependencies/git-for-windows/Git-2.45.2-64-bit.tar.bz2";
    @NotNull
    private static final Set<String> FILE_LIST;
    @NotNull
    public static final String MSYS_TARGET_DIR_NAME = "msys-ssh-agent";

    private Msys2SshAgentDownloader() {
    }

    @NotNull
    public final Set<String> getFILE_LIST() {
        return FILE_LIST;
    }

    @NotNull
    public final Path downloadAndExtractGitForWindows(@NotNull BuildDependenciesCommunityRoot communityRoot) {
        Intrinsics.checkNotNullParameter((Object)communityRoot, (String)"communityRoot");
        Path gitForWindowsArchive = BuildDependenciesDownloader.downloadFileToCacheLocation((BuildDependenciesCommunityRoot)communityRoot, (URI)new URI(GIT_FOR_WINDOWS_URL));
        return BuildDependenciesDownloader.INSTANCE.extractFileToCacheLocation(communityRoot, gitForWindowsArchive, new BuildDependenciesExtractOptions[0]);
    }

    private final Path resolveSshAgentFilesDir(Path gitDir) {
        Path path2 = gitDir.resolve("usr/bin");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<Path> getSshAgentFileList(@NotNull Path gitDir) {
        List list;
        Intrinsics.checkNotNullParameter((Object)gitDir, (String)"gitDir");
        Path usrBin = this.resolveSshAgentFilesDir(gitDir);
        Closeable closeable = Files.newDirectoryStream(usrBin);
        Throwable throwable = null;
        try {
            void $this$filterTo$iv$iv;
            DirectoryStream stream = (DirectoryStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)stream);
            Iterable $this$filter$iv = stream;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path it = (Path)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!FILE_LIST.contains(PathsKt.getName((Path)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void downloadAndUnpackAgentFiles(@NotNull Path targetDirectory, @NotNull BuildDependenciesCommunityRoot communityRoot) {
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)communityRoot, (String)"communityRoot");
        Files.createDirectories(targetDirectory, new FileAttribute[0]);
        Closeable closeable = Files.newDirectoryStream(this.resolveSshAgentFilesDir(this.downloadAndExtractGitForWindows(communityRoot)));
        Throwable throwable = null;
        try {
            DirectoryStream stream = (DirectoryStream)closeable;
            boolean bl = false;
            Iterator iterator = stream.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Path file = (Path)iterator2.next();
                Intrinsics.checkNotNull((Object)file);
                String fileName = PathsKt.getName((Path)file);
                if (!FILE_LIST.contains(fileName)) continue;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(file, targetDirectory.resolve(fileName), copyOptionArray);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        Object[] objectArray = new String[]{"id.exe", "ssh-agent.exe", "ssh-add.exe", "msys-2.0.dll", "msys-intl-8.dll", "msys-iconv-2.dll", "msys-gcc_s-seh-1.dll", "msys-z.dll", "msys-crypto-3.dll"};
        FILE_LIST = SetsKt.hashSetOf((Object[])objectArray);
    }
}

