/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.ChromeEvaluator;
import com.intellij.javascript.debugger.ExpressionInfoFactory;
import com.intellij.javascript.debugger.GlobalEvaluator;
import com.intellij.javascript.debugger.JSDebuggerSupportUtils;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupportKt;
import com.intellij.javascript.debugger.JavaScriptNameMapper;
import com.intellij.javascript.debugger.JavaScriptNameMapperKt;
import com.intellij.javascript.debugger.NameMapper;
import com.intellij.javascript.debugger.NameMapperKt;
import com.intellij.javascript.debugger.SegmentList;
import com.intellij.javascript.debugger.scripts.VmScriptFileSystemKt;
import com.intellij.javascript.debugger.sourcemap.ScriptMappingEntriesInLine;
import com.intellij.javascript.debugger.sourcemap.SourceMapHelperKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Url;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.PromiseDebuggerEvaluator;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeType;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManager;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.values.ObjectValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J0\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0016J4\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J0\u0010\u0019\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J \u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\b2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0014\u00a8\u0006("}, d2={"Lcom/intellij/javascript/debugger/ChromeEvaluator;", "Lorg/jetbrains/debugger/PromiseDebuggerEvaluator;", "Lcom/intellij/javascript/debugger/ExpressionInfoFactory;", "context", "Lorg/jetbrains/debugger/VariableContext;", "<init>", "(Lorg/jetbrains/debugger/VariableContext;)V", "getExpressionInfoAtOffsetAsync", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/xdebugger/evaluation/ExpressionInfo;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "sideEffectsAllowed", "", "create", "element", "Lcom/intellij/psi/PsiElement;", "createNameMapper", "Lcom/intellij/javascript/debugger/NameMapper;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getEvaluationInfoBySourceMap", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "getPreferredScript", "Lorg/jetbrains/debugger/Script;", "script", "mappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "evaluate", "Lorg/jetbrains/debugger/EvaluateResult;", "expression", "", "expressionPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nChromeEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromeEvaluator.kt\ncom/intellij/javascript/debugger/ChromeEvaluator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1#2:227\n*E\n"})
public class ChromeEvaluator
extends PromiseDebuggerEvaluator
implements ExpressionInfoFactory {
    public ChromeEvaluator(@NotNull VariableContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Promise<ExpressionInfo> getExpressionInfoAtOffsetAsync(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        JavaScriptDebugProcess<?> debugProcess = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext());
        if (!debugProcess.checkCanPerformCommands()) {
            return Promises.resolvedPromise();
        }
        GlobalEvaluator evaluator = debugProcess.getGlobalEvaluator();
        if (evaluator.isDocumentForEvaluation(document)) {
            SegmentList.SegmentListWithData<Pair<String, ObjectValue>> segmentListWithData = evaluator.getValues();
            synchronized (segmentListWithData) {
                int rangeIndex;
                block9: {
                    boolean bl = false;
                    rangeIndex = evaluator.getValues().getRangeIndex(offset);
                    if (rangeIndex != -1) break block9;
                    Promise promise2 = Promises.resolvedPromise();
                    return promise2;
                }
                TextRange textRange = evaluator.getValues().createRange(rangeIndex);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"createRange(...)");
                Promise promise3 = Promises.resolvedPromise((Object)new ExpressionInfo(textRange, (String)evaluator.getValues().getValueByIndex(rangeIndex).getFirst(), null, null, 12, null));
                return promise3;
            }
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return Promises.resolvedPromise();
        }
        PsiFile file = psiFile;
        for (JavaScriptDebugAware debugAware : (JavaScriptDebugAware[])JavaScriptDebugAware.Companion.getEP_NAME().getExtensions()) {
            PsiElement element;
            if (!debugAware.canGetEvaluationInfo(file)) continue;
            if (file.findElementAt(offset) == null) {
                return Promises.resolvedPromise();
            }
            Promise<ExpressionInfo> promise4 = debugAware.getEvaluationInfo(element, document, this);
            if (promise4 == null) continue;
            Promise<ExpressionInfo> it = promise4;
            boolean bl = false;
            return it;
        }
        Ref.IntRef attempts = new Ref.IntRef();
        CancellablePromise cancellablePromise = ReadAction.nonBlocking(() -> ChromeEvaluator.getExpressionInfoAtOffsetAsync$lambda$2(attempts, document, file, offset)).expireWhen(() -> ChromeEvaluator.getExpressionInfoAtOffsetAsync$lambda$3(attempts)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        Intrinsics.checkNotNullExpressionValue((Object)cancellablePromise, (String)"submit(...)");
        return (Promise)cancellablePromise;
    }

    @Override
    @NotNull
    public Promise<ExpressionInfo> create(@NotNull PsiElement element, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        JavaScriptDebugProcess<?> javaScriptDebugProcess = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext());
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        Promise promise2 = this.getEvaluationInfoBySourceMap(element, document, javaScriptDebugProcess, virtualFile).then(arg_0 -> ChromeEvaluator.create$lambda$5(arg_0 -> ChromeEvaluator.create$lambda$4(element, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    @Override
    @Nullable
    public NameMapper createNameMapper(@NotNull VirtualFile file, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        JavaScriptDebugProcess<?> debugProcess = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext());
        List<Url> urls = debugProcess.getFinder().getRemoteUrls(file);
        Ref.ObjectRef result = new Ref.ObjectRef();
        Project project = debugProcess.getSession().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Lazy<SourceFileResolver> resolver = SourceMapHelperKt.createResolver(project, file);
        Function1 processor2 = arg_0 -> ChromeEvaluator.createNameMapper$lambda$8(urls, file, resolver, result, debugProcess, document, arg_0);
        Script preferredScript = this.getPreferredScript(debugProcess, file);
        if (preferredScript == null) {
            Vm vm = debugProcess.getActiveOrMainVm();
            if (vm != null && (vm = vm.getScriptManager()) != null) {
                vm.forEachScript(processor2);
            }
        } else {
            processor2.invoke((Object)preferredScript);
        }
        return (NameMapper)result.element;
    }

    private final Promise<ExpressionInfo> getEvaluationInfoBySourceMap(PsiElement element, Document document, JavaScriptDebugProcess<?> debugProcess, VirtualFile file) {
        int elementOffset = element.getTextOffset();
        int line = document.getLineNumber(elementOffset);
        int elementColumn = elementOffset - document.getLineStartOffset(line);
        int elementEndColumn = elementColumn + element.getTextLength() - 1;
        MultiMap multiMap = MultiMap.createLinked();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createLinked(...)");
        MultiMap scriptToMappings = multiMap;
        Script preferredScript = this.getPreferredScript(debugProcess, file);
        AtomicReference<Object> currentScriptOrUrl = new AtomicReference<Object>();
        MappingsProcessorInLine processor2 = new MappingsProcessorInLine(elementColumn, elementEndColumn, (MultiMap<Object, MappingEntry>)scriptToMappings, currentScriptOrUrl){
            final /* synthetic */ int $elementColumn;
            final /* synthetic */ int $elementEndColumn;
            final /* synthetic */ MultiMap<Object, MappingEntry> $scriptToMappings;
            final /* synthetic */ AtomicReference<Object> $currentScriptOrUrl;
            {
                this.$elementColumn = $elementColumn;
                this.$elementEndColumn = $elementEndColumn;
                this.$scriptToMappings = $scriptToMappings;
                this.$currentScriptOrUrl = $currentScriptOrUrl;
            }

            public boolean process(MappingEntry entry, MappingEntry nextEntry) {
                boolean isSuitable;
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                int entryColumn = entry.getSourceColumn();
                boolean bl = nextEntry == null || entryColumn == 0 && nextEntry.getSourceColumn() == 0 ? entryColumn <= this.$elementColumn : (this.$elementColumn <= entryColumn ? entryColumn <= this.$elementEndColumn : (isSuitable = false));
                if (isSuitable) {
                    this.$scriptToMappings.putValue(this.$currentScriptOrUrl.get(), (Object)entry);
                }
                return true;
            }
        };
        List<Url> sourceUrls = debugProcess.getFinder().getRemoteUrls(file);
        Script script = preferredScript;
        if ((script != null ? script.getSourceMap() : null) == null) {
            for (ScriptMappingEntriesInLine scriptMappingEntries : SourceMapHelperKt.getMappingsInLine(debugProcess, debugProcess.getActiveOrMainVm(), sourceUrls, file, line)) {
                Script script2 = scriptMappingEntries.getScript();
                if (script2 == null) {
                    script2 = scriptMappingEntries.getUrlOrFromScript();
                }
                currentScriptOrUrl.set(script2);
                processor2.processIterable(scriptMappingEntries.getEntries());
            }
        } else {
            currentScriptOrUrl.set(preferredScript.getUrl());
            Project project = debugProcess.getSession().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Lazy<SourceFileResolver> resolver = SourceMapHelperKt.createResolver(project, file);
            for (Url sourceUrl : sourceUrls) {
                SourceMap sourceMap = preferredScript.getSourceMap();
                Intrinsics.checkNotNull((Object)sourceMap);
                processor2.processIterable(sourceMap.getSourceMappingsInLine(sourceUrl, line, file, resolver, false));
            }
        }
        if (scriptToMappings.isEmpty()) {
            return Promises.resolvedPromise();
        }
        for (Object object : scriptToMappings.entrySet()) {
            Intrinsics.checkNotNull((Object)object);
            Object key = object.getKey();
            Collection value = (Collection)object.getValue();
            Intrinsics.checkNotNull((Object)debugProcess.getActiveOrMainVm());
            Script script3 = key instanceof Script ? (Script)key : null;
            if (script3 == null) {
                Vm vm;
                ScriptManager scriptManager = vm.getScriptManager();
                Intrinsics.checkNotNull(key, (String)"null cannot be cast to non-null type com.intellij.util.Url");
                script3 = scriptManager.findScriptByUrl((Url)key);
                if (script3 == null) continue;
            }
            Script script4 = script3;
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<org.jetbrains.debugger.sourcemap.MappingEntry>");
            Promise<ExpressionInfo> expressionInfo = this.getEvaluationInfoBySourceMap(element, script4, TypeIntrinsics.asMutableList((Object)value));
            if (expressionInfo == null) continue;
            return expressionInfo;
        }
        return Promises.resolvedPromise();
    }

    private final Script getPreferredScript(JavaScriptDebugProcess<?> debugProcess, VirtualFile file) {
        CallFrameView topFrameView = (CallFrameView)debugProcess.getSession().getCurrentStackFrame();
        if (topFrameView != null) {
            SourceInfo topFrameSourceInfo;
            SourceInfo sourceInfo = topFrameSourceInfo = topFrameView.getSourcePosition();
            if (Intrinsics.areEqual((Object)(sourceInfo != null ? sourceInfo.getFile() : null), (Object)file)) {
                return topFrameView.getScript();
            }
        }
        return null;
    }

    private final Promise<ExpressionInfo> getEvaluationInfoBySourceMap(PsiElement element, Script script, List<MappingEntry> mappings) {
        boolean isNamedElement = element.getParent() instanceof PsiNamedElement;
        if (mappings.size() > 1 && isNamedElement) {
            NameMapperKt.warnSeveralMapping(element);
            return null;
        }
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> ChromeEvaluator.getEvaluationInfoBySourceMap$lambda$9((Function1)getEvaluationInfoBySourceMap.1.INSTANCE, arg_0)).thenComparing(arg_0 -> ChromeEvaluator.getEvaluationInfoBySourceMap$lambda$10((Function1)getEvaluationInfoBySourceMap.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"thenComparing(...)");
        CollectionsKt.sortWith(mappings, comparator);
        return VmScriptFileSystemKt.getVmFile(script).ensureDownloaded().then(arg_0 -> ChromeEvaluator.getEvaluationInfoBySourceMap$lambda$13(arg_0 -> ChromeEvaluator.getEvaluationInfoBySourceMap$lambda$12(element, script, mappings, arg_0), arg_0));
    }

    @Override
    @NotNull
    protected Promise<EvaluateResult> evaluate(@NotNull String expression, @Nullable XSourcePosition expressionPosition) {
        Promise promise2;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Promise promise3 = null;
        VariableContext context = this.getContext();
        if (context instanceof CallFrameView) {
            for (Scope scope : ((CallFrameView)context).getCallFrame().getVariableScopes()) {
                if (scope.getType() != ScopeType.LOCAL) continue;
                promise3 = ((CallFrameView)context).getMemberFilter(scope).thenAsync(arg_0 -> ChromeEvaluator.evaluate$lambda$15(arg_0 -> ChromeEvaluator.evaluate$lambda$14(context, expression, arg_0), arg_0));
                break;
            }
            if (((CallFrameView)context).getCallFrame().isFromAsyncStack()) {
                return Promises.rejectedPromise((String)"Can't be evaluated in async context");
            }
        }
        if ((promise2 = promise3) == null) {
            promise2 = EvaluateContext.evaluate$default((EvaluateContext)context.getEvaluateContext(), (String)expression, null, (boolean)false, (Project)JavaScriptDebuggerViewSupportKt.getDebugProcess(context).getSession().getProject(), (int)6, null);
        }
        Promise promise4 = promise2.thenAsync(arg_0 -> ChromeEvaluator.evaluate$lambda$17(ChromeEvaluator::evaluate$lambda$16, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise4, (String)"thenAsync(...)");
        return promise4;
    }

    private static final ExpressionInfo getExpressionInfoAtOffsetAsync$lambda$2(Ref.IntRef $attempts, Document $document, PsiFile $file, int $offset) {
        ++$attempts.element;
        return JSDebuggerSupportUtils.getExpressionAtOffset($document, $file, $offset);
    }

    private static final boolean getExpressionInfoAtOffsetAsync$lambda$3(Ref.IntRef $attempts) {
        return $attempts.element > 1;
    }

    private static final ExpressionInfo create$lambda$4(PsiElement $element, ExpressionInfo it) {
        ExpressionInfo expressionInfo = it;
        if (expressionInfo == null) {
            TextRange textRange = $element.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            expressionInfo = new ExpressionInfo(textRange, null, null, null, 14, null);
        }
        return expressionInfo;
    }

    private static final ExpressionInfo create$lambda$5(Function1 $tmp0, Object p0) {
        return (ExpressionInfo)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean createNameMapper$lambda$8(List $urls, VirtualFile $file, Lazy $resolver, Ref.ObjectRef $result, JavaScriptDebugProcess $debugProcess, Document $document, Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        SourceMap sourceMap = script.getSourceMap();
        if (sourceMap == null) {
            return true;
        }
        SourceMap map = sourceMap;
        for (Url url : $urls) {
            Mappings mappings = map.findSourceMappings(url, $file, $resolver, false);
            if (mappings == null) continue;
            Ref.ObjectRef objectRef = $result;
            if (JavaScriptDebugProcess.findFile$default($debugProcess, script.getUrl(), false, null, 6, null) != null) {
                JavaScriptNameMapper javaScriptNameMapper;
                void file;
                Ref.ObjectRef objectRef2 = objectRef;
                boolean bl = false;
                if (FileDocumentManager.getInstance().getDocument((VirtualFile)file) != null) {
                    Document it;
                    boolean bl2 = false;
                    javaScriptNameMapper = new JavaScriptNameMapper($document, it, mappings, map, (VirtualFile)file);
                } else {
                    javaScriptNameMapper = null;
                }
                v3 = javaScriptNameMapper;
                objectRef = objectRef2;
            } else {
                v3 = objectRef.element = null;
            }
            if ($result.element == null) continue;
            return false;
        }
        return true;
    }

    private static final Integer getEvaluationInfoBySourceMap$lambda$9(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Integer getEvaluationInfoBySourceMap$lambda$10(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final ExpressionInfo getEvaluationInfoBySourceMap$lambda$12(PsiElement $element, Script $script, List $mappings, VirtualFile it) {
        ExpressionInfo expressionInfo;
        String generatedName;
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.testFramework.LightVirtualFile");
        Document document = (Document)new DocumentImpl(((LightVirtualFile)it).getContent(), true);
        SourceMap sourceMap = $script.getSourceMap();
        Intrinsics.checkNotNull((Object)sourceMap);
        String string = generatedName = JavaScriptNameMapperKt.computeGeneratedName($element, document, sourceMap, $mappings);
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            TextRange textRange = $element.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            expressionInfo = new ExpressionInfo(textRange, generatedName, null, null, 8, null);
        } else {
            expressionInfo = null;
        }
        return expressionInfo;
    }

    private static final ExpressionInfo getEvaluationInfoBySourceMap$lambda$13(Function1 $tmp0, Object p0) {
        return (ExpressionInfo)$tmp0.invoke(p0);
    }

    private static final Promise evaluate$lambda$14(VariableContext $context, String $expression, MemberFilter it) {
        EvaluateContext evaluateContext = ((CallFrameView)$context).getEvaluateContext();
        String string = it.sourceNameToRaw($expression);
        if (string == null) {
            string = $expression;
        }
        return EvaluateContext.evaluate$default((EvaluateContext)evaluateContext, (String)string, null, (boolean)false, (Project)JavaScriptDebuggerViewSupportKt.getDebugProcess($context).getSession().getProject(), (int)6, null);
    }

    private static final Promise evaluate$lambda$15(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Promise evaluate$lambda$16(EvaluateResult it) {
        Promise promise2;
        if (it.getWasThrown()) {
            String string = it.getValue().getValueString();
            if (string == null) {
                string = "Can't evaluate";
            }
            promise2 = Promises.rejectedPromise((String)string);
        } else {
            promise2 = Promises.resolvedPromise((Object)it);
        }
        return promise2;
    }

    private static final Promise evaluate$lambda$17(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }
}

