/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.scripts.FileInfo;
import com.intellij.javascript.debugger.scripts.FileNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B-\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/intellij/javascript/debugger/scripts/RootScriptsNode;", "Lcom/intellij/javascript/debugger/scripts/FileNode;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "fileInfo", "Lcom/intellij/javascript/debugger/scripts/FileInfo;", "parent", "Lcom/intellij/ide/util/treeView/NodeDescriptor;", "", "<init>", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lcom/intellij/javascript/debugger/scripts/FileInfo;Lcom/intellij/ide/util/treeView/NodeDescriptor;)V", "isAutoExpandNode", "", "buildChildren", "", "Lcom/intellij/ui/treeStructure/SimpleNode;", "()[Lcom/intellij/ui/treeStructure/SimpleNode;", "formatMessage", "intellij.javascript.debugger"})
public final class RootScriptsNode
extends FileNode {
    public RootScriptsNode(@NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull FileInfo fileInfo, @Nullable NodeDescriptor<Object> parent) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        String string = JSDebuggerBundle.message("js.scripts.source.tree.root.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, fileInfo, debugProcess, parent);
    }

    public /* synthetic */ RootScriptsNode(JavaScriptDebugProcess javaScriptDebugProcess, FileInfo fileInfo, NodeDescriptor nodeDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            nodeDescriptor = null;
        }
        this(javaScriptDebugProcess, fileInfo, (NodeDescriptor<Object>)nodeDescriptor);
    }

    public boolean isAutoExpandNode() {
        return true;
    }

    @Override
    @NotNull
    protected SimpleNode[] buildChildren() {
        return !this.getFileInfo().hasChildren() ? this.formatMessage() : super.buildChildren();
    }

    private final SimpleNode[] formatMessage() {
        SimpleNode[] simpleNodeArray;
        WebBrowser browser = this.getDebugProcess().getConnection().getBrowser();
        if (browser == null) {
            simpleNodeArray = JSDebuggerBundle.message("js.scripts.no", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{browser.getName()};
            simpleNodeArray = JSDebuggerBundle.message("js.scripts.no.browser", objectArray);
        }
        SimpleNode[] simpleNodeArray2 = simpleNodeArray;
        Intrinsics.checkNotNull((Object)simpleNodeArray2);
        SimpleNode[] message = simpleNodeArray2;
        simpleNodeArray2 = new SimpleNode[]{new SimpleNode((String)message, this){
            {
                this.getTemplatePresentation().addText($message, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }

            public SimpleNode[] getChildren() {
                return SimpleNode.NO_CHILDREN;
            }
        }};
        return simpleNodeArray2;
    }
}

