/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.settingsSync.core.SettingsSyncEvents;
import com.intellij.settingsSync.core.SettingsSyncMain;
import com.intellij.settingsSync.core.SettingsSyncMainKt;
import com.intellij.settingsSync.core.SettingsSynchronizerKt;
import com.intellij.settingsSync.core.SettingsSynchronizerState;
import com.intellij.settingsSync.core.SyncSettingsEvent;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0003R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/settingsSync/core/SettingsSynchronizer;", "Lcom/intellij/openapi/application/ApplicationActivationListener;", "<init>", "()V", "autoSyncDelay", "", "getAutoSyncDelay", "()J", "applicationActivated", "", "ideFrame", "Lcom/intellij/openapi/wm/IdeFrame;", "applicationDeactivated", "setupSyncingByTimer", "Ljava/util/concurrent/ScheduledFuture;", "intellij.settingsSync.core"})
@SourceDebugExtension(value={"SMAP\nSettingsSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSynchronizer.kt\ncom/intellij/settingsSync/core/SettingsSynchronizer\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,157:1\n40#2,3:158\n40#2,3:161\n40#2,3:164\n40#2,3:167\n*S KotlinDebug\n*F\n+ 1 SettingsSynchronizer.kt\ncom/intellij/settingsSync/core/SettingsSynchronizer\n*L\n132#1:158,3\n133#1:161,3\n142#1:164,3\n148#1:167,3\n*E\n"})
final class SettingsSynchronizer
implements ApplicationActivationListener {
    private final long getAutoSyncDelay() {
        return Registry.Companion.intValue("settingsSync.autoSync.frequency.sec", 60);
    }

    public void applicationActivated(@NotNull IdeFrame ideFrame) {
        Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
        if (!SettingsSyncMainKt.isSettingsSyncEnabledInSettings() || !SettingsSyncMain.Companion.isAvailable()) {
            return;
        }
        if (this.getAutoSyncDelay() > 0L) {
            boolean $i$f$service = false;
            Class<SettingsSynchronizerState> serviceClass$iv = SettingsSynchronizerState.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            if (((SettingsSynchronizerState)object).scheduledFuture == null) {
                $i$f$service = false;
                serviceClass$iv = SettingsSynchronizerState.class;
                if (ApplicationManager.getApplication().getService(serviceClass$iv) == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                ((SettingsSynchronizerState)ApplicationManager.getApplication().getService(serviceClass$iv)).scheduledFuture = this.setupSyncingByTimer();
            }
        }
        if (Registry.Companion.is("settingsSync.autoSync.on.focus", true)) {
            SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(SyncSettingsEvent.SyncRequest.INSTANCE);
        }
    }

    public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
        Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
        boolean $i$f$service = false;
        Class<SettingsSynchronizerState> serviceClass$iv = SettingsSynchronizerState.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((SettingsSynchronizerState)object).stopSyncingByTimer();
    }

    @RequiresEdt
    private final ScheduledFuture<?> setupSyncingByTimer() {
        long delay = this.getAutoSyncDelay();
        boolean $i$f$service = false;
        Class<SettingsSynchronizerState> serviceClass$iv = SettingsSynchronizerState.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ScheduledFuture<?> scheduledFuture = ((SettingsSynchronizerState)object).executorService.scheduleWithFixedDelay(SettingsSynchronizer::setupSyncingByTimer$lambda$0, delay, delay, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleWithFixedDelay(...)");
        return scheduledFuture;
    }

    private static final void setupSyncingByTimer$lambda$0() {
        SettingsSynchronizerKt.access$getLOG$p().debug("Syncing settings by timer");
        SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(SyncSettingsEvent.SyncRequest.INSTANCE);
    }
}

