/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ZenJdbcHelper
extends JdbcHelperImpl {
    public ZenJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("ZEN", version, connection);
    }

    public ZenJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "pervasive.*sql") && !JdbcNativeUtil.detectString(product, "actian.*zen")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return ZenJdbcHelper.create(delegate, productVer);
    }

    @NotNull
    private static ZenJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new ZenJdbcHelper(ZenJdbcHelper.extractVersion(productVer), delegate);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return ZenJdbcHelper.extractVersion(version);
    }

    @Nullable
    private static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection) {
        return new ZenJdbcHelper(version, connection);
    }

    @Override
    public char getEscapeChar() {
        return '\\';
    }
}

