/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0003\u0014\u0015\u0016B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0006\u0010\u0013\u001a\u00020\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream;", "Ljava/io/InputStream;", "delegate", "Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate;)V", "source", "(Ljava/io/InputStream;)V", "isClosed", "", "read", "", "b", "", "off", "len", "updateDelegate", "", "close", "closeAndRestart", "Delegate", "TempFileRef", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nRepeatableInputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepeatableInputStream.kt\ncom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1#2:196\n*E\n"})
public final class RepeatableInputStream
extends InputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Delegate delegate;
    private boolean isClosed;
    public static final int SWITCH_THRESHOLD = 0x100000;
    @NotNull
    private static File tempDirectory = new File(FileUtil.getTempDirectory());

    private RepeatableInputStream(Delegate delegate) {
        this.delegate = delegate;
    }

    public RepeatableInputStream(@NotNull InputStream source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this(new Delegate.ArrayCopying(source, new ByteArrayOutputStream()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read() {
        int n;
        Delegate d = this.delegate;
        if (d instanceof Delegate.Copying) {
            void var3_2;
            if (this.isClosed) {
                throw new IOException("The stream was closed");
            }
            int n2 = ((Delegate.Copying)d).getSource().read();
            ((Delegate.Copying)d).getOutCopy().write(n2);
            n = var3_2;
        } else if (d instanceof Delegate.Repeating) {
            n = ((Delegate.Repeating)d).getInCopy().read();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int n3 = n;
        this.updateDelegate();
        return n3;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        int n;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Delegate d = this.delegate;
        if (d instanceof Delegate.Copying) {
            if (this.isClosed) {
                throw new IOException("The stream was closed");
            }
            int read = ((Delegate.Copying)d).getSource().read(b, off, len);
            if (read >= 0) {
                ((Delegate.Copying)d).getOutCopy().write(b, off, read);
            }
            n = read;
        } else if (d instanceof Delegate.Repeating) {
            n = ((Delegate.Repeating)d).getInCopy().read(b, off, len);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int read = n;
        this.updateDelegate();
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateDelegate() {
        Delegate.ArrayCopying delegateToReplace;
        Object object;
        Delegate.ArrayCopying arrayCopying;
        Delegate d = this.delegate;
        if (d instanceof Delegate.ArrayCopying) {
            arrayCopying = ((Delegate.ArrayCopying)d).getOutCopy().size() >= 0x100000 ? (Delegate.ArrayCopying)d : null;
        } else if (d instanceof Delegate.FileCopying || d instanceof Delegate.Repeating) {
            arrayCopying = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if ((object = (delegateToReplace = arrayCopying)) != null && (object = ((Delegate.ArrayCopying)object).getOutCopy()) != null) {
            Closeable closeable = (Closeable)object;
            Throwable throwable = null;
            try {
                ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
                boolean bl = false;
                Delegate.FileCopying newDelegate = new Delegate.FileCopying(delegateToReplace.getSource());
                delegateToReplace.getOutCopy().writeTo(newDelegate.getOutCopy());
                this.delegate = newDelegate;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            RepeatableInputStream.Companion.close(this.delegate);
        }
    }

    @NotNull
    public final RepeatableInputStream closeAndRestart() {
        Delegate.Repeating repeating;
        Delegate d = this.delegate;
        if (d instanceof Delegate.ArrayCopying) {
            byte[] byArray = ((Delegate.ArrayCopying)d).getOutCopy().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            repeating = new Delegate.ArrayRepeating(byArray);
        } else if (d instanceof Delegate.FileCopying) {
            repeating = new Delegate.FileRepeating(((Delegate.FileCopying)d).getFileRef().share(), null, 2, null);
        } else if (d instanceof Delegate.ArrayRepeating) {
            repeating = new Delegate.ArrayRepeating(((Delegate.ArrayRepeating)d).getData());
        } else if (d instanceof Delegate.FileRepeating) {
            repeating = new Delegate.FileRepeating(((Delegate.FileRepeating)d).getFileRef().share(), null, 2, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Delegate.Repeating newDelegate = repeating;
        try {
            this.close();
        }
        catch (IOException err) {
            Object object;
            Object object2 = this;
            try {
                RepeatableInputStream $this$closeAndRestart_u24lambda_u241 = object2;
                boolean bl = false;
                RepeatableInputStream.Companion.close(newDelegate);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            object = Result.exceptionOrNull-impl((Object)object2);
            if (object != null) {
                Object p0 = object;
                boolean $i$f$closeAndRestart$stub_for_inlining = false;
                boolean bl = false;
                err.addSuppressed((Throwable)p0);
                Result.constructor-impl((Object)Unit.INSTANCE);
            }
            throw err;
        }
        return new RepeatableInputStream(newDelegate);
    }

    @NotNull
    public static final File getTempDirectory() {
        return Companion.getTempDirectory();
    }

    @TestOnly
    public static final void setTempDirectory(@NotNull File file) {
        Companion.setTempDirectory(file);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R,\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8\u0006@GX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Companion;", "", "<init>", "()V", "SWITCH_THRESHOLD", "", "close", "", "delegate", "Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate;", "value", "Ljava/io/File;", "tempDirectory", "getTempDirectory$annotations", "getTempDirectory", "()Ljava/io/File;", "setTempDirectory", "(Ljava/io/File;)V", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nRepeatableInputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepeatableInputStream.kt\ncom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1#2:196\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void close(Delegate delegate) {
            Closeable closeable;
            Delegate delegate2 = delegate;
            if (delegate2 instanceof Delegate.ArrayCopying) {
                closeable = ((Delegate.ArrayCopying)delegate).getSource();
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    ((Delegate.ArrayCopying)delegate).getOutCopy().close();
                    it = Unit.INSTANCE;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            if (delegate2 instanceof Delegate.FileCopying) {
                closeable = ((Delegate.FileCopying)delegate).getFileRef();
                Throwable throwable = null;
                try {
                    TempFileRef it = (TempFileRef)closeable;
                    boolean bl = false;
                    Closeable closeable2 = ((Delegate.FileCopying)delegate).getSource();
                    Throwable throwable2 = null;
                    try {
                        InputStream it2 = (InputStream)closeable2;
                        boolean bl2 = false;
                        ((Delegate.FileCopying)delegate).getOutCopy().close();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    it = Unit.INSTANCE;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            if (delegate2 instanceof Delegate.ArrayRepeating) {
                ((Delegate.ArrayRepeating)delegate).getInCopy().close();
            } else if (delegate2 instanceof Delegate.FileRepeating) {
                closeable = ((Delegate.FileRepeating)delegate).getFileRef();
                Throwable throwable = null;
                try {
                    TempFileRef it = (TempFileRef)closeable;
                    boolean bl = false;
                    ((Delegate.FileRepeating)delegate).getInCopy().close();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Unit $this$close_u24lambda_u244 = Unit.INSTANCE;
            boolean bl = false;
        }

        @NotNull
        public final File getTempDirectory() {
            return tempDirectory;
        }

        @TestOnly
        public final void setTempDirectory(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
            tempDirectory = file;
        }

        @JvmStatic
        public static /* synthetic */ void getTempDirectory$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0006\u0002\u0003\u0004\u0005\u0006\u0007\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate;", "", "Copying", "Repeating", "ArrayCopying", "ArrayRepeating", "FileCopying", "FileRepeating", "Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate$Copying;", "Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate$Repeating;", "intellij.jupyter.core"})
    private static interface Delegate {

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate$ArrayCopying;", "Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate$Copying;", "source", "Ljava/io/InputStream;", "outCopy", "Ljava/io/ByteArrayOutputStream;", "<init>", "(Ljava/io/InputStream;Ljava/io/ByteArrayOutputStream;)V", "getSource", "()Ljava/io/InputStream;", "getOutCopy", "()Ljava/io/ByteArrayOutputStream;", "intellij.jupyter.core"})
        public static final class ArrayCopying
        implements Copying {
            @NotNull
            private final InputStream source;
            @NotNull
            private final ByteArrayOutputStream outCopy;

            public ArrayCopying(@NotNull InputStream source, @NotNull ByteArrayOutputStream outCopy) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)outCopy, (String)"outCopy");
                this.source = source;
                this.outCopy = outCopy;
            }

            @Override
            @NotNull
            public InputStream getSource() {
                return this.source;
            }

            @Override
            @NotNull
            public ByteArrayOutputStream getOutCopy() {
                return this.outCopy;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate$ArrayRepeating;", "Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate$Repeating;", "data", "", "<init>", "([B)V", "getData", "()[B", "inCopy", "Ljava/io/ByteArrayInputStream;", "getInCopy", "()Ljava/io/ByteArrayInputStream;", "intellij.jupyter.core"})
        public static final class ArrayRepeating
        implements Repeating {
            @NotNull
            private final byte[] data;
            @NotNull
            private final ByteArrayInputStream inCopy;

            public ArrayRepeating(@NotNull byte[] data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.data = data;
                this.inCopy = new ByteArrayInputStream(this.data);
            }

            @NotNull
            public final byte[] getData() {
                return this.data;
            }

            @Override
            @NotNull
            public ByteArrayInputStream getInCopy() {
                return this.inCopy;
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate$Copying;", "Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate;", "source", "Ljava/io/InputStream;", "getSource", "()Ljava/io/InputStream;", "outCopy", "Ljava/io/OutputStream;", "getOutCopy", "()Ljava/io/OutputStream;", "Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate$ArrayCopying;", "Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate$FileCopying;", "intellij.jupyter.core"})
        public static interface Copying
        extends Delegate {
            @NotNull
            public InputStream getSource();

            @NotNull
            public OutputStream getOutCopy();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate$FileCopying;", "Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate$Copying;", "source", "Ljava/io/InputStream;", "fileRef", "Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$TempFileRef;", "<init>", "(Ljava/io/InputStream;Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$TempFileRef;)V", "(Ljava/io/InputStream;)V", "getSource", "()Ljava/io/InputStream;", "getFileRef", "()Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$TempFileRef;", "outCopy", "Ljava/io/OutputStream;", "getOutCopy", "()Ljava/io/OutputStream;", "intellij.jupyter.core"})
        public static final class FileCopying
        implements Copying {
            @NotNull
            private final InputStream source;
            @NotNull
            private final TempFileRef fileRef;
            @NotNull
            private final OutputStream outCopy;

            private FileCopying(InputStream source, TempFileRef fileRef) {
                this.source = source;
                this.fileRef = fileRef;
                OutputStream outputStream = PathKt.outputStream$default((Path)this.fileRef.getPath(), (boolean)false, (OpenOption[])new OpenOption[0], (int)1, null);
                int n = 8192;
                this.outCopy = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, n);
            }

            @Override
            @NotNull
            public InputStream getSource() {
                return this.source;
            }

            @NotNull
            public final TempFileRef getFileRef() {
                return this.fileRef;
            }

            @Override
            @NotNull
            public OutputStream getOutCopy() {
                return this.outCopy;
            }

            public FileCopying(@NotNull InputStream source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                this(source, new TempFileRef());
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate$FileRepeating;", "Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate$Repeating;", "fileRef", "Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$TempFileRef;", "inCopy", "Ljava/io/InputStream;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$TempFileRef;Ljava/io/InputStream;)V", "getFileRef", "()Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$TempFileRef;", "getInCopy", "()Ljava/io/InputStream;", "intellij.jupyter.core"})
        public static final class FileRepeating
        implements Repeating {
            @NotNull
            private final TempFileRef fileRef;
            @NotNull
            private final InputStream inCopy;

            public FileRepeating(@NotNull TempFileRef fileRef, @NotNull InputStream inCopy) {
                Intrinsics.checkNotNullParameter((Object)fileRef, (String)"fileRef");
                Intrinsics.checkNotNullParameter((Object)inCopy, (String)"inCopy");
                this.fileRef = fileRef;
                this.inCopy = inCopy;
            }

            public /* synthetic */ FileRepeating(TempFileRef tempFileRef, InputStream inputStream, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    InputStream inputStream2 = Files.newInputStream(tempFileRef.getPath(), Arrays.copyOf(openOptionArray, openOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"newInputStream(...)");
                    inputStream = inputStream2;
                }
                this(tempFileRef, inputStream);
            }

            @NotNull
            public final TempFileRef getFileRef() {
                return this.fileRef;
            }

            @Override
            @NotNull
            public InputStream getInCopy() {
                return this.inCopy;
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate$Repeating;", "Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate;", "inCopy", "Ljava/io/InputStream;", "getInCopy", "()Ljava/io/InputStream;", "Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate$ArrayRepeating;", "Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$Delegate$FileRepeating;", "intellij.jupyter.core"})
        public static interface Repeating
        extends Delegate {
            @NotNull
            public InputStream getInCopy();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0006\u0010\u000b\u001a\u00020\u0000J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/RepeatableInputStream$TempFileRef;", "Ljava/io/Closeable;", "references", "Ljava/util/concurrent/atomic/AtomicInteger;", "path", "Ljava/nio/file/Path;", "<init>", "(Ljava/util/concurrent/atomic/AtomicInteger;Ljava/nio/file/Path;)V", "()V", "getPath", "()Ljava/nio/file/Path;", "share", "close", "", "intellij.jupyter.core"})
    private static final class TempFileRef
    implements Closeable {
        @NotNull
        private final AtomicInteger references;
        @NotNull
        private final Path path;

        private TempFileRef(AtomicInteger references, Path path) {
            this.references = references;
            this.path = path;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        public TempFileRef() {
            AtomicInteger atomicInteger = new AtomicInteger(1);
            Path path = FileUtil.createTempFile((File)Companion.getTempDirectory(), (String)"repeatable-input", (String)"", (boolean)false).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            this(atomicInteger, path);
        }

        @NotNull
        public final TempFileRef share() {
            this.references.incrementAndGet();
            return this;
        }

        @Override
        public void close() {
            if (this.references.decrementAndGet() <= 0) {
                PathKt.delete$default((Path)this.path, (boolean)false, (int)1, null);
            }
        }
    }
}

